/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.operators.ReduceITCase$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001=\u0011ABU3ek\u000e,\u0017\nV\"bg\u0016T!a\u0001\u0003\u0002\u0013=\u0004XM]1u_J\u001c(BA\u0003\u0007\u0003\u0015\u00198-\u00197b\u0015\t9\u0001\"A\u0002ba&T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!Q\u000f^5m\u0015\t)\u0002\"\u0001\u0003uKN$\u0018BA\f\u0013\u0005aiU\u000f\u001c;ja2,\u0007K]8he\u0006l7\u000fV3ti\n\u000b7/\u001a\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005!Qn\u001c3f!\tY2F\u0004\u0002\u001dS9\u0011Q\u0004\u000b\b\u0003=\u001dr!a\b\u0014\u000f\u0005\u0001*cBA\u0011%\u001b\u0005\u0011#BA\u0012\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003+!I!a\u0005\u000b\n\u0005)\u0012\u0012\u0001G'vYRL\u0007\u000f\\3Qe><'/Y7t)\u0016\u001cHOQ1tK&\u0011A&\f\u0002\u0012)\u0016\u001cH/\u0012=fGV$\u0018n\u001c8N_\u0012,'B\u0001\u0016\u0013\u0011\u0015y\u0003\u0001\"\u00011\u0003\u0019a\u0014N\\5u}Q\u0011\u0011g\r\t\u0003e\u0001i\u0011A\u0001\u0005\u000639\u0002\rA\u0007\u0005\bk\u0001\u0001\r\u0011\"\u00037\u0003)\u0011Xm];miB\u000bG\u000f[\u000b\u0002oA\u0011\u0001(\u0010\b\u0003smj\u0011A\u000f\u0006\u0002\u000b%\u0011AHO\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=u!9\u0011\t\u0001a\u0001\n\u0013\u0011\u0015A\u0004:fgVdG\u000fU1uQ~#S-\u001d\u000b\u0003\u0007\u001a\u0003\"!\u000f#\n\u0005\u0015S$\u0001B+oSRDqa\u0012!\u0002\u0002\u0003\u0007q'A\u0002yIEBa!\u0013\u0001!B\u00139\u0014a\u0003:fgVdG\u000fU1uQ\u0002Bqa\u0013\u0001A\u0002\u0013%a'\u0001\u0005fqB,7\r^3e\u0011\u001di\u0005\u00011A\u0005\n9\u000bA\"\u001a=qK\u000e$X\rZ0%KF$\"aQ(\t\u000f\u001dc\u0015\u0011!a\u0001o!1\u0011\u000b\u0001Q!\n]\n\u0011\"\u001a=qK\u000e$X\r\u001a\u0011\t\u000fM\u0003!\u0019!C\u0005)\u0006Yq\f^3na\u001a{G\u000eZ3s+\u0005)\u0006C\u0001,\\\u001b\u00059&B\u0001-Z\u0003\u0015\u0011X\u000f\\3t\u0015\tQF\"A\u0003kk:LG/\u0003\u0002]/\nyA+Z7q_J\f'/\u001f$pY\u0012,'\u000f\u0003\u0004_\u0001\u0001\u0006I!V\u0001\r?R,W\u000e\u001d$pY\u0012,'\u000f\t\u0005\u0006A\u0002!\t\u0001V\u0001\u000bi\u0016l\u0007OR8mI\u0016\u0014\bFA0c!\t\u0019G-D\u0001Z\u0013\t)\u0017L\u0001\u0003Sk2,\u0007\"B4\u0001\t\u0003A\u0017A\u00022fM>\u0014X\rF\u0001DQ\t1'\u000e\u0005\u0002dW&\u0011A.\u0017\u0002\u0007\u0005\u00164wN]3\t\u000b9\u0004A\u0011\u00015\u0002\u000b\u00054G/\u001a:)\u00055\u0004\bCA2r\u0013\t\u0011\u0018LA\u0003BMR,'\u000fC\u0003u\u0001\u0011\u0005\u0001.\u0001\u0014uKN$(+\u001a3vG\u0016|e\u000eV;qY\u0016\u001cx+\u001b;i\u0017\u0016Lh)[3mIN+G.Z2u_JD#a\u001d<\u0011\u0005\r<\u0018B\u0001=Z\u0005\u0011!Vm\u001d;\t\u000bi\u0004A\u0011\u00015\u0002_Q,7\u000f\u001e*fIV\u001cWm\u00148UkBdWm],ji\"lU\u000f\u001c;ja2,7*Z=GS\u0016dGmU3mK\u000e$xN]:)\u0005e4\b\"B?\u0001\t\u0003A\u0017A\t;fgR\u0014V\rZ;dK>sG+\u001e9mKN<\u0016\u000e\u001e5LKf,\u0005\u0010\u001e:bGR|'\u000f\u000b\u0002}m\"1\u0011\u0011\u0001\u0001\u0005\u0002!\fa\u0005^3tiJ+G-^2f\u001f:\u001cUo\u001d;p[RK\b/Z,ji\"\\U-_#yiJ\f7\r^8sQ\tyh\u000f\u0003\u0004\u0002\b\u0001!\t\u0001[\u0001\u0016i\u0016\u001cH/\u00117m%\u0016$WoY3G_J$V\u000f\u001d7fQ\r\t)A\u001e\u0005\u0007\u0003\u001b\u0001A\u0011\u00015\u00027Q,7\u000f^!mYJ+G-^2f\r>\u00148)^:u_6$\u0016\u0010]3tQ\r\tYA\u001e\u0005\u0007\u0003'\u0001A\u0011\u00015\u00025Q,7\u000f\u001e*fIV\u001cWmV5uQ\n\u0013x.\u00193dCN$8+\u001a;)\u0007\u0005Ea\u000f\u0003\u0004\u0002\u001a\u0001!\t\u0001[\u00011i\u0016\u001cHOU3ek\u000e,w+\u001b;i+\u00123E\u000b[1u%\u0016$XO\u001d8t)\",7+Z2p]\u0012Le\u000e];u\u001f\nTWm\u0019;)\u0007\u0005]a\u000f\u0003\u0004\u0002 \u0001!\t\u0001[\u0001)i\u0016\u001cHOU3ek\u000e,w+\u001b;i\u0003R+\b\u000f\\3SKR,(O\\5oO.+\u0017pU3mK\u000e$xN\u001d\u0015\u0004\u0003;1\bBBA\u0013\u0001\u0011\u0005\u0001.\u0001\u0013uKN$(+\u001a3vG\u0016|en\u0012:pkB,G\rR*Cs\u0016C\bO]3tg&|gnS3zQ\r\t\u0019C\u001e\u0015\b\u0001\u0005-\u0012qGA\u001d!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u00193\u00061!/\u001e8oKJLA!!\u000e\u00020\t9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!3\u00069!/\u001e8oKJ\u001c\u0018\u0002BA#\u0003\u007f\u0011Q\u0002U1sC6,G/\u001a:ju\u0016$\u0007")
public class ReduceITCase
extends MultipleProgramsTestBase {
    private String resultPath = null;
    private String expected = null;
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    @Test
    public void testReduceOnTuplesWithKeyFieldSelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, String> apply(Tuple3<Object, Object, String> in1, Tuple3<Object, Object, String> in2) {
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))), in1._2(), (Object)"B-)");
            }
        });
        String x$3 = this.resultPath();
        FileSystem.WriteMode x$4 = FileSystem.WriteMode.OVERWRITE;
        String x$5 = reduceDs.writeAsCsv$default$2();
        String x$6 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$3, x$5, x$6, x$4);
        env.execute();
        this.expected_$eq("1,1,Hi\n5,2,B-)\n15,3,B-)\n34,4,B-)\n65,5,B-)\n111,6,B-)\n");
    }

    @Test
    public void testReduceOnTuplesWithMultipleKeyFieldSelectors() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0})).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple5<Object, Object, Object, String, Object> apply(Tuple5<Object, Object, Object, String, Object> in1, Tuple5<Object, Object, Object, String, Object> in2) {
                return new Tuple5(in1._1(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)BoxesRunTime.boxToInteger((int)0), (Object)"P-)", in1._5());
            }
        });
        String x$7 = this.resultPath();
        FileSystem.WriteMode x$8 = FileSystem.WriteMode.OVERWRITE;
        String x$9 = reduceDs.writeAsCsv$default$2();
        String x$10 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$7, x$9, x$10, x$8);
        env.execute();
        this.expected_$eq("1,1,0,Hallo,1\n2,3,2,Hallo Welt wie,1\n2,2,1,Hallo Welt,2\n3,9,0,P-),2\n3,6,5,BCD,3\n4,17,0,P-),1\n4,17,0,P-),2\n5,11,10,GHI,1\n5,29,0,P-),2\n5,25,0,P-),3\n");
    }

    @Test
    public void testReduceOnTuplesWithKeyExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$1) {
                return BoxesRunTime.unboxToLong((Object)x$1._2());
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, String> apply(Tuple3<Object, Object, String> in1, Tuple3<Object, Object, String> in2) {
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))), in1._2(), (Object)"B-)");
            }
        });
        String x$11 = this.resultPath();
        FileSystem.WriteMode x$12 = FileSystem.WriteMode.OVERWRITE;
        String x$13 = reduceDs.writeAsCsv$default$2();
        String x$14 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$11, x$13, x$14, x$12);
        env.execute();
        this.expected_$eq("1,1,Hi\n5,2,B-)\n15,3,B-)\n34,4,B-)\n65,5,B-)\n111,6,B-)\n");
    }

    @Test
    public void testReduceOnCustomTypeWithKeyExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet reduceDs = ds.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(CollectionDataSets.CustomType x$2) {
                return x$2.myInt();
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final CollectionDataSets.CustomType apply(CollectionDataSets.CustomType in1, CollectionDataSets.CustomType in2) {
                in1.myLong_$eq(in1.myLong() + in2.myLong());
                in1.myString_$eq("Hello!");
                return in1;
            }
        });
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1,0,Hi\n2,3,Hello!\n3,12,Hello!\n4,30,Hello!\n5,60,Hello!\n6,105,Hello!\n");
    }

    @Test
    public void testAllReduceForTuple() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet reduceDs = ds.reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, String> apply(Tuple3<Object, Object, String> in1, Tuple3<Object, Object, String> in2) {
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)"Hello World");
            }
        });
        String x$15 = this.resultPath();
        FileSystem.WriteMode x$16 = FileSystem.WriteMode.OVERWRITE;
        String x$17 = reduceDs.writeAsCsv$default$2();
        String x$18 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$15, x$17, x$18, x$16);
        env.execute();
        this.expected_$eq("231,91,Hello World\n");
    }

    @Test
    public void testAllReduceForCustomTypes() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet reduceDs = ds.reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final CollectionDataSets.CustomType apply(CollectionDataSets.CustomType in1, CollectionDataSets.CustomType in2) {
                in1.myInt_$eq(in1.myInt() + in2.myInt());
                in1.myLong_$eq(in1.myLong() + in2.myLong());
                in1.myString_$eq("Hello!");
                return in1;
            }
        });
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("91,210,Hello!");
    }

    @Test
    public void testReduceWithBroadcastSet() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Object> intDs = CollectionDataSets$.MODULE$.getIntDataSet(env);
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).reduce((ReduceFunction)new RichReduceFunction<Tuple3<Object, Object, String>>(this){
            private String f2Replace;

            private String f2Replace() {
                return this.f2Replace;
            }

            private void f2Replace_$eq(String x$1) {
                this.f2Replace = x$1;
            }

            public void open(Configuration config) {
                Buffer ints = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.getRuntimeContext().getBroadcastVariable("ints")).asScala();
                this.f2Replace_$eq(new StringBuilder().append(BoxesRunTime.unboxToInt((Object)ints.sum((Numeric)Numeric.IntIsIntegral$.MODULE$))).append((Object)"").toString());
            }

            public Tuple3<Object, Object, String> reduce(Tuple3<Object, Object, String> in1, Tuple3<Object, Object, String> in2) {
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))), in1._2(), (Object)this.f2Replace());
            }
            {
                this.f2Replace = "";
            }
        }).withBroadcastSet(intDs, "ints");
        String x$19 = this.resultPath();
        FileSystem.WriteMode x$20 = FileSystem.WriteMode.OVERWRITE;
        String x$21 = reduceDs.writeAsCsv$default$2();
        String x$22 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$19, x$21, x$22, x$20);
        env.execute();
        this.expected_$eq("1,1,Hi\n5,2,55\n15,3,55\n34,4,55\n65,5,55\n111,6,55\n");
    }

    @Test
    public void testReduceWithUDFThatReturnsTheSecondInputObject() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final CollectionDataSets.MutableTuple3<Object, Object, String> apply(Tuple3<Object, Object, String> t) {
                return new CollectionDataSets.MutableTuple3<Object, Object, Object>(t._1(), t._2(), t._3());
            }
        }, (TypeInformation)new CaseClassTypeInfo<CollectionDataSets.MutableTuple3<Object, Object, String>>(this){

            public TypeInformation<?>[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$5 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                return new CaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>>(this, fieldSerializers){

                    public CollectionDataSets.MutableTuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new CollectionDataSets.MutableTuple3<Object, Object, String>(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (String)fields[2]);
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(CollectionDataSets.MutableTuple3.class));
        DataSet reduceDs = ds.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).reduce((ReduceFunction)new RichReduceFunction<CollectionDataSets.MutableTuple3<Object, Object, String>>(this){

            public CollectionDataSets.MutableTuple3<Object, Object, String> reduce(CollectionDataSets.MutableTuple3<Object, Object, String> in1, CollectionDataSets.MutableTuple3<Object, Object, String> in2) {
                in2._1_$eq(BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))));
                in2._3_$eq("Hi again!");
                return in2;
            }
        });
        String x$23 = this.resultPath();
        FileSystem.WriteMode x$24 = FileSystem.WriteMode.OVERWRITE;
        String x$25 = reduceDs.writeAsCsv$default$2();
        String x$26 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$23, x$25, x$26, x$24);
        env.execute();
        this.expected_$eq("1,1,Hi\n5,2,Hi again!\n15,3,Hi again!\n34,4,Hi again!\n65,5,Hi again!\n111,6,Hi again!\n");
    }

    @Test
    public void testReduceWithATupleReturningKeySelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple5<Object, Object, Object, String, Object> t) {
                return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)t._1()), BoxesRunTime.unboxToLong((Object)t._5()));
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(this){

            public TypeInformation<?>[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$6 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
            }
        }).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple5<Object, Object, Object, String, Object> apply(Tuple5<Object, Object, Object, String, Object> in1, Tuple5<Object, Object, Object, String, Object> in2) {
                return new Tuple5(in1._1(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)BoxesRunTime.boxToInteger((int)0), (Object)"P-)", in1._5());
            }
        });
        String x$27 = this.resultPath();
        FileSystem.WriteMode x$28 = FileSystem.WriteMode.OVERWRITE;
        String x$29 = reduceDs.writeAsCsv$default$2();
        String x$30 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$27, x$29, x$30, x$28);
        env.execute();
        this.expected_$eq("1,1,0,Hallo,1\n2,3,2,Hallo Welt wie,1\n2,2,1,Hallo Welt,2\n3,9,0,P-),2\n3,6,5,BCD,3\n4,17,0,P-),1\n4,17,0,P-),2\n5,11,10,GHI,1\n5,29,0,P-),2\n5,25,0,P-),3\n");
    }

    @Test
    public void testReduceOnGroupedDSByExpressionKey() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.groupBy("_5", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_1"})).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple5<Object, Object, Object, String, Object> apply(Tuple5<Object, Object, Object, String, Object> in1, Tuple5<Object, Object, Object, String, Object> in2) {
                return new Tuple5(in1._1(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)BoxesRunTime.boxToInteger((int)0), (Object)"P-)", in1._5());
            }
        });
        String x$31 = this.resultPath();
        FileSystem.WriteMode x$32 = FileSystem.WriteMode.OVERWRITE;
        String x$33 = reduceDs.writeAsCsv$default$2();
        String x$34 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$31, x$33, x$34, x$32);
        env.execute();
        this.expected_$eq("1,1,0,Hallo,1\n2,3,2,Hallo Welt wie,1\n2,2,1,Hallo Welt,2\n3,9,0,P-),2\n3,6,5,BCD,3\n4,17,0,P-),1\n4,17,0,P-),2\n5,11,10,GHI,1\n5,29,0,P-),2\n5,25,0,P-),3\n");
    }

    public ReduceITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }
}

