/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.RichFilterFunction;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.operators.FilterITCase$;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001=\u0011ABR5mi\u0016\u0014\u0018\nV\"bg\u0016T!a\u0001\u0003\u0002\u0013=\u0004XM]1u_J\u001c(BA\u0003\u0007\u0003\u0015\u00198-\u00197b\u0015\t9\u0001\"A\u0002ba&T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!Q\u000f^5m\u0015\t)\u0002\"\u0001\u0003uKN$\u0018BA\f\u0013\u0005aiU\u000f\u001c;ja2,\u0007K]8he\u0006l7\u000fV3ti\n\u000b7/\u001a\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005!Qn\u001c3f!\tY2F\u0004\u0002\u001dS9\u0011Q\u0004\u000b\b\u0003=\u001dr!a\b\u0014\u000f\u0005\u0001*cBA\u0011%\u001b\u0005\u0011#BA\u0012\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003+!I!a\u0005\u000b\n\u0005)\u0012\u0012\u0001G'vYRL\u0007\u000f\\3Qe><'/Y7t)\u0016\u001cHOQ1tK&\u0011A&\f\u0002\u0012)\u0016\u001cH/\u0012=fGV$\u0018n\u001c8N_\u0012,'B\u0001\u0016\u0013\u0011\u0015y\u0003\u0001\"\u00011\u0003\u0019a\u0014N\\5u}Q\u0011\u0011g\r\t\u0003e\u0001i\u0011A\u0001\u0005\u000639\u0002\rA\u0007\u0005\bk\u0001\u0001\r\u0011\"\u00037\u0003)\u0011Xm];miB\u000bG\u000f[\u000b\u0002oA\u0011\u0001(\u0010\b\u0003smj\u0011A\u000f\u0006\u0002\u000b%\u0011AHO\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=u!9\u0011\t\u0001a\u0001\n\u0013\u0011\u0015A\u0004:fgVdG\u000fU1uQ~#S-\u001d\u000b\u0003\u0007\u001a\u0003\"!\u000f#\n\u0005\u0015S$\u0001B+oSRDqa\u0012!\u0002\u0002\u0003\u0007q'A\u0002yIEBa!\u0013\u0001!B\u00139\u0014a\u0003:fgVdG\u000fU1uQ\u0002Bqa\u0013\u0001A\u0002\u0013%a'\u0001\u0005fqB,7\r^3e\u0011\u001di\u0005\u00011A\u0005\n9\u000bA\"\u001a=qK\u000e$X\rZ0%KF$\"aQ(\t\u000f\u001dc\u0015\u0011!a\u0001o!1\u0011\u000b\u0001Q!\n]\n\u0011\"\u001a=qK\u000e$X\r\u001a\u0011\t\u000fM\u0003!\u0019!C\u0005)\u0006Yq\f^3na\u001a{G\u000eZ3s+\u0005)\u0006C\u0001,\\\u001b\u00059&B\u0001-Z\u0003\u0015\u0011X\u000f\\3t\u0015\tQF\"A\u0003kk:LG/\u0003\u0002]/\nyA+Z7q_J\f'/\u001f$pY\u0012,'\u000f\u0003\u0004_\u0001\u0001\u0006I!V\u0001\r?R,W\u000e\u001d$pY\u0012,'\u000f\t\u0005\u0006A\u0002!\t\u0001V\u0001\u000bi\u0016l\u0007OR8mI\u0016\u0014\bFA0c!\t\u0019G-D\u0001Z\u0013\t)\u0017L\u0001\u0003Sk2,\u0007\"B4\u0001\t\u0003A\u0017A\u00022fM>\u0014X\rF\u0001DQ\t1'\u000e\u0005\u0002dW&\u0011A.\u0017\u0002\u0007\u0005\u00164wN]3\t\u000b9\u0004A\u0011\u00015\u0002\u000b\u00054G/\u001a:)\u00055\u0004\bCA2r\u0013\t\u0011\u0018LA\u0003BMR,'\u000fC\u0003u\u0001\u0011\u0005\u0001.\u0001\fuKN$\u0018\t\u001c7SK*,7\r^5oO\u001aKG\u000e^3sQ\t\u0019h\u000f\u0005\u0002do&\u0011\u00010\u0017\u0002\u0005)\u0016\u001cH\u000fC\u0003{\u0001\u0011\u0005\u0001.\u0001\u000buKN$\u0018\t\u001c7QCN\u001c\u0018N\\4GS2$XM\u001d\u0015\u0003sZDQ! \u0001\u0005\u0002!\fA\u0004^3ti\u001aKG\u000e^3s\u001f:\u001cFO]5oOR+\b\u000f\\3GS\u0016dG\r\u000b\u0002}m\"1\u0011\u0011\u0001\u0001\u0005\u0002!\fQ\u0004^3ti\u001aKG\u000e^3s\u001f:Le\u000e^3hKJ$V\u000f\u001d7f\r&,G\u000e\u001a\u0015\u0003\u007fZDa!a\u0002\u0001\t\u0003A\u0017a\u0005;fgR4\u0015\u000e\u001c;fe\n\u000b7/[2UsB,\u0007fAA\u0003m\"1\u0011Q\u0002\u0001\u0005\u0002!\fa\u0003^3ti\u001aKG\u000e^3s\u001f:\u001cUo\u001d;p[RK\b/\u001a\u0015\u0004\u0003\u00171\bBBA\n\u0001\u0011\u0005\u0001.\u0001\u0011uKN$(+[2i\r&dG/\u001a:P]N#(/\u001b8h)V\u0004H.\u001a$jK2$\u0007fAA\tm\":\u0001!!\u0007\u0002&\u0005\u001d\u0002\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}\u0011,\u0001\u0004sk:tWM]\u0005\u0005\u0003G\tiBA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\u0012,A\u0004sk:tWM]:\n\t\u0005M\u0012Q\u0006\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3")
public class FilterITCase
extends MultipleProgramsTestBase {
    private String resultPath = null;
    private String expected = null;
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    @Test
    public void testAllRejectingFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple3<Object, Object, String> t) {
                return false;
            }
        });
        String x$5 = this.resultPath();
        FileSystem.WriteMode x$6 = FileSystem.WriteMode.OVERWRITE;
        String x$7 = filterDs.writeAsCsv$default$2();
        String x$8 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$5, x$7, x$8, x$6);
        env.execute();
        this.expected_$eq("\n");
    }

    @Test
    public void testAllPassingFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple3<Object, Object, String> t) {
                return true;
            }
        });
        String x$9 = this.resultPath();
        FileSystem.WriteMode x$10 = FileSystem.WriteMode.OVERWRITE;
        String x$11 = filterDs.writeAsCsv$default$2();
        String x$12 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$9, x$11, x$12, x$10);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n");
    }

    @Test
    public void testFilterOnStringTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple3<Object, Object, String> x$1) {
                return ((String)x$1._3()).contains("world");
            }
        });
        String x$13 = this.resultPath();
        FileSystem.WriteMode x$14 = FileSystem.WriteMode.OVERWRITE;
        String x$15 = filterDs.writeAsCsv$default$2();
        String x$16 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$13, x$15, x$16, x$14);
        env.execute();
        this.expected_$eq("3,2,Hello world\n4,3,Hello world, how are you?\n");
    }

    @Test
    public void testFilterOnIntegerTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple3<Object, Object, String> x$2) {
                return BoxesRunTime.unboxToInt((Object)x$2._1()) % 2 == 0;
            }
        });
        String x$17 = this.resultPath();
        FileSystem.WriteMode x$18 = FileSystem.WriteMode.OVERWRITE;
        String x$19 = filterDs.writeAsCsv$default$2();
        String x$20 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$17, x$19, x$20, x$18);
        env.execute();
        this.expected_$eq("2,2,Hello\n4,3,Hello world, how are you?\n6,3,Luke Skywalker\n8,4,Comment#2\n10,4,Comment#4\n12,5,Comment#6\n14,5,Comment#8\n16,6,Comment#10\n18,6,Comment#12\n20,6,Comment#14\n");
    }

    @Test
    public void testFilterBasicType() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets$.MODULE$.getStringDataSet(env);
        DataSet filterDs = ds.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return x$3.startsWith("H");
            }
        });
        filterDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("Hi\nHello\nHello world\nHello world, how are you?\n");
    }

    @Test
    public void testFilterOnCustomType() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet filterDs = ds.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CollectionDataSets.CustomType x$4) {
                return x$4.myString().contains("a");
            }
        });
        filterDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("3,3,Hello world, how are you?\n3,4,I am fine.\n3,5,Luke Skywalker\n");
    }

    @Test
    public void testRichFilterOnStringTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Object> ints = CollectionDataSets$.MODULE$.getIntDataSet(env);
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((FilterFunction)new RichFilterFunction<Tuple3<Object, Object, String>>(this){
            private int literal;

            public int literal() {
                return this.literal;
            }

            public void literal_$eq(int x$1) {
                this.literal = x$1;
            }

            public void open(Configuration config) {
                List ints = this.getRuntimeContext().getBroadcastVariable("ints");
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ints).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.$outer.literal_$eq(this.$outer.literal() < i ? i : this.$outer.literal());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public boolean filter(Tuple3<Object, Object, String> value) {
                return BoxesRunTime.unboxToInt((Object)value._1()) < this.literal();
            }
            {
                this.literal = -1;
            }
        }).withBroadcastSet(ints, "ints");
        String x$21 = this.resultPath();
        FileSystem.WriteMode x$22 = FileSystem.WriteMode.OVERWRITE;
        String x$23 = filterDs.writeAsCsv$default$2();
        String x$24 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$21, x$23, x$24, x$22);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n");
    }

    public FilterITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }
}

