/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.CodeAnalysisMode;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.core.fs.Path;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.minicluster.LocalFlinkMiniCluster;
import org.apache.flink.util.Preconditions;

public class TestEnvironment
extends ExecutionEnvironment {
    private final LocalFlinkMiniCluster miniCluster;
    private final Collection<Path> jarFiles;
    private final Collection<URL> classPaths;
    private TestEnvironment lastEnv;

    public TestEnvironment(LocalFlinkMiniCluster miniCluster, int parallelism, boolean isObjectReuseEnabled, Collection<Path> jarFiles, Collection<URL> classPaths) {
        this.miniCluster = (LocalFlinkMiniCluster)Preconditions.checkNotNull((Object)miniCluster);
        this.jarFiles = (Collection)Preconditions.checkNotNull(jarFiles);
        this.classPaths = (Collection)Preconditions.checkNotNull(classPaths);
        this.setParallelism(parallelism);
        this.getConfig().setCodeAnalysisMode(CodeAnalysisMode.DISABLE);
        if (isObjectReuseEnabled) {
            this.getConfig().enableObjectReuse();
        } else {
            this.getConfig().disableObjectReuse();
        }
        this.lastEnv = null;
    }

    public TestEnvironment(LocalFlinkMiniCluster executor, int parallelism, boolean isObjectReuseEnabled) {
        this(executor, parallelism, isObjectReuseEnabled, Collections.emptyList(), Collections.emptyList());
    }

    public JobExecutionResult getLastJobExecutionResult() {
        if (this.lastEnv == null) {
            return this.lastJobExecutionResult;
        }
        return this.lastEnv.getLastJobExecutionResult();
    }

    public void startNewSession() throws Exception {
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        OptimizedPlan op = this.compileProgram(jobName);
        JobGraphGenerator jgg = new JobGraphGenerator();
        JobGraph jobGraph = jgg.compileJobGraph(op);
        for (Path jarFile : this.jarFiles) {
            jobGraph.addJar(jarFile);
        }
        jobGraph.setClasspaths(new ArrayList<URL>(this.classPaths));
        this.lastJobExecutionResult = this.miniCluster.submitJobAndWait(jobGraph, false);
        return this.lastJobExecutionResult;
    }

    public String getExecutionPlan() throws Exception {
        OptimizedPlan op = this.compileProgram("unused");
        PlanJSONDumpGenerator jsonGen = new PlanJSONDumpGenerator();
        return jsonGen.getOptimizerPlanAsJSON(op);
    }

    private OptimizedPlan compileProgram(String jobName) {
        Plan p = this.createProgramPlan(jobName);
        Optimizer pc = new Optimizer(new DataStatistics(), this.miniCluster.configuration());
        return pc.compile(p);
    }

    public void setAsContext() {
        ExecutionEnvironmentFactory factory = new ExecutionEnvironmentFactory(){

            public ExecutionEnvironment createExecutionEnvironment() {
                TestEnvironment.this.lastEnv = new TestEnvironment(TestEnvironment.this.miniCluster, TestEnvironment.this.getParallelism(), TestEnvironment.this.getConfig().isObjectReuseEnabled());
                return TestEnvironment.this.lastEnv;
            }
        };
        TestEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    public static void setAsContext(final LocalFlinkMiniCluster miniCluster, final int parallelism, final Collection<Path> jarFiles, final Collection<URL> classPaths) {
        ExecutionEnvironmentFactory factory = new ExecutionEnvironmentFactory(){

            public ExecutionEnvironment createExecutionEnvironment() {
                return new TestEnvironment(miniCluster, parallelism, false, jarFiles, classPaths);
            }
        };
        TestEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    public static void setAsContext(LocalFlinkMiniCluster miniCluster, int parallelism) {
        TestEnvironment.setAsContext(miniCluster, parallelism, Collections.emptyList(), Collections.emptyList());
    }

    public static void unsetAsContext() {
        TestEnvironment.resetContextEnvironment();
    }
}

