/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.util.Comparator;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.test.util.CollectionTestEnvironment;
import org.apache.flink.test.util.TestEnvironment;
import org.junit.Assert;
import org.junit.Test;

public abstract class JavaProgramTestBase
extends AbstractTestBase {
    private static final int DEFAULT_PARALLELISM = 4;
    private JobExecutionResult latestExecutionResult;
    private int parallelism = 4;
    private int numberOfTestRepetitions = 1;
    private boolean isCollectionExecution;

    public JavaProgramTestBase() {
        this(new Configuration());
    }

    public JavaProgramTestBase(Configuration config) {
        super(config);
        this.setTaskManagerNumSlots(this.parallelism);
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
        this.setTaskManagerNumSlots(parallelism);
    }

    public void setNumberOfTestRepetitions(int numberOfTestRepetitions) {
        this.numberOfTestRepetitions = numberOfTestRepetitions;
    }

    public int getParallelism() {
        return this.isCollectionExecution ? 1 : this.parallelism;
    }

    public JobExecutionResult getLatestExecutionResult() {
        return this.latestExecutionResult;
    }

    public boolean isCollectionExecution() {
        return this.isCollectionExecution;
    }

    protected abstract void testProgram() throws Exception;

    protected void preSubmit() throws Exception {
    }

    protected void postSubmit() throws Exception {
    }

    protected boolean skipCollectionExecution() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobWithObjectReuse() throws Exception {
        this.isCollectionExecution = false;
        this.startCluster();
        try {
            try {
                this.preSubmit();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                Assert.fail((String)("Pre-submit work caused an error: " + e.getMessage()));
            }
            TestEnvironment env = new TestEnvironment(this.executor, this.parallelism, false);
            env.getConfig().enableObjectReuse();
            env.setAsContext();
            for (int i = 0; i < this.numberOfTestRepetitions; ++i) {
                try {
                    this.testProgram();
                    this.latestExecutionResult = env.getLastJobExecutionResult();
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                    Assert.fail((String)("Error while calling the test program: " + e.getMessage()));
                }
                Assert.assertNotNull((String)"The test program never triggered an execution.", (Object)this.latestExecutionResult);
            }
            try {
                this.postSubmit();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                Assert.fail((String)("Post-submit work caused an error: " + e.getMessage()));
            }
        }
        finally {
            this.stopCluster();
            TestEnvironment.unsetAsContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobWithoutObjectReuse() throws Exception {
        this.isCollectionExecution = false;
        this.startCluster();
        try {
            try {
                this.preSubmit();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                Assert.fail((String)("Pre-submit work caused an error: " + e.getMessage()));
            }
            TestEnvironment env = new TestEnvironment(this.executor, this.parallelism, false);
            env.getConfig().disableObjectReuse();
            env.setAsContext();
            for (int i = 0; i < this.numberOfTestRepetitions; ++i) {
                try {
                    this.testProgram();
                    this.latestExecutionResult = env.getLastJobExecutionResult();
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                    Assert.fail((String)("Error while calling the test program: " + e.getMessage()));
                }
                Assert.assertNotNull((String)"The test program never triggered an execution.", (Object)this.latestExecutionResult);
            }
            try {
                this.postSubmit();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                Assert.fail((String)("Post-submit work caused an error: " + e.getMessage()));
            }
        }
        finally {
            this.stopCluster();
            TestEnvironment.unsetAsContext();
        }
    }

    @Test
    public void testJobCollectionExecution() throws Exception {
        if (this.skipCollectionExecution()) {
            return;
        }
        this.isCollectionExecution = true;
        try {
            this.preSubmit();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Pre-submit work caused an error: " + e.getMessage()));
        }
        CollectionTestEnvironment env = new CollectionTestEnvironment();
        env.setAsContext();
        try {
            this.testProgram();
            this.latestExecutionResult = env.getLastJobExecutionResult();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Error while calling the test program: " + e.getMessage()));
        }
        finally {
            CollectionTestEnvironment.unsetAsContext();
        }
        Assert.assertNotNull((String)"The test program never triggered an execution.", (Object)this.latestExecutionResult);
        try {
            this.postSubmit();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Post-submit work caused an error: " + e.getMessage()));
        }
    }

    public static class TupleComparator<T extends Tuple>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            int a2;
            int a1 = o1.getArity();
            if (a1 < (a2 = o2.getArity())) {
                return -1;
            }
            if (a2 < a1) {
                return 1;
            }
            for (int i = 0; i < a1; ++i) {
                int cmp;
                Object obj1 = o1.getField(i);
                Object obj2 = o2.getField(i);
                if (!(obj1 instanceof Comparable) || !(obj2 instanceof Comparable)) {
                    Assert.fail((String)"Cannot compare tuple fields");
                }
                if ((cmp = ((Comparable)obj1).compareTo(obj2)) == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

