/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.minicluster.LocalFlinkMiniCluster;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.Preconditions;

public class TestStreamEnvironment
extends StreamExecutionEnvironment {
    private final LocalFlinkMiniCluster miniCluster;
    private final Collection<Path> jarFiles;
    private final Collection<URL> classPaths;

    public TestStreamEnvironment(LocalFlinkMiniCluster miniCluster, int parallelism, Collection<Path> jarFiles, Collection<URL> classPaths) {
        this.miniCluster = (LocalFlinkMiniCluster)Preconditions.checkNotNull((Object)miniCluster);
        this.jarFiles = (Collection)Preconditions.checkNotNull(jarFiles);
        this.classPaths = (Collection)Preconditions.checkNotNull(classPaths);
        this.setParallelism(parallelism);
    }

    public TestStreamEnvironment(LocalFlinkMiniCluster miniCluster, int parallelism) {
        this(miniCluster, parallelism, Collections.emptyList(), Collections.emptyList());
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        StreamGraph streamGraph = this.getStreamGraph();
        streamGraph.setJobName(jobName);
        JobGraph jobGraph = streamGraph.getJobGraph();
        for (Path jarFile : this.jarFiles) {
            jobGraph.addJar(jarFile);
        }
        jobGraph.setClasspaths(new ArrayList<URL>(this.classPaths));
        return this.miniCluster.submitJobAndWait(jobGraph, false);
    }

    public static void setAsContext(final LocalFlinkMiniCluster cluster, final int parallelism, final Collection<Path> jarFiles, final Collection<URL> classpaths) {
        StreamExecutionEnvironmentFactory factory = new StreamExecutionEnvironmentFactory(){

            public StreamExecutionEnvironment createExecutionEnvironment() {
                return new TestStreamEnvironment(cluster, parallelism, jarFiles, classpaths);
            }
        };
        TestStreamEnvironment.initializeContextEnvironment((StreamExecutionEnvironmentFactory)factory);
    }

    public static void setAsContext(LocalFlinkMiniCluster cluster, int parallelism) {
        TestStreamEnvironment.setAsContext(cluster, parallelism, Collections.emptyList(), Collections.emptyList());
    }

    public static void unsetAsContext() {
        TestStreamEnvironment.resetContextEnvironment();
    }
}

