/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.minicluster.LocalFlinkMiniCluster;
import org.apache.flink.shaded.com.google.common.base.Charsets;
import org.apache.flink.shaded.com.google.common.io.Files;
import org.apache.flink.test.util.TestBaseUtils;
import scala.concurrent.duration.FiniteDuration;

public abstract class AbstractTestBase
extends TestBaseUtils {
    protected final Configuration config;
    private final List<File> tempFiles;
    private final FiniteDuration timeout;
    protected int taskManagerNumSlots = 1;
    protected int numTaskManagers = 1;
    protected LocalFlinkMiniCluster executor;

    public AbstractTestBase(Configuration config) {
        this.config = Objects.requireNonNull(config);
        this.tempFiles = new ArrayList<File>();
        this.timeout = AkkaUtils.getTimeout((Configuration)config);
    }

    public void startCluster() throws Exception {
        this.executor = AbstractTestBase.startCluster(this.numTaskManagers, this.taskManagerNumSlots, false, false, true);
    }

    public void stopCluster() throws Exception {
        AbstractTestBase.stopCluster(this.executor, this.timeout);
        this.deleteAllTempFiles();
    }

    public int getTaskManagerNumSlots() {
        return this.taskManagerNumSlots;
    }

    public void setTaskManagerNumSlots(int taskManagerNumSlots) {
        this.taskManagerNumSlots = taskManagerNumSlots;
    }

    public int getNumTaskManagers() {
        return this.numTaskManagers;
    }

    public void setNumTaskManagers(int numTaskManagers) {
        this.numTaskManagers = numTaskManagers;
    }

    public String getTempDirPath(String dirName) throws IOException {
        File f = this.createAndRegisterTempFile(dirName);
        return f.toURI().toString();
    }

    public String getTempFilePath(String fileName) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        return f.toURI().toString();
    }

    public String createTempFile(String fileName, String contents) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        Files.write(contents, f, Charsets.UTF_8);
        return f.toURI().toString();
    }

    public File createAndRegisterTempFile(String fileName) throws IOException {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        File f = new File(baseDir, ((Object)((Object)this)).getClass().getName() + "-" + fileName);
        if (f.exists()) {
            AbstractTestBase.deleteRecursively(f);
        }
        File parentToDelete = f;
        while (true) {
            File parent;
            if ((parent = parentToDelete.getParentFile()) == null) {
                throw new IOException("Missed temp dir while traversing parents of a temp file.");
            }
            if (parent.equals(baseDir)) break;
            parentToDelete = parent;
        }
        Files.createParentDirs(f);
        this.tempFiles.add(parentToDelete);
        return f;
    }

    private void deleteAllTempFiles() throws IOException {
        for (File f : this.tempFiles) {
            if (!f.exists()) continue;
            AbstractTestBase.deleteRecursively(f);
        }
    }
}

