/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.test.util.ForkableFlinkMiniCluster;
import org.apache.flink.util.Preconditions;

public class TestStreamEnvironment
extends StreamExecutionEnvironment {
    private ForkableFlinkMiniCluster executor;

    public TestStreamEnvironment(ForkableFlinkMiniCluster executor, int parallelism) {
        this.executor = (ForkableFlinkMiniCluster)((Object)Preconditions.checkNotNull((Object)((Object)executor)));
        this.setParallelism(parallelism);
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        StreamGraph streamGraph = this.getStreamGraph();
        streamGraph.setJobName(jobName);
        JobGraph jobGraph = streamGraph.getJobGraph();
        return this.executor.submitJobAndWait(jobGraph, false);
    }

    public static void setAsContext(final ForkableFlinkMiniCluster cluster, final int parallelism) {
        StreamExecutionEnvironmentFactory factory = new StreamExecutionEnvironmentFactory(){

            public StreamExecutionEnvironment createExecutionEnvironment() {
                return new TestStreamEnvironment(cluster, parallelism);
            }
        };
        TestStreamEnvironment.initializeContextEnvironment((StreamExecutionEnvironmentFactory)factory);
    }

    public static void unsetAsContext() {
        TestStreamEnvironment.resetContextEnvironment();
    }
}

