/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.util.TestStreamEnvironment;
import org.apache.flink.test.util.AbstractTestBase;
import org.junit.Assert;
import org.junit.Test;

public abstract class StreamingProgramTestBase
extends AbstractTestBase {
    protected static final int DEFAULT_PARALLELISM = 4;
    private int parallelism;

    public StreamingProgramTestBase() {
        super(new Configuration());
        this.setParallelism(4);
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
        this.setTaskManagerNumSlots(parallelism);
    }

    public int getParallelism() {
        return this.parallelism;
    }

    protected abstract void testProgram() throws Exception;

    protected void preSubmit() throws Exception {
    }

    protected void postSubmit() throws Exception {
    }

    @Test
    public void testJob() throws Exception {
        try {
            try {
                this.preSubmit();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                Assert.fail((String)("Pre-submit work caused an error: " + e.getMessage()));
            }
            this.startCluster();
            TestStreamEnvironment.setAsContext(this.executor, this.getParallelism());
            try {
                this.testProgram();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                Assert.fail((String)("Error while calling the test program: " + e.getMessage()));
            }
            finally {
                TestStreamEnvironment.unsetAsContext();
            }
            try {
                this.postSubmit();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                Assert.fail((String)("Post-submit work caused an error: " + e.getMessage()));
            }
        }
        finally {
            this.stopCluster();
        }
    }
}

