/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.test.util.CollectionTestEnvironment;
import org.apache.flink.test.util.ForkableFlinkMiniCluster;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.test.util.TestEnvironment;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runners.Parameterized;

public class MultipleProgramsTestBase
extends TestBaseUtils {
    protected static final int DEFAULT_PARALLELISM = 4;
    protected static boolean startWebServer = false;
    protected static ForkableFlinkMiniCluster cluster = null;
    protected final TestExecutionMode mode;

    public MultipleProgramsTestBase(TestExecutionMode mode) {
        this.mode = mode;
        switch (mode) {
            case CLUSTER: {
                TestEnvironment clusterEnv = new TestEnvironment(cluster, 4);
                clusterEnv.setAsContext();
                break;
            }
            case COLLECTION: {
                CollectionTestEnvironment collectionEnv = new CollectionTestEnvironment();
                collectionEnv.setAsContext();
            }
        }
    }

    @BeforeClass
    public static void setup() throws Exception {
        cluster = TestBaseUtils.startCluster(1, 4, startWebServer, false, true);
    }

    @AfterClass
    public static void teardown() throws Exception {
        MultipleProgramsTestBase.stopCluster(cluster, TestBaseUtils.DEFAULT_TIMEOUT);
    }

    @Parameterized.Parameters(name="Execution mode = {0}")
    public static Collection<Object[]> executionModes() {
        return Arrays.asList({TestExecutionMode.CLUSTER}, {TestExecutionMode.COLLECTION});
    }

    public static enum TestExecutionMode {
        CLUSTER,
        COLLECTION;

    }
}

