/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import akka.actor.ActorRef;
import akka.dispatch.Futures;
import akka.pattern.Patterns;
import akka.util.Timeout;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.testingUtils.TestingTaskManagerMessages;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.shaded.com.google.common.collect.Lists;
import org.apache.flink.test.util.ForkableFlinkMiniCluster;
import org.apache.flink.util.TestLogger;
import org.apache.hadoop.fs.FileSystem;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class TestBaseUtils
extends TestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(TestBaseUtils.class);
    protected static final int MINIMUM_HEAP_SIZE_MB = 192;
    protected static final long TASK_MANAGER_MEMORY_SIZE = 80L;
    protected static final long DEFAULT_AKKA_ASK_TIMEOUT = 1000L;
    protected static final String DEFAULT_AKKA_STARTUP_TIMEOUT = "60 s";
    protected static FiniteDuration DEFAULT_TIMEOUT = new FiniteDuration(1000L, TimeUnit.SECONDS);
    protected static File logDir;

    protected TestBaseUtils() {
        TestBaseUtils.verifyJvmOptions();
    }

    private static void verifyJvmOptions() {
        long heap = Runtime.getRuntime().maxMemory() >> 20;
        Assert.assertTrue((String)("Insufficient java heap space " + heap + "mb - set JVM option: -Xmx" + 192 + "m"), (heap > 142L ? 1 : 0) != 0);
    }

    public static ForkableFlinkMiniCluster startCluster(int numTaskManagers, int taskManagerNumSlots, boolean startWebserver, boolean startZooKeeper, boolean singleActorSystem) throws Exception {
        Configuration config = new Configuration();
        config.setInteger("local.number-taskmanager", numTaskManagers);
        config.setInteger("taskmanager.numberOfTaskSlots", taskManagerNumSlots);
        config.setBoolean("local.start-webserver", startWebserver);
        if (startZooKeeper) {
            config.setInteger("local.number-jobmanager", 3);
            config.setString("recovery.mode", "zookeeper");
        }
        return TestBaseUtils.startCluster(config, singleActorSystem);
    }

    public static ForkableFlinkMiniCluster startCluster(Configuration config, boolean singleActorSystem) throws Exception {
        logDir = File.createTempFile("TestBaseUtils-logdir", null);
        Assert.assertTrue((String)"Unable to delete temp file", (boolean)logDir.delete());
        Assert.assertTrue((String)"Unable to create temp directory", (boolean)logDir.mkdir());
        Path logFile = Files.createFile(new File(logDir, "jobmanager.log").toPath(), new FileAttribute[0]);
        Files.createFile(new File(logDir, "jobmanager.out").toPath(), new FileAttribute[0]);
        config.setLong("taskmanager.memory.size", 80L);
        config.setBoolean("fs.overwrite-files", true);
        config.setString("akka.ask.timeout", "1000s");
        config.setString("akka.startup-timeout", DEFAULT_AKKA_STARTUP_TIMEOUT);
        config.setInteger("jobmanager.web.port", 8081);
        config.setString("jobmanager.web.log.path", logFile.toString());
        ForkableFlinkMiniCluster cluster = new ForkableFlinkMiniCluster(config, singleActorSystem);
        cluster.start();
        return cluster;
    }

    public static void stopCluster(ForkableFlinkMiniCluster executor, FiniteDuration timeout) throws Exception {
        if (logDir != null) {
            FileUtils.deleteDirectory((File)logDir);
        }
        if (executor != null) {
            int numUnreleasedBCVars = 0;
            int numActiveConnections = 0;
            if (executor.running()) {
                List tms = executor.getTaskManagersAsJava();
                ArrayList<Future> bcVariableManagerResponseFutures = new ArrayList<Future>();
                ArrayList<Future> numActiveConnectionsResponseFutures = new ArrayList<Future>();
                for (ActorRef tm : tms) {
                    bcVariableManagerResponseFutures.add(Patterns.ask((ActorRef)tm, (Object)TestingTaskManagerMessages.RequestBroadcastVariablesWithReferences$.MODULE$, (Timeout)new Timeout(timeout)));
                    numActiveConnectionsResponseFutures.add(Patterns.ask((ActorRef)tm, (Object)TestingTaskManagerMessages.RequestNumActiveConnections$.MODULE$, (Timeout)new Timeout(timeout)));
                }
                Future bcVariableManagerFutureResponses = Futures.sequence(bcVariableManagerResponseFutures, (ExecutionContext)TestingUtils.defaultExecutionContext());
                Iterable responses = (Iterable)Await.result((Awaitable)bcVariableManagerFutureResponses, (Duration)timeout);
                for (Object response : responses) {
                    numUnreleasedBCVars += ((TestingTaskManagerMessages.ResponseBroadcastVariablesWithReferences)response).number();
                }
                Future numActiveConnectionsFutureResponses = Futures.sequence(numActiveConnectionsResponseFutures, (ExecutionContext)TestingUtils.defaultExecutionContext());
                responses = (Iterable)Await.result((Awaitable)numActiveConnectionsFutureResponses, (Duration)timeout);
                for (Object response : responses) {
                    numActiveConnections += ((TestingTaskManagerMessages.ResponseNumActiveConnections)response).number();
                }
            }
            executor.stop();
            FileSystem.closeAll();
            System.gc();
            Assert.assertEquals((String)"Not all broadcast variables were released.", (long)0L, (long)numUnreleasedBCVars);
            Assert.assertEquals((String)"Not all TCP connections were released.", (long)0L, (long)numActiveConnections);
        }
    }

    public static BufferedReader[] getResultReader(String resultPath) throws IOException {
        return TestBaseUtils.getResultReader(resultPath, new String[0], false);
    }

    public static BufferedReader[] getResultReader(String resultPath, String[] excludePrefixes, boolean inOrderOfFiles) throws IOException {
        File[] files = TestBaseUtils.getAllInvolvedFiles(resultPath, excludePrefixes);
        if (inOrderOfFiles) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    try {
                        int f1 = Integer.parseInt(o1.getName());
                        int f2 = Integer.parseInt(o2.getName());
                        return f1 < f2 ? -1 : (f1 > f2 ? 1 : 0);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("The file names are no numbers and cannot be ordered: " + o1.getName() + "/" + o2.getName());
                    }
                }
            });
        }
        BufferedReader[] readers = new BufferedReader[files.length];
        for (int i = 0; i < files.length; ++i) {
            readers[i] = new BufferedReader(new FileReader(files[i]));
        }
        return readers;
    }

    public static BufferedInputStream[] getResultInputStream(String resultPath) throws IOException {
        return TestBaseUtils.getResultInputStream(resultPath, new String[0]);
    }

    public static BufferedInputStream[] getResultInputStream(String resultPath, String[] excludePrefixes) throws IOException {
        File[] files = TestBaseUtils.getAllInvolvedFiles(resultPath, excludePrefixes);
        BufferedInputStream[] inStreams = new BufferedInputStream[files.length];
        for (int i = 0; i < files.length; ++i) {
            inStreams[i] = new BufferedInputStream(new FileInputStream(files[i]));
        }
        return inStreams;
    }

    public static void readAllResultLines(List<String> target, String resultPath) throws IOException {
        TestBaseUtils.readAllResultLines(target, resultPath, new String[0]);
    }

    public static void readAllResultLines(List<String> target, String resultPath, String[] excludePrefixes) throws IOException {
        TestBaseUtils.readAllResultLines(target, resultPath, excludePrefixes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readAllResultLines(List<String> target, String resultPath, String[] excludePrefixes, boolean inOrderOfFiles) throws IOException {
        BufferedReader[] readers = TestBaseUtils.getResultReader(resultPath, excludePrefixes, inOrderOfFiles);
        try {
            for (BufferedReader reader : readers) {
                String s;
                while ((s = reader.readLine()) != null) {
                    target.add(s);
                }
            }
        }
        finally {
            for (BufferedReader reader : readers) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void compareResultsByLinesInMemory(String expectedResultStr, String resultPath) throws Exception {
        TestBaseUtils.compareResultsByLinesInMemory(expectedResultStr, resultPath, new String[0]);
    }

    public static void compareResultsByLinesInMemory(String expectedResultStr, String resultPath, String[] excludePrefixes) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        TestBaseUtils.readAllResultLines(list, resultPath, excludePrefixes, false);
        Object[] result = list.toArray(new String[list.size()]);
        Arrays.sort(result);
        Object[] expected = expectedResultStr.isEmpty() ? new String[]{} : expectedResultStr.split("\n");
        Arrays.sort(expected);
        Assert.assertEquals((String)"Different number of lines in expected and obtained result.", (long)expected.length, (long)result.length);
        Assert.assertArrayEquals((Object[])expected, (Object[])result);
    }

    public static void compareResultsByLinesInMemoryWithStrictOrder(String expectedResultStr, String resultPath) throws Exception {
        TestBaseUtils.compareResultsByLinesInMemoryWithStrictOrder(expectedResultStr, resultPath, new String[0]);
    }

    public static void compareResultsByLinesInMemoryWithStrictOrder(String expectedResultStr, String resultPath, String[] excludePrefixes) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        TestBaseUtils.readAllResultLines(list, resultPath, excludePrefixes, true);
        Object[] result = list.toArray(new String[list.size()]);
        Object[] expected = expectedResultStr.split("\n");
        Assert.assertEquals((String)"Different number of lines in expected and obtained result.", (long)expected.length, (long)result.length);
        Assert.assertArrayEquals((Object[])expected, (Object[])result);
    }

    public static void checkLinesAgainstRegexp(String resultPath, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher("");
        ArrayList<String> list = new ArrayList<String>();
        try {
            TestBaseUtils.readAllResultLines(list, resultPath, new String[0], false);
        }
        catch (IOException e1) {
            Assert.fail((String)"Error reading the result");
        }
        for (String line : list) {
            matcher.reset(line);
            if (matcher.find()) continue;
            String msg = "Line is not well-formed: " + line;
            Assert.fail((String)msg);
        }
    }

    public static void compareKeyValuePairsWithDelta(String expectedLines, String resultPath, String delimiter, double maxDelta) throws Exception {
        TestBaseUtils.compareKeyValuePairsWithDelta(expectedLines, resultPath, new String[0], delimiter, maxDelta);
    }

    public static void compareKeyValuePairsWithDelta(String expectedLines, String resultPath, String[] excludePrefixes, String delimiter, double maxDelta) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        TestBaseUtils.readAllResultLines(list, resultPath, excludePrefixes, false);
        Object[] result = list.toArray(new String[list.size()]);
        Object[] expected = expectedLines.isEmpty() ? new String[]{} : expectedLines.split("\n");
        Assert.assertEquals((String)"Wrong number of result lines.", (long)expected.length, (long)result.length);
        Arrays.sort(result);
        Arrays.sort(expected);
        for (int i = 0; i < expected.length; ++i) {
            double resultPayLoad;
            String[] expectedFields = ((String)expected[i]).split(delimiter);
            String[] resultFields = ((String)result[i]).split(delimiter);
            double expectedPayLoad = Double.parseDouble(expectedFields[1]);
            Assert.assertTrue((String)"Values differ by more than the permissible delta", (Math.abs(expectedPayLoad - (resultPayLoad = Double.parseDouble(resultFields[1]))) < maxDelta ? 1 : 0) != 0);
        }
    }

    public static <X> void compareResultCollections(List<X> expected, List<X> actual, Comparator<X> comparator) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Collections.sort(expected, comparator);
        Collections.sort(actual, comparator);
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals(expected.get(i), actual.get(i));
        }
    }

    private static File[] getAllInvolvedFiles(String resultPath, String[] excludePrefixes) {
        final String[] exPrefs = excludePrefixes;
        File result = TestBaseUtils.asFile(resultPath);
        if (!result.exists()) {
            Assert.fail((String)"Result file was not written");
        }
        if (result.isDirectory()) {
            return result.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    for (String p : exPrefs) {
                        if (!name.startsWith(p)) continue;
                        return false;
                    }
                    return true;
                }
            });
        }
        return new File[]{result};
    }

    protected static File asFile(String path) {
        try {
            URI uri = new URI(path);
            if (uri.getScheme().equals("file")) {
                return new File(uri.getPath());
            }
            throw new IllegalArgumentException("This path does not denote a local file.");
        }
        catch (NullPointerException | URISyntaxException e) {
            throw new IllegalArgumentException("This path does not describe a valid local file URI.");
        }
    }

    public static <T> void compareResultAsTuples(List<T> result, String expected) {
        TestBaseUtils.compareResult(result, expected, true);
    }

    public static <T> void compareResultAsText(List<T> result, String expected) {
        TestBaseUtils.compareResult(result, expected, false);
    }

    private static <T> void compareResult(List<T> result, String expected, boolean asTuples) {
        int i;
        Object[] expectedStrings = expected.split("\n");
        Object[] resultStrings = new String[result.size()];
        for (i = 0; i < resultStrings.length; ++i) {
            T val = result.get(i);
            if (asTuples) {
                if (val instanceof Tuple) {
                    Tuple t = (Tuple)val;
                    Object first = t.getField(0);
                    StringBuilder bld = new StringBuilder(first == null ? "null" : first.toString());
                    for (int pos = 1; pos < t.getArity(); ++pos) {
                        Object next = t.getField(pos);
                        bld.append(',').append(next == null ? "null" : next.toString());
                    }
                    resultStrings[i] = bld.toString();
                    continue;
                }
                throw new IllegalArgumentException(val + " is no tuple");
            }
            resultStrings[i] = val == null ? "null" : val.toString();
        }
        Assert.assertEquals((String)"Wrong number of elements result", (long)expectedStrings.length, (long)resultStrings.length);
        Arrays.sort(expectedStrings);
        Arrays.sort(resultStrings);
        for (i = 0; i < expectedStrings.length; ++i) {
            Assert.assertEquals((Object)expectedStrings[i], (Object)resultStrings[i]);
        }
    }

    public static <T> void containsResultAsText(List<T> result, String expected) {
        String[] expectedStrings = expected.split("\n");
        LinkedList<String> resultStrings = Lists.newLinkedList();
        for (int i = 0; i < result.size(); ++i) {
            T val = result.get(i);
            String str = val == null ? "null" : val.toString();
            resultStrings.add(str);
        }
        List<String> expectedStringList = Arrays.asList(expectedStrings);
        for (String element : resultStrings) {
            Assert.assertTrue((boolean)expectedStringList.contains(element));
        }
    }

    protected static Collection<Object[]> toParameterList(Configuration ... testConfigs) {
        ArrayList<Object[]> configs = new ArrayList<Object[]>();
        for (Configuration testConfig : testConfigs) {
            Object[] c = new Object[]{testConfig};
            configs.add(c);
        }
        return configs;
    }

    protected static Collection<Object[]> toParameterList(List<Configuration> testConfigs) {
        LinkedList<Object[]> configs = new LinkedList<Object[]>();
        for (Configuration testConfig : testConfigs) {
            Object[] c = new Object[]{testConfig};
            configs.add(c);
        }
        return configs;
    }

    public static void setEnv(Map<String, String> newenv) {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.putAll(newenv);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.putAll(newenv);
        }
        catch (NoSuchFieldException e) {
            try {
                Class<?>[] classes = Collections.class.getDeclaredClasses();
                Map<String, String> env = System.getenv();
                for (Class<?> cl : classes) {
                    if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                    Field field = cl.getDeclaredField("m");
                    field.setAccessible(true);
                    Object obj = field.get(env);
                    Map map = (Map)obj;
                    map.clear();
                    map.putAll(newenv);
                }
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    protected static void deleteRecursively(File f) throws IOException {
        if (f.isDirectory()) {
            FileUtils.deleteDirectory((File)f);
        } else if (!f.delete()) {
            System.err.println("Failed to delete file " + f.getAbsolutePath());
        }
    }

    public static String constructTestPath(Class<?> forClass, String folder) {
        String path = System.getProperty("java.io.tmpdir");
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + System.getProperty("file.separator");
        }
        path = path + forClass.getName() + "-" + folder;
        return path;
    }

    public static String constructTestURI(Class<?> forClass, String folder) {
        return new File(TestBaseUtils.constructTestPath(forClass, folder)).toURI().toString();
    }

    public static String getFromHTTP(String url) throws Exception {
        InputStream is;
        URL u = new URL(url);
        LOG.info("Accessing URL " + url + " as URL: " + u);
        HttpURLConnection connection = (HttpURLConnection)u.openConnection();
        connection.setConnectTimeout(100000);
        connection.connect();
        if (connection.getResponseCode() >= 400) {
            LOG.warn("HTTP Response code when connecting to {} was {}", (Object)url, (Object)connection.getResponseCode());
            is = connection.getErrorStream();
        } else {
            is = connection.getInputStream();
        }
        return IOUtils.toString((InputStream)is, (String)(connection.getContentEncoding() != null ? connection.getContentEncoding() : "UTF-8"));
    }

    public static class TupleComparator<T extends Tuple>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            if (o1 == null || o2 == null) {
                throw new IllegalArgumentException("Cannot compare null tuples");
            }
            if (o1.getArity() != o2.getArity()) {
                return o1.getArity() - o2.getArity();
            }
            for (int i = 0; i < o1.getArity(); ++i) {
                int cmp;
                Object val1 = o1.getField(i);
                Object val2 = o2.getField(i);
                if (val1 != null && val2 != null) {
                    cmp = TupleComparator.compareValues(val1, val2);
                } else {
                    int n = val1 == null ? (val2 == null ? 0 : -1) : (cmp = 1);
                }
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        private static <X extends Comparable<X>> int compareValues(Object o1, Object o2) {
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
            throw new IllegalArgumentException("Cannot compare tuples with non comparable elements");
        }
    }
}

