/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.junit.extensions.retry.strategy;

import org.apache.flink.testutils.junit.extensions.retry.strategy.AbstractRetryStrategy;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryOnFailureStrategy
extends AbstractRetryStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RetryOnFailureStrategy.class);

    public RetryOnFailureStrategy(int retryTimes) {
        super(retryTimes, true);
    }

    @Override
    public void handleException(String testName, int attemptIndex, Throwable throwable) throws Throwable {
        if (attemptIndex >= this.totalTimes) {
            LOG.error("Test Failed at the last retry.", throwable);
            throw throwable;
        }
        String retryMsg = String.format("Retry test %s[%d/%d] failed, continue retrying.", testName, attemptIndex, this.totalTimes);
        LOG.error(retryMsg, throwable);
        throw new TestAbortedException(retryMsg);
    }
}

