/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.testutils;

import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ThrowingConsumer;

public final class FlinkAssertions {
    public static final InstanceOfAssertFactory<Stream, ListAssert<Throwable>> STREAM_THROWABLE = new InstanceOfAssertFactory(Stream.class, Assertions::assertThat);

    private FlinkAssertions() {
    }

    public static ThrowingConsumer<? super Throwable> anyCauseMatches(Class<? extends Throwable> clazz, String containsMessage) {
        return t -> {
            ListAssert cfr_ignored_0 = (ListAssert)FlinkAssertions.assertThatChainOfCauses(t).anySatisfy(cause -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)cause).isInstanceOf(clazz)).hasMessageContaining(containsMessage));
        };
    }

    public static ThrowingConsumer<? super Throwable> containsCause(Throwable throwable) {
        return t -> {
            ListAssert cfr_ignored_0 = (ListAssert)FlinkAssertions.assertThatChainOfCauses(t).anySatisfy(cause -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)cause).isInstanceOf(throwable.getClass())).hasMessage(throwable.getMessage()));
        };
    }

    public static ThrowingConsumer<? super Throwable> anyCauseMatches(Class<? extends Throwable> clazz) {
        return t -> {
            ListAssert cfr_ignored_0 = (ListAssert)FlinkAssertions.assertThatChainOfCauses(t).anySatisfy(cause -> {
                AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)cause).isInstanceOf(clazz);
            });
        };
    }

    public static ThrowingConsumer<? super Throwable> anyCauseMatches(String containsMessage) {
        return t -> {
            ListAssert cfr_ignored_0 = (ListAssert)FlinkAssertions.assertThatChainOfCauses(t).anySatisfy(t1 -> Assertions.assertThat((Throwable)t1).hasMessageContaining(containsMessage));
        };
    }

    public static ListAssert<Throwable> assertThatChainOfCauses(Throwable root) {
        return (ListAssert)Assertions.assertThat((Throwable)root).extracting(FlinkAssertions::chainOfCauses, STREAM_THROWABLE);
    }

    public static Stream<Throwable> chainOfCauses(Throwable throwable) {
        if (throwable == null) {
            return Stream.empty();
        }
        if (throwable.getCause() == null) {
            return Stream.of(throwable);
        }
        return Stream.concat(Stream.of(throwable), FlinkAssertions.chainOfCauses(throwable.getCause()));
    }
}

