/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.join.JoinType;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.runtime.join.EmitAwareCollector;
import org.apache.flink.table.runtime.join.OuterJoinPaddingUtil;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5h!B\u0001\u0003\u0003\u0003y!!\u0006+j[\u0016\u0014u.\u001e8eK\u0012\u001cFO]3b[*{\u0017N\u001c\u0006\u0003\u0007\u0011\tAA[8j]*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t#kA)\u0011C\u0007\u000f\u001d95\t!C\u0003\u0002\u0014)\u0005\u00111m\u001c\u0006\u0003+Y\t\u0011BZ;oGRLwN\\:\u000b\u0005]A\u0012aA1qS*\u0011\u0011\u0004C\u0001\ngR\u0014X-Y7j]\u001eL!a\u0007\n\u0003#\r{\u0007K]8dKN\u001ch)\u001e8di&|g\u000e\u0005\u0002\u001eA5\taD\u0003\u0002 \t\u0005)A/\u001f9fg&\u0011\u0011E\b\u0002\u0005\u0007J{w\u000fE\u0002$M!j\u0011\u0001\n\u0006\u0003K\u0019\tqaY8eK\u001e,g.\u0003\u0002(I\tA1i\\7qS2,'\u000fE\u0003*]A\u0002\u0004'D\u0001+\u0015\t)2F\u0003\u0002-[\u000511m\\7n_:T!a\u0006\u0005\n\u0005=R#\u0001\u0005$mCRTu.\u001b8Gk:\u001cG/[8o!\t\t4'D\u00013\u0015\ty\u0002\"\u0003\u00025e\t\u0019!k\\<\u0011\u0005YJT\"A\u001c\u000b\u0005a2\u0011\u0001B;uS2L!AO\u001c\u0003\u000f1{wmZ5oO\"AA\b\u0001BC\u0002\u0013%Q(\u0001\u0005k_&tG+\u001f9f+\u0005q\u0004CA F\u001b\u0005\u0001%BA\u0002B\u0015\t\u00115)A\u0005pa\u0016\u0014\u0018\r^8sg*\u0011A)L\u0001\u0005U\u00064\u0018-\u0003\u0002G\u0001\nA!j\\5o)f\u0004X\r\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003?\u0003%Qw.\u001b8UsB,\u0007\u0005\u0003\u0005K\u0001\t\u0015\r\u0011\"\u0003L\u00039aWM\u001a;M_^,'OQ8v]\u0012,\u0012\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0005\u0019>tw\r\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003M\u0003=aWM\u001a;M_^,'OQ8v]\u0012\u0004\u0003\u0002C+\u0001\u0005\u000b\u0007I\u0011B&\u0002\u001d1,g\r^+qa\u0016\u0014(i\\;oI\"Aq\u000b\u0001B\u0001B\u0003%A*A\bmK\u001a$X\u000b\u001d9fe\n{WO\u001c3!\u0011!I\u0006A!b\u0001\n\u0013Y\u0015aD1mY><X\r\u001a'bi\u0016tWm]:\t\u0011m\u0003!\u0011!Q\u0001\n1\u000b\u0001#\u00197m_^,G\rT1uK:,7o\u001d\u0011\t\u0011u\u0003!Q1A\u0005\ny\u000b\u0001\u0002\\3giRK\b/Z\u000b\u0002?B\u0019\u0001m\u0019\u0019\u000e\u0003\u0005T!AY\u0016\u0002\u0011QL\b/Z5oM>L!\u0001Z1\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:D\u0001B\u001a\u0001\u0003\u0002\u0003\u0006IaX\u0001\nY\u00164G\u000fV=qK\u0002B\u0001\u0002\u001b\u0001\u0003\u0006\u0004%IAX\u0001\ne&<\u0007\u000e\u001e+za\u0016D\u0001B\u001b\u0001\u0003\u0002\u0003\u0006IaX\u0001\u000be&<\u0007\u000e\u001e+za\u0016\u0004\u0003\u0002\u00037\u0001\u0005\u000b\u0007I\u0011B7\u0002\u001f\u001d,gNS8j]\u001a+hn\u0019(b[\u0016,\u0012A\u001c\t\u0003_Zt!\u0001\u001d;\u0011\u0005EtU\"\u0001:\u000b\u0005Mt\u0011A\u0002\u001fs_>$h(\u0003\u0002v\u001d\u00061\u0001K]3eK\u001aL!a\u001e=\u0003\rM#(/\u001b8h\u0015\t)h\n\u0003\u0005{\u0001\t\u0005\t\u0015!\u0003o\u0003A9WM\u001c&pS:4UO\\2OC6,\u0007\u0005\u0003\u0005}\u0001\t\u0015\r\u0011\"\u0003n\u0003=9WM\u001c&pS:4UO\\2D_\u0012,\u0007\u0002\u0003@\u0001\u0005\u0003\u0005\u000b\u0011\u00028\u0002!\u001d,gNS8j]\u001a+hnY\"pI\u0016\u0004\u0003bBA\u0001\u0001\u0011\u0005\u00111A\u0001\u0007y%t\u0017\u000e\u001e \u0015%\u0005\u0015\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0011q\u0003\t\u0004\u0003\u000f\u0001Q\"\u0001\u0002\t\u000bqz\b\u0019\u0001 \t\u000b){\b\u0019\u0001'\t\u000bU{\b\u0019\u0001'\t\u000be{\b\u0019\u0001'\t\u000bu{\b\u0019A0\t\u000b!|\b\u0019A0\t\u000b1|\b\u0019\u00018\t\u000bq|\b\u0019\u00018\t\u0013\u0005m\u0001A1A\u0005\n\u0005u\u0011a\u00039bI\u0012LgnZ+uS2,\"!a\b\u0011\t\u0005\u001d\u0011\u0011E\u0005\u0004\u0003G\u0011!\u0001F(vi\u0016\u0014(j\\5o!\u0006$G-\u001b8h+RLG\u000e\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u0010\u00031\u0001\u0018\r\u001a3j]\u001e,F/\u001b7!\u0011-\tY\u0003\u0001a\u0001\u0002\u0004%I!!\f\u0002\u001b)|\u0017N\\\"pY2,7\r^8s+\t\ty\u0003\u0005\u0003\u0002\b\u0005E\u0012bAA\u001a\u0005\t\u0011R)\\5u\u0003^\f'/Z\"pY2,7\r^8s\u0011-\t9\u0004\u0001a\u0001\u0002\u0004%I!!\u000f\u0002#)|\u0017N\\\"pY2,7\r^8s?\u0012*\u0017\u000f\u0006\u0003\u0002<\u0005\u0005\u0003cA'\u0002>%\u0019\u0011q\b(\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003\u0007\n)$!AA\u0002\u0005=\u0012a\u0001=%c!Y\u0011q\t\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0018\u00039Qw.\u001b8D_2dWm\u0019;pe\u0002B1\"a\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002N\u0005a!n\\5o\rVt7\r^5p]V\t\u0001\u0006C\u0006\u0002R\u0001\u0001\r\u00111A\u0005\n\u0005M\u0013\u0001\u00056pS:4UO\\2uS>tw\fJ3r)\u0011\tY$!\u0016\t\u0013\u0005\r\u0013qJA\u0001\u0002\u0004A\u0003BCA-\u0001\u0001\u0007\t\u0011)Q\u0005Q\u0005i!n\\5o\rVt7\r^5p]\u0002B1\"!\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002`\u0005IA.\u001a4u\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003C\u0002r!a\u0019\u0002j1\u000bi'\u0004\u0002\u0002f)\u0019\u0011qM\u0016\u0002\u000bM$\u0018\r^3\n\t\u0005-\u0014Q\r\u0002\t\u001b\u0006\u00048\u000b^1uKB1\u0011qNA;\u0003sj!!!\u001d\u000b\u0007a\n\u0019HC\u0001E\u0013\u0011\t9(!\u001d\u0003\t1K7\u000f\u001e\t\b\u0003w\n\t\tMAC\u001b\t\tiHC\u0002\u0002\u0000\r\u000bQ\u0001^;qY\u0016LA!a!\u0002~\t1A+\u001e9mKJ\u00022!TAD\u0013\r\tII\u0014\u0002\b\u0005>|G.Z1o\u0011-\ti\t\u0001a\u0001\u0002\u0004%I!a$\u0002\u001b1,g\r^\"bG\",w\fJ3r)\u0011\tY$!%\t\u0015\u0005\r\u00131RA\u0001\u0002\u0004\t\t\u0007C\u0006\u0002\u0016\u0002\u0001\r\u0011!Q!\n\u0005\u0005\u0014A\u00037fMR\u001c\u0015m\u00195fA!Y\u0011\u0011\u0014\u0001A\u0002\u0003\u0007I\u0011BA0\u0003)\u0011\u0018n\u001a5u\u0007\u0006\u001c\u0007.\u001a\u0005\f\u0003;\u0003\u0001\u0019!a\u0001\n\u0013\ty*\u0001\bsS\u001eDGoQ1dQ\u0016|F%Z9\u0015\t\u0005m\u0012\u0011\u0015\u0005\u000b\u0003\u0007\nY*!AA\u0002\u0005\u0005\u0004bCAS\u0001\u0001\u0007\t\u0011)Q\u0005\u0003C\n1B]5hQR\u001c\u0015m\u00195fA!Y\u0011\u0011\u0016\u0001A\u0002\u0003\u0007I\u0011BAV\u00039aWM\u001a;US6,'o\u0015;bi\u0016,\"!!,\u0011\u000b\u0005\r\u0014q\u0016'\n\t\u0005E\u0016Q\r\u0002\u000b-\u0006dW/Z*uCR,\u0007bCA[\u0001\u0001\u0007\t\u0019!C\u0005\u0003o\u000b!\u0003\\3giRKW.\u001a:Ti\u0006$Xm\u0018\u0013fcR!\u00111HA]\u0011)\t\u0019%a-\u0002\u0002\u0003\u0007\u0011Q\u0016\u0005\f\u0003{\u0003\u0001\u0019!A!B\u0013\ti+A\bmK\u001a$H+[7feN#\u0018\r^3!\u0011-\t\t\r\u0001a\u0001\u0002\u0004%I!a+\u0002\u001fILw\r\u001b;US6,'o\u0015;bi\u0016D1\"!2\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002H\u0006\u0019\"/[4iiRKW.\u001a:Ti\u0006$Xm\u0018\u0013fcR!\u00111HAe\u0011)\t\u0019%a1\u0002\u0002\u0003\u0007\u0011Q\u0016\u0005\f\u0003\u001b\u0004\u0001\u0019!A!B\u0013\ti+\u0001\tsS\u001eDG\u000fV5nKJ\u001cF/\u0019;fA!A\u0011\u0011\u001b\u0001C\u0002\u0013E1*\u0001\tmK\u001a$(+\u001a7bi&4XmU5{K\"9\u0011Q\u001b\u0001!\u0002\u0013a\u0015!\u00057fMR\u0014V\r\\1uSZ,7+\u001b>fA!A\u0011\u0011\u001c\u0001C\u0002\u0013E1*A\tsS\u001eDGOU3mCRLg/Z*ju\u0016Dq!!8\u0001A\u0003%A*\u0001\nsS\u001eDGOU3mCRLg/Z*ju\u0016\u0004\u0003\u0002CAq\u0001\u0001\u0007I\u0011B&\u0002%1,g\r^#ya&\u0014\u0018\r^5p]RKW.\u001a\u0005\n\u0003K\u0004\u0001\u0019!C\u0005\u0003O\fa\u0003\\3gi\u0016C\b/\u001b:bi&|g\u000eV5nK~#S-\u001d\u000b\u0005\u0003w\tI\u000fC\u0005\u0002D\u0005\r\u0018\u0011!a\u0001\u0019\"9\u0011Q\u001e\u0001!B\u0013a\u0015a\u00057fMR,\u0005\u0010]5sCRLwN\u001c+j[\u0016\u0004\u0003\u0002CAy\u0001\u0001\u0007I\u0011B&\u0002'ILw\r\u001b;FqBL'/\u0019;j_:$\u0016.\\3\t\u0013\u0005U\b\u00011A\u0005\n\u0005]\u0018a\u0006:jO\"$X\t\u001f9je\u0006$\u0018n\u001c8US6,w\fJ3r)\u0011\tY$!?\t\u0013\u0005\r\u00131_A\u0001\u0002\u0004a\u0005bBA\u007f\u0001\u0001\u0006K\u0001T\u0001\u0015e&<\u0007\u000e^#ya&\u0014\u0018\r^5p]RKW.\u001a\u0011\t\u0011\t\u0005\u0001\u00011A\u0005\u0012-\u000b\u0001\u0003\\3gi>\u0003XM]1u_J$\u0016.\\3\t\u0013\t\u0015\u0001\u00011A\u0005\u0012\t\u001d\u0011\u0001\u00067fMR|\u0005/\u001a:bi>\u0014H+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002<\t%\u0001\"CA\"\u0005\u0007\t\t\u00111\u0001M\u0011\u001d\u0011i\u0001\u0001Q!\n1\u000b\u0011\u0003\\3gi>\u0003XM]1u_J$\u0016.\\3!\u0011!\u0011\t\u0002\u0001a\u0001\n#Y\u0015!\u0005:jO\"$x\n]3sCR|'\u000fV5nK\"I!Q\u0003\u0001A\u0002\u0013E!qC\u0001\u0016e&<\u0007\u000e^(qKJ\fGo\u001c:US6,w\fJ3r)\u0011\tYD!\u0007\t\u0013\u0005\r#1CA\u0001\u0002\u0004a\u0005b\u0002B\u000f\u0001\u0001\u0006K\u0001T\u0001\u0013e&<\u0007\u000e^(qKJ\fGo\u001c:US6,\u0007\u0005\u0003\u0005\u0003\"\u0001\u0011\r\u0011\"\u0003L\u0003Ii\u0017N\\\"mK\u0006tW\u000b]%oi\u0016\u0014h/\u00197\t\u000f\t\u0015\u0002\u0001)A\u0005\u0019\u0006\u0019R.\u001b8DY\u0016\fg.\u00169J]R,'O^1mA!9!\u0011\u0006\u0001\u0005B\t-\u0012\u0001B8qK:$B!a\u000f\u0003.!A!q\u0006B\u0014\u0001\u0004\u0011\t$\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0005g\u0011I$\u0004\u0002\u00036)\u0019!q\u0007\u0005\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\u0011\u0011YD!\u000e\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\u0011y\u0004\u0001C!\u0005\u0003\nq\u0002\u001d:pG\u0016\u001c8/\u00127f[\u0016tG/\r\u000b\t\u0003w\u0011\u0019Ea\u0012\u0003R!9!Q\tB\u001f\u0001\u0004a\u0012!C2S_^4\u0016\r\\;f\u0011!\u0011IE!\u0010A\u0002\t-\u0013aA2uqB\u0019\u0001C!\u0014\n\u0007\t=#DA\u0004D_:$X\r\u001f;\t\u0011\tM#Q\ba\u0001\u0005+\n1a\\;u!\u0015\u00119Fa\u0017\u001d\u001b\t\u0011IF\u0003\u00029\u0011%!!Q\fB-\u0005%\u0019u\u000e\u001c7fGR|'\u000fC\u0004\u0003b\u0001!\tEa\u0019\u0002\u001fA\u0014xnY3tg\u0016cW-\\3oiJ\"\u0002\"a\u000f\u0003f\t\u001d$\u0011\u000e\u0005\b\u0005\u000b\u0012y\u00061\u0001\u001d\u0011!\u0011IEa\u0018A\u0002\t-\u0003\u0002\u0003B*\u0005?\u0002\rA!\u0016\t\u000f\t5\u0004\u0001\"\u0011\u0003p\u00059qN\u001c+j[\u0016\u0014H\u0003CA\u001e\u0005c\u0012)H! \t\u000f\tM$1\u000ea\u0001\u0019\u0006IA/[7fgR\fW\u000e\u001d\u0005\t\u0005\u0013\u0012Y\u00071\u0001\u0003xA\u0019\u0001C!\u001f\n\u0007\tm$D\u0001\bP]RKW.\u001a:D_:$X\r\u001f;\t\u0011\tM#1\u000ea\u0001\u0005+BqA!!\u0001\t\u0003\u0012\u0019)A\u0003dY>\u001cX\r\u0006\u0002\u0002<!9!q\u0011\u0001\u0005\n\t%\u0015!E2bY\u0016C\b/\u001b:bi&|g\u000eV5nKR)AJa#\u0003\u0010\"9!Q\u0012BC\u0001\u0004a\u0015\u0001D8qKJ\fGo\u001c:US6,\u0007b\u0002BI\u0005\u000b\u0003\r\u0001T\u0001\re\u0016d\u0017\r^5wKNK'0\u001a\u0005\b\u0005+\u0003A\u0011\u0002BL\u0003Q\u0011XmZ5ti\u0016\u00148\t\\3b]V\u0003H+[7feRA\u00111\bBM\u00057\u0013y\n\u0003\u0005\u0003J\tM\u0005\u0019\u0001B&\u0011\u001d\u0011iJa%A\u00021\u000bqA]8x)&lW\r\u0003\u0005\u0003\"\nM\u0005\u0019AAC\u0003\u001daWM\u001a;S_^DqA!*\u0001\t\u0013\u00119+A\tsK6|g/Z#ya&\u0014X\r\u001a*poN$b\"a\u000f\u0003*\n=&1\u0017B\\\u0005w\u0013i\f\u0003\u0005\u0003,\n\r\u0006\u0019\u0001BW\u0003%\u0019w\u000e\u001c7fGR|'\u000fE\u0003\u0003X\tm\u0003\u0007C\u0004\u00032\n\r\u0006\u0019\u0001'\u0002\u001d\u0015D\b/\u001b:bi&|g\u000eV5nK\"A!Q\u0017BR\u0001\u0004\t\t'\u0001\u0005s_^\u001c\u0015m\u00195f\u0011!\u0011ILa)A\u0002\u00055\u0016A\u0003;j[\u0016\u00148\u000b^1uK\"A!\u0011\nBR\u0001\u0004\u00119\b\u0003\u0005\u0003@\n\r\u0006\u0019AAC\u0003)\u0011X-\\8wK2+g\r\u001e\u0005\b\u0005\u0007\u0004a\u0011\u0001Bc\u0003I)\b\u000fZ1uK>\u0003XM]1u_J$\u0016.\\3\u0015\t\u0005m\"q\u0019\u0005\t\u0005\u0013\u0012\t\r1\u0001\u0003L!9!1\u001a\u0001\u0007\u0002\t5\u0017\u0001F4fiRKW.\u001a$pe2+g\r^*ue\u0016\fW\u000eF\u0003M\u0005\u001f\u0014\u0019\u000e\u0003\u0005\u0003R\n%\u0007\u0019\u0001B&\u0003\u001d\u0019wN\u001c;fqRDqA!6\u0003J\u0002\u0007\u0001'A\u0002s_^DqA!7\u0001\r\u0003\u0011Y.A\u000bhKR$\u0016.\\3G_J\u0014\u0016n\u001a5u'R\u0014X-Y7\u0015\u000b1\u0013iNa8\t\u0011\tE'q\u001ba\u0001\u0005\u0017BqA!6\u0003X\u0002\u0007\u0001\u0007C\u0004\u0003d\u00021\tA!:\u0002\u001bI,w-[:uKJ$\u0016.\\3s)\u0019\tYDa:\u0003j\"A!\u0011\nBq\u0001\u0004\u0011Y\u0005C\u0004\u0003l\n\u0005\b\u0019\u0001'\u0002\u0017\rdW-\u00198vaRKW.\u001a")
public abstract class TimeBoundedStreamJoin
extends CoProcessFunction<CRow, CRow, CRow>
implements Compiler<FlatJoinFunction<Row, Row, Row>>,
Logging {
    private final JoinType joinType;
    private final long leftLowerBound;
    private final long leftUpperBound;
    private final long allowedLateness;
    private final TypeInformation<Row> leftType;
    private final TypeInformation<Row> rightType;
    private final String genJoinFuncName;
    private final String genJoinFuncCode;
    private final OuterJoinPaddingUtil paddingUtil;
    private EmitAwareCollector joinCollector;
    private FlatJoinFunction<Row, Row, Row> joinFunction;
    private MapState<Object, List<Tuple2<Row, Object>>> leftCache;
    private MapState<Object, List<Tuple2<Row, Object>>> rightCache;
    private ValueState<Object> leftTimerState;
    private ValueState<Object> rightTimerState;
    private final long leftRelativeSize;
    private final long rightRelativeSize;
    private long leftExpirationTime;
    private long rightExpirationTime;
    private long leftOperatorTime;
    private long rightOperatorTime;
    private final long minCleanUpInterval;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<FlatJoinFunction<Row, Row, Row>> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        TimeBoundedStreamJoin timeBoundedStreamJoin = this;
        synchronized (timeBoundedStreamJoin) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private JoinType joinType() {
        return this.joinType;
    }

    private long leftLowerBound() {
        return this.leftLowerBound;
    }

    private long leftUpperBound() {
        return this.leftUpperBound;
    }

    private long allowedLateness() {
        return this.allowedLateness;
    }

    private TypeInformation<Row> leftType() {
        return this.leftType;
    }

    private TypeInformation<Row> rightType() {
        return this.rightType;
    }

    private String genJoinFuncName() {
        return this.genJoinFuncName;
    }

    private String genJoinFuncCode() {
        return this.genJoinFuncCode;
    }

    private OuterJoinPaddingUtil paddingUtil() {
        return this.paddingUtil;
    }

    private EmitAwareCollector joinCollector() {
        return this.joinCollector;
    }

    private void joinCollector_$eq(EmitAwareCollector x$1) {
        this.joinCollector = x$1;
    }

    private FlatJoinFunction<Row, Row, Row> joinFunction() {
        return this.joinFunction;
    }

    private void joinFunction_$eq(FlatJoinFunction<Row, Row, Row> x$1) {
        this.joinFunction = x$1;
    }

    private MapState<Object, List<Tuple2<Row, Object>>> leftCache() {
        return this.leftCache;
    }

    private void leftCache_$eq(MapState<Object, List<Tuple2<Row, Object>>> x$1) {
        this.leftCache = x$1;
    }

    private MapState<Object, List<Tuple2<Row, Object>>> rightCache() {
        return this.rightCache;
    }

    private void rightCache_$eq(MapState<Object, List<Tuple2<Row, Object>>> x$1) {
        this.rightCache = x$1;
    }

    private ValueState<Object> leftTimerState() {
        return this.leftTimerState;
    }

    private void leftTimerState_$eq(ValueState<Object> x$1) {
        this.leftTimerState = x$1;
    }

    private ValueState<Object> rightTimerState() {
        return this.rightTimerState;
    }

    private void rightTimerState_$eq(ValueState<Object> x$1) {
        this.rightTimerState = x$1;
    }

    public long leftRelativeSize() {
        return this.leftRelativeSize;
    }

    public long rightRelativeSize() {
        return this.rightRelativeSize;
    }

    private long leftExpirationTime() {
        return this.leftExpirationTime;
    }

    private void leftExpirationTime_$eq(long x$1) {
        this.leftExpirationTime = x$1;
    }

    private long rightExpirationTime() {
        return this.rightExpirationTime;
    }

    private void rightExpirationTime_$eq(long x$1) {
        this.rightExpirationTime = x$1;
    }

    public long leftOperatorTime() {
        return this.leftOperatorTime;
    }

    public void leftOperatorTime_$eq(long x$1) {
        this.leftOperatorTime = x$1;
    }

    public long rightOperatorTime() {
        return this.rightOperatorTime;
    }

    public void rightOperatorTime_$eq(long x$1) {
        this.rightOperatorTime = x$1;
    }

    private long minCleanUpInterval() {
        return this.minCleanUpInterval;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(28).append("Compiling JoinFunction: ").append(this.genJoinFuncName()).append(" \n\n ").append(new StringBuilder(6).append("Code:\n").append(this.genJoinFuncCode()).toString()).toString());
        Class<FlatJoinFunction<Row, Row, Row>> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genJoinFuncName(), this.genJoinFuncCode());
        this.LOG().debug("Instantiating JoinFunction.");
        this.joinFunction_$eq(clazz.newInstance());
        FunctionUtils.setFunctionRuntimeContext(this.joinFunction(), (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.joinFunction(), (Configuration)config);
        this.joinCollector_$eq(new EmitAwareCollector());
        this.joinCollector().setCRowChange(true);
        ListTypeInfo leftListTypeInfo = new ListTypeInfo((TypeInformation)new TupleTypeInfo(new TypeInformation[]{this.leftType(), BasicTypeInfo.BOOLEAN_TYPE_INFO}));
        MapStateDescriptor leftStateDescriptor = new MapStateDescriptor("WindowJoinLeftCache", Types$.MODULE$.LONG(), (TypeInformation)leftListTypeInfo);
        this.leftCache_$eq((MapState<Object, List<Tuple2<Row, Object>>>)this.getRuntimeContext().getMapState(leftStateDescriptor));
        ListTypeInfo rightListTypeInfo = new ListTypeInfo((TypeInformation)new TupleTypeInfo(new TypeInformation[]{this.rightType(), BasicTypeInfo.BOOLEAN_TYPE_INFO}));
        MapStateDescriptor rightStateDescriptor = new MapStateDescriptor("WindowJoinRightCache", Types$.MODULE$.LONG(), (TypeInformation)rightListTypeInfo);
        this.rightCache_$eq((MapState<Object, List<Tuple2<Row, Object>>>)this.getRuntimeContext().getMapState(rightStateDescriptor));
        ValueStateDescriptor leftTimerStateDesc = new ValueStateDescriptor("WindowJoinLeftTimerState", Long.TYPE);
        this.leftTimerState_$eq((ValueState<Object>)this.getRuntimeContext().getState(leftTimerStateDesc));
        ValueStateDescriptor rightTimerStateDesc = new ValueStateDescriptor("WindowJoinRightTimerState", Long.TYPE);
        this.rightTimerState_$eq((ValueState<Object>)this.getRuntimeContext().getState(rightTimerStateDesc));
    }

    public void processElement1(CRow cRowValue, CoProcessFunction.Context ctx, Collector<CRow> out) {
        block17: {
            boolean emitted;
            Row leftRow;
            block18: {
                block16: {
                    long rightQualifiedUpperBound;
                    long timeForLeftRow;
                    block13: {
                        this.joinCollector().innerCollector_$eq(out);
                        this.updateOperatorTime(ctx);
                        leftRow = cRowValue.row();
                        timeForLeftRow = this.getTimeForLeftStream(ctx, leftRow);
                        long rightQualifiedLowerBound = timeForLeftRow - this.rightRelativeSize();
                        rightQualifiedUpperBound = timeForLeftRow + this.leftRelativeSize();
                        emitted = false;
                        if (this.rightExpirationTime() >= rightQualifiedUpperBound) break block13;
                        this.rightExpirationTime_$eq(this.calExpirationTime(this.leftOperatorTime(), this.rightRelativeSize()));
                        Iterator rightIterator = this.rightCache().iterator();
                        while (rightIterator.hasNext()) {
                            block15: {
                                Map.Entry rightEntry;
                                block14: {
                                    Object object;
                                    rightEntry = (Map.Entry)rightIterator.next();
                                    long rightTime = BoxesRunTime.unboxToLong(rightEntry.getKey());
                                    if (rightTime >= rightQualifiedLowerBound && rightTime <= rightQualifiedUpperBound) {
                                        List rightRows = (List)rightEntry.getValue();
                                        boolean entryUpdated = false;
                                        for (int i = 0; i < rightRows.size(); ++i) {
                                            this.joinCollector().reset();
                                            Tuple2 tuple = (Tuple2)rightRows.get(i);
                                            this.joinFunction().join((Object)leftRow, tuple.f0, (Collector)this.joinCollector());
                                            emitted = emitted || this.joinCollector().emitted();
                                            JoinType joinType = this.joinType();
                                            JoinType joinType2 = JoinType.RIGHT_OUTER;
                                            if (joinType == null ? joinType2 != null : !joinType.equals(joinType2)) {
                                                JoinType joinType3 = this.joinType();
                                                JoinType joinType4 = JoinType.FULL_OUTER;
                                                if (joinType3 != null ? !joinType3.equals(joinType4) : joinType4 != null) continue;
                                            }
                                            if (BoxesRunTime.unboxToBoolean((Object)tuple.f1) || !this.joinCollector().emitted()) continue;
                                            tuple.f1 = BoxesRunTime.boxToBoolean((boolean)true);
                                            entryUpdated = true;
                                        }
                                        object = entryUpdated ? rightEntry.setValue(rightRows) : BoxedUnit.UNIT;
                                    } else {
                                        object = BoxedUnit.UNIT;
                                    }
                                    if (rightTime > this.rightExpirationTime()) continue;
                                    JoinType joinType = this.joinType();
                                    JoinType joinType5 = JoinType.RIGHT_OUTER;
                                    if (!(joinType == null ? joinType5 != null : !joinType.equals(joinType5))) break block14;
                                    JoinType joinType6 = this.joinType();
                                    JoinType joinType7 = JoinType.FULL_OUTER;
                                    if (joinType6 != null ? !joinType6.equals(joinType7) : joinType7 != null) break block15;
                                }
                                List rightRows = (List)rightEntry.getValue();
                                for (int i = 0; i < rightRows.size(); ++i) {
                                    Tuple2 tuple = (Tuple2)rightRows.get(i);
                                    if (BoxesRunTime.unboxToBoolean((Object)tuple.f1)) continue;
                                    this.joinCollector().collect(this.paddingUtil().padRight((Row)tuple.f0));
                                }
                            }
                            rightIterator.remove();
                        }
                    }
                    if (this.rightOperatorTime() >= rightQualifiedUpperBound) break block16;
                    ArrayList<Tuple2> leftRowList = (ArrayList<Tuple2>)this.leftCache().get((Object)BoxesRunTime.boxToLong((long)timeForLeftRow));
                    if (leftRowList == null) {
                        leftRowList = new ArrayList<Tuple2>(1);
                    }
                    leftRowList.add(Tuple2.of((Object)leftRow, (Object)BoxesRunTime.boxToBoolean((boolean)emitted)));
                    this.leftCache().put((Object)BoxesRunTime.boxToLong((long)timeForLeftRow), leftRowList);
                    if (BoxesRunTime.unboxToLong((Object)this.rightTimerState().value()) != 0L) break block17;
                    this.registerCleanUpTimer(ctx, timeForLeftRow, true);
                    break block17;
                }
                JoinType joinType = this.joinType();
                JoinType joinType8 = JoinType.LEFT_OUTER;
                if (!(joinType == null ? joinType8 != null : !joinType.equals(joinType8))) break block18;
                JoinType joinType9 = this.joinType();
                JoinType joinType10 = JoinType.FULL_OUTER;
                if (joinType9 != null ? !joinType9.equals(joinType10) : joinType10 != null) break block17;
            }
            if (!emitted) {
                this.joinCollector().collect(this.paddingUtil().padLeft(leftRow));
            }
        }
    }

    public void processElement2(CRow cRowValue, CoProcessFunction.Context ctx, Collector<CRow> out) {
        block17: {
            boolean emitted;
            Row rightRow;
            block18: {
                block16: {
                    long leftQualifiedUpperBound;
                    long timeForRightRow;
                    block13: {
                        this.joinCollector().innerCollector_$eq(out);
                        this.updateOperatorTime(ctx);
                        rightRow = cRowValue.row();
                        timeForRightRow = this.getTimeForRightStream(ctx, rightRow);
                        long leftQualifiedLowerBound = timeForRightRow - this.leftRelativeSize();
                        leftQualifiedUpperBound = timeForRightRow + this.rightRelativeSize();
                        emitted = false;
                        if (this.leftExpirationTime() >= leftQualifiedUpperBound) break block13;
                        this.leftExpirationTime_$eq(this.calExpirationTime(this.rightOperatorTime(), this.leftRelativeSize()));
                        Iterator leftIterator = this.leftCache().iterator();
                        while (leftIterator.hasNext()) {
                            block15: {
                                Map.Entry leftEntry;
                                block14: {
                                    Object object;
                                    leftEntry = (Map.Entry)leftIterator.next();
                                    long leftTime = BoxesRunTime.unboxToLong(leftEntry.getKey());
                                    if (leftTime >= leftQualifiedLowerBound && leftTime <= leftQualifiedUpperBound) {
                                        List leftRows = (List)leftEntry.getValue();
                                        boolean entryUpdated = false;
                                        for (int i = 0; i < leftRows.size(); ++i) {
                                            this.joinCollector().reset();
                                            Tuple2 tuple = (Tuple2)leftRows.get(i);
                                            this.joinFunction().join(tuple.f0, (Object)rightRow, (Collector)this.joinCollector());
                                            emitted = emitted || this.joinCollector().emitted();
                                            JoinType joinType = this.joinType();
                                            JoinType joinType2 = JoinType.LEFT_OUTER;
                                            if (joinType == null ? joinType2 != null : !joinType.equals(joinType2)) {
                                                JoinType joinType3 = this.joinType();
                                                JoinType joinType4 = JoinType.FULL_OUTER;
                                                if (joinType3 != null ? !joinType3.equals(joinType4) : joinType4 != null) continue;
                                            }
                                            if (BoxesRunTime.unboxToBoolean((Object)tuple.f1) || !this.joinCollector().emitted()) continue;
                                            tuple.f1 = BoxesRunTime.boxToBoolean((boolean)true);
                                            entryUpdated = true;
                                        }
                                        object = entryUpdated ? leftEntry.setValue(leftRows) : BoxedUnit.UNIT;
                                    } else {
                                        object = BoxedUnit.UNIT;
                                    }
                                    if (leftTime > this.leftExpirationTime()) continue;
                                    JoinType joinType = this.joinType();
                                    JoinType joinType5 = JoinType.LEFT_OUTER;
                                    if (!(joinType == null ? joinType5 != null : !joinType.equals(joinType5))) break block14;
                                    JoinType joinType6 = this.joinType();
                                    JoinType joinType7 = JoinType.FULL_OUTER;
                                    if (joinType6 != null ? !joinType6.equals(joinType7) : joinType7 != null) break block15;
                                }
                                List leftRows = (List)leftEntry.getValue();
                                for (int i = 0; i < leftRows.size(); ++i) {
                                    Tuple2 tuple = (Tuple2)leftRows.get(i);
                                    if (BoxesRunTime.unboxToBoolean((Object)tuple.f1)) continue;
                                    this.joinCollector().collect(this.paddingUtil().padLeft((Row)tuple.f0));
                                }
                            }
                            leftIterator.remove();
                        }
                    }
                    if (this.leftOperatorTime() >= leftQualifiedUpperBound) break block16;
                    ArrayList<Tuple2> rightRowList = (ArrayList<Tuple2>)this.rightCache().get((Object)BoxesRunTime.boxToLong((long)timeForRightRow));
                    if (rightRowList == null) {
                        rightRowList = new ArrayList<Tuple2>(1);
                    }
                    rightRowList.add(new Tuple2((Object)rightRow, (Object)BoxesRunTime.boxToBoolean((boolean)emitted)));
                    this.rightCache().put((Object)BoxesRunTime.boxToLong((long)timeForRightRow), rightRowList);
                    if (BoxesRunTime.unboxToLong((Object)this.leftTimerState().value()) != 0L) break block17;
                    this.registerCleanUpTimer(ctx, timeForRightRow, false);
                    break block17;
                }
                JoinType joinType = this.joinType();
                JoinType joinType8 = JoinType.RIGHT_OUTER;
                if (!(joinType == null ? joinType8 != null : !joinType.equals(joinType8))) break block18;
                JoinType joinType9 = this.joinType();
                JoinType joinType10 = JoinType.FULL_OUTER;
                if (joinType9 != null ? !joinType9.equals(joinType10) : joinType10 != null) break block17;
            }
            if (!emitted) {
                this.joinCollector().collect(this.paddingUtil().padRight(rightRow));
            }
        }
    }

    public void onTimer(long timestamp, CoProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        block1: {
            this.joinCollector().innerCollector_$eq(out);
            this.updateOperatorTime((CoProcessFunction.Context)ctx);
            if (BoxesRunTime.unboxToLong((Object)this.leftTimerState().value()) == timestamp) {
                this.rightExpirationTime_$eq(this.calExpirationTime(this.leftOperatorTime(), this.rightRelativeSize()));
                this.removeExpiredRows(this.joinCollector(), this.rightExpirationTime(), this.rightCache(), this.leftTimerState(), ctx, false);
            }
            if (BoxesRunTime.unboxToLong((Object)this.rightTimerState().value()) != timestamp) break block1;
            this.leftExpirationTime_$eq(this.calExpirationTime(this.rightOperatorTime(), this.leftRelativeSize()));
            this.removeExpiredRows(this.joinCollector(), this.leftExpirationTime(), this.leftCache(), this.rightTimerState(), ctx, true);
        }
    }

    public void close() {
        FunctionUtils.closeFunction(this.joinFunction());
    }

    private long calExpirationTime(long operatorTime, long relativeSize) {
        return operatorTime < Long.MAX_VALUE ? operatorTime - relativeSize - this.allowedLateness() - 1L : Long.MAX_VALUE;
    }

    private void registerCleanUpTimer(CoProcessFunction.Context ctx, long rowTime, boolean leftRow) {
        if (leftRow) {
            long cleanupTime = rowTime + this.leftRelativeSize() + this.minCleanUpInterval() + this.allowedLateness() + 1L;
            this.registerTimer(ctx, cleanupTime);
            this.rightTimerState().update((Object)BoxesRunTime.boxToLong((long)cleanupTime));
        } else {
            long cleanupTime = rowTime + this.rightRelativeSize() + this.minCleanUpInterval() + this.allowedLateness() + 1L;
            this.registerTimer(ctx, cleanupTime);
            this.leftTimerState().update((Object)BoxesRunTime.boxToLong((long)cleanupTime));
        }
    }

    private void removeExpiredRows(Collector<Row> collector, long expirationTime, MapState<Object, List<Tuple2<Row, Object>>> rowCache, ValueState<Object> timerState, CoProcessFunction.OnTimerContext ctx, boolean removeLeft) {
        Iterator iterator = rowCache.iterator();
        long earliestTimestamp = -1L;
        while (iterator.hasNext()) {
            long rowTime;
            block6: {
                block9: {
                    Map.Entry entry;
                    block10: {
                        block7: {
                            block8: {
                                entry = (Map.Entry)iterator.next();
                                rowTime = BoxesRunTime.unboxToLong(entry.getKey());
                                if (rowTime > expirationTime) break block6;
                                if (!removeLeft) break block7;
                                JoinType joinType = this.joinType();
                                JoinType joinType2 = JoinType.LEFT_OUTER;
                                if (!(joinType == null ? joinType2 != null : !joinType.equals(joinType2))) break block8;
                                JoinType joinType3 = this.joinType();
                                JoinType joinType4 = JoinType.FULL_OUTER;
                                if (joinType3 != null ? !joinType3.equals(joinType4) : joinType4 != null) break block7;
                            }
                            List rows = (List)entry.getValue();
                            for (int i = 0; i < rows.size(); ++i) {
                                Tuple2 tuple = (Tuple2)rows.get(i);
                                if (BoxesRunTime.unboxToBoolean((Object)tuple.f1)) continue;
                                collector.collect((Object)this.paddingUtil().padLeft((Row)tuple.f0));
                            }
                            break block9;
                        }
                        if (removeLeft) break block9;
                        JoinType joinType = this.joinType();
                        JoinType joinType5 = JoinType.RIGHT_OUTER;
                        if (!(joinType == null ? joinType5 != null : !joinType.equals(joinType5))) break block10;
                        JoinType joinType6 = this.joinType();
                        JoinType joinType7 = JoinType.FULL_OUTER;
                        if (joinType6 != null ? !joinType6.equals(joinType7) : joinType7 != null) break block9;
                    }
                    List rows = (List)entry.getValue();
                    for (int i = 0; i < rows.size(); ++i) {
                        Tuple2 tuple = (Tuple2)rows.get(i);
                        if (BoxesRunTime.unboxToBoolean((Object)tuple.f1)) continue;
                        collector.collect((Object)this.paddingUtil().padRight((Row)tuple.f0));
                    }
                }
                iterator.remove();
                continue;
            }
            if (rowTime >= earliestTimestamp && earliestTimestamp >= 0L) continue;
            earliestTimestamp = rowTime;
        }
        if (earliestTimestamp > 0L) {
            this.registerCleanUpTimer((CoProcessFunction.Context)ctx, earliestTimestamp, removeLeft);
        } else {
            timerState.clear();
            rowCache.clear();
        }
    }

    public abstract void updateOperatorTime(CoProcessFunction.Context var1);

    public abstract long getTimeForLeftStream(CoProcessFunction.Context var1, Row var2);

    public abstract long getTimeForRightStream(CoProcessFunction.Context var1, Row var2);

    public abstract void registerTimer(CoProcessFunction.Context var1, long var2);

    public TimeBoundedStreamJoin(JoinType joinType, long leftLowerBound, long leftUpperBound, long allowedLateness, TypeInformation<Row> leftType, TypeInformation<Row> rightType, String genJoinFuncName, String genJoinFuncCode) {
        this.joinType = joinType;
        this.leftLowerBound = leftLowerBound;
        this.leftUpperBound = leftUpperBound;
        this.allowedLateness = allowedLateness;
        this.leftType = leftType;
        this.rightType = rightType;
        this.genJoinFuncName = genJoinFuncName;
        this.genJoinFuncCode = genJoinFuncCode;
        Compiler.$init$(this);
        Logging.$init$(this);
        this.paddingUtil = new OuterJoinPaddingUtil(leftType.getArity(), rightType.getArity());
        this.leftRelativeSize = -leftLowerBound;
        this.rightRelativeSize = leftUpperBound;
        this.leftExpirationTime = 0L;
        this.rightExpirationTime = 0L;
        this.leftOperatorTime = 0L;
        this.rightOperatorTime = 0L;
        this.minCleanUpInterval = (this.leftRelativeSize() + this.rightRelativeSize()) / 2L;
        if (allowedLateness < 0L) {
            throw new IllegalArgumentException("The allowed lateness must be non-negative.");
        }
    }
}

