/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0001=\u0011qCU8x)&lWMQ8v]\u0012,GMU1oO\u0016|e/\u001a:\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u000e$!\u0011\t\"\u0003\u0006\u000b\u000e\u0003\tI!a\u0005\u0002\u0003?A\u0013xnY3tg\u001a+hn\u0019;j_:<\u0016\u000e\u001e5DY\u0016\fg.\u001e9Ti\u0006$X\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u0005)A/\u001f9fg&\u0011\u0011D\u0006\u0002\u0005\u0007J{w\u000fE\u0002\u001c=\u0001j\u0011\u0001\b\u0006\u0003;\u0019\tqaY8eK\u001e,g.\u0003\u0002 9\tA1i\\7qS2,'\u000f\u0005\u0002\u0012C%\u0011!E\u0001\u0002\u0016\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t!\t!s%D\u0001&\u0015\t1c!\u0001\u0003vi&d\u0017B\u0001\u0015&\u0005\u001daunZ4j]\u001eD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0010O\u0016t\u0017iZ4sK\u001e\fG/[8ogB\u00111\u0004L\u0005\u0003[q\u0011QdR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7OR;oGRLwN\u001c\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005!\u0012mZ4sK\u001e\fG/[8o'R\fG/\u001a+za\u0016\u0004\"!\r\u001d\u000e\u0003IR!a\r\u001b\u0002\u0013QL\b/Z;uS2\u001c(BA\u001b7\u0003\u0011Q\u0017M^1\u000b\u0005]B\u0011aA1qS&\u0011\u0011H\r\u0002\f%><H+\u001f9f\u0013:4w\u000e\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u00031Ig\u000e];u%><H+\u001f9f!\t)R(\u0003\u0002?-\ta1IU8x)f\u0004X-\u00138g_\"A\u0001\t\u0001B\u0001B\u0003%\u0011)A\bqe\u0016\u001cW\rZ5oO>3gm]3u!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u0011auN\\4\t\u0011!\u0003!\u0011!Q\u0001\n%\u000b!B]8x)&lW-\u00133y!\t\u0011%*\u0003\u0002L\u0007\n\u0019\u0011J\u001c;\t\u00115\u0003!\u0011!Q\u0001\n9\u000b1\"];fef\u001cuN\u001c4jOB\u0011q*U\u0007\u0002!*\u0011qGB\u0005\u0003%B\u0013\u0011c\u0015;sK\u0006l\u0017+^3ss\u000e{gNZ5h\u0011\u0015!\u0006\u0001\"\u0001V\u0003\u0019a\u0014N\\5u}Q9ak\u0016-Z5nc\u0006CA\t\u0001\u0011\u0015Q3\u000b1\u0001,\u0011\u0015y3\u000b1\u00011\u0011\u0015Y4\u000b1\u0001=\u0011\u0015\u00015\u000b1\u0001B\u0011\u0015A5\u000b1\u0001J\u0011\u0015i5\u000b1\u0001O\u0011%q\u0006\u00011AA\u0002\u0013%q,\u0001\u0004pkR\u0004X\u000f^\u000b\u0002)!I\u0011\r\u0001a\u0001\u0002\u0004%IAY\u0001\u000b_V$\b/\u001e;`I\u0015\fHCA2g!\t\u0011E-\u0003\u0002f\u0007\n!QK\\5u\u0011\u001d9\u0007-!AA\u0002Q\t1\u0001\u001f\u00132\u0011%I\u0007\u00011A\u0001B\u0003&A#A\u0004pkR\u0004X\u000f\u001e\u0011\t\u0013-\u0004\u0001\u0019!a\u0001\n\u0013a\u0017!\u00067bgR$&/[4hKJLgn\u001a+t'R\fG/Z\u000b\u0002[B\u0019an]!\u000e\u0003=T!\u0001]9\u0002\u000bM$\u0018\r^3\u000b\u0005I4\u0014AB2p[6|g.\u0003\u0002u_\nQa+\u00197vKN#\u0018\r^3\t\u0013Y\u0004\u0001\u0019!a\u0001\n\u00139\u0018!\u00077bgR$&/[4hKJLgn\u001a+t'R\fG/Z0%KF$\"a\u0019=\t\u000f\u001d,\u0018\u0011!a\u0001[\"I!\u0010\u0001a\u0001\u0002\u0003\u0006K!\\\u0001\u0017Y\u0006\u001cH\u000f\u0016:jO\u001e,'/\u001b8h)N\u001cF/\u0019;fA!IA\u0010\u0001a\u0001\u0002\u0004%I!`\u0001\u0011C\u000e\u001cW/\\;mCR|'o\u0015;bi\u0016,\u0012A \t\u0004]N|\b\u0003BA\u0001\u0003\u000bi!!a\u0001\u000b\u0005]A\u0011\u0002BA\u0004\u0003\u0007\u00111AU8x\u0011-\tY\u0001\u0001a\u0001\u0002\u0004%I!!\u0004\u0002)\u0005\u001c7-^7vY\u0006$xN]*uCR,w\fJ3r)\r\u0019\u0017q\u0002\u0005\tO\u0006%\u0011\u0011!a\u0001}\"Q\u00111\u0003\u0001A\u0002\u0003\u0005\u000b\u0015\u0002@\u0002#\u0005\u001c7-^7vY\u0006$xN]*uCR,\u0007\u0005C\u0006\u0002\u0018\u0001\u0001\r\u00111A\u0005\n\u0005e\u0011!\u00033bi\u0006\u001cF/\u0019;f+\t\tY\u0002\u0005\u0004o\u0003;\t\u0015\u0011E\u0005\u0004\u0003?y'\u0001C'baN#\u0018\r^3\u0011\u000b\u0005\r\u0012\u0011F@\u000e\u0005\u0005\u0015\"b\u0001\u0014\u0002()\tQ'\u0003\u0003\u0002,\u0005\u0015\"\u0001\u0002'jgRD1\"a\f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00022\u0005iA-\u0019;b'R\fG/Z0%KF$2aYA\u001a\u0011%9\u0017QFA\u0001\u0002\u0004\tY\u0002C\u0006\u00028\u0001\u0001\r\u0011!Q!\n\u0005m\u0011A\u00033bi\u0006\u001cF/\u0019;fA!Y\u00111\b\u0001A\u0002\u0003\u0007I\u0011BA\u001f\u0003!1WO\\2uS>tW#\u0001\u0011\t\u0017\u0005\u0005\u0003\u00011AA\u0002\u0013%\u00111I\u0001\rMVt7\r^5p]~#S-\u001d\u000b\u0004G\u0006\u0015\u0003\u0002C4\u0002@\u0005\u0005\t\u0019\u0001\u0011\t\u0015\u0005%\u0003\u00011A\u0001B\u0003&\u0001%A\u0005gk:\u001cG/[8oA!9\u0011Q\n\u0001\u0005B\u0005=\u0013\u0001B8qK:$2aYA)\u0011!\t\u0019&a\u0013A\u0002\u0005U\u0013AB2p]\u001aLw\r\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tY\u0006C\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\u0005}\u0013\u0011\f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002f\u0005q\u0001O]8dKN\u001cX\t\\3nK:$HcB2\u0002h\u0005-\u0014q\u0011\u0005\b\u0003S\n\t\u00071\u0001\u0015\u0003\u0019Ig\u000e];u\u0007\"A\u0011QNA1\u0001\u0004\ty'A\u0002dib\u0004B!!\u001d\u0002\u0004B1\u00111OA@)Qi!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\nMVt7\r^5p]NT1aNA>\u0015\r\ti\bC\u0001\ngR\u0014X-Y7j]\u001eLA!!!\u0002v\ty\u0001K]8dKN\u001ch)\u001e8di&|g.\u0003\u0003\u0002\u0006\u0006}$aB\"p]R,\u0007\u0010\u001e\u0005\t\u0003\u0013\u000b\t\u00071\u0001\u0002\f\u0006\u0019q.\u001e;\u0011\u000b\u00055\u0015\u0011\u0013\u000b\u000e\u0005\u0005=%B\u0001\u0014\t\u0013\u0011\t\u0019*a$\u0003\u0013\r{G\u000e\\3di>\u0014\bbBAL\u0001\u0011\u0005\u0013\u0011T\u0001\b_:$\u0016.\\3s)\u001d\u0019\u00171TAP\u0003OCq!!(\u0002\u0016\u0002\u0007\u0011)A\u0005uS6,7\u000f^1na\"A\u0011QNAK\u0001\u0004\t\t\u000b\u0005\u0003\u0002r\u0005\r\u0016\u0002BAS\u0003\u007f\u0012ab\u00148US6,'oQ8oi\u0016DH\u000f\u0003\u0005\u0002\n\u0006U\u0005\u0019AAF\u0011\u001d\tY\u000b\u0001C!\u0003[\u000bQa\u00197pg\u0016$\u0012a\u0019")
public class RowTimeBoundedRangeOver
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        RowTimeBoundedRangeOver rowTimeBoundedRangeOver = this;
        synchronized (rowTimeBoundedRangeOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(30).append("Compiling AggregateHelper: ").append(this.genAggregations.name()).append(" \n\n").append(new StringBuilder(6).append("Code:\n").append(this.genAggregations.code()).toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRangeOverCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        block2: {
            Row input = inputC.row();
            this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
            long triggeringTs = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
            long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
            if (triggeringTs <= lastTriggeringTs) break block2;
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)triggeringTs));
            if (data != null) {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), (Object)data);
            } else {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            }
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.needToCleanupState(timestamp)) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            int dataListIndex = 0;
            boolean aggregatesIndex = false;
            if (accumulators == null) {
                accumulators = this.function().createAccumulators();
                aggregatesIndex = false;
            }
            ArrayList<Long> retractTsList = new ArrayList<Long>();
            for (Map.Entry entry : this.dataState()) {
                Object object;
                long dataTs = BoxesRunTime.unboxToLong(entry.getKey());
                long offset = timestamp - dataTs;
                if (offset > this.precedingOffset) {
                    List retractDataList = (List)entry.getValue();
                    for (dataListIndex = 0; dataListIndex < retractDataList.size(); ++dataListIndex) {
                        Row retractRow = (Row)retractDataList.get(dataListIndex);
                        this.function().retract(accumulators, retractRow);
                    }
                    object = BoxesRunTime.boxToBoolean((boolean)retractTsList.add(BoxesRunTime.boxToLong((long)dataTs)));
                    continue;
                }
                object = BoxedUnit.UNIT;
            }
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                Row curRow = (Row)inputs.get(dataListIndex);
                this.function().accumulate(accumulators, curRow);
            }
            this.function().setAggregationResults(accumulators, this.output().row());
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                aggregatesIndex = false;
                this.function().setForwardedFields((Row)inputs.get(dataListIndex), this.output().row());
                out.collect((Object)this.output());
            }
            for (dataListIndex = 0; dataListIndex < retractTsList.size(); ++dataListIndex) {
                this.dataState().remove(retractTsList.get(dataListIndex));
            }
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public void close() {
        this.function().close();
    }

    public RowTimeBoundedRangeOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, int rowTimeIdx, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(queryConfig);
        Compiler.$init$(this);
        Logging.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

