/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.plan.rules.logical.PushFilterIntoTableSourceScanRule$;
import org.apache.flink.table.plan.util.RexProgramExtractor$;
import org.apache.flink.table.sources.FilterableTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.validate.FunctionCatalog;
import org.apache.flink.table.validate.FunctionCatalog$;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001#\t\t\u0003+^:i\r&dG/\u001a:J]R|G+\u00192mKN{WO]2f'\u000e\fgNU;mK*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M9R\"\u0001\u000b\u000b\u0005\u001d)\"B\u0001\f\r\u0003\u001d\u0019\u0017\r\\2ji\u0016L!\u0001\u0007\u000b\u0003\u0015I+Gn\u00149u%VdW\rC\u0003\u001b\u0001\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u0005!)q\u0004\u0001C!A\u00059Q.\u0019;dQ\u0016\u001cHCA\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u000b\u0010A\u0002%\nAaY1mYB\u00111CK\u0005\u0003WQ\u0011aBU3m\u001fB$(+\u001e7f\u0007\u0006dG\u000eC\u0003.\u0001\u0011\u0005c&A\u0004p]6\u000bGo\u00195\u0015\u0005=\u0012\u0004C\u0001\u00121\u0013\t\t4E\u0001\u0003V]&$\b\"\u0002\u0015-\u0001\u0004I\u0003\"\u0002\u001b\u0001\t\u0013)\u0014A\u00059vg\"4\u0015\u000e\u001c;fe&sGo\\*dC:$ba\f\u001c8\u0001\u0016K\u0006\"\u0002\u00154\u0001\u0004I\u0003\"\u0002\u001d4\u0001\u0004I\u0014\u0001B2bY\u000e\u0004\"A\u000f \u000e\u0003mR!a\u0001\u001f\u000b\u0005u2\u0011!\u00028pI\u0016\u001c\u0018BA <\u0005A1E.\u001b8l\u0019><\u0017nY1m\u0007\u0006d7\rC\u0003Bg\u0001\u0007!)\u0001\u0003tG\u0006t\u0007C\u0001\u001eD\u0013\t!5HA\u000eGY&t7\u000eT8hS\u000e\fG\u000eV1cY\u0016\u001cv.\u001e:dKN\u001b\u0017M\u001c\u0005\u0006\rN\u0002\raR\u0001\u0011M&dG/\u001a:bE2,7k\\;sG\u0016\u0004$\u0001\u0013)\u0011\u0007%ce*D\u0001K\u0015\tY\u0005\"A\u0004t_V\u00148-Z:\n\u00055S%!\u0006$jYR,'/\u00192mKR\u000b'\r\\3T_V\u00148-\u001a\t\u0003\u001fBc\u0001\u0001B\u0005R\u000b\u0006\u0005\t\u0011!B\u0001%\n\u0019q\f\n\u001a\u0012\u0005M3\u0006C\u0001\u0012U\u0013\t)6EA\u0004O_RD\u0017N\\4\u0011\u0005\t:\u0016B\u0001-$\u0005\r\te.\u001f\u0005\u00065N\u0002\raW\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0005\u0002]G:\u0011Q,\u0019\t\u0003=\u000ej\u0011a\u0018\u0006\u0003AB\ta\u0001\u0010:p_Rt\u0014B\u00012$\u0003\u0019\u0001&/\u001a3fM&\u0011A-\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t\u001cs!B4\u0003\u0011\u0003A\u0017!\t)vg\"4\u0015\u000e\u001c;fe&sGo\u001c+bE2,7k\\;sG\u0016\u001c6-\u00198Sk2,\u0007CA\u000fj\r\u0015\t!\u0001#\u0001k'\tI7\u000e\u0005\u0002#Y&\u0011Qn\t\u0002\u0007\u0003:L(+\u001a4\t\u000biIG\u0011A8\u0015\u0003!Dq!]5C\u0002\u0013\u0005!/\u0001\u0005J\u001dN#\u0016IT\"F+\u0005\u0011\u0002B\u0002;jA\u0003%!#A\u0005J\u001dN#\u0016IT\"FA\u0001")
public class PushFilterIntoTableSourceScanRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return PushFilterIntoTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean bl;
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        TableSource<?> tableSource = scan.tableSource();
        if (tableSource instanceof FilterableTableSource) {
            TableSource<?> tableSource2 = tableSource;
            bl = calc.getProgram().getCondition() != null && !((FilterableTableSource)((Object)tableSource2)).isFilterPushedDown();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        FilterableTableSource filterableSource = (FilterableTableSource)((Object)scan.tableSource());
        this.pushFilterIntoScan(call, calc, scan, filterableSource, this.description);
    }

    private void pushFilterIntoScan(RelOptRuleCall call, FlinkLogicalCalc calc, FlinkLogicalTableSourceScan scan, FilterableTableSource<?> filterableSource, String description) {
        RexProgram newRexProgram;
        RexProgram rexProgram;
        RexNode rexNode;
        Preconditions.checkArgument((!filterableSource.isFilterPushedDown() ? 1 : 0) != 0);
        RexProgram program = calc.getProgram();
        FunctionCatalog functionCatalog = FunctionCatalog$.MODULE$.withBuiltIns();
        Tuple2<Expression[], RexNode[]> tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(program, call.builder().getRexBuilder(), functionCatalog);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] predicates = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)predicates, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] predicates2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates2)).isEmpty()) {
            return;
        }
        LinkedList<Expression> remainingPredicates = new LinkedList<Expression>();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates2)).foreach((Function1 & Serializable & scala.Serializable)e2 -> BoxesRunTime.boxToBoolean((boolean)remainingPredicates.add(e2)));
        TableSource<?> newTableSource = filterableSource.applyPredicate(remainingPredicates);
        RelBuilder relBuilder = call.builder();
        if (!remainingPredicates.isEmpty() || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2)).nonEmpty()) {
            relBuilder.push(scan);
            Buffer remainingConditions = ((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(remainingPredicates).asScala()).map((Function1 & Serializable & scala.Serializable)expr -> expr.toRexNode(relBuilder), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2)));
            rexNode = (RexNode)remainingConditions.reduce((Function2 & Serializable & scala.Serializable)(l, r) -> relBuilder.and((RexNode)l, (RexNode)r));
        } else {
            rexNode = null;
        }
        RexNode remainingCondition = rexNode;
        FlinkLogicalTableSourceScan newScan = scan.copy(scan.getTraitSet(), newTableSource, scan.selectedFields());
        if (remainingCondition != null || !program.projectsOnlyIdentity()) {
            List expandedProjectList = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(program.getProjectList()).asScala()).map((Function1 & Serializable & scala.Serializable)ref -> program.expandLocalRef((RexLocalRef)ref), Buffer$.MODULE$.canBuildFrom())).asJava();
            rexProgram = RexProgram.create(program.getInputRowType(), (List<? extends RexNode>)expandedProjectList, remainingCondition, program.getOutputRowType(), relBuilder.getRexBuilder());
        } else {
            rexProgram = newRexProgram = null;
        }
        if (newRexProgram != null) {
            Calc newCalc = calc.copy(calc.getTraitSet(), newScan, newRexProgram);
            call.transformTo(newCalc);
        } else {
            call.transformTo(newScan);
        }
    }

    public PushFilterIntoTableSourceScanRule() {
        super(RelOptRule.operand(FlinkLogicalCalc.class, RelOptRule.operand(FlinkLogicalTableSourceScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushFilterIntoTableSourceScanRule");
    }
}

