/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import java.io.Serializable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.aftermatch.SkipPastLastStrategy;
import org.apache.flink.cep.nfa.aftermatch.SkipToElementStrategy;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.conditions.BooleanConditions;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.plan.logical.MatchRecognize;
import org.apache.flink.table.plan.util.RexDefaultVisitor;
import org.apache.flink.table.runtime.match.IterativeConditionRunner;
import org.apache.flink.table.runtime.match.MatchUtil$;
import org.apache.flink.types.Row;
import org.apache.flink.util.MathUtils;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.LinkedHashSet;
import scala.reflect.ScalaSignature;

@VisibleForTesting
@ScalaSignature(bytes="\u0006\u0001\u0005Md!B\u0001\u0003\u0001)\u0001\"A\u0004)biR,'O\u001c,jg&$xN\u001d\u0006\u0003\u0007\u0011\t!\u0002Z1uCN$(/Z1n\u0015\t)a!A\u0003o_\u0012,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h'\t\u0001\u0011\u0003E\u0002\u0013+]i\u0011a\u0005\u0006\u0003)\u0019\tA!\u001e;jY&\u0011ac\u0005\u0002\u0012%\u0016DH)\u001a4bk2$h+[:ji>\u0014\b\u0003\u0002\r\u001e?}i\u0011!\u0007\u0006\u00035m\tq\u0001]1ui\u0016\u0014hN\u0003\u0002\u001d\u0015\u0005\u00191-\u001a9\n\u0005yI\"a\u0002)biR,'O\u001c\t\u0003A\rj\u0011!\t\u0006\u0003E)\tQ\u0001^=qKNL!\u0001J\u0011\u0003\u0007I{w\u000f\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003)\u0003\u0019\u0019wN\u001c4jO\u000e\u0001\u0001CA\u0015-\u001b\u0005Q#BA\u0016\t\u0003\r\t\u0007/[\u0005\u0003[)\u00121\u0002V1cY\u0016\u001cuN\u001c4jO\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0007j]B,H\u000fV=qK&sgm\u001c\t\u0004c]zR\"\u0001\u001a\u000b\u0005M\"\u0014\u0001\u0003;za\u0016LgNZ8\u000b\u0005U2\u0014AB2p[6|gN\u0003\u0002,\u0015%\u0011\u0001H\r\u0002\u0010)f\u0004X-\u00138g_Jl\u0017\r^5p]\"A!\b\u0001B\u0001B\u0003%1(\u0001\u0007m_\u001eL7-\u00197NCR\u001c\u0007\u000e\u0005\u0002=\u007f5\tQH\u0003\u0002?\r\u00059An\\4jG\u0006d\u0017B\u0001!>\u00059i\u0015\r^2i%\u0016\u001cwn\u001a8ju\u0016DQA\u0011\u0001\u0005\u0002\r\u000ba\u0001P5oSRtD\u0003\u0002#G\u000f\"\u0003\"!\u0012\u0001\u000e\u0003\tAQAJ!A\u0002!BQaL!A\u0002ABQAO!A\u0002mB\u0011B\u0007\u0001A\u0002\u0003\u0007I\u0011\u0002&\u0016\u0003]A\u0011\u0002\u0014\u0001A\u0002\u0003\u0007I\u0011B'\u0002\u0017A\fG\u000f^3s]~#S-\u001d\u000b\u0003\u001dR\u0003\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013A!\u00168ji\"9QkSA\u0001\u0002\u00049\u0012a\u0001=%c!Iq\u000b\u0001a\u0001\u0002\u0003\u0006KaF\u0001\ta\u0006$H/\u001a:oA!9\u0011\f\u0001b\u0001\n\u0003Q\u0016!\u00028b[\u0016\u001cX#A.\u0011\u0007q\u000b7-D\u0001^\u0015\tqv,A\u0004nkR\f'\r\\3\u000b\u0005\u0001\u0004\u0016AC2pY2,7\r^5p]&\u0011!-\u0018\u0002\u000e\u0019&t7.\u001a3ICND7+\u001a;\u0011\u0005\u0011\\gBA3j!\t1\u0007+D\u0001h\u0015\tAw%\u0001\u0004=e>|GOP\u0005\u0003UB\u000ba\u0001\u0015:fI\u00164\u0017B\u00017n\u0005\u0019\u0019FO]5oO*\u0011!\u000e\u0015\u0005\u0007_\u0002\u0001\u000b\u0011B.\u0002\r9\fW.Z:!\u0011\u0015\t\b\u0001\"\u0011s\u000311\u0018n]5u\u0019&$XM]1m)\t92\u000fC\u0003ua\u0002\u0007Q/A\u0004mSR,'/\u00197\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018a\u0001:fq*\u0011!\u0010D\u0001\bG\u0006d7-\u001b;f\u0013\taxO\u0001\u0006SKbd\u0015\u000e^3sC2DQA \u0001\u0005B}\f\u0011B^5tSR\u001c\u0015\r\u001c7\u0015\u0007]\t\t\u0001C\u0004\u0002\u0004u\u0004\r!!\u0002\u0002\t\r\fG\u000e\u001c\t\u0004m\u0006\u001d\u0011bAA\u0005o\n9!+\u001a=DC2d\u0007bBA\u0007\u0001\u0011\u0005\u0013qB\u0001\nm&\u001c\u0018\u000e\u001e(pI\u0016$2aFA\t\u0011!\t\u0019\"a\u0003A\u0002\u0005U\u0011a\u0002:fq:{G-\u001a\t\u0004m\u0006]\u0011bAA\ro\n9!+\u001a=O_\u0012,\u0007bBA\u000f\u0001\u0011%\u0011qD\u0001\u0016iJ\fgn\u001d7bi\u0016\u001c6.\u001b9TiJ\fG/Z4z+\t\t\t\u0003\u0005\u0003\u0002$\u00055RBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u0015\u00054G/\u001a:nCR\u001c\u0007NC\u0002\u0002,m\t1A\u001c4b\u0013\u0011\ty#!\n\u0003-\u00053G/\u001a:NCR\u001c\u0007nU6jaN#(/\u0019;fOfDq!a\r\u0001\t\u0013\t)$A\fue\u0006t7\u000f\\1uKNKgn\u001a7f-\u0006\u0014\u0018.\u00192mKR)q#a\u000e\u0002B!A\u0011\u0011HA\u0019\u0001\u0004\tY$A\bqe\u00164\u0018n\\;t!\u0006$H/\u001a:o!\u0011y\u0015QH\f\n\u0007\u0005}\u0002K\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u0007\n\t\u00041\u0001d\u0003-\u0001\u0018\r\u001e;fe:t\u0015-\\3\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J\u0005y\u0011\r\u001d9msF+\u0018M\u001c;jM&,'\u000fF\u0005\u0018\u0003\u0017\ni%a\u0016\u0002\\!1!$!\u0012A\u0002]A\u0001\"a\u0014\u0002F\u0001\u0007\u0011\u0011K\u0001\tgR\f'\u000f\u001e(v[B\u0019q*a\u0015\n\u0007\u0005U\u0003KA\u0002J]RD\u0001\"!\u0017\u0002F\u0001\u0007\u0011\u0011K\u0001\u0007K:$g*^7\t\u0011\u0005u\u0013Q\ta\u0001\u0003?\naa\u001a:fK\u0012L\bcA(\u0002b%\u0019\u00111\r)\u0003\u000f\t{w\u000e\\3b]\"\u001a\u0001!a\u001a\u0011\t\u0005%\u0014qN\u0007\u0003\u0003WR1!!\u001c\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\nYGA\tWSNL'\r\\3G_J$Vm\u001d;j]\u001e\u0004")
public class PatternVisitor
extends RexDefaultVisitor<Pattern<Row, Row>> {
    private final TableConfig config;
    private final TypeInformation<Row> inputTypeInfo;
    private final MatchRecognize logicalMatch;
    private Pattern<Row, Row> pattern;
    private final LinkedHashSet<String> names;

    private Pattern<Row, Row> pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern<Row, Row> x$1) {
        this.pattern = x$1;
    }

    public LinkedHashSet<String> names() {
        return this.names;
    }

    @Override
    public Pattern<Row, Row> visitLiteral(RexLiteral literal) {
        Pattern pattern;
        String patternName = literal.getValueAs(String.class);
        this.pattern_$eq(this.translateSingleVariable((Option<Pattern<Row, Row>>)Option$.MODULE$.apply(this.pattern()), patternName));
        RexNode patternDefinition = this.logicalMatch.patternDefinitions().get(patternName);
        if (patternDefinition != null) {
            IterativeConditionRunner condition = MatchUtil$.MODULE$.generateIterativeCondition(this.config, patternDefinition, this.inputTypeInfo, patternName, (Seq<String>)this.names().toSeq());
            pattern = this.pattern().where((IterativeCondition)condition);
        } else {
            pattern = this.pattern().where(BooleanConditions.trueFunction());
        }
        return pattern;
    }

    @Override
    public Pattern<Row, Row> visitCall(RexCall call) {
        Pattern<Row, Row> pattern;
        SqlOperator sqlOperator = call.getOperator();
        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.PATTERN_CONCAT;
        SqlOperator sqlOperator2 = sqlOperator;
        if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null)) {
            RexNode left = (RexNode)call.operands.get(0);
            RexNode right = (RexNode)call.operands.get(1);
            this.pattern_$eq(left.accept(this));
            this.pattern_$eq(right.accept(this));
            pattern = this.pattern();
        } else {
            SqlSpecialOperator sqlSpecialOperator = SqlStdOperatorTable.PATTERN_QUANTIFIER;
            SqlOperator sqlOperator3 = sqlOperator;
            if (!(sqlSpecialOperator != null ? !((Object)sqlSpecialOperator).equals(sqlOperator3) : sqlOperator3 != null)) {
                RexLiteral rexLiteral;
                RexNode rexNode = (RexNode)call.operands.get(0);
                if (!(rexNode instanceof RexLiteral)) {
                    throw new TableException(new StringBuilder(64).append("Expression not supported: ").append(rexNode).append(" Group patterns are ").append("not supported yet.").toString());
                }
                RexLiteral rexLiteral2 = rexLiteral = (RexLiteral)rexNode;
                RexLiteral name = rexLiteral2;
                this.pattern_$eq(name.accept(this));
                int startNum = MathUtils.checkedDownCast((long)Predef$.MODULE$.Long2long(((RexLiteral)call.operands.get(1)).getValueAs(Long.class)));
                int endNum = MathUtils.checkedDownCast((long)Predef$.MODULE$.Long2long(((RexLiteral)call.operands.get(2)).getValueAs(Long.class)));
                boolean isGreedy = !Predef$.MODULE$.Boolean2boolean(((RexLiteral)call.operands.get(3)).getValueAs(Boolean.class));
                pattern = this.applyQuantifier(this.pattern(), startNum, endNum, isGreedy);
            } else {
                SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.PATTERN_ALTER;
                SqlOperator sqlOperator4 = sqlOperator;
                if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator4) : sqlOperator4 != null)) {
                    throw new TableException(new StringBuilder(78).append("Expression not supported: ").append(call).append(". Currently, CEP doesn't support branching patterns.").toString());
                }
                SqlSpecialOperator sqlSpecialOperator2 = SqlStdOperatorTable.PATTERN_PERMUTE;
                SqlOperator sqlOperator5 = sqlOperator;
                if (!(sqlSpecialOperator2 != null ? !((Object)sqlSpecialOperator2).equals(sqlOperator5) : sqlOperator5 != null)) {
                    throw new TableException(new StringBuilder(76).append("Expression not supported: ").append(call).append(". Currently, CEP doesn't support PERMUTE patterns.").toString());
                }
                SqlSpecialOperator sqlSpecialOperator3 = SqlStdOperatorTable.PATTERN_EXCLUDE;
                SqlOperator sqlOperator6 = sqlOperator;
                if (!(sqlSpecialOperator3 != null ? !((Object)sqlSpecialOperator3).equals(sqlOperator6) : sqlOperator6 != null)) {
                    throw new TableException(new StringBuilder(78).append("Expression not supported: ").append(call).append(". Currently, CEP doesn't support '{-' '-}' patterns.").toString());
                }
                throw new MatchError((Object)sqlOperator);
            }
        }
        return pattern;
    }

    @Override
    public Pattern<Row, Row> visitNode(RexNode rexNode) {
        throw new TableException(new StringBuilder(41).append("Unsupported expression within Pattern: [").append(rexNode).append("]").toString());
    }

    private AfterMatchSkipStrategy translateSkipStrategy() {
        SkipToElementStrategy skipToElementStrategy;
        Function0 & Serializable & scala.Serializable getPatternTarget = (Function0 & Serializable & scala.Serializable)() -> ((RexLiteral)((RexCall)$this.logicalMatch.after()).getOperands().get(0)).getValueAs(String.class);
        SqlKind sqlKind = this.logicalMatch.after().getKind();
        if (((Object)((Object)SqlKind.LITERAL)).equals((Object)sqlKind)) {
            SkipPastLastStrategy skipPastLastStrategy;
            SqlMatchRecognize.AfterOption afterOption = ((RexLiteral)this.logicalMatch.after()).getValueAs(SqlMatchRecognize.AfterOption.class);
            if (((Object)((Object)SqlMatchRecognize.AfterOption.SKIP_PAST_LAST_ROW)).equals((Object)afterOption)) {
                skipPastLastStrategy = AfterMatchSkipStrategy.skipPastLastEvent();
            } else if (((Object)((Object)SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW)).equals((Object)afterOption)) {
                skipPastLastStrategy = AfterMatchSkipStrategy.skipToNext();
            } else {
                throw new MatchError((Object)afterOption);
            }
            skipToElementStrategy = skipPastLastStrategy;
        } else if (((Object)((Object)SqlKind.SKIP_TO_FIRST)).equals((Object)sqlKind)) {
            skipToElementStrategy = AfterMatchSkipStrategy.skipToFirst((String)((String)getPatternTarget.apply())).throwExceptionOnMiss();
        } else if (((Object)((Object)SqlKind.SKIP_TO_LAST)).equals((Object)sqlKind)) {
            skipToElementStrategy = AfterMatchSkipStrategy.skipToLast((String)((String)getPatternTarget.apply())).throwExceptionOnMiss();
        } else {
            throw new IllegalStateException(new StringBuilder(33).append("Corrupted query tree. Unexpected ").append(new StringBuilder(26).append(this.logicalMatch.after()).append(" for after match strategy.").toString()).toString());
        }
        return skipToElementStrategy;
    }

    private Pattern<Row, Row> translateSingleVariable(Option<Pattern<Row, Row>> previousPattern, String patternName) {
        Pattern pattern;
        if (this.names().contains((Object)patternName)) {
            throw new TableException("Pattern variables must be unique. That might change in the future.");
        }
        this.names().add((Object)patternName);
        Option<Pattern<Row, Row>> option = previousPattern;
        if (option instanceof Some) {
            Some some = (Some)option;
            Pattern p = (Pattern)some.value();
            pattern = p.next(patternName);
        } else if (None$.MODULE$.equals(option)) {
            pattern = Pattern.begin((String)patternName, (AfterMatchSkipStrategy)this.translateSkipStrategy());
        } else {
            throw new MatchError(option);
        }
        return pattern;
    }

    private Pattern<Row, Row> applyQuantifier(Pattern<Row, Row> pattern, int startNum, int endNum, boolean greedy) {
        Pattern pattern2;
        Pattern newPattern;
        boolean isOptional;
        boolean bl = isOptional = startNum == 0 && endNum == 1;
        Pattern pattern3 = startNum == 0 && endNum == -1 ? pattern.oneOrMore().optional().consecutive() : (startNum == 1 && endNum == -1 ? pattern.oneOrMore().consecutive() : (isOptional ? pattern.optional() : (newPattern = endNum != -1 ? pattern.times(startNum, endNum).consecutive() : pattern.timesOrMore(startNum).consecutive())));
        if (greedy && isOptional) {
            pattern2 = newPattern;
        } else if (greedy) {
            pattern2 = newPattern.greedy();
        } else {
            if (isOptional) {
                throw new TableException("Reluctant optional variables are not supported yet.");
            }
            pattern2 = newPattern;
        }
        return pattern2;
    }

    public PatternVisitor(TableConfig config, TypeInformation<Row> inputTypeInfo, MatchRecognize logicalMatch) {
        this.config = config;
        this.inputTypeInfo = inputTypeInfo;
        this.logicalMatch = logicalMatch;
        this.names = new LinkedHashSet();
    }
}

