/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import org.apache.flink.streaming.api.datastream.AllWindowedStream;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.WindowedStream;
import org.apache.flink.streaming.api.windowing.assigners.EventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.ProcessingTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.PurgingTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils$;
import org.apache.flink.table.plan.logical.LogicalWindow;
import org.apache.flink.table.plan.logical.SessionGroupWindow;
import org.apache.flink.table.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.runtime.triggers.StateCleaningCountTrigger$;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.typeutils.TypeCheckUtils$;
import org.apache.flink.types.Row;
import scala.MatchError;

public final class DataStreamGroupWindowAggregate$ {
    public static DataStreamGroupWindowAggregate$ MODULE$;

    static {
        new DataStreamGroupWindowAggregate$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WindowedStream<CRow, Row, ? extends Window> org$apache$flink$table$plan$nodes$datastream$DataStreamGroupWindowAggregate$$createKeyedWindowedStream(StreamQueryConfig queryConfig, LogicalWindow groupWindow, KeyedStream<CRow, Row> stream) {
        boolean bl = false;
        TumblingGroupWindow tumblingGroupWindow = null;
        boolean bl2 = false;
        SlidingGroupWindow slidingGroupWindow = null;
        boolean bl3 = false;
        SessionGroupWindow sessionGroupWindow = null;
        LogicalWindow logicalWindow = groupWindow;
        if (logicalWindow instanceof TumblingGroupWindow) {
            bl = true;
            tumblingGroupWindow = (TumblingGroupWindow)logicalWindow;
            Expression timeField = tumblingGroupWindow.timeField();
            Expression size = tumblingGroupWindow.size();
            if (ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) {
                return stream.window((WindowAssigner)TumblingProcessingTimeWindows.of((Time)ExpressionUtils$.MODULE$.toTime(size)));
            }
        }
        if (bl) {
            Expression timeField = tumblingGroupWindow.timeField();
            Expression size = tumblingGroupWindow.size();
            if (ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && ExpressionUtils$.MODULE$.isRowCountLiteral(size)) {
                return stream.countWindow(ExpressionUtils$.MODULE$.toLong(size)).trigger((Trigger)PurgingTrigger.of((Trigger)StateCleaningCountTrigger$.MODULE$.of(queryConfig, ExpressionUtils$.MODULE$.toLong(size))));
            }
        }
        if (bl) {
            Expression timeField = tumblingGroupWindow.timeField();
            Expression size = tumblingGroupWindow.size();
            if (ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) {
                return stream.window((WindowAssigner)TumblingEventTimeWindows.of((Time)ExpressionUtils$.MODULE$.toTime(size)));
            }
        }
        if (bl) {
            throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
        }
        if (logicalWindow instanceof SlidingGroupWindow) {
            bl2 = true;
            slidingGroupWindow = (SlidingGroupWindow)logicalWindow;
            Expression timeField = slidingGroupWindow.timeField();
            Expression size = slidingGroupWindow.size();
            Expression slide = slidingGroupWindow.slide();
            if (ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(slide)) {
                return stream.window((WindowAssigner)SlidingProcessingTimeWindows.of((Time)ExpressionUtils$.MODULE$.toTime(size), (Time)ExpressionUtils$.MODULE$.toTime(slide)));
            }
        }
        if (bl2) {
            Expression timeField = slidingGroupWindow.timeField();
            Expression size = slidingGroupWindow.size();
            Expression slide = slidingGroupWindow.slide();
            if (ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && ExpressionUtils$.MODULE$.isRowCountLiteral(size)) {
                return stream.countWindow(ExpressionUtils$.MODULE$.toLong(size), ExpressionUtils$.MODULE$.toLong(slide)).trigger((Trigger)StateCleaningCountTrigger$.MODULE$.of(queryConfig, ExpressionUtils$.MODULE$.toLong(slide)));
            }
        }
        if (bl2) {
            Expression timeField = slidingGroupWindow.timeField();
            Expression size = slidingGroupWindow.size();
            Expression slide = slidingGroupWindow.slide();
            if (ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) {
                return stream.window((WindowAssigner)SlidingEventTimeWindows.of((Time)ExpressionUtils$.MODULE$.toTime(size), (Time)ExpressionUtils$.MODULE$.toTime(slide)));
            }
        }
        if (bl2) {
            throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
        }
        if (logicalWindow instanceof SessionGroupWindow) {
            bl3 = true;
            sessionGroupWindow = (SessionGroupWindow)logicalWindow;
            Expression timeField = sessionGroupWindow.timeField();
            Expression gap = sessionGroupWindow.gap();
            if (ExpressionUtils$.MODULE$.isProctimeAttribute(timeField)) {
                return stream.window((WindowAssigner)ProcessingTimeSessionWindows.withGap((Time)ExpressionUtils$.MODULE$.toTime(gap)));
            }
        }
        if (!bl3) throw new MatchError((Object)logicalWindow);
        Expression timeField = sessionGroupWindow.timeField();
        Expression gap = sessionGroupWindow.gap();
        if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField)) throw new MatchError((Object)logicalWindow);
        return stream.window((WindowAssigner)EventTimeSessionWindows.withGap((Time)ExpressionUtils$.MODULE$.toTime(gap)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AllWindowedStream<CRow, ? extends Window> org$apache$flink$table$plan$nodes$datastream$DataStreamGroupWindowAggregate$$createNonKeyedWindowedStream(StreamQueryConfig queryConfig, LogicalWindow groupWindow, DataStream<CRow> stream) {
        Expression size;
        boolean bl = false;
        TumblingGroupWindow tumblingGroupWindow = null;
        boolean bl2 = false;
        SlidingGroupWindow slidingGroupWindow = null;
        boolean bl3 = false;
        SessionGroupWindow sessionGroupWindow = null;
        LogicalWindow logicalWindow = groupWindow;
        if (logicalWindow instanceof TumblingGroupWindow) {
            bl = true;
            tumblingGroupWindow = (TumblingGroupWindow)logicalWindow;
            Expression timeField = tumblingGroupWindow.timeField();
            Expression size2 = tumblingGroupWindow.size();
            if (ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size2)) {
                return stream.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Time)ExpressionUtils$.MODULE$.toTime(size2)));
            }
        }
        if (bl) {
            Expression timeField = tumblingGroupWindow.timeField();
            Expression size3 = tumblingGroupWindow.size();
            if (ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && ExpressionUtils$.MODULE$.isRowCountLiteral(size3)) {
                return stream.countWindowAll(ExpressionUtils$.MODULE$.toLong(size3)).trigger((Trigger)PurgingTrigger.of((Trigger)StateCleaningCountTrigger$.MODULE$.of(queryConfig, ExpressionUtils$.MODULE$.toLong(size3))));
            }
        }
        if (bl && TypeCheckUtils$.MODULE$.isTimeInterval((size = tumblingGroupWindow.size()).resultType())) {
            return stream.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)ExpressionUtils$.MODULE$.toTime(size)));
        }
        if (bl) {
            throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
        }
        if (logicalWindow instanceof SlidingGroupWindow) {
            bl2 = true;
            slidingGroupWindow = (SlidingGroupWindow)logicalWindow;
            Expression timeField = slidingGroupWindow.timeField();
            Expression size4 = slidingGroupWindow.size();
            Expression slide = slidingGroupWindow.slide();
            if (ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size4)) {
                return stream.windowAll((WindowAssigner)SlidingProcessingTimeWindows.of((Time)ExpressionUtils$.MODULE$.toTime(size4), (Time)ExpressionUtils$.MODULE$.toTime(slide)));
            }
        }
        if (bl2) {
            Expression timeField = slidingGroupWindow.timeField();
            Expression size5 = slidingGroupWindow.size();
            Expression slide = slidingGroupWindow.slide();
            if (ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && ExpressionUtils$.MODULE$.isRowCountLiteral(size5)) {
                return stream.countWindowAll(ExpressionUtils$.MODULE$.toLong(size5), ExpressionUtils$.MODULE$.toLong(slide)).trigger((Trigger)StateCleaningCountTrigger$.MODULE$.of(queryConfig, ExpressionUtils$.MODULE$.toLong(slide)));
            }
        }
        if (bl2) {
            Expression timeField = slidingGroupWindow.timeField();
            Expression size6 = slidingGroupWindow.size();
            Expression slide = slidingGroupWindow.slide();
            if (ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size6)) {
                return stream.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)ExpressionUtils$.MODULE$.toTime(size6), (Time)ExpressionUtils$.MODULE$.toTime(slide)));
            }
        }
        if (bl2) {
            throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
        }
        if (logicalWindow instanceof SessionGroupWindow) {
            bl3 = true;
            sessionGroupWindow = (SessionGroupWindow)logicalWindow;
            Expression timeField = sessionGroupWindow.timeField();
            Expression gap = sessionGroupWindow.gap();
            if (ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(gap)) {
                return stream.windowAll((WindowAssigner)ProcessingTimeSessionWindows.withGap((Time)ExpressionUtils$.MODULE$.toTime(gap)));
            }
        }
        if (!bl3) throw new MatchError((Object)logicalWindow);
        Expression timeField = sessionGroupWindow.timeField();
        Expression gap = sessionGroupWindow.gap();
        if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField)) throw new MatchError((Object)logicalWindow);
        if (!ExpressionUtils$.MODULE$.isTimeIntervalLiteral(gap)) throw new MatchError((Object)logicalWindow);
        return stream.windowAll((WindowAssigner)EventTimeSessionWindows.withGap((Time)ExpressionUtils$.MODULE$.toTime(gap)));
    }

    private DataStreamGroupWindowAggregate$() {
        MODULE$ = this;
    }
}

