/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.dataset;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.PartitionOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.BatchQueryConfig;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.codegen.FunctionCodeGenerator;
import org.apache.flink.table.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.codegen.GeneratedExpression;
import org.apache.flink.table.codegen.GeneratedFunction;
import org.apache.flink.table.plan.nodes.CommonJoin;
import org.apache.flink.table.plan.nodes.FlinkRelNode;
import org.apache.flink.table.plan.nodes.dataset.DataSetRel;
import org.apache.flink.table.runtime.FlatJoinRunner;
import org.apache.flink.table.runtime.FullOuterJoinRunner;
import org.apache.flink.table.runtime.LeftFullOuterJoinGroupReduceRunner;
import org.apache.flink.table.runtime.LeftOuterJoinGroupReduceRunner;
import org.apache.flink.table.runtime.LeftOuterJoinRunner;
import org.apache.flink.table.runtime.RightFullOuterJoinGroupReduceRunner;
import org.apache.flink.table.runtime.RightOuterJoinGroupReduceRunner;
import org.apache.flink.table.runtime.RightOuterJoinRunner;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001B\u0001\u0003\u0001E\u00111\u0002R1uCN+GOS8j]*\u00111\u0001B\u0001\bI\u0006$\u0018m]3u\u0015\t)a!A\u0003o_\u0012,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\n\u001b=A\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0004e\u0016d'BA\f\r\u0003\u001d\u0019\u0017\r\\2ji\u0016L!!\u0007\u000b\u0003\u000b\tK'+\u001a7\u0011\u0005maR\"\u0001\u0003\n\u0005u!!AC\"p[6|gNS8j]B\u0011q\u0004I\u0007\u0002\u0005%\u0011\u0011E\u0001\u0002\u000b\t\u0006$\u0018mU3u%\u0016d\u0007\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u000f\rdWo\u001d;feB\u0011QeJ\u0007\u0002M)\u0011qAF\u0005\u0003Q\u0019\u0012QBU3m\u001fB$8\t\\;ti\u0016\u0014\b\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u0011Q\u0014\u0018-\u001b;TKR\u0004\"!\n\u0017\n\u000552#a\u0003*fYR\u0013\u0018-\u001b;TKRD\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\tY\u00164GOT8eKB\u00111#M\u0005\u0003eQ\u0011qAU3m\u001d>$W\r\u0003\u00055\u0001\t\u0005\t\u0015!\u00031\u0003%\u0011\u0018n\u001a5u\u001d>$W\r\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u00039\u0011xn\u001e*fY\u0012\u000bG/\u0019+za\u0016\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\u000b\u0002\tQL\b/Z\u0005\u0003ye\u00121BU3m\t\u0006$\u0018\rV=qK\"Aa\b\u0001B\u0001B\u0003%q(A\u0007k_&t7i\u001c8eSRLwN\u001c\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005Z\t1A]3y\u0013\t!\u0015IA\u0004SKbtu\u000eZ3\t\u0011\u0019\u0003!\u0011!Q\u0001\n]\n1B[8j]J{w\u000fV=qK\"A\u0001\n\u0001B\u0001B\u0003%\u0011*\u0001\u0005k_&t\u0017J\u001c4p!\tQU*D\u0001L\u0015\taE#\u0001\u0003d_J,\u0017B\u0001(L\u0005!Qu.\u001b8J]\u001a|\u0007\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\u0002\u0011-,\u0017\u0010U1jeN\u00042A\u0015/`\u001d\t\u0019\u0016L\u0004\u0002U/6\tQK\u0003\u0002W!\u00051AH]8pizJ\u0011\u0001W\u0001\u0006g\u000e\fG.Y\u0005\u00035n\u000bq\u0001]1dW\u0006<WMC\u0001Y\u0013\tifL\u0001\u0003MSN$(B\u0001.\\!\t\u0001W-D\u0001b\u0015\t\u00117-A\u0004nCB\u0004\u0018N\\4\u000b\u0005\u00114\u0012\u0001B;uS2L!AZ1\u0003\u000f%sG\u000fU1je\"A\u0001\u000e\u0001B\u0001B\u0003%\u0011.\u0001\u0005k_&tG+\u001f9f!\tQ%.\u0003\u0002l\u0017\nY!j\\5o%\u0016dG+\u001f9f\u0011!i\u0007A!A!\u0002\u0013q\u0017\u0001\u00036pS:D\u0015N\u001c;\u0011\u0007=\f\tBD\u0002q\u0003\u0017q1!]A\u0003\u001d\t\u0011xP\u0004\u0002ty:\u0011AO\u001f\b\u0003kft!A\u001e=\u000f\u0005Q;\u0018\"A\b\n\u00055q\u0011BA\u0006\r\u0013\tY(\"A\u0002ba&L!! @\u0002\r\r|W.\\8o\u0015\tY(\"\u0003\u0003\u0002\u0002\u0005\r\u0011!C8qKJ\fGo\u001c:t\u0015\tih0\u0003\u0003\u0002\b\u0005%\u0011\u0001\u00022bg\u0016TA!!\u0001\u0002\u0004%!\u0011QBA\b\u0003AQu.\u001b8Pa\u0016\u0014\u0018\r^8s\u0005\u0006\u001cXM\u0003\u0003\u0002\b\u0005%\u0011\u0002BA\n\u0003+\u0011\u0001BS8j]\"Kg\u000e\u001e\u0006\u0005\u0003\u001b\ty\u0001\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0005\u00037\tqB];mK\u0012+7o\u0019:jaRLwN\u001c\t\u0005\u0003;\t)C\u0004\u0003\u0002 \u0005\u0005\u0002C\u0001+\\\u0013\r\t\u0019cW\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0012\u0011\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r2\fC\u0004\u0002.\u0001!\t!a\f\u0002\rqJg.\u001b;?)i\t\t$a\r\u00026\u0005]\u0012\u0011HA\u001e\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0013qIA%!\ty\u0002\u0001\u0003\u0004$\u0003W\u0001\r\u0001\n\u0005\u0007U\u0005-\u0002\u0019A\u0016\t\r=\nY\u00031\u00011\u0011\u0019!\u00141\u0006a\u0001a!1a'a\u000bA\u0002]BaAPA\u0016\u0001\u0004y\u0004B\u0002$\u0002,\u0001\u0007q\u0007\u0003\u0004I\u0003W\u0001\r!\u0013\u0005\u0007!\u0006-\u0002\u0019A)\t\r!\fY\u00031\u0001j\u0011\u0019i\u00171\u0006a\u0001]\"A\u0011\u0011DA\u0016\u0001\u0004\tY\u0002C\u0004\u0002N\u0001!\t%a\u0014\u0002\u001b\u0011,'/\u001b<f%><H+\u001f9f)\u00059\u0004bBA*\u0001\u0011\u0005\u0013QK\u0001\u0005G>\u0004\u0018\u0010F\u00031\u0003/\nI\u0006\u0003\u0004+\u0003#\u0002\ra\u000b\u0005\t\u00037\n\t\u00061\u0001\u0002^\u00051\u0011N\u001c9viN\u0004R!a\u0018\u0002hAj!!!\u0019\u000b\u0007\u0011\f\u0019G\u0003\u0002\u0002f\u0005!!.\u0019<b\u0013\ri\u0016\u0011\r\u0005\b\u0003W\u0002A\u0011IA7\u0003!!xn\u0015;sS:<GCAA\u000e\u0011\u001d\t\t\b\u0001C!\u0003g\nA\"\u001a=qY\u0006Lg\u000eV3s[N$B!!\u001e\u0002|A\u00191#a\u001e\n\u0007\u0005eDCA\u0005SK2<&/\u001b;fe\"A\u0011QPA8\u0001\u0004\t)(\u0001\u0002qo\"9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0015aD2p[B,H/Z*fY\u001a\u001cun\u001d;\u0015\r\u0005\u0015\u00151RAK!\r)\u0013qQ\u0005\u0004\u0003\u00133#A\u0003*fY>\u0003HoQ8ti\"A\u0011QRA@\u0001\u0004\ty)A\u0004qY\u0006tg.\u001a:\u0011\u0007\u0015\n\t*C\u0002\u0002\u0014\u001a\u0012QBU3m\u001fB$\b\u000b\\1o]\u0016\u0014\b\u0002CAL\u0003\u007f\u0002\r!!'\u0002\u00115,G/\u00193bi\u0006\u0004B!a'\u0002 6\u0011\u0011Q\u0014\u0006\u0004\u0003/#\u0012\u0002BAQ\u0003;\u0013\u0001CU3m\u001b\u0016$\u0018\rZ1uCF+XM]=\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\u0006yAO]1og2\fG/\u001a+p!2\fg\u000e\u0006\u0004\u0002*\u0006}\u0016Q\u001a\t\u0007\u0003W\u000by+a-\u000e\u0005\u00055&bAA3}&!\u0011\u0011WAW\u0005\u001d!\u0015\r^1TKR\u0004B!!.\u0002<6\u0011\u0011q\u0017\u0006\u0004\u0003sS\u0011!\u0002;za\u0016\u001c\u0018\u0002BA_\u0003o\u00131AU8x\u0011!\t\t-a)A\u0002\u0005\r\u0017\u0001\u0003;bE2,WI\u001c<\u0011\t\u0005\u0015\u0017\u0011Z\u0007\u0003\u0003\u000fT!a\u001f\u0005\n\t\u0005-\u0017q\u0019\u0002\u0016\u0005\u0006$8\r\u001b+bE2,WI\u001c<je>tW.\u001a8u\u0011!\ty-a)A\u0002\u0005E\u0017aC9vKJL8i\u001c8gS\u001e\u0004B!!2\u0002T&!\u0011Q[Ad\u0005A\u0011\u0015\r^2i#V,'/_\"p]\u001aLw\rC\u0004\u0002Z\u0002!I!a7\u0002\u0019\u0005$G-\u00138oKJTu.\u001b8\u0015\u001d\u0005%\u0016Q\\Aq\u0003K\f90a?\u0003\f!A\u0011q\\Al\u0001\u0004\tI+\u0001\u0003mK\u001a$\b\u0002CAr\u0003/\u0004\r!!+\u0002\u000bILw\r\u001b;\t\u0011\u0005\u001d\u0018q\u001ba\u0001\u0003S\f\u0001\u0002\\3gi.+\u0017p\u001d\t\u0007\u0003W\fi/!=\u000e\u0003mK1!a<\\\u0005\u0015\t%O]1z!\u0011\tY/a=\n\u0007\u0005U8LA\u0002J]RD\u0001\"!?\u0002X\u0002\u0007\u0011\u0011^\u0001\ne&<\u0007\u000e^&fsND\u0001\"!@\u0002X\u0002\u0007\u0011q`\u0001\u000be\u0016\u001cX\u000f\u001c;UsB,\u0007C\u0002B\u0001\u0005\u000f\t\u0019,\u0004\u0002\u0003\u0004)!!QAA\u0002\u0003!!\u0018\u0010]3j]\u001a|\u0017\u0002\u0002B\u0005\u0005\u0007\u0011q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\t\u0005\u001b\t9\u000e1\u0001\u0003\u0010\u000511m\u001c8gS\u001e\u0004B!!2\u0003\u0012%!!1CAd\u0005-!\u0016M\u00197f\u0007>tg-[4\t\u000f\t]\u0001\u0001\"\u0003\u0003\u001a\u0005\u0001\u0012\r\u001a3MK\u001a$x*\u001e;fe*{\u0017N\u001c\u000b\u000f\u0003S\u0013YB!\b\u0003 \t\u0005\"1\u0005B\u0013\u0011!\tyN!\u0006A\u0002\u0005%\u0006\u0002CAr\u0005+\u0001\r!!+\t\u0011\u0005\u001d(Q\u0003a\u0001\u0003SD\u0001\"!?\u0003\u0016\u0001\u0007\u0011\u0011\u001e\u0005\t\u0003{\u0014)\u00021\u0001\u0002\u0000\"A!Q\u0002B\u000b\u0001\u0004\u0011y\u0001C\u0004\u0003*\u0001!IAa\u000b\u0002#\u0005$GMU5hQR|U\u000f^3s\u0015>Lg\u000e\u0006\b\u0002*\n5\"q\u0006B\u0019\u0005g\u0011)Da\u000e\t\u0011\u0005}'q\u0005a\u0001\u0003SC\u0001\"a9\u0003(\u0001\u0007\u0011\u0011\u0016\u0005\t\u0003O\u00149\u00031\u0001\u0002j\"A\u0011\u0011 B\u0014\u0001\u0004\tI\u000f\u0003\u0005\u0002~\n\u001d\u0002\u0019AA\u0000\u0011!\u0011iAa\nA\u0002\t=\u0001b\u0002B\u001e\u0001\u0011%!QH\u0001\u0011C\u0012$g)\u001e7m\u001fV$XM\u001d&pS:$b\"!+\u0003@\t\u0005#1\tB#\u0005\u000f\u0012I\u0005\u0003\u0005\u0002`\ne\u0002\u0019AAU\u0011!\t\u0019O!\u000fA\u0002\u0005%\u0006\u0002CAt\u0005s\u0001\r!!;\t\u0011\u0005e(\u0011\ba\u0001\u0003SD\u0001\"!@\u0003:\u0001\u0007\u0011q \u0005\t\u0005\u001b\u0011I\u00041\u0001\u0003\u0010!9!Q\n\u0001\u0005\n\t=\u0013!D4fi*{\u0017N\\(q\u001d\u0006lW-\u0006\u0002\u0002\u001c!9!1\u000b\u0001\u0005\n\tU\u0013!G4fi\u001a+H\u000e\\%oI&\u001c\u0017.Z:XSRD\u0007K]3gSb$b!!;\u0003X\tm\u0003\u0002\u0003B-\u0005#\u0002\r!!;\u0002\t-,\u0017p\u001d\u0005\t\u0005;\u0012\t\u00061\u0001\u0002r\u0006Ia.^7GS\u0016dGm\u001d\u0005\b\u0005C\u0002A\u0011\u0002B2\u0003A\u0001\u0018M\u001d;ji&|g.\u00118e'>\u0014H\u000f\u0006\u0004\u0002*\n\u0015$\u0011\u000e\u0005\t\u0005O\u0012y\u00061\u0001\u0002*\u00069A-\u0019;b'\u0016$\b\u0002\u0003B6\u0005?\u0002\r!!;\u0002\u001bA\f'\u000f^5uS>t7*Z=t\u0011\u001d\u0011y\u0007\u0001C\u0005\u0005c\n\u0011CZ8mI&#WM\u001c;jG\u0006d'k\\<t)\u0019\tIKa\u001d\u0003v!A!q\rB7\u0001\u0004\tI\u000b\u0003\u0005\u0003x\t5\u0004\u0019AA\u0000\u0003-!\u0017\r^1TKR$\u0016\u0010]3\t\u000f\tm\u0004\u0001\"\u0003\u0003~\u0005Ir-\u001a8fe\u0006$X\r\u0015:fI&\u001c\u0017\r^3Gk:\u001cG/[8o)!\u0011yHa)\u0003(\n-\u0006\u0003\u0003BA\u0005\u000f\u0013YIa&\u000e\u0005\t\r%b\u0001BC\u0011\u000591m\u001c3fO\u0016t\u0017\u0002\u0002BE\u0005\u0007\u0013\u0011cR3oKJ\fG/\u001a3Gk:\u001cG/[8o!)\u0011iIa%\u00024\u0006M&qS\u0007\u0003\u0005\u001fSAA!%\u0002\u0004\u0005Ia-\u001e8di&|gn]\u0005\u0005\u0005+\u0013yI\u0001\u0007K_&tg)\u001e8di&|g\u000e\u0005\u0003\u0003\u001a\n}UB\u0001BN\u0015\u0011\u0011i*a\u0019\u0002\t1\fgnZ\u0005\u0005\u0005C\u0013YJA\u0004C_>dW-\u00198\t\u0011\t\u0015&\u0011\u0010a\u0001\u0003\u007f\f\u0001\u0002\\3giRK\b/\u001a\u0005\t\u0005S\u0013I\b1\u0001\u0002\u0000\u0006I!/[4iiRK\b/\u001a\u0005\t\u0005\u001b\u0011I\b1\u0001\u0003\u0010!9!q\u0016\u0001\u0005\n\tE\u0016AG4f]\u0016\u0014\u0018\r^3D_:4XM]:j_:4UO\\2uS>tGC\u0003BZ\u0005o\u0013ILa/\u0003>BA!\u0011\u0011BD\u0005k\u000b\u0019\f\u0005\u0006\u0003\u000e\nM\u00151WAZ\u0003gC\u0001B!*\u0003.\u0002\u0007\u0011q \u0005\t\u0005S\u0013i\u000b1\u0001\u0002\u0000\"A\u0011Q BW\u0001\u0004\ty\u0010\u0003\u0005\u0003\u000e\t5\u0006\u0019\u0001B\b\u00111\u0011\t\r\u0001I\u0001\u0002\u0003\u0005I\u0011\u0001Bb\u00039\u0001(o\u001c;fGR,G\r\n7fMR$2\u0001\rBc\u0011)\u00119Ma0\u0002\u0002\u0003\u0007\u0011\u0011G\u0001\u0004q\u0012\n\u0004\u0002\u0004Bf\u0001A\u0005\t\u0011!A\u0005\u0002\t5\u0017a\u00049s_R,7\r^3eIILw\r\u001b;\u0015\u0007A\u0012y\r\u0003\u0006\u0003H\n%\u0017\u0011!a\u0001\u0003c\u0001")
public class DataSetJoin
extends BiRel
implements CommonJoin,
DataSetRel {
    private final RelOptCluster cluster;
    private final RelDataType rowRelDataType;
    private final RexNode joinCondition;
    private final RelDataType joinRowType;
    private final JoinInfo joinInfo;
    private final List<IntPair> keyPairs;
    private final JoinRelType joinType;
    private final JoinOperatorBase.JoinHint joinHint;
    private final String ruleDescription;

    @Override
    public String getExpressionString(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
        return FlinkRelNode.getExpressionString$(this, expr, inFields, localExprsTable);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRelNode.estimateRowSize$(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRelNode.estimateDataTypeSize$(this, t);
    }

    @Override
    public String joinSelectionToString(RelDataType inputType) {
        return CommonJoin.joinSelectionToString$(this, inputType);
    }

    @Override
    public String joinConditionToString(RelDataType inputType, RexNode joinCondition, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression) {
        return CommonJoin.joinConditionToString$(this, inputType, joinCondition, expression);
    }

    @Override
    public String joinTypeToString(JoinRelType joinType) {
        return CommonJoin.joinTypeToString$(this, joinType);
    }

    @Override
    public String temporalJoinToString(RelDataType inputType, RexNode joinCondition, JoinRelType joinType, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression) {
        return CommonJoin.temporalJoinToString$(this, inputType, joinCondition, joinType, expression);
    }

    @Override
    public String joinToString(RelDataType inputType, RexNode joinCondition, JoinRelType joinType, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression) {
        return CommonJoin.joinToString$(this, inputType, joinCondition, joinType, expression);
    }

    @Override
    public RelWriter joinExplainTerms(RelWriter pw, RelDataType inputType, RexNode joinCondition, JoinRelType joinType, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression) {
        return CommonJoin.joinExplainTerms$(this, pw, inputType, joinCondition, joinType, expression);
    }

    public /* synthetic */ RelNode protected$left(DataSetJoin x$1) {
        return x$1.left;
    }

    public /* synthetic */ RelNode protected$right(DataSetJoin x$1) {
        return x$1.right;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.rowRelDataType;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, java.util.List<RelNode> inputs) {
        return new DataSetJoin(this.cluster, traitSet, inputs.get(0), inputs.get(1), this.getRowType(), this.joinCondition, this.joinRowType, this.joinInfo, this.keyPairs, this.joinType, this.joinHint, this.ruleDescription);
    }

    @Override
    public String toString() {
        return this.joinToString(this.joinRowType, this.joinCondition, this.joinType, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable));
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.joinExplainTerms(super.explainTerms(pw), this.joinRowType, this.joinCondition, this.joinType, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable));
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery metadata) {
        Double leftRowCnt = metadata.getRowCount(this.getLeft());
        double leftRowSize = this.estimateRowSize(this.getLeft().getRowType());
        Double rightRowCnt = metadata.getRowCount(this.getRight());
        double rightRowSize = this.estimateRowSize(this.getRight().getRowType());
        double ioCost = Predef$.MODULE$.Double2double(leftRowCnt) * leftRowSize + Predef$.MODULE$.Double2double(rightRowCnt) * rightRowSize;
        double cpuCost = Predef$.MODULE$.Double2double(leftRowCnt) + Predef$.MODULE$.Double2double(rightRowCnt);
        double rowCnt = Predef$.MODULE$.Double2double(leftRowCnt) + Predef$.MODULE$.Double2double(rightRowCnt);
        return planner.getCostFactory().makeCost(rowCnt, cpuCost, ioCost);
    }

    @Override
    public DataSet<Row> translateToPlan(BatchTableEnvironment tableEnv, BatchQueryConfig queryConfig) {
        DataSet<Row> dataSet;
        TableConfig config = tableEnv.getConfig();
        TypeInformation<Row> returnType = FlinkTypeFactory$.MODULE$.toInternalRowTypeInfo(this.getRowType());
        ArrayBuffer leftKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer rightKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        if (this.keyPairs.isEmpty()) {
            throw new TableException(new StringBuilder(51).append("Joins should have at least one equality condition.\n").append(new StringBuilder(9).append("\tLeft: ").append(this.left.toString()).append(",\n").toString()).append(new StringBuilder(10).append("\tRight: ").append(this.right.toString()).append(",\n").toString()).append(new StringBuilder(14).append("\tCondition: (").append(this.joinConditionToString(this.joinRowType, this.joinCondition, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable))).append(")").toString()).toString());
        }
        java.util.List<RelDataTypeField> leftFields = this.left.getRowType().getFieldList();
        java.util.List<RelDataTypeField> rightFields = this.right.getRowType().getFieldList();
        this.keyPairs.foreach((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)DataSetJoin.$anonfun$translateToPlan$2(this, leftKeys, rightKeys, leftFields, rightFields, pair)));
        DataSet<Row> leftDataSet = ((DataSetRel)this.left).translateToPlan(tableEnv, queryConfig);
        DataSet<Row> rightDataSet = ((DataSetRel)this.right).translateToPlan(tableEnv, queryConfig);
        JoinRelType joinRelType = this.joinType;
        if (((Object)((Object)JoinRelType.INNER)).equals((Object)joinRelType)) {
            dataSet = this.addInnerJoin(leftDataSet, rightDataSet, (int[])leftKeys.toArray(ClassTag$.MODULE$.Int()), (int[])rightKeys.toArray(ClassTag$.MODULE$.Int()), returnType, config);
        } else if (((Object)((Object)JoinRelType.LEFT)).equals((Object)joinRelType)) {
            dataSet = this.addLeftOuterJoin(leftDataSet, rightDataSet, (int[])leftKeys.toArray(ClassTag$.MODULE$.Int()), (int[])rightKeys.toArray(ClassTag$.MODULE$.Int()), returnType, config);
        } else if (((Object)((Object)JoinRelType.RIGHT)).equals((Object)joinRelType)) {
            dataSet = this.addRightOuterJoin(leftDataSet, rightDataSet, (int[])leftKeys.toArray(ClassTag$.MODULE$.Int()), (int[])rightKeys.toArray(ClassTag$.MODULE$.Int()), returnType, config);
        } else if (((Object)((Object)JoinRelType.FULL)).equals((Object)joinRelType)) {
            dataSet = this.addFullOuterJoin(leftDataSet, rightDataSet, (int[])leftKeys.toArray(ClassTag$.MODULE$.Int()), (int[])rightKeys.toArray(ClassTag$.MODULE$.Int()), returnType, config);
        } else {
            throw new MatchError((Object)joinRelType);
        }
        return dataSet;
    }

    private DataSet<Row> addInnerJoin(DataSet<Row> left, DataSet<Row> right, int[] leftKeys, int[] rightKeys, TypeInformation<Row> resultType, TableConfig config) {
        FunctionCodeGenerator generator = new FunctionCodeGenerator(config, false, (TypeInformation<?>)left.getType(), (Option<TypeInformation<?>>)new Some((Object)right.getType()), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$5(), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$6());
        GeneratedExpression conversion = generator.generateConverterResultExpression(resultType, (Seq<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.joinRowType.getFieldNames()), generator.generateConverterResultExpression$default$3());
        GeneratedExpression condition = generator.generateExpression(this.joinCondition);
        String body = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n         |").append(condition.code()).append("\n         |if (").append(condition.resultTerm()).append(") {\n         |  ").append(conversion.code()).append("\n         |  ").append(generator.collectorTerm()).append(".collect(").append(conversion.resultTerm()).append(");\n         |}\n         |").toString())).stripMargin();
        GeneratedFunction<FlatJoinFunction, Row> genFunction = generator.generateFunction(this.ruleDescription, FlatJoinFunction.class, body, resultType);
        FlatJoinRunner joinFun = new FlatJoinRunner(genFunction.name(), genFunction.code(), genFunction.returnType());
        return left.join(right).where(leftKeys).equalTo(rightKeys).with(joinFun).name(this.getJoinOpName());
    }

    private DataSet<Row> addLeftOuterJoin(DataSet<Row> left, DataSet<Row> right, int[] leftKeys, int[] rightKeys, TypeInformation<Row> resultType, TableConfig config) {
        if (!config.getNullCheck()) {
            throw new TableException("Null check in TableConfig must be enabled for outer joins.");
        }
        String joinOpName = this.getJoinOpName();
        RowTypeInfo leftType = new RowTypeInfo(((RowTypeInfo)left.getType()).getFieldTypes());
        RowTypeInfo rightType = (RowTypeInfo)right.getType();
        DataSet<Row> partitionedSortedLeft = this.partitionAndSort(left, leftKeys);
        DataSet<Row> foldedRowsLeft = this.foldIdenticalRows(partitionedSortedLeft, (TypeInformation<Row>)leftType);
        GeneratedFunction<JoinFunction<Row, Row, Boolean>, Boolean> predFun = this.generatePredicateFunction((TypeInformation<Row>)leftType, (TypeInformation<Row>)rightType, config);
        RowTypeInfo joinOutType = new RowTypeInfo(new TypeInformation[]{leftType, rightType, Types$.MODULE$.INT()});
        LeftOuterJoinRunner joinFun = new LeftOuterJoinRunner(predFun.name(), predFun.code(), (TypeInformation<Row>)joinOutType);
        String[] nestedLeftKeys = (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(leftKeys)).map((Function1 & Serializable & scala.Serializable)i -> DataSetJoin.$anonfun$addLeftOuterJoin$1(BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        JoinOperator joinPairs = (JoinOperator)foldedRowsLeft.leftOuterJoin(right, JoinOperatorBase.JoinHint.REPARTITION_SORT_MERGE).where(nestedLeftKeys).equalTo(rightKeys).with((FlatJoinFunction)joinFun).withForwardedFieldsFirst(new String[]{"f0->f0"}).name(joinOpName);
        GeneratedFunction<JoinFunction<Row, Row, Row>, Row> convFun = this.generateConversionFunction((TypeInformation<Row>)leftType, (TypeInformation<Row>)rightType, resultType, config);
        LeftOuterJoinGroupReduceRunner reduceFun = new LeftOuterJoinGroupReduceRunner(convFun.name(), convFun.code(), convFun.returnType());
        return ((SingleInputUdfOperator)joinPairs.groupBy(new String[]{"f0"}).reduceGroup((GroupReduceFunction)reduceFun).name(joinOpName)).returns(resultType);
    }

    private DataSet<Row> addRightOuterJoin(DataSet<Row> left, DataSet<Row> right, int[] leftKeys, int[] rightKeys, TypeInformation<Row> resultType, TableConfig config) {
        if (!config.getNullCheck()) {
            throw new TableException("Null check in TableConfig must be enabled for outer joins.");
        }
        String joinOpName = this.getJoinOpName();
        RowTypeInfo leftType = (RowTypeInfo)left.getType();
        RowTypeInfo rightType = new RowTypeInfo(((RowTypeInfo)right.getType()).getFieldTypes());
        DataSet<Row> partitionedSortedRight = this.partitionAndSort(right, rightKeys);
        DataSet<Row> foldedRowsRight = this.foldIdenticalRows(partitionedSortedRight, (TypeInformation<Row>)rightType);
        GeneratedFunction<JoinFunction<Row, Row, Boolean>, Boolean> predFun = this.generatePredicateFunction((TypeInformation<Row>)leftType, (TypeInformation<Row>)rightType, config);
        RowTypeInfo joinOutType = new RowTypeInfo(new TypeInformation[]{leftType, rightType, Types$.MODULE$.INT()});
        RightOuterJoinRunner joinFun = new RightOuterJoinRunner(predFun.name(), predFun.code(), (TypeInformation<Row>)joinOutType);
        String[] nestedRightKeys = (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(rightKeys)).map((Function1 & Serializable & scala.Serializable)i -> DataSetJoin.$anonfun$addRightOuterJoin$1(BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        JoinOperator joinPairs = (JoinOperator)left.rightOuterJoin(foldedRowsRight, JoinOperatorBase.JoinHint.REPARTITION_SORT_MERGE).where(leftKeys).equalTo(nestedRightKeys).with((FlatJoinFunction)joinFun).withForwardedFieldsSecond(new String[]{"f0->f1"}).name(joinOpName);
        GeneratedFunction<JoinFunction<Row, Row, Row>, Row> convFun = this.generateConversionFunction((TypeInformation<Row>)leftType, (TypeInformation<Row>)rightType, resultType, config);
        RightOuterJoinGroupReduceRunner reduceFun = new RightOuterJoinGroupReduceRunner(convFun.name(), convFun.code(), convFun.returnType());
        return ((SingleInputUdfOperator)joinPairs.groupBy(new String[]{"f1"}).reduceGroup((GroupReduceFunction)reduceFun).name(joinOpName)).returns(resultType);
    }

    private DataSet<Row> addFullOuterJoin(DataSet<Row> left, DataSet<Row> right, int[] leftKeys, int[] rightKeys, TypeInformation<Row> resultType, TableConfig config) {
        if (!config.getNullCheck()) {
            throw new TableException("Null check in TableConfig must be enabled for outer joins.");
        }
        String joinOpName = this.getJoinOpName();
        RowTypeInfo leftType = new RowTypeInfo(((RowTypeInfo)left.getType()).getFieldTypes());
        RowTypeInfo rightType = new RowTypeInfo(((RowTypeInfo)right.getType()).getFieldTypes());
        DataSet<Row> partitionedSortedLeft = this.partitionAndSort(left, leftKeys);
        DataSet<Row> partitionedSortedRight = this.partitionAndSort(right, rightKeys);
        DataSet<Row> foldedRowsLeft = this.foldIdenticalRows(partitionedSortedLeft, (TypeInformation<Row>)leftType);
        DataSet<Row> foldedRowsRight = this.foldIdenticalRows(partitionedSortedRight, (TypeInformation<Row>)rightType);
        GeneratedFunction<JoinFunction<Row, Row, Boolean>, Boolean> predFun = this.generatePredicateFunction((TypeInformation<Row>)leftType, (TypeInformation<Row>)rightType, config);
        RowTypeInfo joinOutType = new RowTypeInfo(new TypeInformation[]{leftType, rightType, Types$.MODULE$.INT(), Types$.MODULE$.INT()});
        FullOuterJoinRunner joinFun = new FullOuterJoinRunner(predFun.name(), predFun.code(), (TypeInformation<Row>)joinOutType);
        String[] nestedLeftKeys = (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(leftKeys)).map((Function1 & Serializable & scala.Serializable)i -> DataSetJoin.$anonfun$addFullOuterJoin$1(BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] nestedRightKeys = (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(rightKeys)).map((Function1 & Serializable & scala.Serializable)i -> DataSetJoin.$anonfun$addFullOuterJoin$2(BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        JoinOperator joinPairs = (JoinOperator)foldedRowsLeft.fullOuterJoin(foldedRowsRight, JoinOperatorBase.JoinHint.REPARTITION_SORT_MERGE).where(nestedLeftKeys).equalTo(nestedRightKeys).with((FlatJoinFunction)joinFun).withForwardedFieldsFirst(new String[]{"f0->f0"}).withForwardedFieldsSecond(new String[]{"f0->f1"}).name(joinOpName);
        GeneratedFunction<JoinFunction<Row, Row, Row>, Row> convFun = this.generateConversionFunction((TypeInformation<Row>)leftType, (TypeInformation<Row>)rightType, resultType, config);
        LeftFullOuterJoinGroupReduceRunner leftReduceFun = new LeftFullOuterJoinGroupReduceRunner(convFun.name(), convFun.code(), convFun.returnType());
        RightFullOuterJoinGroupReduceRunner rightReduceFun = new RightFullOuterJoinGroupReduceRunner(convFun.name(), convFun.code(), convFun.returnType());
        GroupReduceOperator joinedAndLeftPreserved = (GroupReduceOperator)((SingleInputUdfOperator)joinPairs.filter((FilterFunction)new FilterFunction<Row>(null){

            public boolean filter(Row row2) {
                return row2.getField(0) != null;
            }
        }).groupBy(new String[]{"f0"}).reduceGroup((GroupReduceFunction)leftReduceFun).name(joinOpName)).returns(resultType);
        GroupReduceOperator rightPreserved = (GroupReduceOperator)((SingleInputUdfOperator)joinPairs.filter((FilterFunction)new FilterFunction<Row>(null){

            public boolean filter(Row row2) {
                return row2.getField(1) != null;
            }
        }).groupBy(new String[]{"f1"}).reduceGroup((GroupReduceFunction)rightReduceFun).name(joinOpName)).returns(resultType);
        return joinedAndLeftPreserved.union((DataSet)rightPreserved);
    }

    private String getJoinOpName() {
        return new StringBuilder(11).append("where: (").append(this.joinConditionToString(this.joinRowType, this.joinCondition, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable))).append("), ").append(new StringBuilder(8).append("join: (").append(this.joinSelectionToString(this.joinRowType)).append(")").toString()).toString();
    }

    private int[] getFullIndiciesWithPrefix(int[] keys, int numFields) {
        IndexedSeq nonKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFields).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> !new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keys)).contains((Object)BoxesRunTime.boxToInteger((int)x$1)));
        return (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keys)).$plus$plus((GenTraversableOnce)nonKeys, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    private DataSet<Row> partitionAndSort(DataSet<Row> dataSet, int[] partitionKeys) {
        int[] sortKeys = this.getFullIndiciesWithPrefix(partitionKeys, dataSet.getType().getArity());
        PartitionOperator partitioned = dataSet.partitionByHash(partitionKeys);
        return (DataSet)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sortKeys)).foldLeft((Object)partitioned, (Function2 & Serializable & scala.Serializable)(d, i) -> d.sortPartition(BoxesRunTime.unboxToInt((Object)i), Order.ASCENDING));
    }

    private DataSet<Row> foldIdenticalRows(DataSet<Row> dataSet, TypeInformation<Row> dataSetType) {
        RowTypeInfo resultType = new RowTypeInfo(new TypeInformation[]{dataSetType, Types$.MODULE$.INT()});
        Range groupKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), dataSetType.getArity());
        return dataSet.groupBy((int[])groupKeys.toArray(ClassTag$.MODULE$.Int())).reduceGroup((GroupReduceFunction)new GroupReduceFunction<Row, Row>(null){
            private final Row outTuple;

            private Row outTuple() {
                return this.outTuple;
            }

            public void reduce(Iterable<Row> values, Collector<Row> out) {
                int cnt = 0;
                Iterator<Row> it = values.iterator();
                while (it.hasNext()) {
                    this.outTuple().setField(0, (Object)it.next());
                    ++cnt;
                }
                this.outTuple().setField(1, (Object)BoxesRunTime.boxToInteger((int)cnt));
                out.collect((Object)this.outTuple());
            }
            {
                this.outTuple = new Row(2);
            }
        }).returns((TypeInformation)resultType).withForwardedFields(new String[]{"*->f0"}).name("fold identical rows");
    }

    private GeneratedFunction<JoinFunction<Row, Row, Boolean>, Boolean> generatePredicateFunction(TypeInformation<Row> leftType, TypeInformation<Row> rightType, TableConfig config) {
        FunctionCodeGenerator predGenerator = new FunctionCodeGenerator(config, false, leftType, (Option<TypeInformation<?>>)new Some(rightType), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$5(), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$6());
        GeneratedExpression condition = predGenerator.generateExpression(this.joinCondition);
        String predCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(43).append("\n         |").append(condition.code()).append("\n         |return (").append(condition.resultTerm()).append(");\n         |").toString())).stripMargin();
        return predGenerator.generateFunction("OuterJoinPredicate", JoinFunction.class, predCode, Types$.MODULE$.BOOLEAN());
    }

    private GeneratedFunction<JoinFunction<Row, Row, Row>, Row> generateConversionFunction(TypeInformation<Row> leftType, TypeInformation<Row> rightType, TypeInformation<Row> resultType, TableConfig config) {
        FunctionCodeGenerator conversionGenerator = new FunctionCodeGenerator(config, true, leftType, (Option<TypeInformation<?>>)new Some(rightType), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$5(), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$6());
        GeneratedExpression conversion = conversionGenerator.generateConverterResultExpression(resultType, (Seq<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.joinRowType.getFieldNames()), conversionGenerator.generateConverterResultExpression$default$3());
        String convCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n         |").append(conversion.code()).append("\n         |return ").append(conversion.resultTerm()).append(";\n         |").toString())).stripMargin();
        return conversionGenerator.generateFunction("OuterJoinConverter", JoinFunction.class, convCode, resultType);
    }

    public static final /* synthetic */ boolean $anonfun$translateToPlan$2(DataSetJoin $this, ArrayBuffer leftKeys$1, ArrayBuffer rightKeys$1, java.util.List leftFields$1, java.util.List rightFields$1, IntPair pair) {
        SqlTypeName leftKeyType = ((RelDataTypeField)leftFields$1.get(pair.source)).getType().getSqlTypeName();
        SqlTypeName rightKeyType = ((RelDataTypeField)rightFields$1.get(pair.target)).getType().getSqlTypeName();
        SqlTypeName sqlTypeName = leftKeyType;
        SqlTypeName sqlTypeName2 = rightKeyType;
        if (sqlTypeName != null ? !((Object)((Object)sqlTypeName)).equals((Object)sqlTypeName2) : sqlTypeName2 != null) {
            throw new TableException(new StringBuilder(47).append("Equality join predicate on incompatible types.\n").append(new StringBuilder(9).append("\tLeft: ").append($this.protected$left($this).toString()).append(",\n").toString()).append(new StringBuilder(10).append("\tRight: ").append($this.protected$right($this).toString()).append(",\n").toString()).append(new StringBuilder(14).append("\tCondition: (").append($this.joinConditionToString($this.joinRowType, $this.joinCondition, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> $this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable))).append(")").toString()).toString());
        }
        JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)leftKeys$1).add(BoxesRunTime.boxToInteger((int)pair.source));
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)rightKeys$1).add(BoxesRunTime.boxToInteger((int)pair.target));
    }

    public static final /* synthetic */ String $anonfun$addLeftOuterJoin$1(int i) {
        return new StringBuilder(4).append("f0.f").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$addRightOuterJoin$1(int i) {
        return new StringBuilder(4).append("f0.f").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$addFullOuterJoin$1(int i) {
        return new StringBuilder(4).append("f0.f").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$addFullOuterJoin$2(int i) {
        return new StringBuilder(4).append("f0.f").append(i).toString();
    }

    public DataSetJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode leftNode, RelNode rightNode, RelDataType rowRelDataType, RexNode joinCondition, RelDataType joinRowType, JoinInfo joinInfo, List<IntPair> keyPairs, JoinRelType joinType, JoinOperatorBase.JoinHint joinHint, String ruleDescription) {
        this.cluster = cluster;
        this.rowRelDataType = rowRelDataType;
        this.joinCondition = joinCondition;
        this.joinRowType = joinRowType;
        this.joinInfo = joinInfo;
        this.keyPairs = keyPairs;
        this.joinType = joinType;
        this.joinHint = joinHint;
        this.ruleDescription = ruleDescription;
        super(cluster, traitSet, leftNode, rightNode);
        CommonJoin.$init$(this);
        FlinkRelNode.$init$(this);
    }
}

