/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan;

import java.io.Serializable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.api.OverWindow;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.AbstractWindowProperty;
import org.apache.flink.table.expressions.AggFunctionCall;
import org.apache.flink.table.expressions.Aggregation;
import org.apache.flink.table.expressions.Alias;
import org.apache.flink.table.expressions.Alias$;
import org.apache.flink.table.expressions.ArrayConstructor;
import org.apache.flink.table.expressions.Attribute;
import org.apache.flink.table.expressions.BinaryExpression;
import org.apache.flink.table.expressions.Call;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.Flattening;
import org.apache.flink.table.expressions.GetCompositeField;
import org.apache.flink.table.expressions.LeafExpression;
import org.apache.flink.table.expressions.MapConstructor;
import org.apache.flink.table.expressions.NamedExpression;
import org.apache.flink.table.expressions.OverCall;
import org.apache.flink.table.expressions.ScalarFunctionCall;
import org.apache.flink.table.expressions.UnaryExpression;
import org.apache.flink.table.expressions.UnresolvedAlias;
import org.apache.flink.table.expressions.UnresolvedAlias$;
import org.apache.flink.table.expressions.UnresolvedFieldReference;
import org.apache.flink.table.expressions.UnresolvedOverCall;
import org.apache.flink.table.expressions.WindowProperty;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.plan.logical.LogicalNode;
import org.apache.flink.table.plan.logical.Project;
import org.apache.flink.table.plan.logical.Project$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ProjectionTranslator$ {
    public static ProjectionTranslator$ MODULE$;

    static {
        new ProjectionTranslator$();
    }

    public Tuple2<Map<Expression, String>, Map<Expression, String>> extractAggregationsAndProperties(Seq<Expression> exprs, TableEnvironment tableEnv) {
        return (Tuple2)exprs.foldLeft((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Function2 & Serializable & scala.Serializable)(x, y) -> MODULE$.identifyAggregationsAndProperties((Expression)y, tableEnv, (Map<Expression, String>)((Map)x._1()), (Map<Expression, String>)((Map)x._2())));
    }

    private Tuple2<Map<Expression, String>, Map<Expression, String>> identifyAggregationsAndProperties(Expression exp, TableEnvironment tableEnv, Map<Expression, String> aggNames, Map<Expression, String> propNames) {
        Tuple2 tuple2;
        block12: {
            Expression expression;
            while (true) {
                if ((expression = exp) instanceof Aggregation) {
                    Aggregation aggregation = (Aggregation)expression;
                    tuple2 = aggNames.contains((Object)aggregation) ? new Tuple2(aggNames, propNames) : new Tuple2((Object)aggNames.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aggregation), (Object)tableEnv.createUniqueAttributeName())), propNames);
                    break block12;
                }
                if (expression instanceof WindowProperty) {
                    Expression expression2 = expression;
                    tuple2 = propNames.contains((Object)expression2) ? new Tuple2(aggNames, propNames) : new Tuple2(aggNames, (Object)propNames.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)expression2), (Object)tableEnv.createUniqueAttributeName())));
                    break block12;
                }
                if (expression instanceof LeafExpression) {
                    tuple2 = new Tuple2(aggNames, propNames);
                    break block12;
                }
                if (expression instanceof UnaryExpression) {
                    UnaryExpression unaryExpression = (UnaryExpression)expression;
                    exp = unaryExpression.child();
                    continue;
                }
                if (!(expression instanceof BinaryExpression)) break;
                BinaryExpression binaryExpression = (BinaryExpression)expression;
                Tuple2<Map<Expression, String>, Map<Expression, String>> l = this.identifyAggregationsAndProperties(binaryExpression.left(), tableEnv, aggNames, propNames);
                propNames = (Map)l._2();
                aggNames = (Map)l._1();
                exp = binaryExpression.right();
            }
            if (expression instanceof Call) {
                Call call = (Call)expression;
                Seq<Expression> args = call.args();
                tuple2 = (Tuple2)args.foldLeft((Object)new Tuple2(aggNames, propNames), (Function2 & Serializable & scala.Serializable)(x, y) -> MODULE$.identifyAggregationsAndProperties((Expression)y, tableEnv, (Map<Expression, String>)((Map)x._1()), (Map<Expression, String>)((Map)x._2())));
            } else if (expression instanceof ScalarFunctionCall) {
                ScalarFunctionCall scalarFunctionCall = (ScalarFunctionCall)expression;
                Seq<Expression> args = scalarFunctionCall.parameters();
                tuple2 = (Tuple2)args.foldLeft((Object)new Tuple2(aggNames, propNames), (Function2 & Serializable & scala.Serializable)(x, y) -> MODULE$.identifyAggregationsAndProperties((Expression)y, tableEnv, (Map<Expression, String>)((Map)x._1()), (Map<Expression, String>)((Map)x._2())));
            } else if (expression != null) {
                Expression expression3 = expression;
                tuple2 = (Tuple2)expression3.productIterator().foldLeft((Object)new Tuple2(aggNames, propNames), (Function2 & Serializable & scala.Serializable)(x, y) -> {
                    Tuple2<Map<Expression, String>, Map<Expression, String>> tuple2;
                    Object object = y;
                    if (object instanceof Expression) {
                        Expression expression = (Expression)object;
                        tuple2 = MODULE$.identifyAggregationsAndProperties(expression, tableEnv, (Map<Expression, String>)((Map)x._1()), (Map<Expression, String>)((Map)x._2()));
                    } else {
                        tuple2 = new Tuple2<Map<Expression, String>, Map<Expression, String>>(x._1(), x._2());
                    }
                    return tuple2;
                });
            } else {
                if (expression == null) {
                    throw new ValidationException("Scala 'null' is not a valid expression. Use 'Null(TYPE)' to specify typed null expressions. For example: Null(Types.INT)");
                }
                throw new MatchError((Object)expression);
            }
        }
        return tuple2;
    }

    public Seq<NamedExpression> replaceAggregationsAndProperties(Seq<Expression> exprs, TableEnvironment tableEnv, Map<Expression, String> aggNames, Map<Expression, String> propNames) {
        HashSet projectedNames = new HashSet();
        return (Seq)((TraversableLike)exprs.map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.replaceAggregationsAndProperties((Expression)exp, tableEnv, aggNames, propNames, (HashSet<String>)projectedNames), Seq$.MODULE$.canBuildFrom())).map((Function1)UnresolvedAlias$.MODULE$, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Expression replaceAggregationsAndProperties(Expression exp2, TableEnvironment tableEnv, Map<Expression, String> aggNames, Map<Expression, String> propNames, HashSet<String> projectedNames) {
        void var11_23;
        boolean bl = false;
        Alias alias = null;
        Expression expression = exp2;
        if (expression instanceof Aggregation) {
            Aggregation aggregation = (Aggregation)expression;
            String name = (String)aggNames.apply((Object)aggregation);
            Expression expression2 = projectedNames.add((Object)name) ? new UnresolvedFieldReference(name) : new Alias(new UnresolvedFieldReference(name), tableEnv.createUniqueAttributeName(), Alias$.MODULE$.apply$default$3());
            return var11_23;
        }
        if (expression instanceof WindowProperty) {
            Expression expression3 = expression;
            String name = (String)propNames.apply((Object)expression3);
            Expression expression4 = projectedNames.add((Object)name) ? new UnresolvedFieldReference(name) : new Alias(new UnresolvedFieldReference(name), tableEnv.createUniqueAttributeName(), Alias$.MODULE$.apply$default$3());
            return var11_23;
        }
        if (expression instanceof Alias) {
            bl = true;
            alias = (Alias)expression;
            Expression agg = alias.child();
            String name = alias.name();
            if (agg instanceof Aggregation) {
                Aggregation aggregation = (Aggregation)agg;
                String aName = (String)aggNames.apply((Object)aggregation);
                Alias alias2 = new Alias(new UnresolvedFieldReference(aName), name, Alias$.MODULE$.apply$default$3());
                return var11_23;
            }
        }
        if (bl) {
            Expression prop = alias.child();
            String name = alias.name();
            if (prop instanceof WindowProperty) {
                Expression expression5 = prop;
                String pName = (String)propNames.apply((Object)expression5);
                Alias alias3 = new Alias(new UnresolvedFieldReference(pName), name, Alias$.MODULE$.apply$default$3());
                return var11_23;
            }
        }
        if (expression instanceof LeafExpression) {
            LeafExpression leafExpression;
            LeafExpression leafExpression2 = leafExpression = (LeafExpression)expression;
            return var11_23;
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            Expression c = this.replaceAggregationsAndProperties(unaryExpression.child(), tableEnv, aggNames, propNames, projectedNames);
            Expression expression6 = (Expression)unaryExpression.makeCopy(new Object[]{c});
            return var11_23;
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            Expression l = this.replaceAggregationsAndProperties(binaryExpression.left(), tableEnv, aggNames, propNames, projectedNames);
            Expression r = this.replaceAggregationsAndProperties(binaryExpression.right(), tableEnv, aggNames, propNames, projectedNames);
            Expression expression7 = (Expression)binaryExpression.makeCopy(new Object[]{l, r});
            return var11_23;
        }
        if (expression instanceof Call) {
            Call call = (Call)expression;
            String name = call.functionName();
            Seq<Expression> args = call.args();
            Seq newArgs = (Seq)args.map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.replaceAggregationsAndProperties((Expression)exp, tableEnv, aggNames, propNames, projectedNames), Seq$.MODULE$.canBuildFrom());
            Expression expression8 = (Expression)call.makeCopy(new Object[]{name, newArgs});
            return var11_23;
        }
        if (expression instanceof ScalarFunctionCall) {
            ScalarFunctionCall scalarFunctionCall = (ScalarFunctionCall)expression;
            ScalarFunction clazz = scalarFunctionCall.scalarFunction();
            Seq<Expression> args = scalarFunctionCall.parameters();
            Seq newArgs = (Seq)args.map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.replaceAggregationsAndProperties((Expression)exp, tableEnv, aggNames, propNames, projectedNames), Seq$.MODULE$.canBuildFrom());
            Expression expression9 = (Expression)scalarFunctionCall.makeCopy(new Object[]{clazz, newArgs});
            return var11_23;
        }
        if (expression instanceof ArrayConstructor) {
            ArrayConstructor arrayConstructor = (ArrayConstructor)expression;
            Seq newArgs = (Seq)arrayConstructor.elements().map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.replaceAggregationsAndProperties((Expression)exp, tableEnv, aggNames, propNames, projectedNames), Seq$.MODULE$.canBuildFrom());
            Expression expression10 = (Expression)arrayConstructor.makeCopy(new Object[]{newArgs});
            return var11_23;
        }
        if (expression instanceof MapConstructor) {
            MapConstructor mapConstructor = (MapConstructor)expression;
            Seq newArgs = (Seq)mapConstructor.elements().map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.replaceAggregationsAndProperties((Expression)exp, tableEnv, aggNames, propNames, projectedNames), Seq$.MODULE$.canBuildFrom());
            Expression expression11 = (Expression)mapConstructor.makeCopy(new Object[]{newArgs});
            return var11_23;
        }
        if (expression == null) throw new MatchError((Object)expression);
        Expression expression12 = expression;
        Iterator newArgs = expression12.productIterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (!(object instanceof Expression)) {
                throw new MatchError(object);
            }
            Expression expression = (Expression)object;
            Expression expression2 = MODULE$.replaceAggregationsAndProperties(expression, tableEnv, aggNames, propNames, projectedNames);
            return expression2;
        });
        Expression expression13 = (Expression)expression12.makeCopy((Object[])newArgs.toArray(ClassTag$.MODULE$.AnyRef()));
        return var11_23;
    }

    public Seq<Expression> expandProjectList(Seq<Expression> exprs, LogicalNode parent, TableEnvironment tableEnv) {
        ListBuffer projectList = new ListBuffer();
        exprs.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Expression expression = x0$2;
            if (expression instanceof UnresolvedFieldReference) {
                UnresolvedFieldReference unresolvedFieldReference = (UnresolvedFieldReference)expression;
                String string = unresolvedFieldReference.name();
                String string2 = "*";
                if (string == null) {
                    if (string2 == null) return projectList.$plus$plus$eq((TraversableOnce)parent.output().map((Function1 & Serializable & scala.Serializable)a -> new UnresolvedFieldReference(a.name()), Seq$.MODULE$.canBuildFrom()));
                } else if (string.equals(string2)) {
                    return projectList.$plus$plus$eq((TraversableOnce)parent.output().map((Function1 & Serializable & scala.Serializable)a -> new UnresolvedFieldReference(a.name()), Seq$.MODULE$.canBuildFrom()));
                }
            }
            if (expression instanceof Flattening) {
                ListBuffer listBuffer;
                Flattening flattening = (Flattening)expression;
                Expression unresolved = flattening.child();
                LogicalNode project = new Project((Seq<NamedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAlias[]{new UnresolvedAlias(unresolved)}))), parent, Project$.MODULE$.apply$default$3()).validate(tableEnv);
                Attribute resolvedExpr = (Attribute)project.output().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new RuntimeException("Could not find resolved composite.");
                });
                resolvedExpr.validateInput();
                TypeInformation<?> typeInformation = resolvedExpr.resultType();
                if (typeInformation instanceof CompositeType) {
                    CompositeType compositeType = (CompositeType)typeInformation;
                    listBuffer = (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), compositeType.getArity()).map((Function1 & Serializable & scala.Serializable)idx -> projectList.$plus$eq((Object)new GetCompositeField(unresolved, compositeType.getFieldNames()[BoxesRunTime.unboxToInt((Object)idx)])), IndexedSeq$.MODULE$.canBuildFrom());
                } else {
                    listBuffer = projectList.$plus$eq((Object)unresolved);
                }
                ListBuffer newProjects = listBuffer;
                return BoxedUnit.UNIT;
            }
            if (expression == null) throw new MatchError((Object)expression);
            Expression expression2 = expression;
            return projectList.$plus$eq((Object)expression2);
        });
        return projectList;
    }

    public Seq<Expression> resolveOverWindows(Seq<Expression> exprs, OverWindow[] overWindows, TableEnvironment tEnv) {
        return (Seq)exprs.map((Function1 & Serializable & scala.Serializable)e2 -> MODULE$.replaceOverCall((Expression)e2, overWindows, tEnv), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Expression replaceOverCall(Expression expr, OverWindow[] overWindows, TableEnvironment tableEnv) {
        Expression expression;
        void var7_14;
        Expression expression2 = expr;
        if (expression2 instanceof UnresolvedOverCall) {
            UnresolvedOverCall unresolvedOverCall = (UnresolvedOverCall)expression2;
            Option overWindow = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])overWindows)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ProjectionTranslator$.$anonfun$replaceOverCall$1(unresolvedOverCall, x$1)));
            Expression expression3 = overWindow.isDefined() ? new OverCall(unresolvedOverCall.agg(), ((OverWindow)overWindow.get()).partitionBy(), ((OverWindow)overWindow.get()).orderBy(), ((OverWindow)overWindow.get()).preceding(), ((OverWindow)overWindow.get()).following()) : unresolvedOverCall;
            return var7_14;
        }
        if (expression2 instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression2;
            Expression c = this.replaceOverCall(unaryExpression.child(), overWindows, tableEnv);
            Expression expression4 = (Expression)unaryExpression.makeCopy(new Object[]{c});
            return var7_14;
        }
        if (expression2 instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression2;
            Expression l = this.replaceOverCall(binaryExpression.left(), overWindows, tableEnv);
            Expression r = this.replaceOverCall(binaryExpression.right(), overWindows, tableEnv);
            Expression expression5 = (Expression)binaryExpression.makeCopy(new Object[]{l, r});
            return var7_14;
        }
        if (expression2 instanceof Call) {
            Call call = (Call)expression2;
            String name = call.functionName();
            Seq<Expression> args = call.args();
            if (args != null) {
                Seq<Expression> seq = args;
                Seq newArgs = (Seq)seq.map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.replaceOverCall((Expression)exp, overWindows, tableEnv), Seq$.MODULE$.canBuildFrom());
                Expression expression6 = (Expression)call.makeCopy(new Object[]{name, newArgs});
                return var7_14;
            }
        }
        if (expression2 instanceof ScalarFunctionCall) {
            ScalarFunctionCall scalarFunctionCall = (ScalarFunctionCall)expression2;
            ScalarFunction clazz = scalarFunctionCall.scalarFunction();
            Seq<Expression> args = scalarFunctionCall.parameters();
            if (args != null) {
                Seq<Expression> seq = args;
                Seq newArgs = (Seq)seq.map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.replaceOverCall((Expression)exp, overWindows, tableEnv), Seq$.MODULE$.canBuildFrom());
                Expression expression7 = (Expression)scalarFunctionCall.makeCopy(new Object[]{clazz, newArgs});
                return var7_14;
            }
        }
        if (expression2 instanceof ArrayConstructor) {
            ArrayConstructor arrayConstructor = (ArrayConstructor)expression2;
            Seq newArgs = (Seq)arrayConstructor.elements().map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.replaceOverCall((Expression)exp, overWindows, tableEnv), Seq$.MODULE$.canBuildFrom());
            Expression expression8 = (Expression)arrayConstructor.makeCopy(new Object[]{newArgs});
            return var7_14;
        }
        if (expression2 == null) throw new MatchError((Object)expression2);
        Expression expression9 = expression = expression2;
        return var7_14;
    }

    public Seq<NamedExpression> extractFieldReferences(Seq<Expression> exprs) {
        return ((SetLike)exprs.foldLeft((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(fieldReferences, expr) -> MODULE$.identifyFieldReferences((Expression)expr, (Set<NamedExpression>)fieldReferences))).toSeq();
    }

    private Set<NamedExpression> identifyFieldReferences(Expression expr2, Set<NamedExpression> fieldReferences2) {
        Set set;
        block10: {
            Expression expression;
            while (true) {
                ScalarFunctionCall scalarFunctionCall;
                Seq<Expression> args;
                Call call;
                Seq<Expression> args2;
                if ((expression = expr2) instanceof UnresolvedFieldReference) {
                    UnresolvedFieldReference unresolvedFieldReference = (UnresolvedFieldReference)expression;
                    set = (Set)fieldReferences2.$plus((Object)new UnresolvedAlias(unresolvedFieldReference));
                    break block10;
                }
                if (expression instanceof BinaryExpression) {
                    BinaryExpression binaryExpression = (BinaryExpression)expression;
                    Set<NamedExpression> l = this.identifyFieldReferences(binaryExpression.left(), fieldReferences2);
                    fieldReferences2 = l;
                    expr2 = binaryExpression.right();
                    continue;
                }
                if (expression instanceof Call && (args2 = (call = (Call)expression).args()) != null) {
                    Seq<Expression> seq = args2;
                    set = (Set)seq.foldLeft(fieldReferences2, (Function2 & Serializable & scala.Serializable)(fieldReferences, expr) -> MODULE$.identifyFieldReferences((Expression)expr, (Set<NamedExpression>)fieldReferences));
                    break block10;
                }
                if (expression instanceof ScalarFunctionCall && (args = (scalarFunctionCall = (ScalarFunctionCall)expression).parameters()) != null) {
                    Seq<Expression> seq = args;
                    set = (Set)seq.foldLeft(fieldReferences2, (Function2 & Serializable & scala.Serializable)(fieldReferences, expr) -> MODULE$.identifyFieldReferences((Expression)expr, (Set<NamedExpression>)fieldReferences));
                    break block10;
                }
                if (expression instanceof AggFunctionCall) {
                    AggFunctionCall aggFunctionCall = (AggFunctionCall)expression;
                    Seq<Expression> args3 = aggFunctionCall.args();
                    set = (Set)args3.foldLeft(fieldReferences2, (Function2 & Serializable & scala.Serializable)(fieldReferences, expr) -> MODULE$.identifyFieldReferences((Expression)expr, (Set<NamedExpression>)fieldReferences));
                    break block10;
                }
                if (expression instanceof ArrayConstructor) {
                    ArrayConstructor arrayConstructor = (ArrayConstructor)expression;
                    Seq<Expression> args4 = arrayConstructor.elements();
                    set = (Set)args4.foldLeft((Object)fieldReferences2, (Function2 & Serializable & scala.Serializable)(fieldReferences, expr) -> MODULE$.identifyFieldReferences((Expression)expr, (Set<NamedExpression>)fieldReferences));
                    break block10;
                }
                if (expression instanceof WindowProperty) {
                    set = fieldReferences2;
                    break block10;
                }
                if (!(expression instanceof UnaryExpression)) break;
                UnaryExpression unaryExpression = (UnaryExpression)expression;
                expr2 = unaryExpression.child();
            }
            if (expression != null) {
                Expression expression2 = expression;
                set = (Set)expression2.productIterator().foldLeft((Object)fieldReferences2, (Function2 & Serializable & scala.Serializable)(fieldReferences, expr) -> {
                    Set<NamedExpression> set;
                    Object object = expr;
                    if (object instanceof Expression) {
                        Expression expression = (Expression)object;
                        set = MODULE$.identifyFieldReferences(expression, (Set<NamedExpression>)fieldReferences);
                    } else {
                        set = fieldReferences;
                    }
                    return set;
                });
            } else {
                throw new MatchError((Object)expression);
            }
        }
        return set;
    }

    public Expression replaceAggFunctionCall(Expression field, TableEnvironment tableEnv) {
        Expression expression;
        Expression expression2 = field;
        if (expression2 instanceof LeafExpression) {
            LeafExpression leafExpression;
            expression = leafExpression = (LeafExpression)expression2;
        } else if (expression2 instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression2;
            Expression c = this.replaceAggFunctionCall(unaryExpression.child(), tableEnv);
            expression = (Expression)unaryExpression.makeCopy(new Object[]{c});
        } else if (expression2 instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression2;
            Expression l = this.replaceAggFunctionCall(binaryExpression.left(), tableEnv);
            Expression r = this.replaceAggFunctionCall(binaryExpression.right(), tableEnv);
            expression = (Expression)binaryExpression.makeCopy(new Object[]{l, r});
        } else if (expression2 instanceof Call) {
            Expression expression3;
            Call call = (Call)expression2;
            String name = call.functionName();
            Seq<Expression> args = call.args();
            Expression function = tableEnv.getFunctionCatalog().lookupFunction(name, args);
            Expression expression4 = function;
            if (expression4 instanceof AggFunctionCall) {
                AggFunctionCall aggFunctionCall;
                expression3 = aggFunctionCall = (AggFunctionCall)expression4;
            } else if (expression4 instanceof Aggregation) {
                Aggregation aggregation = (Aggregation)expression4;
                expression3 = aggregation;
            } else if (expression4 instanceof AbstractWindowProperty) {
                AbstractWindowProperty abstractWindowProperty = (AbstractWindowProperty)expression4;
                expression3 = abstractWindowProperty;
            } else {
                Seq newArgs = (Seq)args.map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.replaceAggFunctionCall((Expression)exp, tableEnv), Seq$.MODULE$.canBuildFrom());
                expression3 = (Expression)call.makeCopy(new Object[]{name, newArgs});
            }
            expression = expression3;
        } else if (expression2 instanceof ScalarFunctionCall) {
            ScalarFunctionCall scalarFunctionCall = (ScalarFunctionCall)expression2;
            ScalarFunction clazz = scalarFunctionCall.scalarFunction();
            Seq<Expression> args = scalarFunctionCall.parameters();
            Seq newArgs = (Seq)args.map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.replaceAggFunctionCall((Expression)exp, tableEnv), Seq$.MODULE$.canBuildFrom());
            expression = (Expression)scalarFunctionCall.makeCopy(new Object[]{clazz, newArgs});
        } else if (expression2 instanceof ArrayConstructor) {
            ArrayConstructor arrayConstructor = (ArrayConstructor)expression2;
            Seq newArgs = (Seq)arrayConstructor.elements().map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.replaceAggFunctionCall((Expression)exp, tableEnv), Seq$.MODULE$.canBuildFrom());
            expression = (Expression)arrayConstructor.makeCopy(new Object[]{newArgs});
        } else if (expression2 != null) {
            Expression expression5 = expression2;
            expression = expression5;
        } else {
            throw new MatchError((Object)expression2);
        }
        return expression;
    }

    public static final /* synthetic */ boolean $anonfun$replaceOverCall$1(UnresolvedOverCall x5$1, OverWindow x$1) {
        return x$1.alias().equals(x5$1.alias());
    }

    private ProjectionTranslator$() {
        MODULE$ = this;
    }
}

