/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.List;
import org.apache.flink.table.api.CatalogAlreadyExistException;
import org.apache.flink.table.api.CatalogNotExistException;
import org.apache.flink.table.api.TableAlreadyExistException;
import org.apache.flink.table.api.TableNotExistException;
import org.apache.flink.table.catalog.CrudExternalCatalog;
import org.apache.flink.table.catalog.ExternalCatalog;
import org.apache.flink.table.catalog.ExternalCatalogTable;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u00015\u0011q#\u00138NK6|'/_#yi\u0016\u0014h.\u00197DCR\fGn\\4\u000b\u0005\r!\u0011aB2bi\u0006dwn\u001a\u0006\u0003\u000b\u0019\tQ\u0001^1cY\u0016T!a\u0002\u0005\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!aE\"sk\u0012,\u0005\u0010^3s]\u0006d7)\u0019;bY><\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\t9\fW.\u001a\t\u00037\tr!\u0001\b\u0011\u0011\u0005u\u0001R\"\u0001\u0010\u000b\u0005}a\u0011A\u0002\u001fs_>$h(\u0003\u0002\"!\u00051\u0001K]3eK\u001aL!a\t\u0013\u0003\rM#(/\u001b8h\u0015\t\t\u0003\u0003C\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0003Q%\u0002\"!\u0006\u0001\t\u000be)\u0003\u0019\u0001\u000e\t\u000f-\u0002!\u0019!C\u0005Y\u0005IA-\u0019;bE\u0006\u001cXm]\u000b\u0002[A!af\r\u000e6\u001b\u0005y#B\u0001\u00192\u0003\u001diW\u000f^1cY\u0016T!A\r\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00025_\t9\u0001*Y:i\u001b\u0006\u0004\bCA\u000b7\u0013\t9$AA\bFqR,'O\\1m\u0007\u0006$\u0018\r\\8h\u0011\u0019I\u0004\u0001)A\u0005[\u0005QA-\u0019;bE\u0006\u001cXm\u001d\u0011\t\u000fm\u0002!\u0019!C\u0005y\u00051A/\u00192mKN,\u0012!\u0010\t\u0005]MRb\b\u0005\u0002\u0016\u007f%\u0011\u0001I\u0001\u0002\u0015\u000bb$XM\u001d8bY\u000e\u000bG/\u00197pOR\u000b'\r\\3\t\r\t\u0003\u0001\u0015!\u0003>\u0003\u001d!\u0018M\u00197fg\u0002BQ\u0001\u0012\u0001\u0005B\u0015\u000b1b\u0019:fCR,G+\u00192mKR!a)S&M!\tyq)\u0003\u0002I!\t!QK\\5u\u0011\u0015Q5\t1\u0001\u001b\u0003%!\u0018M\u00197f\u001d\u0006lW\rC\u0003\u0006\u0007\u0002\u0007a\bC\u0003N\u0007\u0002\u0007a*\u0001\bjO:|'/Z%g\u000bbL7\u000f^:\u0011\u0005=y\u0015B\u0001)\u0011\u0005\u001d\u0011un\u001c7fC:D3a\u0011*\\!\ry1+V\u0005\u0003)B\u0011a\u0001\u001e5s_^\u001c\bC\u0001,Z\u001b\u00059&B\u0001-\u0005\u0003\r\t\u0007/[\u0005\u00035^\u0013!\u0004V1cY\u0016\fEN]3bIf,\u00050[:u\u000bb\u001cW\r\u001d;j_:\fDA\b\u000e]kF*1%X1qEV\u0011alX\u000b\u00025\u0011)\u0001\r\u0004b\u0001K\n\tA+\u0003\u0002cG\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER!\u0001\u001a\t\u0002\rQD'o\\<t#\t1\u0017\u000e\u0005\u0002\u0010O&\u0011\u0001\u000e\u0005\u0002\b\u001d>$\b.\u001b8h!\tQWN\u0004\u0002\u0010W&\u0011A\u000eE\u0001\ba\u0006\u001c7.Y4f\u0013\tqwNA\u0005UQJ|w/\u00192mK*\u0011A\u000eE\u0019\u0006GE\u00148\u000f\u001a\b\u0003\u001fIL!\u0001\u001a\t2\t\tz\u0001\u0003\u001e\u0002\u0006g\u000e\fG.Y\u0019\u0003MUCQa\u001e\u0001\u0005Ba\f\u0011\u0002\u001a:paR\u000b'\r\\3\u0015\u0007\u0019K(\u0010C\u0003Km\u0002\u0007!\u0004C\u0003|m\u0002\u0007a*A\tjO:|'/Z%g\u001d>$X\t_5tiNDCA^?\u0002\u0004A\u0019qb\u0015@\u0011\u0005Y{\u0018bAA\u0001/\n1B+\u00192mK:{G/\u0012=jgR,\u0005pY3qi&|g.\r\u0004\u001f5\u0005\u0015\u00111B\u0019\u0007Gu\u000b\u0017q\u000122\r\r\n(/!\u0003ec\u0011\u0011s\u0002\u0005;2\u0005\u0019r\bbBA\b\u0001\u0011\u0005\u0013\u0011C\u0001\u000bC2$XM\u001d+bE2,Gc\u0002$\u0002\u0014\u0005U\u0011q\u0003\u0005\u0007\u0015\u00065\u0001\u0019\u0001\u000e\t\r\u0015\ti\u00011\u0001?\u0011\u0019Y\u0018Q\u0002a\u0001\u001d\"*\u0011QB?\u0002\u001cE2aDGA\u000f\u0003G\tdaI/b\u0003?\u0011\u0017GB\u0012re\u0006\u0005B-\r\u0003#\u001fA!\u0018G\u0001\u0014\u007f\u0011\u001d\t9\u0003\u0001C!\u0003S\t\u0001c\u0019:fCR,7+\u001e2DCR\fGn\\4\u0015\u000f\u0019\u000bY#a\f\u00022!9\u0011QFA\u0013\u0001\u0004Q\u0012aC2bi\u0006dwn\u001a(b[\u0016DaaAA\u0013\u0001\u0004)\u0004BB'\u0002&\u0001\u0007a\n\u000b\u0004\u0002&\u0005U\u0012Q\b\t\u0005\u001fM\u000b9\u0004E\u0002W\u0003sI1!a\u000fX\u0005q\u0019\u0015\r^1m_\u001e\fEN]3bIf,\u00050[:u\u000bb\u001cW\r\u001d;j_:\fdA\b\u000e\u0002@\u0005\u0015\u0013GB\u0012^C\u0006\u0005#-\r\u0004$cJ\f\u0019\u0005Z\u0019\u0005E=\u0001B/M\u0002'\u0003oAq!!\u0013\u0001\t\u0003\nY%\u0001\bee>\u00048+\u001e2DCR\fGn\\4\u0015\u000b\u0019\u000bi%a\u0014\t\u000f\u00055\u0012q\ta\u00015!110a\u0012A\u00029Cc!a\u0012\u0002T\u0005m\u0003\u0003B\bT\u0003+\u00022AVA,\u0013\r\tIf\u0016\u0002\u0019\u0007\u0006$\u0018\r\\8h\u001d>$X\t_5ti\u0016C8-\u001a9uS>t\u0017G\u0002\u0010\u001b\u0003;\n\u0019'\r\u0004$;\u0006\fyFY\u0019\u0007GE\u0014\u0018\u0011\r32\t\tz\u0001\u0003^\u0019\u0004M\u0005U\u0003bBA4\u0001\u0011\u0005\u0013\u0011N\u0001\u0010C2$XM]*vE\u000e\u000bG/\u00197pOR9a)a\u001b\u0002n\u0005=\u0004bBA\u0017\u0003K\u0002\rA\u0007\u0005\u0007\u0007\u0005\u0015\u0004\u0019A\u001b\t\rm\f)\u00071\u0001O\u0011\u001d\t\u0019\b\u0001C!\u0003k\n\u0001bZ3u)\u0006\u0014G.\u001a\u000b\u0004}\u0005]\u0004B\u0002&\u0002r\u0001\u0007!\u0004C\u0004\u0002|\u0001!\t%! \u0002\u00151L7\u000f\u001e+bE2,7\u000f\u0006\u0002\u0002\u0000A)\u0011\u0011QAF55\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)\u0001\u0003vi&d'BAAE\u0003\u0011Q\u0017M^1\n\t\u00055\u00151\u0011\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002\u0012\u0002!\t%a%\u0002\u001b\u001d,GoU;c\u0007\u0006$\u0018\r\\8h)\r)\u0014Q\u0013\u0005\b\u0003[\ty\t1\u0001\u001bQ\u0019\ty)a\u0015\u0002\u001aF2aDGAN\u0003C\u000bdaI/b\u0003;\u0013\u0017GB\u0012re\u0006}E-\r\u0003#\u001fA!\u0018g\u0001\u0014\u0002V!9\u0011Q\u0015\u0001\u0005B\u0005u\u0014a\u00047jgR\u001cVOY\"bi\u0006dwnZ:")
public class InMemoryExternalCatalog
implements CrudExternalCatalog {
    private final String name;
    private final HashMap<String, ExternalCatalog> databases;
    private final HashMap<String, ExternalCatalogTable> tables;

    private HashMap<String, ExternalCatalog> databases() {
        return this.databases;
    }

    private HashMap<String, ExternalCatalogTable> tables() {
        return this.tables;
    }

    @Override
    public void createTable(String tableName, ExternalCatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException {
        InMemoryExternalCatalog inMemoryExternalCatalog = this;
        synchronized (inMemoryExternalCatalog) {
            Option option = this.tables().get((Object)tableName);
            if (option instanceof Some && !ignoreIfExists) {
                throw new TableAlreadyExistException(this.name, tableName);
            }
            Option option2 = this.tables().put((Object)tableName, (Object)table);
        }
    }

    @Override
    public synchronized void dropTable(String tableName, boolean ignoreIfNotExists) throws TableNotExistException {
        if (this.tables().remove((Object)tableName).isEmpty() && !ignoreIfNotExists) {
            throw new TableNotExistException(this.name, tableName);
        }
    }

    @Override
    public void alterTable(String tableName, ExternalCatalogTable table, boolean ignoreIfNotExists) throws TableNotExistException {
        InMemoryExternalCatalog inMemoryExternalCatalog = this;
        synchronized (inMemoryExternalCatalog) {
            BoxedUnit boxedUnit;
            if (this.tables().contains((Object)tableName)) {
                boxedUnit = this.tables().put((Object)tableName, (Object)table);
            } else {
                if (!ignoreIfNotExists) {
                    throw new TableNotExistException(this.name, tableName);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void createSubCatalog(String catalogName, ExternalCatalog catalog, boolean ignoreIfExists) throws CatalogAlreadyExistException {
        InMemoryExternalCatalog inMemoryExternalCatalog = this;
        synchronized (inMemoryExternalCatalog) {
            Option option = this.databases().get((Object)catalogName);
            if (option instanceof Some && !ignoreIfExists) {
                throw new CatalogAlreadyExistException(catalogName, null);
            }
            Option option2 = this.databases().put((Object)catalogName, (Object)catalog);
        }
    }

    @Override
    public synchronized void dropSubCatalog(String catalogName, boolean ignoreIfNotExists) throws CatalogNotExistException {
        if (this.databases().remove((Object)catalogName).isEmpty() && !ignoreIfNotExists) {
            throw new CatalogNotExistException(catalogName, null);
        }
    }

    @Override
    public void alterSubCatalog(String catalogName, ExternalCatalog catalog, boolean ignoreIfNotExists) {
        InMemoryExternalCatalog inMemoryExternalCatalog = this;
        synchronized (inMemoryExternalCatalog) {
            BoxedUnit boxedUnit;
            if (this.databases().contains((Object)catalogName)) {
                boxedUnit = this.databases().put((Object)catalogName, (Object)catalog);
            } else {
                if (!ignoreIfNotExists) {
                    throw new CatalogNotExistException(catalogName);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public synchronized ExternalCatalogTable getTable(String tableName) {
        ExternalCatalogTable t;
        Option option = this.tables().get((Object)tableName);
        if (!(option instanceof Some)) {
            throw new TableNotExistException(this.name, tableName, null);
        }
        Some some = (Some)option;
        ExternalCatalogTable externalCatalogTable = t = (ExternalCatalogTable)some.value();
        return externalCatalogTable;
    }

    @Override
    public synchronized List<String> listTables() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.tables().keys().toList()).asJava();
    }

    @Override
    public synchronized ExternalCatalog getSubCatalog(String catalogName) throws CatalogNotExistException {
        ExternalCatalog d;
        Option option = this.databases().get((Object)catalogName);
        if (!(option instanceof Some)) {
            throw new CatalogNotExistException(catalogName, null);
        }
        Some some = (Some)option;
        ExternalCatalog externalCatalog = d = (ExternalCatalog)some.value();
        return externalCatalog;
    }

    @Override
    public synchronized List<String> listSubCatalogs() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.databases().keys().toList()).asJava();
    }

    public InMemoryExternalCatalog(String name) {
        this.name = name;
        this.databases = new HashMap();
        this.tables = new HashMap();
    }
}

