/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.Serializable;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.Alias;
import org.apache.flink.table.expressions.Alias$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionParser$;
import org.apache.flink.table.expressions.NamedExpression;
import org.apache.flink.table.plan.ProjectionTranslator$;
import org.apache.flink.table.plan.logical.Aggregate;
import org.apache.flink.table.plan.logical.Project;
import org.apache.flink.table.plan.logical.Project$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u001b\taqI]8va\u0016$G+\u00192mK*\u00111\u0001B\u0001\u0004CBL'BA\u0003\u0007\u0003\u0015!\u0018M\u00197f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"C\u0003\u0001\u0005\u000b\u0007I\u0011\u0001\u0004\u0016+\u00051\u0002CA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u0005\u0015!\u0016M\u00197f\u0011!Y\u0002A!A!\u0002\u00131\u0012A\u0002;bE2,\u0007\u0005C\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u0007=\u0005AqM]8va.+\u00170F\u0001 !\r\u0001\u0003f\u000b\b\u0003C\u0019r!AI\u0013\u000e\u0003\rR!\u0001\n\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA\u0014\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u000b\u0016\u0003\u0007M+\u0017O\u0003\u0002(!A\u0011AfL\u0007\u0002[)\u0011a\u0006B\u0001\fKb\u0004(/Z:tS>t7/\u0003\u00021[\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011I\u0002!\u0011!Q\u0001\n}\t\u0011b\u001a:pkB\\U-\u001f\u0011\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\r1t\u0007\u000f\t\u0003/\u0001AQ!B\u001aA\u0002YAQ!H\u001aA\u0002}AQA\u000f\u0001\u0005\u0002m\naa]3mK\u000e$HC\u0001\f=\u0011\u0015i\u0014\b1\u0001?\u0003\u00191\u0017.\u001a7egB\u0019qbP\u0016\n\u0005\u0001\u0003\"A\u0003\u001fsKB,\u0017\r^3e}!)!\b\u0001C\u0001\u0005R\u0011ac\u0011\u0005\u0006{\u0005\u0003\r\u0001\u0012\t\u0003\u000b&s!AR$\u0011\u0005\t\u0002\u0012B\u0001%\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!\u0003\u0002")
public class GroupedTable {
    private final Table table;
    private final Seq<Expression> groupKey;

    public Table table() {
        return this.table;
    }

    public Seq<Expression> groupKey() {
        return this.groupKey;
    }

    public Table select(Seq<Expression> fields) {
        Seq<Expression> expandedFields = ProjectionTranslator$.MODULE$.expandProjectList(fields, this.table().logicalPlan(), this.table().tableEnv());
        Tuple2<Map<Expression, String>, Map<Expression, String>> tuple2 = ProjectionTranslator$.MODULE$.extractAggregationsAndProperties(expandedFields, this.table().tableEnv());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map aggNames = (Map)tuple2._1();
        Map propNames = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)aggNames, (Object)propNames);
        Tuple2 tuple23 = tuple22;
        Map aggNames2 = (Map)tuple23._1();
        Map propNames2 = (Map)tuple23._2();
        if (propNames2.nonEmpty()) {
            throw new ValidationException("Window properties can only be used on windowed tables.");
        }
        Seq<NamedExpression> projectsOnAgg = ProjectionTranslator$.MODULE$.replaceAggregationsAndProperties(expandedFields, this.table().tableEnv(), (Map<Expression, String>)aggNames2, (Map<Expression, String>)propNames2);
        Seq<NamedExpression> projectFields = ProjectionTranslator$.MODULE$.extractFieldReferences((Seq<Expression>)((Seq)expandedFields.$plus$plus(this.groupKey(), Seq$.MODULE$.canBuildFrom())));
        return new Table(this.table().tableEnv(), new Project(projectsOnAgg, new Aggregate(this.groupKey(), (Seq<NamedExpression>)((TraversableOnce)aggNames2.map((Function1 & Serializable & scala.Serializable)a -> new Alias((Expression)a._1(), (String)a._2(), Alias$.MODULE$.apply$default$3()), Iterable$.MODULE$.canBuildFrom())).toSeq(), new Project(projectFields, this.table().logicalPlan(), Project$.MODULE$.apply$default$3()).validate(this.table().tableEnv())).validate(this.table().tableEnv()), Project$.MODULE$.apply$default$3()).validate(this.table().tableEnv()));
    }

    public Table select(String fields) {
        List<Expression> fieldExprs = ExpressionParser$.MODULE$.parseExpressionList(fields);
        List withResolvedAggFunctionCall = (List)fieldExprs.map((Function1 & Serializable & scala.Serializable)x$8 -> ProjectionTranslator$.MODULE$.replaceAggFunctionCall((Expression)x$8, this.table().tableEnv()), List$.MODULE$.canBuildFrom());
        return this.select((Seq<Expression>)withResolvedAggFunctionCall);
    }

    public GroupedTable(Table table, Seq<Expression> groupKey) {
        this.table = table;
        this.groupKey = groupKey;
    }
}

