/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.org.pentaho.aggdes.util;

import java.math.BigInteger;
import java.util.BitSet;
import java.util.List;

public class BitSetPlus
extends BitSet {
    private final int bitCount;
    private static BigInteger[] twoPowers = new BigInteger[]{BigInteger.ONE, BigInteger.valueOf(2L), BigInteger.valueOf(4L), BigInteger.valueOf(8L)};

    public BitSetPlus() {
        this(0);
    }

    public BitSetPlus(int bitCount) {
        super(bitCount);
        this.bitCount = bitCount;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public BigInteger supersetCardinality() {
        int oneCount = this.cardinality();
        int zeroCount = this.bitCount - oneCount;
        return BitSetPlus.getTwoPower(zeroCount);
    }

    public BigInteger countSupersetDiff(List<BitSetPlus> minusBitSets) {
        for (int i = 0; i < minusBitSets.size(); ++i) {
            BitSetPlus minusBitSet = minusBitSets.get(i);
            if (!this.contains(minusBitSet)) continue;
            return BigInteger.ZERO;
        }
        BitSetPlus[] bitSets = minusBitSets.toArray(new BitSetPlus[minusBitSets.size()]);
        BigInteger res = this.supersetCardinality();
        System.out.println("arity=0, total=" + res);
        boolean neg = true;
        for (int arity = 1; arity <= bitSets.length; ++arity) {
            BigInteger count = new Work(this, arity + 1, bitSets).doIt();
            res = neg ? res.subtract(count) : res.add(count);
            System.out.println("arity=" + arity + ", count=" + (neg ? "-" : "") + count + ", total=" + res);
            neg = !neg;
        }
        return res;
    }

    public boolean contains(BitSet bitSet) {
        if (bitSet.isEmpty()) {
            return true;
        }
        if (!this.intersects(bitSet)) {
            return false;
        }
        int nextSetBit = bitSet.nextSetBit(0);
        while (nextSetBit >= 0) {
            if (!this.get(nextSetBit)) {
                return false;
            }
            nextSetBit = bitSet.nextSetBit(nextSetBit + 1);
        }
        return true;
    }

    public static BigInteger countSupersetIntersection_old(int bitCount, BitSetPlus[] bitSets) {
        int x = 0;
        block0: for (int i = 0; i < bitCount; ++i) {
            for (BitSetPlus bitSet : bitSets) {
                if (bitSet.get(i)) continue block0;
            }
            ++x;
        }
        return BitSetPlus.getTwoPower(x);
    }

    public static BigInteger countSupersetIntersection(int bitCount, BitSetPlus[] bitSets) {
        if (bitSets.length == 0) {
            return BitSetPlus.getTwoPower(bitCount);
        }
        BitSetPlus total = (BitSetPlus)bitSets[0].clone();
        int nextClearBit = 0;
        for (int i = 1; i < bitSets.length; ++i) {
            BitSetPlus set = bitSets[i];
            total.or(set);
            nextClearBit = total.nextClearBit(nextClearBit);
            if (nextClearBit < 0) break;
        }
        int oneCount = total.cardinality();
        int zeroCount = bitCount - oneCount;
        return BitSetPlus.getTwoPower(zeroCount);
    }

    private static synchronized BigInteger getTwoPower(int x) {
        if (x >= twoPowers.length) {
            System.out.println("getTwoPower: x=" + x + ", length=" + twoPowers.length);
            BigInteger[] olds = twoPowers;
            BigInteger[] news = new BigInteger[Math.max(olds.length * 2 + 1, x + 1)];
            System.arraycopy(olds, 0, news, 0, olds.length);
            BigInteger power = olds[olds.length - 1];
            for (int i = olds.length; i < news.length; ++i) {
                news[i] = power = power.add(power);
            }
            twoPowers = news;
        }
        return twoPowers[x];
    }

    private static class Work {
        private final BitSetPlus bitSet;
        private final int bitCount;
        private final int arity;
        private final BitSetPlus[] bitSets;
        private final BitSetPlus[] bitSetTuples;
        private BigInteger res;

        Work(BitSetPlus bitSet, int arity, BitSetPlus[] bitSets) {
            this.bitSet = bitSet;
            this.bitCount = bitSet.bitCount;
            this.arity = arity;
            this.bitSets = bitSets;
            this.bitSetTuples = new BitSetPlus[arity];
            this.res = BigInteger.ZERO;
        }

        BigInteger doIt() {
            this.bitSetTuples[0] = this.bitSet;
            this.doIt(1, 0);
            return this.res;
        }

        private void doIt(int i, int start) {
            if (i == this.arity) {
                BigInteger count = BitSetPlus.countSupersetIntersection(this.bitCount, this.bitSetTuples);
                this.res = this.res.add(count);
            } else {
                for (int j = start; j < this.bitSets.length; ++j) {
                    this.bitSetTuples[i] = this.bitSets[j];
                    this.doIt(i + 1, j + 1);
                }
            }
        }
    }
}

