/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.com.esri.core.geometry;

import org.apache.flink.calcite.shaded.com.esri.core.geometry.Geometry;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.GeometryCursor;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.OperatorDifferenceLocal;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.ProgressTracker;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.SpatialReference;

class OperatorDifferenceCursor
extends GeometryCursor {
    GeometryCursor m_inputGeoms;
    ProgressTracker m_progress_tracker;
    SpatialReference m_Spatial_reference;
    Geometry m_geomSubtractor;
    int m_index;
    boolean m_bEmpty;

    OperatorDifferenceCursor(GeometryCursor inputGeoms, GeometryCursor geomSubtractor, SpatialReference sr, ProgressTracker progress_tracker) {
        this.m_bEmpty = geomSubtractor == null;
        this.m_index = -1;
        this.m_inputGeoms = inputGeoms;
        this.m_Spatial_reference = sr;
        this.m_geomSubtractor = geomSubtractor.next();
        this.m_progress_tracker = progress_tracker;
    }

    @Override
    public Geometry next() {
        if (this.m_bEmpty) {
            return null;
        }
        Geometry geom = this.m_inputGeoms.next();
        if (geom != null) {
            this.m_index = this.m_inputGeoms.getGeometryID();
            return OperatorDifferenceLocal.difference(geom, this.m_geomSubtractor, this.m_Spatial_reference, this.m_progress_tracker);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }
}

