/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.com.esri.core.geometry;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Line;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.VertexDescription;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.VertexDescriptionDesignerImpl;

public class LnSrlzr
implements Serializable {
    private static final long serialVersionUID = 1L;
    double[] attribs;
    int descriptionBitMask;

    public Object readResolve() throws ObjectStreamException {
        Line ln = null;
        if (this.descriptionBitMask == -1) {
            return null;
        }
        try {
            VertexDescription vd = VertexDescriptionDesignerImpl.getVertexDescription(this.descriptionBitMask);
            ln = new Line(vd);
            if (this.attribs != null) {
                ln.setStartXY(this.attribs[0], this.attribs[1]);
                ln.setEndXY(this.attribs[2], this.attribs[3]);
                int index = 4;
                int n = vd.getAttributeCount();
                for (int i = 1; i < n; ++i) {
                    int semantics = vd.getSemantics(i);
                    int comps = VertexDescription.getComponentCount(semantics);
                    for (int ord = 0; ord < comps; ++ord) {
                        ln.setStartAttribute(semantics, ord, this.attribs[index++]);
                        ln.setEndAttribute(semantics, ord, this.attribs[index++]);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectException("Cannot read geometry from stream");
        }
        return ln;
    }

    public void setGeometryByValue(Line ln) throws ObjectStreamException {
        try {
            this.attribs = null;
            if (ln == null) {
                this.descriptionBitMask = -1;
            }
            VertexDescription vd = ln.getDescription();
            this.descriptionBitMask = vd.m_semanticsBitArray;
            this.attribs = new double[vd.getTotalComponentCount() * 2];
            this.attribs[0] = ln.getStartX();
            this.attribs[1] = ln.getStartY();
            this.attribs[2] = ln.getEndX();
            this.attribs[3] = ln.getEndY();
            int index = 4;
            int n = vd.getAttributeCount();
            for (int i = 1; i < n; ++i) {
                int semantics = vd.getSemantics(i);
                int comps = VertexDescription.getComponentCount(semantics);
                for (int ord = 0; ord < comps; ++ord) {
                    this.attribs[index++] = ln.getStartAttributeAsDbl(semantics, ord);
                    this.attribs[index++] = ln.getEndAttributeAsDbl(semantics, ord);
                }
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectException("Cannot serialize this geometry");
        }
    }
}

