/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.ExternalCatalog;
import org.apache.flink.table.catalog.ExternalCatalogTable$;
import org.apache.flink.table.catalog.ExternalCatalogTableBuilder;
import org.apache.flink.table.catalog.InMemoryExternalCatalog;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.Csv;
import org.apache.flink.table.descriptors.Csv$;
import org.apache.flink.table.descriptors.FileSystem;
import org.apache.flink.table.descriptors.FileSystem$;
import org.apache.flink.table.descriptors.FormatDescriptor;
import org.apache.flink.table.descriptors.Schema;
import org.apache.flink.table.descriptors.Schema$;
import org.apache.flink.table.runtime.utils.CommonTestData;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.CsvTableSource;
import org.apache.flink.table.sources.CsvTableSource$;
import org.apache.flink.table.sources.TableSource;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;

public final class CommonTestData$ {
    public static CommonTestData$ MODULE$;

    static {
        new CommonTestData$();
    }

    public CsvTableSource getCsvTableSource() {
        String tempFilePath;
        Seq csvRecords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"First#Id#Score#Last", "Mike#1#12.3#Smith", "Bob#2#45.6#Taylor", "Sam#3#7.89#Miller", "Peter#4#0.12#Smith", "% Just a comment", "Liz#5#34.5#Williams", "Sally#6#6.78#Miller", "Alice#7#90.1#Smith", "Kelly#8#2.34#Williams"}));
        String x$1 = tempFilePath = this.writeToTempFile(csvRecords.mkString("$"), "csv-test", "tmp", this.writeToTempFile$default$4());
        String[] x$2 = (String[])((Object[])new String[]{"first", "id", "score", "last"});
        TypeInformation[] x$3 = (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING, Types.INT, Types.DOUBLE, Types.STRING});
        String x$4 = "#";
        String x$5 = "$";
        boolean x$6 = true;
        String x$7 = "%";
        Character x$8 = CsvTableSource$.MODULE$.$lessinit$greater$default$6();
        boolean x$9 = CsvTableSource$.MODULE$.$lessinit$greater$default$9();
        return new CsvTableSource(x$1, x$2, x$3, x$4, x$5, x$8, x$6, x$7, x$9);
    }

    public ExternalCatalog getInMemoryTestCatalog(boolean isStreaming) {
        Seq csvRecord1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1#1#Hi", "2#2#Hello", "3#2#Hello world"}));
        String tempFilePath1 = this.writeToTempFile(csvRecord1.mkString("\n"), "csv-test1", "tmp", this.writeToTempFile$default$4());
        FileSystem connDesc1 = FileSystem$.MODULE$.apply().path(tempFilePath1);
        Csv formatDesc1 = Csv$.MODULE$.apply().field("a", Types.INT).field("b", Types.LONG).field("c", Types.STRING).fieldDelimiter("#");
        Schema schemaDesc1 = Schema$.MODULE$.apply().field("a", Types.INT).field("b", Types.LONG).field("c", Types.STRING);
        ExternalCatalogTableBuilder externalTableBuilder1 = ExternalCatalogTable$.MODULE$.builder((ConnectorDescriptor)connDesc1).withFormat((FormatDescriptor)formatDesc1).withSchema(schemaDesc1);
        Object object = isStreaming ? externalTableBuilder1.inAppendMode() : BoxedUnit.UNIT;
        Seq csvRecord2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1#1#0#Hallo#1", "2#2#1#Hallo Welt#2", "2#3#2#Hallo Welt wie#1", "3#4#3#Hallo Welt wie gehts?#2", "3#5#4#ABC#2", "3#6#5#BCD#3", "4#7#6#CDE#2", "4#8#7#DEF#1", "4#9#8#EFG#1", "4#10#9#FGH#2", "5#11#10#GHI#1", "5#12#11#HIJ#3", "5#13#12#IJK#3", "5#14#13#JKL#2", "5#15#14#KLM#2"}));
        String tempFilePath2 = this.writeToTempFile(csvRecord2.mkString("\n"), "csv-test2", "tmp", this.writeToTempFile$default$4());
        FileSystem connDesc2 = FileSystem$.MODULE$.apply().path(tempFilePath2);
        Csv formatDesc2 = Csv$.MODULE$.apply().field("d", Types.INT).field("e", Types.LONG).field("f", Types.INT).field("g", Types.STRING).field("h", Types.LONG).fieldDelimiter("#");
        Schema schemaDesc2 = Schema$.MODULE$.apply().field("d", Types.INT).field("e", Types.LONG).field("f", Types.INT).field("g", Types.STRING).field("h", Types.LONG);
        ExternalCatalogTableBuilder externalTableBuilder2 = ExternalCatalogTable$.MODULE$.builder((ConnectorDescriptor)connDesc2).withFormat((FormatDescriptor)formatDesc2).withSchema(schemaDesc2);
        Object object2 = isStreaming ? externalTableBuilder2.inAppendMode() : BoxedUnit.UNIT;
        String tempFilePath3 = this.writeToTempFile("", "csv-test3", "tmp", this.writeToTempFile$default$4());
        FileSystem connDesc3 = FileSystem$.MODULE$.apply().path(tempFilePath3);
        Csv formatDesc3 = Csv$.MODULE$.apply().field("x", Types.INT).field("y", Types.LONG).field("z", Types.STRING).fieldDelimiter("#");
        Schema schemaDesc3 = Schema$.MODULE$.apply().field("x", Types.INT).field("y", Types.LONG).field("z", Types.STRING);
        ExternalCatalogTableBuilder externalTableBuilder3 = ExternalCatalogTable$.MODULE$.builder((ConnectorDescriptor)connDesc3).withFormat((FormatDescriptor)formatDesc3).withSchema(schemaDesc3);
        Object object3 = isStreaming ? externalTableBuilder3.inAppendMode() : BoxedUnit.UNIT;
        InMemoryExternalCatalog catalog = new InMemoryExternalCatalog("test");
        InMemoryExternalCatalog db1 = new InMemoryExternalCatalog("db1");
        InMemoryExternalCatalog db2 = new InMemoryExternalCatalog("db2");
        InMemoryExternalCatalog db3 = new InMemoryExternalCatalog("db3");
        catalog.createSubCatalog("db1", (ExternalCatalog)db1, false);
        catalog.createSubCatalog("db2", (ExternalCatalog)db2, false);
        catalog.createSubCatalog("db3", (ExternalCatalog)db3, false);
        catalog.createTable("tb1", externalTableBuilder1.asTableSource(), false);
        catalog.createTable("tb3", externalTableBuilder3.asTableSink(), false);
        db1.createTable("tb1", externalTableBuilder1.asTableSource(), false);
        db2.createTable("tb2", externalTableBuilder2.asTableSource(), false);
        db3.createTable("tb3", externalTableBuilder3.asTableSink(), false);
        return catalog;
    }

    private String writeToTempFile(String contents, String filePrefix, String fileSuffix, String charset) {
        File tempFile = File.createTempFile(filePrefix, fileSuffix);
        tempFile.deleteOnExit();
        OutputStreamWriter tmpWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), charset);
        tmpWriter.write(contents);
        tmpWriter.close();
        return tempFile.getAbsolutePath();
    }

    private String writeToTempFile$default$4() {
        return "UTF-8";
    }

    public BatchTableSource<CommonTestData.Person> getNestedTableSource() {
        return new BatchTableSource<CommonTestData.Person>(){

            public String explainSource() {
                return TableSource.explainSource$((TableSource)this);
            }

            public DataSet<CommonTestData.Person> getDataSet(ExecutionEnvironment execEnv) {
                ExecutionEnvironment executionEnvironment = ExecutionEnvironment.getExecutionEnvironment();
                return executionEnvironment.fromCollection(Arrays.asList((Object[])new CommonTestData.Person[]{new CommonTestData.Person("Mike", "Smith", new CommonTestData.Address("5th Ave", "New-York")), new CommonTestData.Person("Sally", "Miller", new CommonTestData.Address("Potsdamer Platz", "Berlin")), new CommonTestData.Person("Bob", "Taylor", new CommonTestData.Address("Pearse Street", "Dublin"))}), this.getReturnType());
            }

            public TypeInformation<CommonTestData.Person> getReturnType() {
                return TypeExtractor.getForClass(CommonTestData.Person.class);
            }

            public TableSchema getTableSchema() {
                return TableSchema.fromTypeInfo(this.getReturnType());
            }
            {
                TableSource.$init$((TableSource)this);
            }
        };
    }

    private CommonTestData$() {
        MODULE$ = this;
    }
}

