/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.Window;
import org.apache.flink.table.api.scala.StreamTableEnvironment;
import org.apache.flink.table.api.scala.Tumble$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.runtime.stream.table.TableSourceITCase$;
import org.apache.flink.table.runtime.utils.CommonTestData$;
import org.apache.flink.table.runtime.utils.StreamITCase;
import org.apache.flink.table.runtime.utils.StreamITCase$;
import org.apache.flink.table.sources.CsvTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.utils.TestFilterableTableSource$;
import org.apache.flink.table.utils.TestNestedProjectableTableSource;
import org.apache.flink.table.utils.TestNestedProjectableTableSource$;
import org.apache.flink.table.utils.TestPreserveWMTableSource;
import org.apache.flink.table.utils.TestProjectableTableSource;
import org.apache.flink.table.utils.TestProjectableTableSource$;
import org.apache.flink.table.utils.TestTableSourceWithTime;
import org.apache.flink.table.utils.TestTableSourceWithTime$;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001!\t\tB+\u00192mKN{WO]2f\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011!\u0002;bE2,'BA\u0003\u0007\u0003\u0019\u0019HO]3b[*\u0011q\u0001C\u0001\beVtG/[7f\u0015\t\u0019\u0011B\u0003\u0002\u000b\u0017\u0005)a\r\\5oW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I9R\"A\n\u000b\u0005Q)\u0012\u0001B;uS2T!AF\u0005\u0002\tQ,7\u000f^\u0005\u00031M\u0011\u0001#\u00112tiJ\f7\r\u001e+fgR\u0014\u0015m]3\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005\u0011\u0001\"B\u0010\u0001\t\u0003\u0001\u0013!\u0007;fgRLeN^1mS\u0012$\u0015\r^1tiJ,\u0017-\u001c+za\u0016$\u0012!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0005+:LG\u000f\u000b\u0003\u001fQ9z\u0003CA\u0015-\u001b\u0005Q#BA\u0016\u000e\u0003\u0015QWO\\5u\u0013\ti#F\u0001\u0003UKN$\u0018\u0001C3ya\u0016\u001cG/\u001a3$\u0003A\u0002\"!\r\u001b\u000e\u0003IR!a\r\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u00026e\tqA+\u00192mK\u0016C8-\u001a9uS>t\u0007\"B\u001c\u0001\t\u0003\u0001\u0013A\u0005;fgR\u001c5O\u001e+bE2,7k\\;sG\u0016D#A\u000e\u0015\t\u000bi\u0002A\u0011\u0001\u0011\u0002AQ,7\u000f^\"tmR\u000b'\r\\3T_V\u00148-Z,ji\"4\u0015\u000e\u001c;fe\u0006\u0014G.\u001a\u0015\u0003s!BQ!\u0010\u0001\u0005\u0002\u0001\n\u0011\u0004^3tiJ{w\u000f^5nKJ{w\u000fV1cY\u0016\u001cv.\u001e:dK\"\u0012A\b\u000b\u0005\u0006\u0001\u0002!\t\u0001I\u0001\u001bi\u0016\u001cH\u000f\u0015:pGRLW.\u001a*poR\u000b'\r\\3T_V\u00148-\u001a\u0015\u0003\u007f!BQa\u0011\u0001\u0005\u0002\u0001\n\u0011\u0005^3tiJ{w\u000f^5nKB\u0013xn\u0019;j[\u0016\u0014vn\u001e+bE2,7k\\;sG\u0016D#A\u0011\u0015\t\u000b\u0019\u0003A\u0011\u0001\u0011\u0002IQ,7\u000f\u001e*poRLW.Z!t)&lWm\u001d;b[B\u0014vn\u001e+bE2,7k\\;sG\u0016D#!\u0012\u0015\t\u000b%\u0003A\u0011\u0001\u0011\u00025Q,7\u000f\u001e*poRLW.\u001a'p]\u001e$\u0016M\u00197f'>,(oY3)\u0005!C\u0003\"\u0002'\u0001\t\u0003\u0001\u0013\u0001\b;fgR\u0014vn\u001e;j[\u0016\u001cFO]5oOR\u000b'\r\\3T_V\u00148-\u001a\u0015\u0003\u0017\"BQa\u0014\u0001\u0005\u0002\u0001\nQ\u0004^3tiB\u0013xn\u0019;j[\u0016\u001cFO]5oOR\u000b'\r\\3T_V\u00148-\u001a\u0015\u0003\u001d\"BQA\u0015\u0001\u0005\u0002\u0001\n!\u0005^3tiJ{w\u000f^5nKB\u0013xn\u0019;j[\u0016duN\\4UC\ndWmU8ve\u000e,\u0007FA))\u0011\u0015)\u0006\u0001\"\u0001!\u0003m!Xm\u001d;GS\u0016dG-T1qa&tw\rV1cY\u0016\u001cv.\u001e:dK\"\u0012A\u000b\u000b\u0005\u00061\u0002!\t\u0001I\u0001\"i\u0016\u001cH\u000f\u0015:pU\u0016\u001cGoV5uQ>,HOU8xi&lW\r\u0015:pGRLW.\u001a\u0015\u0003/\"BQa\u0017\u0001\u0005\u0002\u0001\n!\u0004^3tiB\u0013xN[3di^KG\u000f[8viB\u0013xn\u0019;j[\u0016D#A\u0017\u0015\t\u000by\u0003A\u0011\u0001\u0011\u00023Q,7\u000f\u001e)s_*,7\r^,ji\"|W\u000f\u001e*poRLW.\u001a\u0015\u0003;\"BQ!\u0019\u0001\u0005\u0002\u0001\nq\u0003^3tiB\u0013xN[3di>sG.\u001f)s_\u000e$\u0018.\\3\t\u000b\r\u0004A\u0011\u0001\u0011\u0002-Q,7\u000f\u001e)s_*,7\r^(oYf\u0014vn\u001e;j[\u0016DQ!\u001a\u0001\u0005\u0002\u0001\na\u0003^3tiB\u0013xN[3di^KG\u000f['baBLgn\u001a\u0015\u0003I\"BQ\u0001\u001b\u0001\u0005\u0002\u0001\n\u0011\u0003^3ti:+7\u000f^3e!J|'.Z2uQ\t9\u0007\u0006C\u0003l\u0001\u0011\u0005\u0001%\u0001\u0015uKN$(k\\<uS6,G+\u00192mKN{WO]2f!J,7/\u001a:wK^\u000bG/\u001a:nCJ\\7\u000f\u000b\u0002kQ\u0001")
public class TableSourceITCase
extends AbstractTestBase {
    @Test(expected=TableException.class)
    public void testInvalidDatastreamType() {
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamTableSource<Row> tableSource = new StreamTableSource<Row>(null){
            private final String[] fieldNames;
            private final TypeInformation<?>[] fieldTypes;

            public String explainSource() {
                return TableSource.explainSource$((TableSource)this);
            }

            private String[] fieldNames() {
                return this.fieldNames;
            }

            private TypeInformation<?>[] fieldTypes() {
                return this.fieldTypes;
            }

            public DataStream<Row> getDataStream(StreamExecutionEnvironment execEnv) {
                java.util.List data = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Row.of((Object[])new Object[]{"Mary", new Long(1L), new Integer(1)}), (List)Nil$.MODULE$)).asJava();
                return execEnv.fromCollection((Collection)data, (TypeInformation)new GenericTypeInfo(Row.class));
            }

            public TypeInformation<Row> getReturnType() {
                return new RowTypeInfo(this.fieldTypes(), this.fieldNames());
            }

            public TableSchema getTableSchema() {
                return new TableSchema(this.fieldNames(), this.fieldTypes());
            }
            {
                TableSource.$init$((TableSource)this);
                this.fieldNames = (String[])((Object[])new String[]{"name", "id", "value"});
                this.fieldTypes = (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT()});
            }
        };
        tEnv.registerTableSource("T", (TableSource)tableSource);
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "value")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name"))}))).addSink(new StreamITCase.StringSink());
        env.execute();
    }

    @Test
    public void testCsvTableSource() {
        CsvTableSource csvTable = CommonTestData$.MODULE$.getCsvTableSource();
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        tEnv.registerTableSource("csvTable", (TableSource)csvTable);
        org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"csvTable"})).where((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).$greater(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(4))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "last")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "score")).$times(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(2))}))).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Williams,69.0", "Miller,13.56", "Smith,180.2", "Williams,4.68"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCsvTableSourceWithFilterable() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        String tableName = "MyTable";
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        tEnv.registerTableSource(tableName, (TableSource)TestFilterableTableSource$.MODULE$.apply());
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).where("amount > 4 && price < 9").select("id, name")).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"5,Record_5", "6,Record_6", "7,Record_7", "8,Record_8"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowtimeRowTableSource() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        String tableName = "MyTable";
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"Mary", new Long(1L), new Integer(10)}), Row.of((Object[])new Object[]{"Bob", new Long(2L), new Integer(20)}), Row.of((Object[])new Object[]{"Mary", new Long(2L), new Integer(30)}), Row.of((Object[])new Object[]{"Liz", new Long(2001L), new Integer(40)})}));
        String[] fieldNames = (String[])((Object[])new String[]{"name", "rtime", "amount"});
        TableSchema schema = new TableSchema(fieldNames, (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.INT()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT()}), fieldNames);
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, rowType, data, "rtime", null, TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).window((Window)Tumble$.MODULE$.over(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).second()).on(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))).as(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start(), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")).sum()}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1970-01-01 00:00:00.0,40", "Bob,1970-01-01 00:00:00.0,20", "Liz,1970-01-01 00:00:02.0,40"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProctimeRowTableSource() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        String tableName = "MyTable";
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"Mary", new Long(1L), new Integer(10)}), Row.of((Object[])new Object[]{"Bob", new Long(2L), new Integer(20)}), Row.of((Object[])new Object[]{"Mary", new Long(2L), new Integer(30)}), Row.of((Object[])new Object[]{"Liz", new Long(2001L), new Integer(40)})}));
        String[] fieldNames = (String[])((Object[])new String[]{"name", "rtime", "amount"});
        TableSchema schema = new TableSchema((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).$colon$plus((Object)"ptime", ClassTag$.MODULE$.apply(String.class)), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT()}), fieldNames);
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, rowType, data, null, "ptime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).where((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime")).cast(Types$.MODULE$.LONG())).$greater(org.apache.flink.table.api.scala.package$.MODULE$.long2Literal(0L))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount"))}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,10", "Bob,20", "Mary,30", "Liz,40"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowtimeProctimeRowTableSource() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        String tableName = "MyTable";
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"Mary", new Long(1L), new Integer(10)}), Row.of((Object[])new Object[]{"Bob", new Long(2L), new Integer(20)}), Row.of((Object[])new Object[]{"Mary", new Long(2L), new Integer(30)}), Row.of((Object[])new Object[]{"Liz", new Long(2001L), new Integer(40)})}));
        String[] fieldNames = (String[])((Object[])new String[]{"name", "rtime", "amount"});
        TableSchema schema = new TableSchema((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).$colon$plus((Object)"ptime", ClassTag$.MODULE$.apply(String.class)), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT()}), fieldNames);
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, rowType, data, "rtime", "ptime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).window((Window)Tumble$.MODULE$.over(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).second()).on(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))).as(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start(), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")).sum()}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1970-01-01 00:00:00.0,40", "Bob,1970-01-01 00:00:00.0,20", "Liz,1970-01-01 00:00:02.0,40"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowtimeAsTimestampRowTableSource() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        String tableName = "MyTable";
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"Mary", SqlFunctions.internalToTimestamp((long)1L), new Integer(10)}), Row.of((Object[])new Object[]{"Bob", SqlFunctions.internalToTimestamp((long)2L), new Integer(20)}), Row.of((Object[])new Object[]{"Mary", SqlFunctions.internalToTimestamp((long)2L), new Integer(30)}), Row.of((Object[])new Object[]{"Liz", SqlFunctions.internalToTimestamp((long)2001L), new Integer(40)})}));
        String[] fieldNames = (String[])((Object[])new String[]{"name", "rtime", "amount"});
        TableSchema schema = new TableSchema(fieldNames, (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.INT()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.INT()}), fieldNames);
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, rowType, data, "rtime", null, TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).window((Window)Tumble$.MODULE$.over(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).second()).on(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))).as(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start(), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")).sum()}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1970-01-01 00:00:00.0,40", "Bob,1970-01-01 00:00:00.0,20", "Liz,1970-01-01 00:00:02.0,40"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowtimeLongTableSource() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        String tableName = "MyTable";
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{new Long(1L), new Long(2L), new Long(2L), new Long(2001L), new Long(4001L)}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"rtime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.SQL_TIMESTAMP()}));
        TypeInformation returnType = Types$.MODULE$.LONG();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, returnType, data, "rtime", null, TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).window((Window)Tumble$.MODULE$.over(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).second()).on(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))).as(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start(), org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).count()}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.0,3", "1970-01-01 00:00:02.0,1", "1970-01-01 00:00:04.0,1"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowtimeStringTableSource() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        String tableName = "MyTable";
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00", "1970-01-01 00:00:01", "1970-01-01 00:00:01", "1970-01-01 00:00:02", "1970-01-01 00:00:04"}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"rtime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.SQL_TIMESTAMP()}));
        TypeInformation returnType = Types$.MODULE$.STRING();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, returnType, data, "rtime", null, TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).window((Window)Tumble$.MODULE$.over(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).second()).on(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))).as(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start(), org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).count()}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.0,1", "1970-01-01 00:00:01.0,2", "1970-01-01 00:00:02.0,1", "1970-01-01 00:00:04.0,1"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProctimeStringTableSource() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        String tableName = "MyTable";
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary", "Peter", "Bob", "Liz"}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"name", "ptime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP()}));
        TypeInformation returnType = Types$.MODULE$.STRING();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, returnType, data, null, "ptime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).where((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime")).cast(Types$.MODULE$.LONG())).$greater(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name"))}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary", "Peter", "Bob", "Liz"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowtimeProctimeLongTableSource() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        String tableName = "MyTable";
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{new Long(1L), new Long(2L), new Long(2L), new Long(2001L), new Long(4001L)}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"rtime", "ptime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.SQL_TIMESTAMP()}));
        TypeInformation returnType = Types$.MODULE$.LONG();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, returnType, data, "rtime", "ptime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).where((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime")).cast(Types$.MODULE$.LONG())).$greater(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1))).window((Window)Tumble$.MODULE$.over(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).second()).on(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))).as(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start(), org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).count()}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.0,3", "1970-01-01 00:00:02.0,1", "1970-01-01 00:00:04.0,1"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testFieldMappingTableSource() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        String tableName = "MyTable";
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"Mary", new Long(1L), new Integer(10)}), Row.of((Object[])new Object[]{"Bob", new Long(2L), new Integer(20)}), Row.of((Object[])new Object[]{"Mary", new Long(2L), new Integer(30)}), Row.of((Object[])new Object[]{"Liz", new Long(2001L), new Integer(40)})}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"ptime", "amount", "name", "rtime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.INT(), Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP()}));
        RowTypeInfo returnType = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT()});
        Map mapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)"f2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"f0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rtime"), (Object)"f1")}));
        TestTableSourceWithTime source = new TestTableSourceWithTime(schema, returnType, data, "rtime", "ptime", (Map<String, String>)mapping);
        tEnv.registerTableSource(tableName, source);
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).window((Window)Tumble$.MODULE$.over(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).second()).on(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))).as(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start(), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")).sum()}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1970-01-01 00:00:00.0,40", "Bob,1970-01-01 00:00:00.0,20", "Liz,1970-01-01 00:00:02.0,40"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProjectWithoutRowtimeProctime() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), "Mary", new Long(10L), new Long(1L)}), Row.of((Object[])new Object[]{new Integer(2), "Bob", new Long(20L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(3), "Mike", new Long(30L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(4), "Liz", new Long(40L), new Long(2001L)})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        tEnv.registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,10,1", "Bob,20,2", "Mike,30,3", "Liz,40,4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProjectWithoutProctime() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), "Mary", new Long(10L), new Long(1L)}), Row.of((Object[])new Object[]{new Integer(2), "Bob", new Long(20L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(3), "Mike", new Long(30L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(4), "Liz", new Long(40L), new Long(2001L)})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        tEnv.registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.001,Mary,1", "1970-01-01 00:00:00.002,Bob,2", "1970-01-01 00:00:00.002,Mike,3", "1970-01-01 00:00:02.001,Liz,4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProjectWithoutRowtime() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), "Mary", new Long(10L), new Long(1L)}), Row.of((Object[])new Object[]{new Integer(2), "Bob", new Long(20L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(3), "Mike", new Long(30L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(4), "Liz", new Long(40L), new Long(2001L)})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        tEnv.registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).filter((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime")).cast(Types$.MODULE$.LONG())).$greater(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(0))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1", "Bob,2", "Mike,3", "Liz,4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public void testProjectOnlyProctime() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), new Long(1L), new Long(10L), "Mary"}), Row.of((Object[])new Object[]{new Integer(2), new Long(2L), new Long(20L), "Bob"}), Row.of((Object[])new Object[]{new Integer(3), new Long(2L), new Long(30L), "Mike"}), Row.of((Object[])new Object[]{new Integer(4), new Long(2001L), new Long(30L), "Liz"})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        tEnv.registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime")).$greater(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(0))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).count()}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public void testProjectOnlyRowtime() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), new Long(1L), new Long(10L), "Mary"}), Row.of((Object[])new Object[]{new Integer(2), new Long(2L), new Long(20L), "Bob"}), Row.of((Object[])new Object[]{new Integer(3), new Long(2L), new Long(30L), "Mike"}), Row.of((Object[])new Object[]{new Integer(4), new Long(2001L), new Long(30L), "Liz"})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        tEnv.registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.001", "1970-01-01 00:00:00.002", "1970-01-01 00:00:00.002", "1970-01-01 00:00:02.001"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProjectWithMapping() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Long(1L), new Integer(1), "Mary", new Long(10L)}), Row.of((Object[])new Object[]{new Long(2L), new Integer(2), "Bob", new Long(20L)}), Row.of((Object[])new Object[]{new Long(2L), new Integer(3), "Mike", new Long(30L)}), Row.of((Object[])new Object[]{new Long(2001L), new Integer(4), "Liz", new Long(40L)})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.INT(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG()}), (String[])((Object[])new String[]{"p-rtime", "p-id", "p-name", "p-val"}));
        Map mapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rtime"), (Object)"p-rtime"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"p-id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"val"), (Object)"p-val"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"p-name")}));
        tEnv.registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", (Map<String, String>)mapping));
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val"))}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1970-01-01 00:00:00.001,10", "Bob,1970-01-01 00:00:00.002,20", "Mike,1970-01-01 00:00:00.002,30", "Liz,1970-01-01 00:00:02.001,40"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNestedProject() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Long(1L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Sarah", new Integer(100)}), Row.of((Object[])new Object[]{new Integer(1000), new Boolean(true)})}), Row.of((Object[])new Object[]{"Peter", new Integer(10000)}), "Mary"}), Row.of((Object[])new Object[]{new Long(2L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Rob", new Integer(200)}), Row.of((Object[])new Object[]{new Integer(2000), new Boolean(false)})}), Row.of((Object[])new Object[]{"Lucy", new Integer(20000)}), "Bob"}), Row.of((Object[])new Object[]{new Long(3L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Mike", new Integer(300)}), Row.of((Object[])new Object[]{new Integer(3000), new Boolean(true)})}), Row.of((Object[])new Object[]{"Betty", new Integer(30000)}), "Liz"})}));
        RowTypeInfo nested1 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.INT()}), (String[])((Object[])new String[]{"name", "value"}));
        RowTypeInfo nested2 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.BOOLEAN()}), (String[])((Object[])new String[]{"num", "flag"}));
        RowTypeInfo deepNested = new RowTypeInfo((TypeInformation[])new RowTypeInfo[]{nested1, nested2}, (String[])((Object[])new String[]{"nested1", "nested2"}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), deepNested, nested1, Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), deepNested, nested1, Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}));
        tEnv.registerTableSource("T", (TableSource)new TestNestedProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$4(), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$5()));
        org.apache.flink.table.api.scala.package$.MODULE$.table2RowDataStream(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested1")).get("name")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedName"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "nested")).get("value")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedValue"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested2")).get("flag")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedFlag"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested2")).get("num")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedNum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}))).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,Sarah,10000,true,1000", "2,Rob,20000,false,2000", "3,Mike,30000,true,3000"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowtimeTableSourcePreserveWatermarks() {
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        String tableName = "MyTable";
        org.apache.flink.streaming.api.scala.StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)1L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)Row.of((Object[])new Object[]{new Integer(1), new Long(5L), "A"}))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)Row.of((Object[])new Object[]{new Integer(2), new Long(1L), "B"}))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)10L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)8L), (Object)Row.of((Object[])new Object[]{new Integer(6), new Long(8L), "C"}))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)20L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)21L), (Object)Row.of((Object[])new Object[]{new Integer(6), new Long(21L), "D"}))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)30L))}));
        String[] fieldNames = (String[])((Object[])new String[]{"id", "rtime", "name"});
        TableSchema schema = new TableSchema(fieldNames, (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}), fieldNames);
        TestPreserveWMTableSource tableSource = new TestPreserveWMTableSource(schema, rowType, data, "rtime");
        tEnv.registerTableSource(tableName, tableSource);
        org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).where((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime")).cast(Types$.MODULE$.LONG())).$greater(org.apache.flink.table.api.scala.package$.MODULE$.long2Literal(3L))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name"))}))).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).process((ProcessFunction)new ProcessFunction<Row, Tuple2<Row, Object>>(null){

            public void processElement(Row value, ProcessFunction.Context ctx, Collector<Tuple2<Row, Object>> out) {
                out.collect((Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)ctx.timerService().currentWatermark())));
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Row, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Row, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Row, Object>>(this, fieldSerializers){

                    public Tuple2<Row, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((Row)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])));
                    }

                    public CaseClassSerializer<Tuple2<Row, Object>> createSerializerInstance(Class<Tuple2<Row, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.runtime.stream.table.TableSourceITCase$$anon$3 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).addSink(new StreamITCase.StringSink());
        env.execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(1,A,1)", "(6,C,10)", "(6,D,20)"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }
}

