/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.stream.table;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.Window;
import org.apache.flink.table.api.scala.StreamTableEnvironment;
import org.apache.flink.table.api.scala.Tumble$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.runtime.stream.table.RowCollector$;
import org.apache.flink.table.runtime.stream.table.TableSinkITCase$;
import org.apache.flink.table.runtime.stream.table.TestAppendSink;
import org.apache.flink.table.runtime.stream.table.TestRetractSink;
import org.apache.flink.table.runtime.stream.table.TestUpsertSink;
import org.apache.flink.table.runtime.utils.StreamITCase;
import org.apache.flink.table.runtime.utils.StreamITCase$;
import org.apache.flink.table.runtime.utils.StreamTestData$;
import org.apache.flink.table.sinks.CsvTableSink;
import org.apache.flink.table.sinks.CsvTableSink$;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.utils.MemoryTableSourceSinkUtil;
import org.apache.flink.table.utils.MemoryTableSourceSinkUtil$;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001!\tyA+\u00192mKNKgn[%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005)A/\u00192mK*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0007%Q!AC\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u00051i\u0011AB1qC\u000eDWMC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013/5\t1C\u0003\u0002\u0015+\u0005!Q\u000f^5m\u0015\t1\u0012\"\u0001\u0003uKN$\u0018B\u0001\r\u0014\u0005A\t%m\u001d;sC\u000e$H+Z:u\u0005\u0006\u001cX\rC\u0003\u001b\u0001\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u0005!)q\u0004\u0001C\u0001A\u0005\tC/Z:u\u0013:\u001cXM\u001d;J]R|'+Z4jgR,'/\u001a3UC\ndWmU5oWR\t\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0003V]&$\bF\u0001\u0010)!\tIC&D\u0001+\u0015\tYS\"A\u0003kk:LG/\u0003\u0002.U\t!A+Z:u\u0011\u0015y\u0003\u0001\"\u0001!\u0003M!Xm\u001d;TiJ,\u0017-\u001c+bE2,7+\u001b8lQ\tq\u0003\u0006C\u00033\u0001\u0011\u0005\u0001%A\u000euKN$\u0018\t\u001d9f]\u0012\u001c\u0016N\\6P]\u0006\u0003\b/\u001a8e)\u0006\u0014G.\u001a\u0015\u0003c!BQ!\u000e\u0001\u0005\u0002\u0001\nq\u0005^3ti\u0006\u0003\b/\u001a8e'&t7n\u00148BaB,g\u000e\u001a+bE2,gi\u001c:J]:,'OS8j]\"\u0012A\u0007\u000b\u0005\u0006q\u0001!\t\u0001I\u0001\u001fi\u0016\u001cHOU3ue\u0006\u001cGoU5oW>sW\u000b\u001d3bi&tw\rV1cY\u0016D#a\u000e\u0015\t\u000bm\u0002A\u0011\u0001\u0011\u00029Q,7\u000f\u001e*fiJ\f7\r^*j].|e.\u00119qK:$G+\u00192mK\"\u0012!\b\u000b\u0005\u0006}\u0001!\t\u0001I\u0001)i\u0016\u001cH/\u00169tKJ$8+\u001b8l\u001f:,\u0006\u000fZ1uS:<G+\u00192mK^KG\u000f\u001b$vY2\\U-\u001f\u0015\u0003{!BQ!\u0011\u0001\u0005\u0002\u0001\n!\u0006^3tiV\u00038/\u001a:u'&t7n\u00148BaB,g\u000eZ5oOR\u000b'\r\\3XSRDg)\u001e7m\u0017\u0016L\u0018\u0007\u000b\u0002AQ!)A\t\u0001C\u0001A\u0005QC/Z:u+B\u001cXM\u001d;TS:\\wJ\\!qa\u0016tG-\u001b8h)\u0006\u0014G.Z,ji\"4U\u000f\u001c7LKf\u0014\u0004FA\")\u0011\u00159\u0005\u0001\"\u0001!\u00035\"Xm\u001d;VaN,'\u000f^*j].|e.\u00119qK:$\u0017N\\4UC\ndWmV5uQ>,HOR;mY.+\u00170\r\u0015\u0003\r\"BQA\u0013\u0001\u0005\u0002\u0001\nQ\u0006^3tiV\u00038/\u001a:u'&t7n\u00148BaB,g\u000eZ5oOR\u000b'\r\\3XSRDw.\u001e;Gk2d7*Z=3Q\tI\u0005\u0006C\u0003N\u0001\u0011\u0005\u0001%A\ruKN$Hk\\!qa\u0016tGm\u0015;sK\u0006l'k\\<uS6,\u0007F\u0001')\u0011\u0015\u0001\u0006\u0001\"\u0001!\u0003i!Xm\u001d;U_J+GO]1diN#(/Z1n%><H/[7fQ\ty\u0005\u0006C\u0003T\u0001\u0011\u0005\u0001%\u0001\u0010uKN$Hk\\!qa\u0016tGm\u0015;sK\u0006lW*\u001e7uSJ{w\u000f^5nK\"\"!\u000bK+W\u0003!)\u0007\u0010]3di\u0016$7%A,\u0011\u0005a[V\"A-\u000b\u0005iC\u0011aA1qS&\u0011A,\u0017\u0002\u000f)\u0006\u0014G.Z#yG\u0016\u0004H/[8o\u0011\u0015q\u0006\u0001\"\u0001!\u0003}!Xm\u001d;U_J+GO]1diN#(/Z1n\u001bVdG/\u001b*poRLW.\u001a\u0015\u0005;\"*f\u000b")
public class TableSinkITCase
extends AbstractTestBase {
    @Test
    public void testInsertIntoRegisteredTableSink() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        MemoryTableSourceSinkUtil$.MODULE$.clear();
        DataStream input = StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testInsertIntoRegisteredTableSink$1(r)));
        String[] fieldNames = (String[])((Object[])new String[]{"d", "e", "t"});
        TypeInformation[] fieldTypes = (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG()});
        MemoryTableSourceSinkUtil.UnsafeMemoryAppendTableSink sink = new MemoryTableSourceSinkUtil.UnsafeMemoryAppendTableSink();
        tEnv.registerTableSink("targetTable", fieldNames, fieldTypes, (TableSink)sink);
        package$.MODULE$.dataStream2DataStreamConversions(input).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t")).rowtime()})).where((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(3))).$bar$bar((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(19)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).insertInto("targetTable");
        env.execute();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hi,1970-01-01 00:00:00.001,1", "Hello,1970-01-01 00:00:00.002,2", "Comment#14,1970-01-01 00:00:00.006,6", "Comment#15,1970-01-01 00:00:00.006,6"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(MemoryTableSourceSinkUtil$.MODULE$.tableData()).asJava()), (String)expected);
    }

    @Test
    public void testStreamTableSink() {
        File tmpFile = File.createTempFile("flink-table-sink-test", ".tmp");
        tmpFile.deleteOnExit();
        String path = tmpFile.toURI().toString();
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        env.setParallelism(4);
        tEnv.registerTableSink("csvSink", new CsvTableSink(path, CsvTableSink$.MODULE$.$lessinit$greater$default$2()).configure((String[])((Object[])new String[]{"c", "b"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP()})));
        DataStream input = StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testStreamTableSink$1(x$1))).map((Function1 & Serializable & scala.Serializable)x -> x, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.runtime.stream.table.TableSinkITCase$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).setParallelism(4);
        package$.MODULE$.dataStream2DataStreamConversions(input).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).where((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(5))).$bar$bar((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(17)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).insertInto("csvSink");
        env.execute();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hi,1970-01-01 00:00:00.001", "Hello,1970-01-01 00:00:00.002", "Hello world,1970-01-01 00:00:00.002", "Hello world, how are you?,1970-01-01 00:00:00.003", "Comment#12,1970-01-01 00:00:00.006", "Comment#13,1970-01-01 00:00:00.006", "Comment#14,1970-01-01 00:00:00.006", "Comment#15,1970-01-01 00:00:00.006"}))).mkString("\n");
        TestBaseUtils.compareResultsByLinesInMemory((String)expected, (String)path);
    }

    @Test
    public void testAppendSinkOnAppendTable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testAppendSinkOnAppendTable$1(x$2)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        tEnv.registerTableSink("appendSink", new TestAppendSink().configure((String[])((Object[])new String[]{"t", "icnt", "nsum"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG()})));
        t.window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(5).millis()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "t"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "nsum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))})).insertInto("appendSink");
        env.execute();
        List result = (List)((SeqLike)RowCollector$.MODULE$.getAndClearValues().map((Function1 & Serializable & scala.Serializable)x$3 -> ((Row)x$3.f1).toString(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"1970-01-01 00:00:00.005,4,8", (List)new .colon.colon((Object)"1970-01-01 00:00:00.01,5,18", (List)new .colon.colon((Object)"1970-01-01 00:00:00.015,5,24", (List)new .colon.colon((Object)"1970-01-01 00:00:00.02,5,29", (List)new .colon.colon((Object)"1970-01-01 00:00:00.025,2,12", (List)Nil$.MODULE$))))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testAppendSinkOnAppendTableForInnerJoin() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table ds1 = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.getSmall3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get5TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        tEnv.registerTableSink("appendSink", new TestAppendSink().configure((String[])((Object[])new String[]{"c", "g"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.STRING()})));
        ds1.join(ds2).where((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))})).insertInto("appendSink");
        env.execute();
        List result = (List)((SeqLike)RowCollector$.MODULE$.getAndClearValues().map((Function1 & Serializable & scala.Serializable)x$4 -> ((Row)x$4.f1).toString(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"Hi,Hallo", (List)new .colon.colon((Object)"Hello,Hallo Welt", (List)new .colon.colon((Object)"Hello world,Hallo Welt", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testRetractSinkOnUpdatingTable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testRetractSinkOnUpdatingTable$1(x$5)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text"))}));
        tEnv.registerTableSink("retractSink", new TestRetractSink().configure((String[])((Object[])new String[]{"len", "icnt", "nsum"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG()})));
        t.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")).charLength()).as((Symbol)SymbolLiteral.bootstrap("apply", "len"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "nsum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))})).insertInto("retractSink");
        env.execute();
        List<Tuple2<Boolean, Row>> results = RowCollector$.MODULE$.getAndClearValues();
        List retracted = (List)RowCollector$.MODULE$.retractResults(results).sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"2,1,1", (List)new .colon.colon((Object)"5,1,2", (List)new .colon.colon((Object)"11,1,2", (List)new .colon.colon((Object)"25,1,3", (List)new .colon.colon((Object)"10,7,39", (List)new .colon.colon((Object)"14,1,3", (List)new .colon.colon((Object)"9,9,41", (List)Nil$.MODULE$))))))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testRetractSinkOnAppendTable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testRetractSinkOnAppendTable$1(x$6)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        tEnv.registerTableSink("retractSink", new TestRetractSink().configure((String[])((Object[])new String[]{"t", "icnt", "nsum"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG()})));
        t.window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(5).millis()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "t"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "nsum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))})).insertInto("retractSink");
        env.execute();
        List<Tuple2<Boolean, Row>> results = RowCollector$.MODULE$.getAndClearValues();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)results.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TableSinkITCase.$anonfun$testRetractSinkOnAppendTable$2(x$7))));
        List retracted = (List)RowCollector$.MODULE$.retractResults(results).sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"1970-01-01 00:00:00.005,4,8", (List)new .colon.colon((Object)"1970-01-01 00:00:00.01,5,18", (List)new .colon.colon((Object)"1970-01-01 00:00:00.015,5,24", (List)new .colon.colon((Object)"1970-01-01 00:00:00.02,5,29", (List)new .colon.colon((Object)"1970-01-01 00:00:00.025,2,12", (List)Nil$.MODULE$))))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnUpdatingTableWithFullKey() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testUpsertSinkOnUpdatingTableWithFullKey$1(x$8)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text"))}));
        tEnv.registerTableSink("upsertSink", new TestUpsertSink((String[])((Object[])new String[]{"cnt", "cTrue"}), false).configure((String[])((Object[])new String[]{"cnt", "lencnt", "cTrue"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.LONG(), Types$.MODULE$.BOOLEAN()})));
        t.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")).charLength()).as((Symbol)SymbolLiteral.bootstrap("apply", "len"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).$greater(package$.MODULE$.int2Literal(0))).as((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "cnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cnt")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cnt")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "lencnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"))})).insertInto("upsertSink");
        env.execute();
        List<Tuple2<Boolean, Row>> results = RowCollector$.MODULE$.getAndClearValues();
        Assert.assertTrue((String)"Results must include delete messages", (boolean)results.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TableSinkITCase.$anonfun$testUpsertSinkOnUpdatingTableWithFullKey$2(x$9))));
        List retracted = (List)RowCollector$.MODULE$.upsertResults(results, new int[]{0, 2}).sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"1,5,true", (List)new .colon.colon((Object)"7,1,true", (List)new .colon.colon((Object)"9,1,true", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithFullKey1() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithFullKey1$1(x$10)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        tEnv.registerTableSink("upsertSink", new TestUpsertSink((String[])((Object[])new String[]{"wend", "num"}), true).configure((String[])((Object[])new String[]{"num", "wend", "icnt"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG()})));
        t.window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(5).millis()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "wend"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))})).insertInto("upsertSink");
        env.execute();
        List<Tuple2<Boolean, Row>> results = RowCollector$.MODULE$.getAndClearValues();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)results.exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithFullKey1$2(x$11))));
        List retracted = (List)RowCollector$.MODULE$.upsertResults(results, new int[]{0, 1, 2}).sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1970-01-01 00:00:00.005,1", "2,1970-01-01 00:00:00.005,2", "3,1970-01-01 00:00:00.005,1", "3,1970-01-01 00:00:00.01,2", "4,1970-01-01 00:00:00.01,3", "4,1970-01-01 00:00:00.015,1", "5,1970-01-01 00:00:00.015,4", "5,1970-01-01 00:00:00.02,1", "6,1970-01-01 00:00:00.02,4", "6,1970-01-01 00:00:00.025,2"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithFullKey2() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithFullKey2$1(x$12)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        tEnv.registerTableSink("upsertSink", new TestUpsertSink((String[])((Object[])new String[]{"wstart", "wend", "num"}), true).configure((String[])((Object[])new String[]{"wstart", "wend", "num", "icnt"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG()})));
        t.window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(5).millis()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start()).as((Symbol)SymbolLiteral.bootstrap("apply", "wstart"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "wend"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))})).insertInto("upsertSink");
        env.execute();
        List<Tuple2<Boolean, Row>> results = RowCollector$.MODULE$.getAndClearValues();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)results.exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithFullKey2$2(x$13))));
        List retracted = (List)RowCollector$.MODULE$.upsertResults(results, new int[]{0, 1, 2}).sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.0,1970-01-01 00:00:00.005,1,1", "1970-01-01 00:00:00.0,1970-01-01 00:00:00.005,2,2", "1970-01-01 00:00:00.0,1970-01-01 00:00:00.005,3,1", "1970-01-01 00:00:00.005,1970-01-01 00:00:00.01,3,2", "1970-01-01 00:00:00.005,1970-01-01 00:00:00.01,4,3", "1970-01-01 00:00:00.01,1970-01-01 00:00:00.015,4,1", "1970-01-01 00:00:00.01,1970-01-01 00:00:00.015,5,4", "1970-01-01 00:00:00.015,1970-01-01 00:00:00.02,5,1", "1970-01-01 00:00:00.015,1970-01-01 00:00:00.02,6,4", "1970-01-01 00:00:00.02,1970-01-01 00:00:00.025,6,2"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithoutFullKey1() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithoutFullKey1$1(x$14)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        tEnv.registerTableSink("upsertSink", new TestUpsertSink(null, true).configure((String[])((Object[])new String[]{"wend", "cnt"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG()})));
        t.window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(5).millis()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "wend"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "cnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))})).insertInto("upsertSink");
        env.execute();
        List<Tuple2<Boolean, Row>> results = RowCollector$.MODULE$.getAndClearValues();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)results.exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithoutFullKey1$2(x$15))));
        List retracted = (List)((SeqLike)results.map((Function1 & Serializable & scala.Serializable)x$16 -> ((Row)x$16.f1).toString(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.005,1", "1970-01-01 00:00:00.005,2", "1970-01-01 00:00:00.005,1", "1970-01-01 00:00:00.01,2", "1970-01-01 00:00:00.01,3", "1970-01-01 00:00:00.015,1", "1970-01-01 00:00:00.015,4", "1970-01-01 00:00:00.02,1", "1970-01-01 00:00:00.02,4", "1970-01-01 00:00:00.025,2"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithoutFullKey2() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithoutFullKey2$1(x$17)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        tEnv.registerTableSink("upsertSink", new TestUpsertSink(null, true).configure((String[])((Object[])new String[]{"num", "cnt"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.LONG()})));
        t.window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(5).millis()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "cnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))})).insertInto("upsertSink");
        env.execute();
        List<Tuple2<Boolean, Row>> results = RowCollector$.MODULE$.getAndClearValues();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)results.exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)TableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithoutFullKey2$2(x$18))));
        List retracted = (List)((SeqLike)results.map((Function1 & Serializable & scala.Serializable)x$19 -> ((Row)x$19.f1).toString(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1", "2,2", "3,1", "3,2", "4,3", "4,1", "5,4", "5,1", "6,4", "6,2"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testToAppendStreamRowtime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testToAppendStreamRowtime$1(x$20)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        Table r = t.window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(5).milli()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime(), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime()).cast(Types$.MODULE$.LONG())}));
        package$.MODULE$.table2TableConversions(r).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).process((ProcessFunction)new ProcessFunction<Row, Row>(null){

            public void processElement(Row row, ProcessFunction.Context ctx, Collector<Row> out) {
                block0: {
                    long rowTS = BoxesRunTime.unboxToLong((Object)row.getField(2));
                    if (!BoxesRunTime.equalsNumObject((Number)ctx.timestamp(), (Object)BoxesRunTime.boxToLong((long)rowTS))) break block0;
                    out.collect((Object)row);
                }
            }
        }, TypeExtractor.createTypeInfo(Row.class)).addSink(new StreamITCase.StringSink());
        env.execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1970-01-01 00:00:00.004,4", "2,1970-01-01 00:00:00.004,4", "3,1970-01-01 00:00:00.004,4", "3,1970-01-01 00:00:00.009,9", "4,1970-01-01 00:00:00.009,9", "4,1970-01-01 00:00:00.014,14", "5,1970-01-01 00:00:00.014,14", "5,1970-01-01 00:00:00.019,19", "6,1970-01-01 00:00:00.019,19", "6,1970-01-01 00:00:00.024,24"}));
        Assert.assertEquals((Object)expected, (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testToRetractStreamRowtime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testToRetractStreamRowtime$1(x$21)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        Table r = t.window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(5).milli()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime(), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime()).cast(Types$.MODULE$.LONG())}));
        package$.MODULE$.table2TableConversions(r).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).process((ProcessFunction)new ProcessFunction<scala.Tuple2<Object, Row>, Row>(null){

            public void processElement(scala.Tuple2<Object, Row> row, ProcessFunction.Context ctx, Collector<Row> out) {
                block0: {
                    long rowTs = BoxesRunTime.unboxToLong((Object)((Row)row._2()).getField(2));
                    if (!BoxesRunTime.equalsNumObject((Number)ctx.timestamp(), (Object)BoxesRunTime.boxToLong((long)rowTs))) break block0;
                    out.collect(row._2());
                }
            }
        }, TypeExtractor.createTypeInfo(Row.class)).addSink(new StreamITCase.StringSink());
        env.execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1970-01-01 00:00:00.004,4", "2,1970-01-01 00:00:00.004,4", "3,1970-01-01 00:00:00.004,4", "3,1970-01-01 00:00:00.009,9", "4,1970-01-01 00:00:00.009,9", "4,1970-01-01 00:00:00.014,14", "5,1970-01-01 00:00:00.014,14", "5,1970-01-01 00:00:00.019,19", "6,1970-01-01 00:00:00.019,19", "6,1970-01-01 00:00:00.024,24"}));
        Assert.assertEquals((Object)expected, (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test(expected=TableException.class)
    public void testToAppendStreamMultiRowtime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testToAppendStreamMultiRowtime$1(x$22)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        Table r = t.window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(5).milli()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime(), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime()).as((Symbol)SymbolLiteral.bootstrap("apply", "rowtime2"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}));
        package$.MODULE$.table2TableConversions(r).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test(expected=TableException.class)
    public void testToRetractStreamMultiRowtime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToLong((long)TableSinkITCase.$anonfun$testToRetractStreamMultiRowtime$1(x$23)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        Table r = t.window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(5).milli()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime(), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime()).as((Symbol)SymbolLiteral.bootstrap("apply", "rowtime2"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}));
        package$.MODULE$.table2TableConversions(r).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
    }

    public static final /* synthetic */ long $anonfun$testInsertIntoRegisteredTableSink$1(Tuple3 r) {
        return BoxesRunTime.unboxToLong((Object)r._2());
    }

    public static final /* synthetic */ long $anonfun$testStreamTableSink$1(Tuple3 x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1._2());
    }

    public static final /* synthetic */ long $anonfun$testAppendSinkOnAppendTable$1(Tuple3 x$2) {
        return BoxesRunTime.unboxToInt((Object)x$2._1());
    }

    public static final /* synthetic */ long $anonfun$testRetractSinkOnUpdatingTable$1(Tuple3 x$5) {
        return BoxesRunTime.unboxToInt((Object)x$5._1());
    }

    public static final /* synthetic */ long $anonfun$testRetractSinkOnAppendTable$1(Tuple3 x$6) {
        return BoxesRunTime.unboxToInt((Object)x$6._1());
    }

    public static final /* synthetic */ boolean $anonfun$testRetractSinkOnAppendTable$2(Tuple2 x$7) {
        return !Predef$.MODULE$.Boolean2boolean((Boolean)x$7.f0);
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnUpdatingTableWithFullKey$1(Tuple3 x$8) {
        return BoxesRunTime.unboxToInt((Object)x$8._1());
    }

    public static final /* synthetic */ boolean $anonfun$testUpsertSinkOnUpdatingTableWithFullKey$2(Tuple2 x$9) {
        return BoxesRunTime.equals((Object)x$9.f0, (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnAppendingTableWithFullKey1$1(Tuple3 x$10) {
        return BoxesRunTime.unboxToInt((Object)x$10._1());
    }

    public static final /* synthetic */ boolean $anonfun$testUpsertSinkOnAppendingTableWithFullKey1$2(Tuple2 x$11) {
        return !Predef$.MODULE$.Boolean2boolean((Boolean)x$11.f0);
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnAppendingTableWithFullKey2$1(Tuple3 x$12) {
        return BoxesRunTime.unboxToInt((Object)x$12._1());
    }

    public static final /* synthetic */ boolean $anonfun$testUpsertSinkOnAppendingTableWithFullKey2$2(Tuple2 x$13) {
        return !Predef$.MODULE$.Boolean2boolean((Boolean)x$13.f0);
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnAppendingTableWithoutFullKey1$1(Tuple3 x$14) {
        return BoxesRunTime.unboxToInt((Object)x$14._1());
    }

    public static final /* synthetic */ boolean $anonfun$testUpsertSinkOnAppendingTableWithoutFullKey1$2(Tuple2 x$15) {
        return !Predef$.MODULE$.Boolean2boolean((Boolean)x$15.f0);
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnAppendingTableWithoutFullKey2$1(Tuple3 x$17) {
        return BoxesRunTime.unboxToInt((Object)x$17._1());
    }

    public static final /* synthetic */ boolean $anonfun$testUpsertSinkOnAppendingTableWithoutFullKey2$2(Tuple2 x$18) {
        return !Predef$.MODULE$.Boolean2boolean((Boolean)x$18.f0);
    }

    public static final /* synthetic */ long $anonfun$testToAppendStreamRowtime$1(Tuple3 x$20) {
        return BoxesRunTime.unboxToInt((Object)x$20._1());
    }

    public static final /* synthetic */ long $anonfun$testToRetractStreamRowtime$1(Tuple3 x$21) {
        return BoxesRunTime.unboxToInt((Object)x$21._1());
    }

    public static final /* synthetic */ long $anonfun$testToAppendStreamMultiRowtime$1(Tuple3 x$22) {
        return BoxesRunTime.unboxToInt((Object)x$22._1());
    }

    public static final /* synthetic */ long $anonfun$testToRetractStreamMultiRowtime$1(Tuple3 x$23) {
        return BoxesRunTime.unboxToInt((Object)x$23._1());
    }
}

