/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.scala.StreamTableEnvironment;
import org.apache.flink.table.api.scala.map$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.Literal$;
import org.apache.flink.table.expressions.utils.Func13;
import org.apache.flink.table.expressions.utils.RichFunc1;
import org.apache.flink.table.expressions.utils.RichFunc2;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.runtime.stream.table.CalcITCase$;
import org.apache.flink.table.runtime.utils.StreamITCase;
import org.apache.flink.table.runtime.utils.StreamITCase$;
import org.apache.flink.table.runtime.utils.StreamTestData$;
import org.apache.flink.table.runtime.utils.UserDefinedFunctionTestUtils$;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001!\tQ1)\u00197d\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011!\u0002;bE2,'BA\u0003\u0007\u0003\u0019\u0019HO]3b[*\u0011q\u0001C\u0001\beVtG/[7f\u0015\t\u0019\u0011B\u0003\u0002\u000b\u0017\u0005)a\r\\5oW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I9R\"A\n\u000b\u0005Q)\u0012\u0001B;uS2T!AF\u0005\u0002\tQ,7\u000f^\u0005\u00031M\u0011\u0001#\u00112tiJ\f7\r\u001e+fgR\u0014\u0015m]3\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005\u0011\u0001\"B\u0010\u0001\t\u0003\u0001\u0013a\u0005;fgR\u001c\u0016.\u001c9mKN+G.Z2u\u00032dG#A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\tUs\u0017\u000e\u001e\u0015\u0003=!\u0002\"!\u000b\u0017\u000e\u0003)R!aK\u0007\u0002\u000b),h.\u001b;\n\u00055R#\u0001\u0002+fgRDQa\f\u0001\u0005\u0002\u0001\na\u0002^3tiN+G.Z2u'R\f'\u000f\u000b\u0002/Q!)!\u0007\u0001C\u0001A\u0005yA/Z:u'\u0016dWm\u0019;GSJ\u001cH\u000f\u000b\u00022Q!)Q\u0007\u0001C\u0001A\u0005QB/Z:u'&l\u0007\u000f\\3TK2,7\r^,ji\"t\u0015-\\5oO\"\u0012A\u0007\u000b\u0005\u0006q\u0001!\t\u0001I\u0001\u001ai\u0016\u001cHoU5na2,7+\u001a7fGR\fE\u000e\\,ji\"\f5\u000f\u000b\u00028Q!)1\b\u0001C\u0001A\u0005\u0001B/Z:u'&l\u0007\u000f\\3GS2$XM\u001d\u0015\u0003u!BQA\u0010\u0001\u0005\u0002\u0001\na\u0003^3ti\u0006cGNU3kK\u000e$\u0018N\\4GS2$XM\u001d\u0015\u0003{!BQ!\u0011\u0001\u0005\u0002\u0001\nA\u0003^3ti\u0006cG\u000eU1tg&twMR5mi\u0016\u0014\bF\u0001!)\u0011\u0015!\u0005\u0001\"\u0001!\u0003u!Xm\u001d;GS2$XM](o\u0013:$XmZ3s)V\u0004H.\u001a$jK2$\u0007FA\")\u0011\u00159\u0005\u0001\"\u0001!\u00035!Xm\u001d;O_R,\u0015/^1mg\"\u0012a\t\u000b\u0005\u0006\u0015\u0002!\t\u0001I\u0001%i\u0016\u001cH/V:fe\u0012+g-\u001b8fI\u001a+hn\u0019;j_:<\u0016\u000e\u001e5QCJ\fW.\u001a;fe\"\u0012\u0011\n\u000b\u0005\u0006\u001b\u0002!\t\u0001I\u0001!i\u0016\u001cH/T;mi&\u0004H.Z+tKJ$UMZ5oK\u00124UO\\2uS>t7\u000f\u000b\u0002MQ!)\u0001\u000b\u0001C\u0001A\u00059C/Z:u'\u000e\fG.\u0019:Gk:\u001cG/[8o\u0007>t7\u000f\u001e:vGR|'oV5uQB\u000b'/Y7tQ\ty\u0005\u0006C\u0003T\u0001\u0011\u0005\u0001%A\u0006uKN$X*\u00199UsB,\u0007F\u0001*)\u0001")
public class CalcITCase
extends AbstractTestBase {
    @Test
    public void testSimpleSelectAll() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Table ds = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.getSmall3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))}));
        DataStream results = package$.MODULE$.table2TableConversions(ds).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,Hi", "2,2,Hello", "3,2,Hello world"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSelectStar() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Table ds = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.getSmallNestedTupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "*"))}));
        DataStream results = package$.MODULE$.table2TableConversions(ds).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(1,1),one", "(2,2),two", "(3,3),three"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSelectFirst() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Table ds = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.getSmall3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1"))}));
        DataStream results = package$.MODULE$.table2TableConversions(ds).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSimpleSelectWithNaming() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Table ds = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).as((Symbol)SymbolLiteral.bootstrap("apply", "a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).as((Symbol)SymbolLiteral.bootstrap("apply", "b"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).as((Symbol)SymbolLiteral.bootstrap("apply", "c"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        DataStream results = package$.MODULE$.table2TableConversions(ds).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1", "2,2", "3,2", "4,3", "5,3", "6,3", "7,4", "8,4", "9,4", "10,4", "11,5", "12,5", "13,5", "14,5", "15,5", "16,6", "17,6", "18,6", "19,6", "20,6", "21,6"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSimpleSelectAllWithAs() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Table ds = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.getSmall3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        DataStream results = package$.MODULE$.table2TableConversions(ds).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,Hi", "2,2,Hello", "3,2,Hello world"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSimpleFilter() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Table ds = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.getSmall3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table filterDs = ds.filter((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.int2Literal(3)));
        DataStream results = package$.MODULE$.table2TableConversions(filterDs).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,2,Hello world"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAllRejectingFilter() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Table ds = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.getSmall3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table filterDs = ds.filter((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        DataStream results = package$.MODULE$.table2TableConversions(filterDs).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink(new StreamITCase.StringSink());
        env.execute();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)StreamITCase$.MODULE$.testResults().isEmpty()));
    }

    @Test
    public void testAllPassingFilter() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Table ds = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.getSmall3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table filterDs = ds.filter((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        DataStream results = package$.MODULE$.table2TableConversions(filterDs).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,Hi", "2,2,Hello", "3,2,Hello world"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testFilterOnIntegerTupleField() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Table ds = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table filterDs = ds.filter((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$percent(package$.MODULE$.int2Literal(2))).$eq$eq$eq(package$.MODULE$.int2Literal(0))).where("b = 3 || b = 4 || b = 5");
        DataStream results = package$.MODULE$.table2TableConversions(filterDs).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4,3,Hello world, how are you?", "6,3,Luke Skywalker", "8,4,Comment#2", "10,4,Comment#4", "12,5,Comment#6", "14,5,Comment#8"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNotEquals() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Table ds = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table filterDs = ds.filter((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$percent(package$.MODULE$.int2Literal(2))).$bang$eq$eq(package$.MODULE$.int2Literal(0))).where("b != 1 && b != 2 && b != 3");
        DataStream results = package$.MODULE$.table2TableConversions(filterDs).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"7,4,Comment#1", "9,4,Comment#3", "11,5,Comment#5", "13,5,Comment#7", "15,5,Comment#9", "17,6,Comment#11", "19,6,Comment#13", "21,6,Comment#15"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testUserDefinedFunctionWithParameter() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        tEnv.registerFunction("RichFunc2", (ScalarFunction)new RichFunc2());
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(env, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string.value"), (Object)"ABC")}))));
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Table result = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).where("RichFunc2(c)='ABC#Hello'").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        DataStream results = package$.MODULE$.table2TableConversions(result).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMultipleUserDefinedFunctions() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        tEnv.registerFunction("RichFunc1", (ScalarFunction)new RichFunc1());
        tEnv.registerFunction("RichFunc2", (ScalarFunction)new RichFunc2());
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(env, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string.value"), (Object)"Abc")}))));
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Table result = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).where("RichFunc2(c)='Abc#Hello' || RichFunc1(a)=3 && b=2").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        DataStream results = package$.MODULE$.table2TableConversions(result).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello", "Hello world"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testScalarFunctionConstructorWithParams() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        MutableList testData = new MutableList();
        testData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Jack#22"));
        testData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"John#19"));
        testData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Anna#44"));
        testData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"nosharp"));
        Table t = package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)testData, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.runtime.stream.table.CalcITCase$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Func13 func0 = new Func13("default");
        Func13 func1 = new Func13("Sunny");
        Func13 func2 = new Func13("kevin2");
        Table result = t.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{func0.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), func1.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), func2.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))}));
        package$.MODULE$.table2RowDataStream(result).addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default-Anna#44,Sunny-Anna#44,kevin2-Anna#44", "default-Jack#22,Sunny-Jack#22,kevin2-Jack#22", "default-John#19,Sunny-John#19,kevin2-John#19", "default-nosharp,Sunny-nosharp,kevin2-nosharp"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMapType() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.testResults_$eq((MutableList<String>)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Table ds = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{map$.MODULE$.apply(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]))}));
        DataStream results = package$.MODULE$.table2TableConversions(ds).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{10=Comment#4}", "{11=Comment#5}", "{12=Comment#6}", "{13=Comment#7}", "{14=Comment#8}", "{15=Comment#9}", "{16=Comment#10}", "{17=Comment#11}", "{18=Comment#12}", "{19=Comment#13}", "{1=Hi}", "{20=Comment#14}", "{21=Comment#15}", "{2=Hello}", "{3=Hello world}", "{4=Hello world, how are you?}", "{5=I am fine.}", "{6=Luke Skywalker}", "{7=Comment#1}", "{8=Comment#2}", "{9=Comment#3}"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }
}

