/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.scala.StreamTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Aggregation;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.Null;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.stream.table.AggregateITCase$;
import org.apache.flink.table.runtime.stream.table.RowCollector$;
import org.apache.flink.table.runtime.stream.table.TestUpsertSink;
import org.apache.flink.table.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.runtime.utils.StreamITCase;
import org.apache.flink.table.runtime.utils.StreamITCase$;
import org.apache.flink.table.runtime.utils.StreamTestData$;
import org.apache.flink.table.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001!\ty\u0011iZ4sK\u001e\fG/Z%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005)A/\u00192mK*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0007%Q!AC\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u00051i\u0011AB1qC\u000eDWMC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013+5\t1C\u0003\u0002\u0015\r\u0005)Q\u000f^5mg&\u0011ac\u0005\u0002\u001b'R\u0014X-Y7j]\u001e<\u0016\u000e\u001e5Ti\u0006$X\rV3ti\n\u000b7/\u001a\u0005\u00061\u0001!\t!G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0001\"a\u0007\u0001\u000e\u0003\tAq!\b\u0001C\u0002\u0013%a$A\u0006rk\u0016\u0014\u0018pQ8oM&<W#A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tB\u0011aA1qS&\u0011A%\t\u0002\u0012'R\u0014X-Y7Rk\u0016\u0014\u0018pQ8oM&<\u0007B\u0002\u0014\u0001A\u0003%q$\u0001\u0007rk\u0016\u0014\u0018pQ8oM&<\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\tuKN$H)[:uS:\u001cG/\u0016#B\u000f\u001e#\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0005+:LG\u000f\u000b\u0002(cA\u0011!'N\u0007\u0002g)\u0011A'D\u0001\u0006UVt\u0017\u000e^\u0005\u0003mM\u0012A\u0001V3ti\")\u0001\b\u0001C\u0001S\u0005QC/Z:u\t&\u001cH/\u001b8diV#\u0015iR$NSb,GmV5uQ:{g\u000eR5ti&t7\r^+tC\u001e,\u0007FA\u001c2\u0011\u0015Y\u0004\u0001\"\u0001*\u0003U!Xm\u001d;ESN$\u0018N\\2u\u0003\u001e<'/Z4bi\u0016D#AO\u0019\t\u000by\u0002A\u0011A\u0015\u0002SQ,7\u000f\u001e#jgRLgn\u0019;BO\u001e\u0014XmZ1uK6K\u00070\u001a3XSRDgj\u001c8ESN$\u0018N\\2uQ\ti\u0014\u0007C\u0003B\u0001\u0011\u0005\u0011&\u0001\u0007uKN$H)[:uS:\u001cG\u000f\u000b\u0002Ac!)A\t\u0001C\u0001S\u0005QB/Z:u\t&\u001cH/\u001b8di\u00063G/\u001a:BO\u001e\u0014XmZ1uK\"\u00121)\r\u0005\u0006\u000f\u0002!\t!K\u0001\u001bi\u0016\u001cHOT8o\u0017\u0016LX\rZ$s_V\u0004\u0018iZ4sK\u001e\fG/\u001a\u0015\u0003\rFBQA\u0013\u0001\u0005\u0002%\n!\u0003^3ti\u001e\u0013x.\u001e9BO\u001e\u0014XmZ1uK\"\u0012\u0011*\r\u0005\u0006\u001b\u0002!\t!K\u0001\u001bi\u0016\u001cH\u000fR8vE2,wI]8va\u0006;wM]3hCRLwN\u001c\u0015\u0003\u0019FBQ\u0001\u0015\u0001\u0005\u0002%\n\u0001\u0005^3ti\u001e\u0013x.\u001e9BO\u001e\u0014XmZ1uK^KG\u000f[#yaJ,7o]5p]\"\u0012q*\r\u0005\u0006'\u0002!\t!K\u0001\fi\u0016\u001cHoQ8mY\u0016\u001cG\u000f\u000b\u0002Sc!)a\u000b\u0001C\u0001S\u0005\u0011C/Z:u\u000fJ|W\u000f]!hOJ,w-\u0019;f/&$\bn\u0015;bi\u0016\u0014\u0015mY6f]\u0012D#!V\u0019\t\u000be\u0003A\u0011A\u0015\u0002QQ,7\u000f\u001e*f[>4X\rR;qY&\u001c\u0017\r^3SK\u000e|'\u000fZ:XSRDW\u000b]:feR\u001c\u0016N\\6)\u0005a\u000b\u0004")
public class AggregateITCase
extends StreamingWithStateTestBase {
    private final StreamQueryConfig queryConfig = new StreamQueryConfig();

    private StreamQueryConfig queryConfig() {
        return this.queryConfig;
    }

    @Test
    public void testDistinctUDAGG() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStateBackend(this.getStateBackend());
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        JavaUserDefinedAggFunctions.DataViewTestAgg testAgg = new JavaUserDefinedAggFunctions.DataViewTestAgg();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get5TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.toDistinct((AggregateFunction)testAgg, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.DataViewTestAccum.class)).distinct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}))}));
        DataStream results = package$.MODULE$.table2TableConversions(t).toRetractStream(this.queryConfig(), TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)new StreamITCase.RetractingSink()).setParallelism(1);
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,10", "2,21", "3,12"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.retractedResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDistinctUDAGGMixedWithNonDistinctUsage() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStateBackend(this.getStateBackend());
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        JavaUserDefinedAggFunctions.WeightedAvg testAgg = new JavaUserDefinedAggFunctions.WeightedAvg();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get5TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.toDistinct((AggregateFunction)testAgg, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class)).distinct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))})), package$.MODULE$.userDefinedAggFunctionConstructor((AggregateFunction)testAgg, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))}));
        DataStream results = package$.MODULE$.table2TableConversions(t).toRetractStream(this.queryConfig(), TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)new StreamITCase.RetractingSink()).setParallelism(1);
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,3,3", "2,3,4", "3,4,4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.retractedResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDistinctAggregate() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStateBackend(this.getStateBackend());
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get5TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.toDistinct((Aggregation)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count()).distinct()}));
        DataStream results = package$.MODULE$.table2TableConversions(t).toRetractStream(this.queryConfig(), TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)new StreamITCase.RetractingSink()).setParallelism(1);
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,4", "2,4", "3,2"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.retractedResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDistinctAggregateMixedWithNonDistinct() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStateBackend(this.getStateBackend());
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get5TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.toDistinct((Aggregation)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count()).distinct(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).count()}));
        DataStream results = package$.MODULE$.table2TableConversions(t).toRetractStream(this.queryConfig(), TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)new StreamITCase.RetractingSink()).setParallelism(1);
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,4,5", "2,4,7", "3,2,3"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.retractedResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDistinct() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStateBackend(this.getStateBackend());
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), new Null(Types$.MODULE$.LONG())})).distinct();
        DataStream results = package$.MODULE$.table2TableConversions(t).toRetractStream(this.queryConfig(), TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)new StreamITCase.RetractingSink()).setParallelism(1);
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,null", "2,null", "3,null", "4,null", "5,null", "6,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.retractedResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDistinctAfterAggregate() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStateBackend(this.getStateBackend());
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get5TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count()})).distinct();
        DataStream results = package$.MODULE$.table2TableConversions(t).toRetractStream(this.queryConfig(), TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)new StreamITCase.RetractingSink()).setParallelism(1);
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,5", "2,7", "3,3"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.retractedResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNonKeyedGroupAggregate() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStateBackend(this.getStateBackend());
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()}));
        DataStream results = package$.MODULE$.table2TableConversions(t).toRetractStream(this.queryConfig(), TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)new StreamITCase.RetractingSink()).setParallelism(1);
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"231,91", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.retractedResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGroupAggregate() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStateBackend(this.getStateBackend());
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()}));
        DataStream results = package$.MODULE$.table2TableConversions(t).toRetractStream(this.queryConfig(), TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)new StreamITCase.RetractingSink());
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"1,1", (List)new .colon.colon((Object)"2,5", (List)new .colon.colon((Object)"3,15", (List)new .colon.colon((Object)"4,34", (List)new .colon.colon((Object)"5,65", (List)new .colon.colon((Object)"6,111", (List)Nil$.MODULE$))))));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.retractedResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDoubleGroupAggregation() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStateBackend(this.getStateBackend());
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "cnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cnt"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cnt")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "freq"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}));
        DataStream results = package$.MODULE$.table2TableConversions(t).toRetractStream(this.queryConfig(), TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)new StreamITCase.RetractingSink());
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"1,1", (List)new .colon.colon((Object)"2,1", (List)new .colon.colon((Object)"3,1", (List)new .colon.colon((Object)"4,1", (List)new .colon.colon((Object)"5,1", (List)new .colon.colon((Object)"6,1", (List)Nil$.MODULE$))))));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.retractedResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGroupAggregateWithExpression() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStateBackend(this.getStateBackend());
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get5TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$percent(package$.MODULE$.int2Literal(3))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).min(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).avg(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).count()}));
        DataStream results = package$.MODULE$.table2TableConversions(t).toRetractStream(this.queryConfig(), TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)new StreamITCase.RetractingSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,1,1,1", "7,1,4,2", "2,1,3,2", "3,2,3,3", "1,2,3,3", "14,2,5,1", "12,3,5,1", "5,3,4,2"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.retractedResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCollect() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStateBackend(this.getStateBackend());
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.get3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).collect()}));
        DataStream results = package$.MODULE$.table2TableConversions(t).toRetractStream(this.queryConfig(), TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)new StreamITCase.RetractingSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,{1=1}", "2,{2=1, 3=1}", "3,{4=1, 5=1, 6=1}", "4,{7=1, 8=1, 9=1, 10=1}", "5,{11=1, 12=1, 13=1, 14=1, 15=1}", "6,{16=1, 17=1, 18=1, 19=1, 20=1, 21=1}"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.retractedResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGroupAggregateWithStateBackend() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStateBackend(this.getStateBackend());
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"A"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"B"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"B"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"C"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"C"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"C"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToLong((long)4L), (Object)"B"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToLong((long)4L), (Object)"A"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)9), (Object)BoxesRunTime.boxToLong((long)4L), (Object)"D"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToLong((long)4L), (Object)"E"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)11), (Object)BoxesRunTime.boxToLong((long)5L), (Object)"A"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToLong((long)5L), (Object)"B"));
        JavaUserDefinedAggFunctions.CountDistinct distinct = new JavaUserDefinedAggFunctions.CountDistinct();
        JavaUserDefinedAggFunctions.DataViewTestAgg testAgg = new JavaUserDefinedAggFunctions.DataViewTestAgg();
        Table t = package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.runtime.stream.table.AggregateITCase$$anon$3 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.userDefinedAggFunctionConstructor((AggregateFunction)distinct, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.CountDistinctAccum.class)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), package$.MODULE$.userDefinedAggFunctionConstructor((AggregateFunction)testAgg, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.DataViewTestAccum.class)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))}));
        DataStream results = package$.MODULE$.table2TableConversions(t).toRetractStream(this.queryConfig(), TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)new StreamITCase.RetractingSink());
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,2", (List)new .colon.colon((Object)"2,1,5", (List)new .colon.colon((Object)"3,1,10", (List)new .colon.colon((Object)"4,4,20", (List)new .colon.colon((Object)"5,2,12", (List)Nil$.MODULE$)))));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.retractedResults().sorted((Ordering)Ordering.String$.MODULE$));
        Predef$.MODULE$.assert(JavaUserDefinedAggFunctions.isCloseCalled);
    }

    @Test
    public void testRemoveDuplicateRecordsWithUpsertSink() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStateBackend(this.getStateBackend());
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"A"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"B"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"B"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"C"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"C"));
        tEnv.registerTableSink("testSink", new TestUpsertSink((String[])((Object[])new String[]{"c"}), false).configure((String[])((Object[])new String[]{"c", "bMax"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.LONG()})));
        Table t = package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.runtime.stream.table.AggregateITCase$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).max()}));
        t.insertInto("testSink");
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"(true,A,1)", (List)new .colon.colon((Object)"(true,B,2)", (List)new .colon.colon((Object)"(true,C,3)", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)((SeqLike)RowCollector$.MODULE$.getAndClearValues().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$));
    }

    public AggregateITCase() {
        this.queryConfig().withIdleStateRetentionTime(Time.hours((long)1L), Time.hours((long)2L));
    }
}

