/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.scala.StreamTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.runtime.stream.sql.TemporalJoinITCase$;
import org.apache.flink.table.runtime.stream.sql.TimestampExtractor;
import org.apache.flink.table.runtime.utils.StreamITCase;
import org.apache.flink.table.runtime.utils.StreamITCase$;
import org.apache.flink.table.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.MutableList;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001A2A!\u0001\u0002\u0001#\t\u0011B+Z7q_J\fGNS8j]&#6)Y:f\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0019\tQ!\u001e;jYNL!a\u0006\u000b\u00035M#(/Z1nS:<w+\u001b;i'R\fG/\u001a+fgR\u0014\u0015m]3\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010\u0001\t\u0003y\u0012\u0001\u0007;fgR\u0004&o\\2fgN$\u0016.\\3J]:,'OS8j]R\t\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0003V]&$\bFA\u000f(!\tA3&D\u0001*\u0015\tQc\"A\u0003kk:LG/\u0003\u0002-S\t!A+Z:u\u0011\u0015q\u0003\u0001\"\u0001 \u0003Y!Xm\u001d;Fm\u0016tG\u000fV5nK&sg.\u001a:K_&t\u0007FA\u0017(\u0001")
public class TemporalJoinITCase
extends StreamingWithStateTestBase {
    @Test
    public void testProcessTimeInnerJoin() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        env.setStateBackend(this.getStateBackend());
        StreamITCase$.MODULE$.clear();
        env.setParallelism(1);
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  o.amount * r.rate AS amount\n        |FROM\n        |  Orders AS o,\n        |  LATERAL TABLE (Rates(o.proctime)) AS r\n        |WHERE r.currency = o.currency\n        |")).stripMargin();
        MutableList ordersData = new MutableList();
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"Euro"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"US Dollar"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)50L), (Object)"Yen"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"Euro"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)"US Dollar"));
        MutableList ratesHistoryData = new MutableList();
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"US Dollar", (Object)BoxesRunTime.boxToLong((long)102L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)114L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Yen", (Object)BoxesRunTime.boxToLong((long)1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)116L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)119L)));
        Table orders = package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)ordersData, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }

                    public CaseClassSerializer<Tuple2<Object, String>> createSerializerInstance(Class<Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.runtime.stream.sql.TemporalJoinITCase$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        Table ratesHistory = package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)ratesHistoryData, (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])));
                    }

                    public CaseClassSerializer<Tuple2<String, Object>> createSerializerInstance(Class<Tuple2<String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.runtime.stream.sql.TemporalJoinITCase$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.registerTable("Orders", orders);
        tEnv.registerTable("RatesHistory", ratesHistory);
        tEnv.registerFunction("Rates", (TableFunction)ratesHistory.createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency"))), TypeExtractor.createTypeInfo(Row.class));
        DataStream result = package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink(new StreamITCase.StringSink());
        env.execute();
    }

    @Test
    public void testEventTimeInnerJoin() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        env.setStateBackend(this.getStateBackend());
        StreamITCase$.MODULE$.clear();
        env.setParallelism(1);
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  o.amount * r.rate AS amount\n        |FROM\n        |  Orders AS o,\n        |  LATERAL TABLE (Rates(o.rowtime)) AS r\n        |WHERE r.currency = o.currency\n        |")).stripMargin();
        MutableList ordersData = new MutableList();
        ordersData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)"Euro", (Object)new Timestamp(2L)));
        ordersData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)"US Dollar", (Object)new Timestamp(3L)));
        ordersData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)50L), (Object)"Yen", (Object)new Timestamp(4L)));
        ordersData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)3L), (Object)"Euro", (Object)new Timestamp(5L)));
        MutableList ratesHistoryData = new MutableList();
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"US Dollar", (Object)BoxesRunTime.boxToLong((long)102L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)114L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Yen", (Object)BoxesRunTime.boxToLong((long)1L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)116L), (Object)new Timestamp(5L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)119L), (Object)new Timestamp(7L)));
        HashSet expectedOutput = new HashSet();
        expectedOutput.$plus$eq((Object)((Object)BoxesRunTime.boxToInteger((int)228)).toString());
        expectedOutput.$plus$eq((Object)((Object)BoxesRunTime.boxToInteger((int)348)).toString());
        Table orders = package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)ordersData, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple3<Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)((Timestamp)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Timestamp>> createSerializerInstance(Class<Tuple3<Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.runtime.stream.sql.TemporalJoinITCase$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(new TimestampExtractor())).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        Table ratesHistory = package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)ratesHistoryData, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((Timestamp)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<String, Object, Timestamp>> createSerializerInstance(Class<Tuple3<String, Object, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.runtime.stream.sql.TemporalJoinITCase$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(new TimestampExtractor())).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        tEnv.registerTable("Orders", orders);
        tEnv.registerTable("RatesHistory", ratesHistory);
        tEnv.registerTable("FilteredRatesHistory", tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RatesHistory"})).filter((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")).$greater(package$.MODULE$.long2Literal(110L))));
        tEnv.registerFunction("Rates", (TableFunction)tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FilteredRatesHistory"})).createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency"))), TypeExtractor.createTypeInfo(Row.class));
        tEnv.registerTable("TemporalJoinResult", tEnv.sqlQuery(sqlQuery));
        DataStream result = package$.MODULE$.table2TableConversions(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TemporalJoinResult"}))).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink(new StreamITCase.StringSink());
        env.execute();
        Assert.assertEquals((Object)expectedOutput, (Object)StreamITCase$.MODULE$.testResults().toSet());
    }
}

