/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.scala.StreamTableEnvironment;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.runtime.stream.sql.MatchRecognizeITCase$;
import org.apache.flink.table.runtime.utils.StreamITCase;
import org.apache.flink.table.runtime.utils.StreamITCase$;
import org.apache.flink.table.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.runtime.utils.TimeTestUtil;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001#\t!R*\u0019;dQJ+7m\\4oSj,\u0017\nV\"bg\u0016T!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u000511\u000f\u001e:fC6T!a\u0002\u0005\u0002\u000fI,h\u000e^5nK*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\t)b!A\u0003vi&d7/\u0003\u0002\u0018)\tQ2\u000b\u001e:fC6LgnZ,ji\"\u001cF/\u0019;f)\u0016\u001cHOQ1tK\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\u0006=\u0001!\taH\u0001\u000ei\u0016\u001cHoU5na2,7)\u0012)\u0015\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012A!\u00168ji\"\u0012Qd\n\t\u0003Q-j\u0011!\u000b\u0006\u0003U9\tQA[;oSRL!\u0001L\u0015\u0003\tQ+7\u000f\u001e\u0005\u0006]\u0001!\taH\u0001\u0017i\u0016\u001cHoU5na2,7)\u0012)XSRDg*\u001e7mg\"\u0012Qf\n\u0005\u0006c\u0001!\taH\u0001#i\u0016\u001cHoQ8eKN\u0003H.\u001b;t\u0003J,\u0007K]8qKJd\u0017pR3oKJ\fG/\u001a3)\u0005A:\u0003\"\u0002\u001b\u0001\t\u0003y\u0012\u0001\b;fgR,e/\u001a8ug\u0006\u0013X\r\u0015:pa\u0016\u0014H._(sI\u0016\u0014X\r\u001a\u0015\u0003g\u001dBQa\u000e\u0001\u0005\u0002}\t1\u0006^3ti6\u000bGo\u00195SK\u000e|wM\\5{K\u0006\u0003\b\u000f\\5fIR{w+\u001b8e_^,Gm\u0012:pkBLgn\u001a\u0015\u0003m\u001dBQA\u000f\u0001\u0005\u0002}\t!\u0003^3ti2{w-[2bY>3gm]3ug\"\u0012\u0011h\n\u0005\u0006{\u0001!\taH\u0001#i\u0016\u001cH\u000fT8hS\u000e\fGn\u00144gg\u0016$8oV5uQN#\u0018M\u001d,be&\f'\r\\3)\u0005q:\u0003\"\u0002!\u0001\t\u0003y\u0012!\u000b;fgRdunZ5dC2|eMZ:fi>+Ho]5eK>3'+\u00198hK&sW*Z1tkJ,7\u000f\u000b\u0002@O!)1\t\u0001C\u0001?\u0005)B/Z:u\u0003\u000e\u001cWm]:j]\u001e\u0004&o\\2uS6,\u0007F\u0001\"(\u0011\u00151\u0005\u0001\"\u0001 \u0003}!Xm\u001d;QCJ$\u0018\u000e^5p]&twMQ=US6,\u0017J\u001c3jG\u0006$xN\u001d\u0015\u0003\u000b\u001e\u0002")
public class MatchRecognizeITCase
extends StreamingWithStateTestBase {
    @Test
    public void testSimpleCEP() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"z"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)"b"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)"c"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)5), (Object)"d"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)6), (Object)"a"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)7), (Object)"b"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)8), (Object)"c"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)9), (Object)"h"));
        Table t = org.apache.flink.table.api.scala.package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }

                    public CaseClassSerializer<Tuple2<Object, String>> createSerializerInstance(Class<Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.runtime.stream.sql.MatchRecognizeITCase$$anon$11 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.registerTable("MyTable", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T.aid, T.bid, T.cid\n        |FROM MyTable\n        |MATCH_RECOGNIZE (\n        |  ORDER BY proctime\n        |  MEASURES\n        |    `A\"`.id AS aid,\n        |    l.id AS bid,\n        |    C.id AS cid\n        |  PATTERN (`A\"` l C)\n        |  DEFINE\n        |    `A\"` AS name = 'a',\n        |    l AS name = 'b',\n        |    C AS name = 'c'\n        |) AS T\n        |")).stripMargin();
        DataStream result = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"6,7,8"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSimpleCEPWithNulls() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"c", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"d", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), null, null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)"a", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)7), (Object)"b", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)8), (Object)"c", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)9), null, null));
        Table t = org.apache.flink.table.api.scala.package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, String>>(this, fieldSerializers){

                    public Tuple3<Object, String, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, String>> createSerializerInstance(Class<Tuple3<Object, String, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.runtime.stream.sql.MatchRecognizeITCase$$anon$12 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "nullField")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.registerTable("MyTable", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT T.aid, T.bNull, T.cid, T.aNull\n         |FROM MyTable\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.id AS aid,\n         |    A.nullField AS aNull,\n         |    LAST(B.nullField) AS bNull,\n         |    C.id AS cid\n         |  PATTERN (A B C)\n         |  DEFINE\n         |    A AS name = 'a' AND nullField IS NULL,\n         |    B AS name = 'b' AND LAST(A.nullField) IS NULL,\n         |    C AS name = 'c'\n         |) AS T\n         |")).stripMargin();
        DataStream result = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,null,3,null", "6,null,8,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCodeSplitsAreProperlyGenerated() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        TableConfig tableConfig = new TableConfig();
        tableConfig.setMaxGeneratedCodeLength(1);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, tableConfig);
        StreamITCase$.MODULE$.clear();
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a", (Object)"key1", (Object)"second_key3"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b", (Object)"key1", (Object)"second_key3"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)3), (Object)"c", (Object)"key1", (Object)"second_key3"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)4), (Object)"d", (Object)"key", (Object)"second_key"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)5), (Object)"e", (Object)"key", (Object)"second_key"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)"a", (Object)"key2", (Object)"second_key4"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)7), (Object)"b", (Object)"key2", (Object)"second_key4"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)8), (Object)"c", (Object)"key2", (Object)"second_key4"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)9), (Object)"f", (Object)"key", (Object)"second_key"));
        Table t = org.apache.flink.table.api.scala.package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, String, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, String, String, String>>(this, fieldSerializers){

                    public Tuple4<Object, String, String, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)((String)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, String, String, String>> createSerializerInstance(Class<Tuple4<Object, String, String, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.runtime.stream.sql.MatchRecognizeITCase$$anon$13 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "key1")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "key2")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.registerTable("MyTable", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM MyTable\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY key1, key2\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.id AS aid,\n         |    A.key1 AS akey1,\n         |    LAST(B.id) AS bid,\n         |    C.id AS cid,\n         |    C.key2 AS ckey2\n         |  PATTERN (A B C)\n         |  DEFINE\n         |    A AS name = 'a' AND key1 LIKE '%key%' AND id > 0,\n         |    B AS name = 'b' AND LAST(A.name, 2) IS NULL,\n         |    C AS name = 'c' AND LAST(A.name) = 'a'\n         |) AS T\n         |")).stripMargin();
        DataStream result = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key1,second_key3,1,key1,2,3,second_key3", "key2,second_key4,6,key2,7,8,second_key4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testEventsAreProperlyOrdered() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        env.setParallelism(1);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)1), (Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)11), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"b", (Object)BoxesRunTime.boxToInteger((int)2)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"c", (Object)BoxesRunTime.boxToInteger((int)3)))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)3L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)4L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToInteger((int)4), (Object)"a", (Object)BoxesRunTime.boxToInteger((int)4)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)4L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)9), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"b", (Object)BoxesRunTime.boxToInteger((int)5)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToInteger((int)6), (Object)"c", (Object)BoxesRunTime.boxToInteger((int)6)))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)5L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)6L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)8), (Object)"a", (Object)BoxesRunTime.boxToInteger((int)7)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)6L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)7), (Object)"b", (Object)BoxesRunTime.boxToInteger((int)8)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)8L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)9), (Object)"c", (Object)BoxesRunTime.boxToInteger((int)9)))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)8L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)9L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)10), (Object)"a", (Object)BoxesRunTime.boxToInteger((int)10)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)10L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)11), (Object)"b", (Object)BoxesRunTime.boxToInteger((int)11)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)11L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)12), (Object)"c", (Object)BoxesRunTime.boxToInteger((int)12)))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)11L))}));
        Table t = org.apache.flink.table.api.scala.package$.MODULE$.dataStream2DataStreamConversions(env.addSource(new TimeTestUtil.EventTimeSourceFunction(data), (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Object>> createSerializerInstance(Class<Tuple4<Object, Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.runtime.stream.sql.MatchRecognizeITCase$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "secondaryOrder")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ternaryOrder")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tstamp")).rowtime()}));
        tEnv.registerTable("MyTable", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT T.aid, T.bid, T.cid\n         |FROM MyTable\n         |MATCH_RECOGNIZE (\n         |  ORDER BY tstamp, secondaryOrder DESC, ternaryOrder ASC\n         |  MEASURES\n         |    A.id AS aid,\n         |    B.id AS bid,\n         |    C.id AS cid\n         |  PATTERN (A B C)\n         |  DEFINE\n         |    A AS name = 'a',\n         |    B AS name = 'b',\n         |    C AS name = 'c'\n         |) AS T\n         |")).stripMargin();
        Table table = tEnv.sqlQuery(sqlQuery);
        DataStream result = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(table).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink(new StreamITCase.StringSink());
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10,11,12"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMatchRecognizeAppliedToWindowedGrouping() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Time.seconds((long)1L).toMilliseconds()), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Time.seconds((long)2L).toMilliseconds()), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Time.seconds((long)4L).toMilliseconds()), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)4)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Time.seconds((long)5L).toMilliseconds()), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Time.seconds((long)7L).toMilliseconds()), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Time.seconds((long)8L).toMilliseconds()), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME1", (Object)BoxesRunTime.boxToLong((long)Time.seconds((long)1L).toMilliseconds()), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)4)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME1", (Object)BoxesRunTime.boxToLong((long)Time.seconds((long)1L).toMilliseconds()), (Object)BoxesRunTime.boxToInteger((int)24), (Object)BoxesRunTime.boxToInteger((int)4)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME1", (Object)BoxesRunTime.boxToLong((long)Time.seconds((long)1L).toMilliseconds()), (Object)BoxesRunTime.boxToInteger((int)25), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME1", (Object)BoxesRunTime.boxToLong((long)Time.seconds((long)1L).toMilliseconds()), (Object)BoxesRunTime.boxToInteger((int)19), (Object)BoxesRunTime.boxToInteger((int)8)));
        Table t = org.apache.flink.table.api.scala.package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple4<String, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<String, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }

                    public CaseClassSerializer<Tuple4<String, Object, Object, Object>> createSerializerInstance(Class<Tuple4<String, Object, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.runtime.stream.sql.MatchRecognizeITCase$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToLong((long)MatchRecognizeITCase.$anonfun$testMatchRecognizeAppliedToWindowedGrouping$1(e)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "symbol")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tstamp")).rowtime(), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tax"))}));
        tEnv.registerTable("Ticker", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM (\n         |   SELECT\n         |      symbol,\n         |      SUM(price) as price,\n         |      TUMBLE_ROWTIME(tstamp, interval '3' second) as rowTime,\n         |      TUMBLE_START(tstamp, interval '3' second) as startTime\n         |   FROM Ticker\n         |   GROUP BY symbol, TUMBLE(tstamp, interval '3' second)\n         |)\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY rowTime\n         |  MEASURES\n         |    B.price as dPrice,\n         |    B.startTime as dTime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A B)\n         |  DEFINE\n         |    B AS B.price < A.price\n         |)\n         |")).stripMargin();
        DataStream result = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink(new StreamITCase.StringSink());
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"ACME,2,1970-01-01 00:00:03.0", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLogicalOffsets() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)19), (Object)BoxesRunTime.boxToInteger((int)1)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)17), (Object)BoxesRunTime.boxToInteger((int)2)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)13), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)4)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)5L), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)5)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)6L), (Object)BoxesRunTime.boxToInteger((int)26), (Object)BoxesRunTime.boxToInteger((int)6)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)7L), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)7)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)8L), (Object)BoxesRunTime.boxToInteger((int)25), (Object)BoxesRunTime.boxToInteger((int)8)));
        Table t = org.apache.flink.table.api.scala.package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple4<String, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<String, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }

                    public CaseClassSerializer<Tuple4<String, Object, Object, Object>> createSerializerInstance(Class<Tuple4<String, Object, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.runtime.stream.sql.MatchRecognizeITCase$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "symbol")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tstamp")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tax")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.registerTable("Ticker", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    FIRST(DOWN.tstamp) AS start_tstamp,\n         |    LAST(DOWN.tstamp) AS bottom_tstamp,\n         |    UP.tstamp AS end_tstamp,\n         |    FIRST(DOWN.price + DOWN.tax + 1) AS bottom_total,\n         |    UP.price + UP.tax AS end_total\n         |  ONE ROW PER MATCH\n         |  AFTER MATCH SKIP PAST LAST ROW\n         |  PATTERN (DOWN{2,} UP)\n         |  DEFINE\n         |    DOWN AS price < LAST(DOWN.price, 1) OR LAST(DOWN.price, 1) IS NULL,\n         |    UP AS price < FIRST(DOWN.price)\n         |) AS T\n         |")).stripMargin();
        DataStream result = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink(new StreamITCase.StringSink());
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"6,7,8,33,33", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLogicalOffsetsWithStarVariable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)20)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)19)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)3), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)18)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)4), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)17)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)5), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)5L), (Object)BoxesRunTime.boxToInteger((int)16)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)6L), (Object)BoxesRunTime.boxToInteger((int)15)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)7), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)7L), (Object)BoxesRunTime.boxToInteger((int)14)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)8), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)8L), (Object)BoxesRunTime.boxToInteger((int)20)));
        Table t = org.apache.flink.table.api.scala.package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, String, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }

                    public CaseClassSerializer<Tuple4<Object, String, Object, Object>> createSerializerInstance(Class<Tuple4<Object, String, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.runtime.stream.sql.MatchRecognizeITCase$$anon$17 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "symbol")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tstamp")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.registerTable("Ticker", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    FIRST(id, 0) as id0,\n         |    FIRST(id, 1) as id1,\n         |    FIRST(id, 2) as id2,\n         |    FIRST(id, 3) as id3,\n         |    FIRST(id, 4) as id4,\n         |    FIRST(id, 5) as id5,\n         |    FIRST(id, 6) as id6,\n         |    FIRST(id, 7) as id7,\n         |    LAST(id, 0) as id8,\n         |    LAST(id, 1) as id9,\n         |    LAST(id, 2) as id10,\n         |    LAST(id, 3) as id11,\n         |    LAST(id, 4) as id12,\n         |    LAST(id, 5) as id13,\n         |    LAST(id, 6) as id14,\n         |    LAST(id, 7) as id15\n         |  ONE ROW PER MATCH\n         |  AFTER MATCH SKIP PAST LAST ROW\n         |  PATTERN (`DOWN\"`{2,} UP)\n         |  DEFINE\n         |    `DOWN\"` AS price < LAST(price, 1) OR LAST(price, 1) IS NULL,\n         |    UP AS price = FIRST(price) AND price > FIRST(price, 3) AND price = LAST(price, 7)\n         |) AS T\n         |")).stripMargin();
        DataStream result = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink(new StreamITCase.StringSink());
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"1,2,3,4,5,6,7,8,8,7,6,5,4,3,2,1", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLogicalOffsetOutsideOfRangeInMeasures() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)19), (Object)BoxesRunTime.boxToInteger((int)1)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)17), (Object)BoxesRunTime.boxToInteger((int)2)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)13), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)4)));
        Table t = org.apache.flink.table.api.scala.package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple4<String, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<String, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }

                    public CaseClassSerializer<Tuple4<String, Object, Object, Object>> createSerializerInstance(Class<Tuple4<String, Object, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.runtime.stream.sql.MatchRecognizeITCase$$anon$18 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "symbol")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tstamp")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tax")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.registerTable("Ticker", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    FIRST(DOWN.price) as first,\n         |    LAST(DOWN.price) as last,\n         |    FIRST(DOWN.price, 5) as nullPrice\n         |  ONE ROW PER MATCH\n         |  AFTER MATCH SKIP PAST LAST ROW\n         |  PATTERN (DOWN{2,} UP)\n         |  DEFINE\n         |    DOWN AS price < LAST(DOWN.price, 1) OR LAST(DOWN.price, 1) IS NULL,\n         |    UP AS price > LAST(DOWN.price)\n         |) AS T\n         |")).stripMargin();
        DataStream result = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink(new StreamITCase.StringSink());
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"19,13,null", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAccessingProctime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a"));
        Table t = org.apache.flink.table.api.scala.package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }

                    public CaseClassSerializer<Tuple2<Object, String>> createSerializerInstance(Class<Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.runtime.stream.sql.MatchRecognizeITCase$$anon$19 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.registerTable("MyTable", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT T.aid\n         |FROM MyTable\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.id AS aid,\n         |    A.proctime AS aProctime,\n         |    LAST(A.proctime + INTERVAL '1' second) as calculatedField\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS proctime >= (CURRENT_TIMESTAMP - INTERVAL '1' day)\n         |) AS T\n         |")).stripMargin();
        DataStream result = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink(new StreamITCase.StringSink());
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"1", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartitioningByTimeIndicator() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        StreamITCase$.MODULE$.clear();
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a"));
        Table t = org.apache.flink.table.api.scala.package$.MODULE$.dataStream2DataStreamConversions(env.fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }

                    public CaseClassSerializer<Tuple2<Object, String>> createSerializerInstance(Class<Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.table.runtime.stream.sql.MatchRecognizeITCase$$anon$20 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.registerTable("MyTable", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT T.aid\n         |FROM MyTable\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.id AS aid,\n         |    A.proctime AS aProctime,\n         |    LAST(A.proctime + INTERVAL '1' second) as calculatedField\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS proctime >= (CURRENT_TIMESTAMP - INTERVAL '1' day)\n         |) AS T\n         |")).stripMargin();
        DataStream result = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink(new StreamITCase.StringSink());
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"1", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)StreamITCase$.MODULE$.testResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$testMatchRecognizeAppliedToWindowedGrouping$1(Tuple4 e) {
        return BoxesRunTime.unboxToLong((Object)e._2());
    }
}

