/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.stream.sql;

import java.util.ArrayList;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.java.StreamTableEnvironment;
import org.apache.flink.table.runtime.utils.JavaStreamTestData;
import org.apache.flink.table.runtime.utils.StreamITCase;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;

public class JavaSqlITCase
extends AbstractTestBase {
    @Test
    public void testRowRegisterRowWithNames() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((StreamExecutionEnvironment)env);
        StreamITCase.clear();
        ArrayList<Row> data = new ArrayList<Row>();
        data.add(Row.of((Object[])new Object[]{1, 1L, "Hi"}));
        data.add(Row.of((Object[])new Object[]{2, 2L, "Hello"}));
        data.add(Row.of((Object[])new Object[]{3, 2L, "Hello world"}));
        TypeInformation[] types = new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO};
        String[] names = new String[]{"a", "b", "c"};
        RowTypeInfo typeInfo = new RowTypeInfo(types, names);
        SingleOutputStreamOperator ds = env.fromCollection(data).returns((TypeInformation)typeInfo);
        Table in = tableEnv.fromDataStream((DataStream)ds, "a,b,c");
        tableEnv.registerTable("MyTableRow", in);
        String sqlQuery = "SELECT a,c FROM MyTableRow";
        Table result = tableEnv.sqlQuery(sqlQuery);
        DataStream resultSet = tableEnv.toAppendStream(result, Row.class);
        resultSet.addSink(new StreamITCase.StringSink());
        env.execute();
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1,Hi");
        expected.add("2,Hello");
        expected.add("3,Hello world");
        StreamITCase.compareWithList(expected);
    }

    @Test
    public void testSelect() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((StreamExecutionEnvironment)env);
        StreamITCase.clear();
        DataStream<Tuple3<Integer, Long, String>> ds = JavaStreamTestData.getSmall3TupleDataSet(env);
        Table in = tableEnv.fromDataStream(ds, "a,b,c");
        tableEnv.registerTable("MyTable", in);
        String sqlQuery = "SELECT * FROM MyTable";
        Table result = tableEnv.sqlQuery(sqlQuery);
        DataStream resultSet = tableEnv.toAppendStream(result, Row.class);
        resultSet.addSink(new StreamITCase.StringSink());
        env.execute();
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1,1,Hi");
        expected.add("2,2,Hello");
        expected.add("3,2,Hello world");
        StreamITCase.compareWithList(expected);
    }

    @Test
    public void testFilter() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((StreamExecutionEnvironment)env);
        StreamITCase.clear();
        DataStream<Tuple5<Integer, Long, Integer, String, Long>> ds = JavaStreamTestData.get5TupleDataStream(env);
        tableEnv.registerDataStream("MyTable", ds, "a, b, c, d, e");
        String sqlQuery = "SELECT a, b, e FROM MyTable WHERE c < 4";
        Table result = tableEnv.sqlQuery(sqlQuery);
        DataStream resultSet = tableEnv.toAppendStream(result, Row.class);
        resultSet.addSink(new StreamITCase.StringSink());
        env.execute();
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1,1,1");
        expected.add("2,2,2");
        expected.add("2,3,1");
        expected.add("3,4,2");
        StreamITCase.compareWithList(expected);
    }

    @Test
    public void testUnion() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((StreamExecutionEnvironment)env);
        StreamITCase.clear();
        DataStream<Tuple3<Integer, Long, String>> ds1 = JavaStreamTestData.getSmall3TupleDataSet(env);
        Table t1 = tableEnv.fromDataStream(ds1, "a,b,c");
        tableEnv.registerTable("T1", t1);
        DataStream<Tuple5<Integer, Long, Integer, String, Long>> ds2 = JavaStreamTestData.get5TupleDataStream(env);
        tableEnv.registerDataStream("T2", ds2, "a, b, d, c, e");
        String sqlQuery = "SELECT * FROM T1 UNION ALL (SELECT a, b, c FROM T2 WHERE a\t< 3)";
        Table result = tableEnv.sqlQuery(sqlQuery);
        DataStream resultSet = tableEnv.toAppendStream(result, Row.class);
        resultSet.addSink(new StreamITCase.StringSink());
        env.execute();
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1,1,Hi");
        expected.add("2,2,Hello");
        expected.add("3,2,Hello world");
        expected.add("1,1,Hallo");
        expected.add("2,2,Hallo Welt");
        expected.add("2,3,Hallo Welt wie");
        StreamITCase.compareWithList(expected);
    }
}

