/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.LegacyKeyedProcessOperator;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.runtime.harness.HarnessTestBase;
import org.apache.flink.table.runtime.operators.FirstFieldSelector;
import org.apache.flink.table.runtime.operators.MockedProcessFunction;
import org.junit.Assert;
import org.junit.Test;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-2A!\u0001\u0002\u0001\u001f\t\u0019\u0003K]8dKN\u001ch)\u001e8di&|gnV5uQ\u000ecW-\u00198vaN#\u0018\r^3UKN$(BA\u0002\u0005\u0003%y\u0007/\u001a:bi>\u00148O\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0003\u0002\u000f!\f'O\\3tg&\u0011QC\u0005\u0002\u0010\u0011\u0006\u0014h.Z:t)\u0016\u001cHOQ1tK\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011A\u0001\u0005\u00069\u0001!\t!H\u0001\u0012i\u0016\u001cHo\u0015;bi\u0016\u001cE.Z1oS:<G#\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u00037\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u0007\u0002\u000b),h.\u001b;\n\u0005):#\u0001\u0002+fgR\u0004")
public class ProcessFunctionWithCleanupStateTest
extends HarnessTestBase {
    @Test
    public void testStateCleaning() {
        HarnessTestBase.TestStreamQueryConfig queryConfig = new HarnessTestBase.TestStreamQueryConfig(Time.milliseconds((long)5L), Time.milliseconds((long)10L));
        MockedProcessFunction func = new MockedProcessFunction(queryConfig);
        LegacyKeyedProcessOperator operator = new LegacyKeyedProcessOperator((ProcessFunction)func);
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createHarnessTester(operator, new FirstFieldSelector(), TypeInformation.of(String.class));
        testHarness.open();
        testHarness.setProcessingTime(1L);
        testHarness.processElement((Object)new Tuple2((Object)"a", (Object)"payload"), 1L);
        testHarness.processElement((Object)new Tuple2((Object)"b", (Object)"payload"), 1L);
        Assert.assertEquals((long)4L, (long)testHarness.numKeyedStateEntries());
        testHarness.setProcessingTime(5L);
        testHarness.processElement((Object)new Tuple2((Object)"c", (Object)"payload"), 1L);
        testHarness.processElement((Object)new Tuple2((Object)"a", (Object)"payload"), 1L);
        Assert.assertEquals((long)6L, (long)testHarness.numKeyedStateEntries());
        testHarness.setProcessingTime(8L);
        testHarness.processElement((Object)new Tuple2((Object)"b", (Object)"payload"), 1L);
        Assert.assertEquals((long)6L, (long)testHarness.numKeyedStateEntries());
        testHarness.setProcessingTime(11L);
        Assert.assertEquals((long)4L, (long)testHarness.numKeyedStateEntries());
        testHarness.setProcessingTime(15L);
        Assert.assertEquals((long)2L, (long)testHarness.numKeyedStateEntries());
        testHarness.setProcessingTime(18L);
        Assert.assertEquals((long)0L, (long)testHarness.numKeyedStateEntries());
        testHarness.close();
    }
}

