/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.apache.flink.table.runtime.operators.EmptyProcessFunction;
import org.apache.flink.table.runtime.operators.IdentityKeySelector;
import org.apache.flink.table.runtime.operators.KeyedProcessOperatorWithWatermarkDelay;
import org.apache.flink.util.TestLogger;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u001f\tQ3*Z=fIB\u0013xnY3tg>\u0003XM]1u_J<\u0016\u000e\u001e5XCR,'/\\1sW\u0012+G.Y=UKN$(BA\u0002\u0005\u0003%y\u0007/\u001a:bi>\u00148O\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0005\u0002\tU$\u0018\u000e\\\u0005\u0003+I\u0011!\u0002V3ti2{wmZ3s\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t!\u0001C\u0003\u001d\u0001\u0011\u0005Q$A\ruKN$\bj\u001c7eS:<')Y2l/\u0006$XM]7be.\u001cH#\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u00037\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u0007\u0002\u000b),h.\u001b;\n\u0005):#\u0001\u0002+fgRDQ\u0001\f\u0001\u0005\u0002u\t!\u0003^3ti\u0012+G.Y=QCJ\fW.\u001a;fe\"\"1&\n\u00180\u0003!)\u0007\u0010]3di\u0016$7%\u0001\u0019\u0011\u0005EJdB\u0001\u001a8\u001d\t\u0019d'D\u00015\u0015\t)d\"\u0001\u0004=e>|GOP\u0005\u0002C%\u0011\u0001\bI\u0001\ba\u0006\u001c7.Y4f\u0013\tQ4H\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:T!\u0001\u000f\u0011")
public class KeyedProcessOperatorWithWatermarkDelayTest
extends TestLogger {
    @Test
    public void testHoldingBackWatermarks() {
        KeyedProcessOperatorWithWatermarkDelay operator = new KeyedProcessOperatorWithWatermarkDelay((ProcessFunction)new EmptyProcessFunction(), 100L);
        KeyedOneInputStreamOperatorTestHarness testHarness = new KeyedOneInputStreamOperatorTestHarness((OneInputStreamOperator)operator, new IdentityKeySelector(), (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        testHarness.setup();
        testHarness.open();
        testHarness.processWatermark(new Watermark(101L));
        testHarness.processWatermark(new Watermark(103L));
        ConcurrentLinkedQueue<Watermark> expectedOutput = new ConcurrentLinkedQueue<Watermark>();
        expectedOutput.add(new Watermark(1L));
        expectedOutput.add(new Watermark(3L));
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", expectedOutput, (Queue)testHarness.getOutput());
        testHarness.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDelayParameter() {
        new KeyedProcessOperatorWithWatermarkDelay((ProcessFunction)new EmptyProcessFunction(), -1L);
    }
}

