/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.runtime.harness.HarnessTestBase;
import org.apache.flink.table.runtime.operators.FirstFieldSelector;
import org.apache.flink.table.runtime.operators.MockedKeyedProcessFunction;
import org.junit.Assert;
import org.junit.Test;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-2A!\u0001\u0002\u0001\u001f\tA3*Z=fIB\u0013xnY3tg\u001a+hn\u0019;j_:<\u0016\u000e\u001e5DY\u0016\fg.\u001e9Ti\u0006$X\rV3ti*\u00111\u0001B\u0001\n_B,'/\u0019;peNT!!\u0002\u0004\u0002\u000fI,h\u000e^5nK*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\t\u0019B!A\u0004iCJtWm]:\n\u0005U\u0011\"a\u0004%be:,7o\u001d+fgR\u0014\u0015m]3\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005\u0011\u0001\"\u0002\u000f\u0001\t\u0003i\u0012!\u0005;fgR\u001cF/\u0019;f\u00072,\u0017M\\5oOR\ta\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0003V]&$\bFA\u000e&!\t1\u0013&D\u0001(\u0015\tAC\"A\u0003kk:LG/\u0003\u0002+O\t!A+Z:u\u0001")
public class KeyedProcessFunctionWithCleanupStateTest
extends HarnessTestBase {
    @Test
    public void testStateCleaning() {
        HarnessTestBase.TestStreamQueryConfig queryConfig = new HarnessTestBase.TestStreamQueryConfig(Time.milliseconds((long)5L), Time.milliseconds((long)10L));
        MockedKeyedProcessFunction func = new MockedKeyedProcessFunction(queryConfig);
        KeyedProcessOperator operator = new KeyedProcessOperator((KeyedProcessFunction)func);
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createHarnessTester(operator, new FirstFieldSelector(), TypeInformation.of(String.class));
        testHarness.open();
        testHarness.setProcessingTime(1L);
        testHarness.processElement((Object)new Tuple2((Object)"a", (Object)"payload"), 1L);
        testHarness.processElement((Object)new Tuple2((Object)"b", (Object)"payload"), 1L);
        Assert.assertEquals((long)4L, (long)testHarness.numKeyedStateEntries());
        testHarness.setProcessingTime(5L);
        testHarness.processElement((Object)new Tuple2((Object)"c", (Object)"payload"), 1L);
        testHarness.processElement((Object)new Tuple2((Object)"a", (Object)"payload"), 1L);
        Assert.assertEquals((long)6L, (long)testHarness.numKeyedStateEntries());
        testHarness.setProcessingTime(8L);
        testHarness.processElement((Object)new Tuple2((Object)"b", (Object)"payload"), 1L);
        Assert.assertEquals((long)6L, (long)testHarness.numKeyedStateEntries());
        testHarness.setProcessingTime(11L);
        Assert.assertEquals((long)4L, (long)testHarness.numKeyedStateEntries());
        testHarness.setProcessingTime(15L);
        Assert.assertEquals((long)2L, (long)testHarness.numKeyedStateEntries());
        testHarness.setProcessingTime(18L);
        Assert.assertEquals((long)0L, (long)testHarness.numKeyedStateEntries());
        testHarness.close();
    }
}

