/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.util.KeyedTwoInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.apache.flink.table.runtime.operators.CoIdentityKeySelector;
import org.apache.flink.table.runtime.operators.EmptyCoProcessFunction;
import org.apache.flink.table.runtime.operators.IntToStringKeySelector;
import org.apache.flink.table.runtime.operators.KeyedCoProcessOperatorWithWatermarkDelay;
import org.apache.flink.util.TestLogger;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u001f\ta3*Z=fI\u000e{\u0007K]8dKN\u001cx\n]3sCR|'oV5uQ^\u000bG/\u001a:nCJ\\G)\u001a7bsR+7\u000f\u001e\u0006\u0003\u0007\u0011\t\u0011b\u001c9fe\u0006$xN]:\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\u0011\u0005!Q\u000f^5m\u0013\t)\"C\u0001\u0006UKN$Hj\\4hKJDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"\u0001\u0002\t\u000bq\u0001A\u0011A\u000f\u00023Q,7\u000f\u001e%pY\u0012Lgn\u001a\"bG.<\u0016\r^3s[\u0006\u00148n\u001d\u000b\u0002=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t!QK\\5uQ\tYR\u0005\u0005\u0002'S5\tqE\u0003\u0002)\u0019\u0005)!.\u001e8ji&\u0011!f\n\u0002\u0005)\u0016\u001cH\u000fC\u0003-\u0001\u0011\u0005Q$\u0001\nuKN$H)\u001a7bsB\u000b'/Y7fi\u0016\u0014\b\u0006B\u0016&]=\n\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002aA\u0011\u0011'\u000f\b\u0003e]r!a\r\u001c\u000e\u0003QR!!\u000e\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0013B\u0001\u001d!\u0003\u001d\u0001\u0018mY6bO\u0016L!AO\u001e\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|gN\u0003\u00029A\u0001")
public class KeyedCoProcessOperatorWithWatermarkDelayTest
extends TestLogger {
    @Test
    public void testHoldingBackWatermarks() {
        KeyedCoProcessOperatorWithWatermarkDelay operator = new KeyedCoProcessOperatorWithWatermarkDelay((CoProcessFunction)new EmptyCoProcessFunction(), 100L);
        KeyedTwoInputStreamOperatorTestHarness testHarness = new KeyedTwoInputStreamOperatorTestHarness((TwoInputStreamOperator)operator, (KeySelector)new IntToStringKeySelector(), new CoIdentityKeySelector(), (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        testHarness.setup();
        testHarness.open();
        testHarness.processWatermark1(new Watermark(101L));
        testHarness.processWatermark2(new Watermark(202L));
        testHarness.processWatermark1(new Watermark(103L));
        testHarness.processWatermark2(new Watermark(204L));
        ConcurrentLinkedQueue<Watermark> expectedOutput = new ConcurrentLinkedQueue<Watermark>();
        expectedOutput.add(new Watermark(1L));
        expectedOutput.add(new Watermark(3L));
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", expectedOutput, (Queue)testHarness.getOutput());
        testHarness.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDelayParameter() {
        new KeyedCoProcessOperatorWithWatermarkDelay((CoProcessFunction)new EmptyCoProcessFunction(), -1L);
    }
}

