/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.harness;

import java.util.Iterator;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.TriggerTestHarness;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.runtime.harness.HarnessTestBase;
import org.apache.flink.table.runtime.triggers.StateCleaningCountTrigger$;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0001\u0002\u0001\u001f\t!3\u000b^1uK\u000ecW-\u00198j]\u001e\u001cu.\u001e8u)JLwmZ3s\u0011\u0006\u0014h.Z:t)\u0016\u001cHO\u0003\u0002\u0004\t\u00059\u0001.\u0019:oKN\u001c(BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"\u0001\u0002\t\u000fq\u0001\u0001\u0019!C\t;\u0005Y\u0011/^3ss\u000e{gNZ5h+\u0005q\u0002CA\u00102\u001d\t\u0001sF\u0004\u0002\"]9\u0011!%\f\b\u0003G1r!\u0001J\u0016\u000f\u0005\u0015RcB\u0001\u0014*\u001b\u00059#B\u0001\u0015\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011B\u0001\u0019\u0003\u0003=A\u0015M\u001d8fgN$Vm\u001d;CCN,\u0017B\u0001\u001a4\u0005U!Vm\u001d;TiJ,\u0017-\\)vKJL8i\u001c8gS\u001eT!\u0001\r\u0002\t\u000fU\u0002\u0001\u0019!C\tm\u0005y\u0011/^3ss\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u00028uA\u0011\u0011\u0003O\u0005\u0003sI\u0011A!\u00168ji\"91\bNA\u0001\u0002\u0004q\u0012a\u0001=%c!1Q\b\u0001Q!\ny\tA\"];fef\u001cuN\u001c4jO\u0002BQa\u0010\u0001\u0005\u0002\u0001\u000ba\u0004^3ti\u001aK'/\u001b8h\u0003:$g)\u001b:j]\u001e<\u0016\u000e\u001e5QkJ<\u0017N\\4\u0015\u0003]B#A\u0010\"\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015c\u0011!\u00026v]&$\u0018BA$E\u0005\u0011!Vm\u001d;\t\u000b%\u0003A\u0011\u0001!\u0002\u0013Q,7\u000f^\"mK\u0006\u0014\bF\u0001%C\u0001")
public class StateCleaningCountTriggerHarnessTest {
    private HarnessTestBase.TestStreamQueryConfig queryConfig = new HarnessTestBase.TestStreamQueryConfig(Time.seconds((long)2L), Time.seconds((long)3L));

    public HarnessTestBase.TestStreamQueryConfig queryConfig() {
        return this.queryConfig;
    }

    public void queryConfig_$eq(HarnessTestBase.TestStreamQueryConfig x$1) {
        this.queryConfig = x$1;
    }

    @Test
    public void testFiringAndFiringWithPurging() {
        TriggerTestHarness testHarness = new TriggerTestHarness((Trigger)StateCleaningCountTrigger$.MODULE$.of((StreamQueryConfig)this.queryConfig(), 10L), (TypeSerializer)new GlobalWindow.Serializer());
        Assert.assertEquals((long)0L, (long)testHarness.advanceProcessingTime(1L).size());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)BoxesRunTime.boxToInteger((int)1)), (Window)GlobalWindow.get()));
        Assert.assertEquals((long)0L, (long)testHarness.advanceProcessingTime(1000L).size());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)BoxesRunTime.boxToInteger((int)1)), (Window)GlobalWindow.get()));
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries());
        Assert.assertEquals((Object)TriggerResult.FIRE_AND_PURGE, (Object)((Tuple2)testHarness.advanceProcessingTime((long)3001L).iterator().next()).f1);
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)BoxesRunTime.boxToInteger((int)1)), (Window)GlobalWindow.get()));
        Assert.assertEquals((long)0L, (long)testHarness.advanceProcessingTime(4002L).size());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)BoxesRunTime.boxToInteger((int)1)), (Window)GlobalWindow.get()));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)BoxesRunTime.boxToInteger((int)1)), (Window)GlobalWindow.get()));
        Assert.assertEquals((long)2L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries((Window)GlobalWindow.get()));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)BoxesRunTime.boxToInteger((int)1)), (Window)GlobalWindow.get()));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)BoxesRunTime.boxToInteger((int)1)), (Window)GlobalWindow.get()));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)BoxesRunTime.boxToInteger((int)1)), (Window)GlobalWindow.get()));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)BoxesRunTime.boxToInteger((int)1)), (Window)GlobalWindow.get()));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)BoxesRunTime.boxToInteger((int)1)), (Window)GlobalWindow.get()));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)BoxesRunTime.boxToInteger((int)1)), (Window)GlobalWindow.get()));
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.processElement(new StreamRecord((Object)BoxesRunTime.boxToInteger((int)1)), (Window)GlobalWindow.get()));
        Assert.assertEquals((long)1L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)1L, (long)testHarness.numStateEntries((Window)GlobalWindow.get()));
        Iterator timesIt = testHarness.advanceProcessingTime(7002L).iterator();
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)((Tuple2)timesIt.next()).f1);
        Assert.assertEquals((Object)TriggerResult.FIRE_AND_PURGE, (Object)((Tuple2)timesIt.next()).f1);
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
    }

    @Test
    public void testClear() {
        TriggerTestHarness testHarness = new TriggerTestHarness((Trigger)StateCleaningCountTrigger$.MODULE$.of((StreamQueryConfig)this.queryConfig(), 3L), (TypeSerializer)new GlobalWindow.Serializer());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)BoxesRunTime.boxToInteger((int)1)), (Window)GlobalWindow.get()));
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries((Window)GlobalWindow.get()));
        testHarness.clearTriggerState((Window)GlobalWindow.get());
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries((Window)GlobalWindow.get()));
    }
}

