/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.harness;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.LegacyKeyedProcessOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.runtime.aggregate.GroupAggProcessFunction;
import org.apache.flink.table.runtime.harness.HarnessTestBase;
import org.apache.flink.table.runtime.types.CRow$;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001\u001f\tIrI]8va\u0006;wM]3hCR,\u0007*\u0019:oKN\u001cH+Z:u\u0015\t\u0019A!A\u0004iCJtWm]:\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\ty\u0001*\u0019:oKN\u001cH+Z:u\u0005\u0006\u001cX\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0011\u0003\u0001\u0005\b3\u0001\u0001\r\u0011\"\u0005\u001b\u0003-\tX/\u001a:z\u0007>tg-[4\u0016\u0003m\u0001\"\u0001\b\u0018\u000f\u0005uacB\u0001\u0010,\u001d\ty\"F\u0004\u0002!S9\u0011\u0011\u0005\u000b\b\u0003E\u001dr!a\t\u0014\u000e\u0003\u0011R!!\n\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!!\f\u0002\u0002\u001f!\u000b'O\\3tgR+7\u000f\u001e\"bg\u0016L!a\f\u0019\u0003+Q+7\u000f^*ue\u0016\fW.U;fef\u001cuN\u001c4jO*\u0011QF\u0001\u0005\be\u0001\u0001\r\u0011\"\u00054\u0003=\tX/\u001a:z\u0007>tg-[4`I\u0015\fHC\u0001\u001b;!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0011)f.\u001b;\t\u000fm\n\u0014\u0011!a\u00017\u0005\u0019\u0001\u0010J\u0019\t\ru\u0002\u0001\u0015)\u0003\u001c\u00031\tX/\u001a:z\u0007>tg-[4!\u0011\u0015y\u0004\u0001\"\u0001A\u00035!Xm\u001d;BO\u001e\u0014XmZ1uKR\tA\u0007\u000b\u0002?\u0005B\u00111IR\u0007\u0002\t*\u0011Q\tD\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u000f\u0012\u0013A\u0001V3ti\")\u0011\n\u0001C\u0001\u0001\u0006AB/Z:u\u0003\u001e<'/Z4bi\u0016<\u0016\u000e\u001e5SKR\u0014\u0018m\u0019;)\u0005!\u0013\u0005\"\u0002'\u0001\t\u0003\u0001\u0015\u0001\t;fgR$\u0015n\u001d;j]\u000e$\u0018iZ4sK\u001e\fG/Z,ji\"\u0014V\r\u001e:bGRD#a\u0013\"")
public class GroupAggregateHarnessTest
extends HarnessTestBase {
    private HarnessTestBase.TestStreamQueryConfig queryConfig = new HarnessTestBase.TestStreamQueryConfig(Time.seconds((long)2L), Time.seconds((long)3L));

    public HarnessTestBase.TestStreamQueryConfig queryConfig() {
        return this.queryConfig;
    }

    public void queryConfig_$eq(HarnessTestBase.TestStreamQueryConfig x$1) {
        this.queryConfig = x$1;
    }

    @Test
    public void testAggregate() {
        LegacyKeyedProcessOperator processFunction = new LegacyKeyedProcessOperator((ProcessFunction)new GroupAggProcessFunction(this.genSumAggFunction(), this.sumAggregationStateType(), false, (StreamQueryConfig)this.queryConfig()));
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createHarnessTester(processFunction, new HarnessTestBase.TupleRowKeySelector(2), BasicTypeInfo.STRING_TYPE_INFO);
        testHarness.open();
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.setProcessingTime(1L);
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.int2Integer(1), "aaa"})), 1L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.int2Integer(1)})), 1L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.int2Integer(1), "bbb"})), 1L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.int2Integer(1)})), 1L));
        testHarness.setProcessingTime(1000L);
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.int2Integer(2), "aaa"})), 1L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.int2Integer(3)})), 1L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.int2Integer(3), "aaa"})), 1L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.int2Integer(6)})), 1L));
        testHarness.setProcessingTime(1002L);
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(4), "aaa"})), 1L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(10)})), 1L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.int2Integer(2), "bbb"})), 1L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.int2Integer(3)})), 1L));
        testHarness.setProcessingTime(4003L);
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.int2Integer(5), "aaa"})), 1L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.int2Integer(5)})), 1L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.int2Integer(6), "aaa"})), 1L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.int2Integer(11)})), 1L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.int2Integer(7), "aaa"})), 1L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.int2Integer(18)})), 1L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.int2Integer(3), "bbb"})), 1L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.int2Integer(3)})), 1L));
        ConcurrentLinkedQueue result = testHarness.getOutput();
        this.verify(expectedOutput, result);
        testHarness.close();
    }

    @Test
    public void testAggregateWithRetract() {
        LegacyKeyedProcessOperator processFunction = new LegacyKeyedProcessOperator((ProcessFunction)new GroupAggProcessFunction(this.genSumAggFunction(), this.sumAggregationStateType(), true, (StreamQueryConfig)this.queryConfig()));
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createHarnessTester(processFunction, new HarnessTestBase.TupleRowKeySelector(2), BasicTypeInfo.STRING_TYPE_INFO);
        testHarness.open();
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.setProcessingTime(1L);
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.int2Integer(1), "aaa"})), 1L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.int2Integer(1)})), 1L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.int2Integer(1), "bbb"})), 2L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.int2Integer(1)})), 2L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.int2Integer(2), "aaa"})), 3L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.int2Integer(1)})), 3L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.int2Integer(3)})), 3L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.int2Integer(2), "aaa"})), 3L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.int2Integer(3)})), 3L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(3L), Predef$.MODULE$.int2Integer(1)})), 3L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.int2Integer(3), "ccc"})), 4L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.int2Integer(3)})), 4L));
        testHarness.setProcessingTime(3002L);
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.int2Integer(3), "ccc"})), 4L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(4), "aaa"})), 5L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(4)})), 5L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.int2Integer(2), "bbb"})), 6L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(6L), Predef$.MODULE$.int2Integer(2)})), 6L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.int2Integer(5), "aaa"})), 7L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.int2Integer(4)})), 7L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(7L), Predef$.MODULE$.int2Integer(9)})), 7L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.int2Integer(6), "eee"})), 8L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(8L), Predef$.MODULE$.int2Integer(6)})), 8L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.int2Integer(7), "aaa"})), 9L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.int2Integer(9)})), 9L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(9L), Predef$.MODULE$.int2Integer(16)})), 9L));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.int2Integer(3), "bbb"})), 10L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.int2Integer(2)})), 10L));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.int2Integer(5)})), 10L));
        ConcurrentLinkedQueue result = testHarness.getOutput();
        this.verify(expectedOutput, result);
        testHarness.close();
    }

    @Test
    public void testDistinctAggregateWithRetract() {
        LegacyKeyedProcessOperator processFunction = new LegacyKeyedProcessOperator((ProcessFunction)new GroupAggProcessFunction(this.genDistinctCountAggFunction(), this.distinctCountAggregationStateType(), true, (StreamQueryConfig)this.queryConfig()));
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createHarnessTester(processFunction, new HarnessTestBase.TupleRowKeySelector(2), BasicTypeInfo.STRING_TYPE_INFO);
        testHarness.open();
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.setProcessingTime(1L);
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.int2Integer(1), "aaa"}))));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)}))));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.int2Integer(1), "bbb"}))));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L)}))));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.int2Integer(1), "bbb"}))));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L)}))));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(1L)}))));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.int2Integer(2), "aaa"}))));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)}))));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)}))));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.int2Integer(2), "aaa"}))));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L)}))));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)}))));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.int2Integer(3), "ccc"}))));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(1L)}))));
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.int2Integer(3), "ccc"}))));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(4L), Predef$.MODULE$.long2Long(1L)}))));
        testHarness.setProcessingTime(3002L);
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.int2Integer(1), "aaa"}))));
        expectedOutput.add(new StreamRecord((Object)CRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(1L)}))));
        testHarness.setProcessingTime(6002L);
        testHarness.processElement(new StreamRecord((Object)CRow$.MODULE$.apply(false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.int2Integer(1), "aaa"}))));
        ConcurrentLinkedQueue result = testHarness.getOutput();
        this.verify(expectedOutput, result);
        testHarness.close();
    }
}

