/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch.table;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.Window;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.api.scala.Tumble$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.runtime.utils.CommonTestData$;
import org.apache.flink.table.runtime.utils.TableProgramsCollectionTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.CsvTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.utils.TestFilterableTableSource;
import org.apache.flink.table.utils.TestFilterableTableSource$;
import org.apache.flink.table.utils.TestNestedProjectableTableSource;
import org.apache.flink.table.utils.TestNestedProjectableTableSource$;
import org.apache.flink.table.utils.TestProjectableTableSource;
import org.apache.flink.table.utils.TestProjectableTableSource$;
import org.apache.flink.table.utils.TestTableSourceWithTime;
import org.apache.flink.table.utils.TestTableSourceWithTime$;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001A\u0011\u0011\u0003V1cY\u0016\u001cv.\u001e:dK&#6)Y:f\u0015\t\u0019A!A\u0003uC\ndWM\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\beVtG/[7f\u0015\t\u0019\u0011B\u0003\u0002\u000b\u0017\u0005)a\r\\5oW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0005Q1\u0011!B;uS2\u001c\u0018B\u0001\f\u0014\u0005}!\u0016M\u00197f!J|wM]1ng\u000e{G\u000e\\3di&|g\u000eV3ti\n\u000b7/\u001a\u0005\t1\u0001\u0011\t\u0011)A\u00053\u0005Q1m\u001c8gS\u001elu\u000eZ3\u0011\u0005iacBA\u000e+\u001d\ta\u0012F\u0004\u0002\u001eQ9\u0011ad\n\b\u0003?\u0019r!\u0001I\u0013\u000f\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rz\u0011A\u0002\u001fs_>$h(C\u0001\u000f\u0013\taQ\"\u0003\u0002\u000b\u0017%\u00111!C\u0005\u0003\u000f!I!\u0001\u0006\u0004\n\u0005-\u001a\u0012!\u0006+bE2,\u0007K]8he\u0006l7\u000fV3ti\n\u000b7/Z\u0005\u0003[9\u0012q\u0002V1cY\u0016\u001cuN\u001c4jO6{G-\u001a\u0006\u0003WMAQ\u0001\r\u0001\u0005\u0002E\na\u0001P5oSRtDC\u0001\u001a5!\t\u0019\u0004!D\u0001\u0003\u0011\u0015Ar\u00061\u0001\u001a\u0011\u00151\u0004\u0001\"\u00018\u0003e!Xm\u001d;J]Z\fG.\u001b3ECR\f7\u000f\u001e:fC6$\u0016\u0010]3\u0015\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012A!\u00168ji\"\"QgP#G!\t\u00015)D\u0001B\u0015\t\u0011U\"A\u0003kk:LG/\u0003\u0002E\u0003\n!A+Z:u\u0003!)\u0007\u0010]3di\u0016$7%A$\u0011\u0005![U\"A%\u000b\u0005)C\u0011aA1qS&\u0011A*\u0013\u0002\u000f)\u0006\u0014G.Z#yG\u0016\u0004H/[8o\u0011\u0015q\u0005\u0001\"\u00018\u0003\u0001\"Xm\u001d;DgZ$\u0016M\u00197f'>,(oY3XSRD\u0007K]8kK\u000e$\u0018n\u001c8)\u00055{\u0004\"B)\u0001\t\u00039\u0014!\b;fgR$\u0016M\u00197f'>,(oY3XSRDg)\u001b7uKJ\f'\r\\3)\u0005A{\u0004\"\u0002+\u0001\t\u00039\u0014!\u0007;fgR\u0014vn\u001e;j[\u0016\u0014vn\u001e+bE2,7k\\;sG\u0016D#aU \t\u000b]\u0003A\u0011A\u001c\u00025Q,7\u000f\u001e)s_\u000e$\u0018.\\3S_^$\u0016M\u00197f'>,(oY3)\u0005Y{\u0004\"\u0002.\u0001\t\u00039\u0014!\t;fgR\u0014vn\u001e;j[\u0016\u0004&o\\2uS6,'k\\<UC\ndWmU8ve\u000e,\u0007FA-@\u0011\u0015i\u0006\u0001\"\u00018\u0003\u0011\"Xm\u001d;S_^$\u0018.\\3BgRKW.Z:uC6\u0004(k\\<UC\ndWmU8ve\u000e,\u0007F\u0001/@\u0011\u0015\u0001\u0007\u0001\"\u00018\u0003\u0005\"Xm\u001d;UC\ndWmU8ve\u000e,w+\u001b;i\r&dG/\u001a:bE2,G)\u0019;fQ\tyv\bC\u0003d\u0001\u0011\u0005q'\u0001\u000euKN$(k\\<uS6,Gj\u001c8h)\u0006\u0014G.Z*pkJ\u001cW\r\u000b\u0002c\u007f!)a\r\u0001C\u0001o\u0005iB/Z:u!J|7\r^5nKN#(/\u001b8h)\u0006\u0014G.Z*pkJ\u001cW\r\u000b\u0002f\u007f!)\u0011\u000e\u0001C\u0001o\u0005\u0011C/Z:u%><H/[7f!J|7\r^5nK2{gn\u001a+bE2,7k\\;sG\u0016D#\u0001[ \t\u000b1\u0004A\u0011A\u001c\u00027Q,7\u000f\u001e$jK2$W*\u00199qS:<G+\u00192mKN{WO]2fQ\tYw\bC\u0003p\u0001\u0011\u0005q'A\u0011uKN$\bK]8kK\u000e$x+\u001b;i_V$(k\\<uS6,\u0007K]8di&lW\r\u000b\u0002o\u007f!)!\u000f\u0001C\u0001o\u0005QB/Z:u!J|'.Z2u/&$\bn\\;u!J|7\r^5nK\"\u0012\u0011o\u0010\u0005\u0006k\u0002!\taN\u0001\u001ai\u0016\u001cH\u000f\u0015:pU\u0016\u001cGoV5uQ>,HOU8xi&lW\r\u000b\u0002u\u007f!)\u0001\u0010\u0001C\u0001o\u00059B/Z:u!J|'.Z2u\u001f:d\u0017\u0010\u0015:pGRLW.\u001a\u0015\u0003o~BQa\u001f\u0001\u0005\u0002]\na\u0003^3tiB\u0013xN[3di>sG.\u001f*poRLW.\u001a\u0015\u0003u~BQA \u0001\u0005\u0002]\na\u0003^3tiB\u0013xN[3di^KG\u000f['baBLgn\u001a\u0015\u0003{~Ba!a\u0001\u0001\t\u00039\u0014!\u0005;fgRtUm\u001d;fIB\u0013xN[3di\"\u001a\u0011\u0011A \t\r\u0005%\u0001\u0001\"\u00018\u0003\u0005\"Xm\u001d;UC\ndWmU8ve\u000e,w+\u001b;i\r&dG/\u001a:bE2,G+[7fQ\r\t9a\u0010\u0005\u0007\u0003\u001f\u0001A\u0011A\u001c\u0002MQ,7\u000f\u001e+bE2,7k\\;sG\u0016<\u0016\u000e\u001e5GS2$XM]1cY\u0016$\u0016.\\3ti\u0006l\u0007\u000fK\u0002\u0002\u000e}Bq!!\u0006\u0001\t\u0013\t9\"A\u0004nC.,'k\\<\u0015\t\u0005e\u0011Q\u0005\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011qD\u0005\u0002\u000bQL\b/Z:\n\t\u0005\r\u0012Q\u0004\u0002\u0004%><\b\u0002CA\u0014\u0003'\u0001\r!!\u000b\u0002\r\u0019LW\r\u001c3t!\u0015I\u00141FA\u0018\u0013\r\tiC\u000f\u0002\u000byI,\u0007/Z1uK\u0012t\u0004cA\u001d\u00022%\u0019\u00111\u0007\u001e\u0003\u0007\u0005s\u0017\u0010K\u0004\u0001\u0003o\t\u0019%!\u0012\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010B\u0003\u0019\u0011XO\u001c8fe&!\u0011\u0011IA\u001e\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c#!a\u0012\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014B\u0003\u001d\u0011XO\u001c8feNLA!!\u0015\u0002L\ti\u0001+\u0019:b[\u0016$XM]5{K\u0012\u0004")
public class TableSourceITCase
extends TableProgramsCollectionTestBase {
    @Test(expected=TableException.class)
    public void testInvalidDatastreamType() {
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        BatchTableSource<Row> tableSource = new BatchTableSource<Row>(null){
            private final String[] fieldNames;
            private final TypeInformation<?>[] fieldTypes;

            public String explainSource() {
                return TableSource.explainSource$((TableSource)this);
            }

            private String[] fieldNames() {
                return this.fieldNames;
            }

            private TypeInformation<?>[] fieldTypes() {
                return this.fieldTypes;
            }

            public DataSet<Row> getDataSet(ExecutionEnvironment execEnv) {
                java.util.List data = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Row.of((Object[])new Object[]{"Mary", new Long(1L), new Integer(1)}), (List)Nil$.MODULE$)).asJava();
                return execEnv.fromCollection((Collection)data, (TypeInformation)new GenericTypeInfo(Row.class));
            }

            public TypeInformation<Row> getReturnType() {
                return new RowTypeInfo(this.fieldTypes(), this.fieldNames());
            }

            public TableSchema getTableSchema() {
                return new TableSchema(this.fieldNames(), this.fieldTypes());
            }
            {
                TableSource.$init$((TableSource)this);
                this.fieldNames = (String[])((Object[])new String[]{"name", "id", "value"});
                this.fieldTypes = (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT()});
            }
        };
        tEnv.registerTableSource("T", (TableSource)tableSource);
        package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "value")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name"))}))).collect();
    }

    @Test
    public void testCsvTableSourceWithProjection() {
        CsvTableSource csvTable = CommonTestData$.MODULE$.getCsvTableSource();
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        tEnv.registerTableSource("csvTable", (TableSource)csvTable);
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"csvTable"})).where((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "score")).$less(package$.MODULE$.int2Literal(20))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "last")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).floor(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "score")).$times(package$.MODULE$.int2Literal(2))}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Smith,1,24.6", "Miller,3,15.78", "Smith,4,0.24", "Miller,6,13.56", "Williams,8,4.68"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableSourceWithFilterable() {
        String tableName = "MyTable";
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        tableEnv.registerTableSource(tableName, (TableSource)TestFilterableTableSource$.MODULE$.apply());
        Seq results = package$.MODULE$.table2RowDataSet(tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).where("amount > 4 && price < 9").select("id, name")).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"5,Record_5", "6,Record_6", "7,Record_7", "8,Record_8"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRowtimeRowTableSource() {
        String tableName = "MyTable";
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"Mary", new Long(1L), new Integer(10)}), Row.of((Object[])new Object[]{"Bob", new Long(2L), new Integer(20)}), Row.of((Object[])new Object[]{"Mary", new Long(2L), new Integer(30)}), Row.of((Object[])new Object[]{"Liz", new Long(2001L), new Integer(40)})}));
        String[] fieldNames = (String[])((Object[])new String[]{"name", "rtime", "amount"});
        TableSchema schema = new TableSchema(fieldNames, (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.INT()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT()}), fieldNames);
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, rowType, data, "rtime", null, TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(1).second()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")).sum()}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1970-01-01 00:00:00.0,40", "Bob,1970-01-01 00:00:00.0,20", "Liz,1970-01-01 00:00:02.0,40"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testProctimeRowTableSource() {
        String tableName = "MyTable";
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"Mary", new Long(1L), new Integer(10)}), Row.of((Object[])new Object[]{"Bob", new Long(2L), new Integer(20)}), Row.of((Object[])new Object[]{"Mary", new Long(2L), new Integer(30)}), Row.of((Object[])new Object[]{"Liz", new Long(2001L), new Integer(40)})}));
        String[] fieldNames = (String[])((Object[])new String[]{"name", "rtime", "amount"});
        TableSchema schema = new TableSchema((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).$colon$plus((Object)"ptime", ClassTag$.MODULE$.apply(String.class)), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT()}), fieldNames);
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, rowType, data, null, "ptime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).where((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime")).cast(Types$.MODULE$.LONG())).$greater(package$.MODULE$.long2Literal(0L))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount"))}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,10", "Bob,20", "Mary,30", "Liz,40"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRowtimeProctimeRowTableSource() {
        String tableName = "MyTable";
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"Mary", new Long(1L), new Integer(10)}), Row.of((Object[])new Object[]{"Bob", new Long(2L), new Integer(20)}), Row.of((Object[])new Object[]{"Mary", new Long(2L), new Integer(30)}), Row.of((Object[])new Object[]{"Liz", new Long(2001L), new Integer(40)})}));
        String[] fieldNames = (String[])((Object[])new String[]{"name", "rtime", "amount"});
        TableSchema schema = new TableSchema((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).$colon$plus((Object)"ptime", ClassTag$.MODULE$.apply(String.class)), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT()}), fieldNames);
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, rowType, data, "rtime", "ptime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(1).second()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")).sum()}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1970-01-01 00:00:00.0,40", "Bob,1970-01-01 00:00:00.0,20", "Liz,1970-01-01 00:00:02.0,40"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRowtimeAsTimestampRowTableSource() {
        String tableName = "MyTable";
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"Mary", SqlFunctions.internalToTimestamp((long)1L), new Integer(10)}), Row.of((Object[])new Object[]{"Bob", SqlFunctions.internalToTimestamp((long)2L), new Integer(20)}), Row.of((Object[])new Object[]{"Mary", SqlFunctions.internalToTimestamp((long)2L), new Integer(30)}), Row.of((Object[])new Object[]{"Liz", SqlFunctions.internalToTimestamp((long)2001L), new Integer(40)})}));
        String[] fieldNames = (String[])((Object[])new String[]{"name", "rtime", "amount"});
        TableSchema schema = new TableSchema(fieldNames, (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.INT()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.INT()}), fieldNames);
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, rowType, data, "rtime", null, TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(1).second()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")).sum()}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1970-01-01 00:00:00.0,40", "Bob,1970-01-01 00:00:00.0,20", "Liz,1970-01-01 00:00:02.0,40"}))).mkString("\n");
    }

    @Test
    public void testTableSourceWithFilterableDate() {
        String tableName = "MyTable";
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        RowTypeInfo rowTypeInfo = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, SqlTimeTypeInfo.DATE}), (String[])((Object[])new String[]{"id", "date_val"}));
        Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)23), Date.valueOf("2017-04-23")})), this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)24), Date.valueOf("2017-04-24")})), this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)25), Date.valueOf("2017-04-25")})), this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)26), Date.valueOf("2017-04-26")}))}));
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id from MyTable\n        |where date_val >= DATE '2017-04-24' and date_val < DATE '2017-04-26'\n      ")).stripMargin();
        TestFilterableTableSource tableSource = TestFilterableTableSource$.MODULE$.apply(rowTypeInfo, (Seq<Row>)rows, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date_val"}))));
        tableEnv.registerTableSource(tableName, (TableSource)tableSource);
        Seq results = package$.MODULE$.table2RowDataSet(tableEnv.sqlQuery(query)).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{24, 25}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRowtimeLongTableSource() {
        String tableName = "MyTable";
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{new Long(1L), new Long(2L), new Long(2L), new Long(2001L), new Long(4001L)}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"rtime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.SQL_TIMESTAMP()}));
        TypeInformation returnType = Types$.MODULE$.LONG();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, returnType, data, "rtime", null, TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(1).second()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime")).count()}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.0,3", "1970-01-01 00:00:02.0,1", "1970-01-01 00:00:04.0,1"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testProctimeStringTableSource() {
        String tableName = "MyTable";
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary", "Peter", "Bob", "Liz"}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"name", "ptime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP()}));
        TypeInformation returnType = Types$.MODULE$.STRING();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, returnType, data, null, "ptime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).where((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime")).cast(Types$.MODULE$.LONG())).$greater(package$.MODULE$.int2Literal(1))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name"))}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary", "Peter", "Bob", "Liz"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRowtimeProctimeLongTableSource() {
        String tableName = "MyTable";
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{new Long(1L), new Long(2L), new Long(2L), new Long(2001L), new Long(4001L)}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"rtime", "ptime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.SQL_TIMESTAMP()}));
        TypeInformation returnType = Types$.MODULE$.LONG();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(schema, returnType, data, "rtime", "ptime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource(tableName, tableSource);
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).where((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime")).cast(Types$.MODULE$.LONG())).$greater(package$.MODULE$.int2Literal(1))).window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(1).second()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime")).count()}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.0,3", "1970-01-01 00:00:02.0,1", "1970-01-01 00:00:04.0,1"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFieldMappingTableSource() {
        String tableName = "MyTable";
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"Mary", new Long(1L), new Integer(10)}), Row.of((Object[])new Object[]{"Bob", new Long(2L), new Integer(20)}), Row.of((Object[])new Object[]{"Mary", new Long(2L), new Integer(30)}), Row.of((Object[])new Object[]{"Liz", new Long(2001L), new Integer(40)})}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"ptime", "amount", "name", "rtime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.INT(), Types$.MODULE$.STRING(), Types$.MODULE$.SQL_TIMESTAMP()}));
        RowTypeInfo returnType = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT()});
        Map mapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)"f2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"f0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rtime"), (Object)"f1")}));
        TestTableSourceWithTime source = new TestTableSourceWithTime(schema, returnType, data, "rtime", "ptime", (Map<String, String>)mapping);
        tEnv.registerTableSource(tableName, source);
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(1).second()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount")).sum()}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1970-01-01 00:00:00.0,40", "Bob,1970-01-01 00:00:00.0,20", "Liz,1970-01-01 00:00:02.0,40"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testProjectWithoutRowtimeProctime() {
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), "Mary", new Long(10L), new Long(1L)}), Row.of((Object[])new Object[]{new Integer(2), "Bob", new Long(20L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(3), "Mike", new Long(30L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(4), "Liz", new Long(40L), new Long(2001L)})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        tEnv.registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,10,1", "Bob,20,2", "Mike,30,3", "Liz,40,4"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testProjectWithoutProctime() {
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), "Mary", new Long(10L), new Long(1L)}), Row.of((Object[])new Object[]{new Integer(2), "Bob", new Long(20L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(3), "Mike", new Long(30L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(4), "Liz", new Long(40L), new Long(2001L)})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        tEnv.registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.001,Mary,1", "1970-01-01 00:00:00.002,Bob,2", "1970-01-01 00:00:00.002,Mike,3", "1970-01-01 00:00:02.001,Liz,4"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testProjectWithoutRowtime() {
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), "Mary", new Long(10L), new Long(1L)}), Row.of((Object[])new Object[]{new Integer(2), "Bob", new Long(20L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(3), "Mike", new Long(30L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(4), "Liz", new Long(40L), new Long(2001L)})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        tEnv.registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).filter((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime")).cast(Types$.MODULE$.LONG())).$greater(package$.MODULE$.int2Literal(0))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1", "Bob,2", "Mike,3", "Liz,4"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testProjectOnlyProctime() {
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), new Long(1L), new Long(10L), "Mary"}), Row.of((Object[])new Object[]{new Integer(2), new Long(2L), new Long(20L), "Bob"}), Row.of((Object[])new Object[]{new Integer(3), new Long(2L), new Long(30L), "Mike"}), Row.of((Object[])new Object[]{new Integer(4), new Long(2001L), new Long(30L), "Liz"})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        tEnv.registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime")).cast(Types$.MODULE$.LONG())).$greater(package$.MODULE$.int2Literal(0))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.LiteralIntExpression(1).count()}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testProjectOnlyRowtime() {
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), new Long(1L), new Long(10L), "Mary"}), Row.of((Object[])new Object[]{new Integer(2), new Long(2L), new Long(20L), "Bob"}), Row.of((Object[])new Object[]{new Integer(3), new Long(2L), new Long(30L), "Mike"}), Row.of((Object[])new Object[]{new Integer(4), new Long(2001L), new Long(30L), "Liz"})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        tEnv.registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.001", "1970-01-01 00:00:00.002", "1970-01-01 00:00:00.002", "1970-01-01 00:00:02.001"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testProjectWithMapping() {
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Long(1L), new Integer(1), "Mary", new Long(10L)}), Row.of((Object[])new Object[]{new Long(2L), new Integer(2), "Bob", new Long(20L)}), Row.of((Object[])new Object[]{new Long(2L), new Integer(3), "Mike", new Long(30L)}), Row.of((Object[])new Object[]{new Long(2001L), new Integer(4), "Liz", new Long(40L)})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.INT(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG()}), (String[])((Object[])new String[]{"p-rtime", "p-id", "p-name", "p-val"}));
        Map mapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rtime"), (Object)"p-rtime"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"p-id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"val"), (Object)"p-val"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"p-name")}));
        tEnv.registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", (Map<String, String>)mapping));
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val"))}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1970-01-01 00:00:00.001,10", "Bob,1970-01-01 00:00:00.002,20", "Mike,1970-01-01 00:00:00.002,30", "Liz,1970-01-01 00:00:02.001,40"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testNestedProject() {
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Long(1L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Sarah", new Integer(100)}), Row.of((Object[])new Object[]{new Integer(1000), new Boolean(true)})}), Row.of((Object[])new Object[]{"Peter", new Integer(10000)}), "Mary"}), Row.of((Object[])new Object[]{new Long(2L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Rob", new Integer(200)}), Row.of((Object[])new Object[]{new Integer(2000), new Boolean(false)})}), Row.of((Object[])new Object[]{"Lucy", new Integer(20000)}), "Bob"}), Row.of((Object[])new Object[]{new Long(3L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Mike", new Integer(300)}), Row.of((Object[])new Object[]{new Integer(3000), new Boolean(true)})}), Row.of((Object[])new Object[]{"Betty", new Integer(30000)}), "Liz"})}));
        RowTypeInfo nested1 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.INT()}), (String[])((Object[])new String[]{"name", "value"}));
        RowTypeInfo nested2 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.BOOLEAN()}), (String[])((Object[])new String[]{"num", "flag"}));
        RowTypeInfo deepNested = new RowTypeInfo((TypeInformation[])new RowTypeInfo[]{nested1, nested2}, (String[])((Object[])new String[]{"nested1", "nested2"}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), deepNested, nested1, Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), deepNested, nested1, Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}));
        tEnv.registerTableSource("T", (TableSource)new TestNestedProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$4(), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$5()));
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested1")).get("name")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedName"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "nested")).get("value")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedValue"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested2")).get("flag")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedFlag"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested2")).get("num")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedNum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}))).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,Sarah,10000,true,1000", "2,Rob,20000,false,2000", "3,Mike,30000,true,3000"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableSourceWithFilterableTime() {
        String tableName = "MyTable";
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        RowTypeInfo rowTypeInfo = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, SqlTimeTypeInfo.TIME}), (String[])((Object[])new String[]{"id", "time_val"}));
        Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Time.valueOf("7:23:19")})), this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), Time.valueOf("11:45:00")})), this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), Time.valueOf("11:45:01")})), this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), Time.valueOf("12:14:23")})), this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), Time.valueOf("13:33:12")}))}));
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id from MyTable\n        |where time_val >= TIME '11:45:00' and time_val < TIME '12:14:23'\n      ")).stripMargin();
        TestFilterableTableSource tableSource = TestFilterableTableSource$.MODULE$.apply(rowTypeInfo, (Seq<Row>)rows, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time_val"}))));
        tableEnv.registerTableSource(tableName, (TableSource)tableSource);
        Seq results = package$.MODULE$.table2RowDataSet(tableEnv.sqlQuery(query)).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableSourceWithFilterableTimestamp() {
        String tableName = "MyTable";
        org.apache.flink.api.scala.ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        RowTypeInfo rowTypeInfo = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, SqlTimeTypeInfo.TIMESTAMP}), (String[])((Object[])new String[]{"id", "ts"}));
        Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Timestamp.valueOf("2017-07-11 7:23:19")})), this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), Timestamp.valueOf("2017-07-12 11:45:00")})), this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), Timestamp.valueOf("2017-07-13 11:45:01")})), this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), Timestamp.valueOf("2017-07-14 12:14:23")})), this.makeRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), Timestamp.valueOf("2017-07-13 13:33:12")}))}));
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id from MyTable\n        |where ts >= TIMESTAMP '2017-07-12 11:45:00' and ts < TIMESTAMP '2017-07-14 12:14:23'\n      ")).stripMargin();
        TestFilterableTableSource tableSource = TestFilterableTableSource$.MODULE$.apply(rowTypeInfo, (Seq<Row>)rows, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ts"}))));
        tableEnv.registerTableSource(tableName, (TableSource)tableSource);
        Seq results = package$.MODULE$.table2RowDataSet(tableEnv.sqlQuery(query)).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    /*
     * WARNING - void declaration
     */
    private Row makeRow(Seq<Object> fields) {
        void var2_2;
        Row row = new Row(fields.length());
        Function2 & Serializable & scala.Serializable addField = (Function2 & Serializable & scala.Serializable)(value, pos) -> {
            row.setField(BoxesRunTime.unboxToInt((Object)pos), value);
            return BoxedUnit.UNIT;
        };
        ((IterableLike)fields.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach(addField.tupled());
        return var2_2;
    }

    public TableSourceITCase(TableProgramsTestBase.TableConfigMode configMode) {
        super(configMode);
    }
}

