/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.runtime.batch.table.SomeCaseClass;
import org.apache.flink.table.runtime.batch.table.TableEnvironmentITCase$;
import org.apache.flink.table.runtime.utils.TableProgramsCollectionTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.utils.MemoryTableSourceSinkUtil;
import org.apache.flink.table.utils.MemoryTableSourceSinkUtil$;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001A\u0011a\u0003V1cY\u0016,eN^5s_:lWM\u001c;J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\tQ\u0001^1cY\u0016T!!\u0002\u0004\u0002\u000b\t\fGo\u00195\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0007%Q!AC\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u00051i\u0011AB1qC\u000eDWMC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013+5\t1C\u0003\u0002\u0015\r\u0005)Q\u000f^5mg&\u0011ac\u0005\u0002 )\u0006\u0014G.\u001a)s_\u001e\u0014\u0018-\\:D_2dWm\u0019;j_:$Vm\u001d;CCN,\u0007\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011B\r\u0002\u0015\r|gNZ5h\u001b>$W\r\u0005\u0002\u001bY9\u00111D\u000b\b\u00039%r!!\b\u0015\u000f\u0005y9cBA\u0010'\u001d\t\u0001SE\u0004\u0002\"I5\t!E\u0003\u0002$\u001f\u00051AH]8pizJ\u0011AD\u0005\u0003\u00195I!AC\u0006\n\u0005\rI\u0011BA\u0004\t\u0013\t!b!\u0003\u0002,'\u0005)B+\u00192mKB\u0013xn\u001a:b[N$Vm\u001d;CCN,\u0017BA\u0017/\u0005=!\u0016M\u00197f\u0007>tg-[4N_\u0012,'BA\u0016\u0014\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003\u0019a\u0014N\\5u}Q\u0011!\u0007\u000e\t\u0003g\u0001i\u0011A\u0001\u0005\u00061=\u0002\r!\u0007\u0005\u0006m\u0001!\taN\u0001\u0013i\u0016\u001cHoU5na2,'+Z4jgR,'\u000fF\u00019!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0011)f.\u001b;)\u0005Uz\u0004C\u0001!D\u001b\u0005\t%B\u0001\"\u000e\u0003\u0015QWO\\5u\u0013\t!\u0015I\u0001\u0003UKN$\b\"\u0002$\u0001\t\u00039\u0014\u0001\t;fgR\u0014VmZ5ti\u0016\u0014x+\u001b;i\r&,G\u000eZ:CsB{7/\u001b;j_:D#!R \t\u000b%\u0003A\u0011A\u001c\u00029Q,7\u000f\u001e*fO&\u001cH/\u001a:XSRDg)[3mIN\u0014\u0015PT1nK\"\u0012\u0001j\u0010\u0005\u0006\u0019\u0002!\taN\u0001\u0012i\u0016\u001cH\u000fV1cY\u0016\u0014VmZ5ti\u0016\u0014\bFA&@\u0011\u0015y\u0005\u0001\"\u00018\u0003-!Xm\u001d;U_R\u000b'\r\\3)\u00059{\u0004\"\u0002*\u0001\t\u00039\u0014\u0001\u0007;fgR$v\u000eV1cY\u00164%o\\7DCN,7\t\\1tg\"\u0012\u0011k\u0010\u0005\u0006+\u0002!\taN\u0001\u001ei\u0016\u001cH\u000fV8UC\ndWM\u0012:p[\u0006sG\rV8DCN,7\t\\1tg\"\u0012Ak\u0010\u0005\u00061\u0002!\taN\u0001\u001ai\u0016\u001cH/\u00138tKJ$\u0018J\u001c;p\u001b\u0016lwN]=UC\ndW\r\u000b\u0002X\u007f!\"\u0001aW1c!\tav,D\u0001^\u0015\tq\u0016)\u0001\u0004sk:tWM]\u0005\u0003Av\u0013qAU;o/&$\b.A\u0003wC2,XmI\u0001d!\t!w-D\u0001f\u0015\t1\u0017)A\u0004sk:tWM]:\n\u0005!,'!\u0004)be\u0006lW\r^3sSj,GmB\u0003k\u0005!\u00051.\u0001\fUC\ndW-\u00128wSJ|g.\\3oi&#6)Y:f!\t\u0019DNB\u0003\u0002\u0005!\u0005Qn\u0005\u0002m]B\u0011\u0011h\\\u0005\u0003aj\u0012a!\u00118z%\u00164\u0007\"\u0002\u0019m\t\u0003\u0011H#A6\t\u000bQdG\u0011A;\u0002\u0015A\f'/Y7fi\u0016\u00148\u000fF\u0001w!\r9HP`\u0007\u0002q*\u0011\u0011P_\u0001\u0005kRLGNC\u0001|\u0003\u0011Q\u0017M^1\n\u0005uD(AC\"pY2,7\r^5p]B!\u0011h`A\u0002\u0013\r\t\tA\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002>\u0002\t1\fgnZ\u0005\u0005\u0003\u001b\t9A\u0001\u0004PE*,7\r\u001e\u0015\bg\u0006E\u0011qDA\u0011!\u0011\t\u0019\"!\u0007\u000f\u0007\u0011\f)\"C\u0002\u0002\u0018\u0015\fQ\u0002U1sC6,G/\u001a:ju\u0016$\u0017\u0002BA\u000e\u0003;\u0011!\u0002U1sC6,G/\u001a:t\u0015\r\t9\"Z\u0001\u0005]\u0006lW-\t\u0002\u0002$\u0005\u0011B+\u00192mK\u0002\u001awN\u001c4jO\u0002j\u0004e\u001f\u0019~\u0001")
public class TableEnvironmentITCase
extends TableProgramsCollectionTestBase {
    @Parameterized.Parameters(name="Table config = {0}")
    public static Collection<Object[]> parameters() {
        return TableEnvironmentITCase$.MODULE$.parameters();
    }

    @Test
    public void testSimpleRegister() {
        String tableName = "MyTable";
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        tEnv.registerDataSet(tableName, ds);
        Table t = tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))}));
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRegisterWithFieldsByPosition() {
        String tableName = "MyTable";
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        tEnv.registerDataSet(tableName, ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table t = tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        String expected = "1,1\n2,2\n3,2\n4,3\n5,3\n6,3\n7,4\n8,4\n9,4\n10,4\n11,5\n12,5\n13,5\n14,5\n15,5\n16,6\n17,6\n18,6\n19,6\n20,6\n21,6\n";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRegisterWithFieldsByName() {
        String tableName = "MyTable";
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        tEnv.registerDataSet(tableName, ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2"))}));
        Table t = tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2"))}));
        String expected = "1,1\n2,2\n3,2\n4,3\n5,3\n6,3\n7,4\n8,4\n9,4\n10,4\n11,5\n12,5\n13,5\n14,5\n15,5\n16,6\n17,6\n18,6\n19,6\n20,6\n21,6\n";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableRegister() {
        String tableName = "MyTable";
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable(tableName, t);
        Table regT = tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).filter((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(8)));
        String expected = "9,4\n10,4\n11,5\n12,5\n13,5\n14,5\n15,5\n16,6\n17,6\n18,6\n19,6\n20,6\n21,6\n";
        Seq results = package$.MODULE$.table2TableConversions(regT).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testToTable() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testToTableFromCaseClass() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        .colon.colon data = new .colon.colon((Object)new SomeCaseClass("Peter", 28, 4000.0, "Sales"), (List)new .colon.colon((Object)new SomeCaseClass("Anna", 56, 10000.0, "Engineering"), (List)new .colon.colon((Object)new SomeCaseClass("Lucy", 42, 6000.0, "HR"), (List)Nil$.MODULE$)));
        Table t = package$.MODULE$.dataSet2DataSetConversions(env.fromCollection((Iterable)data, ClassTag$.MODULE$.apply(SomeCaseClass.class), (TypeInformation)new CaseClassTypeInfo<SomeCaseClass>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<SomeCaseClass> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<SomeCaseClass>(this, fieldSerializers){

                    public SomeCaseClass createInstance(Object[] fields) {
                        return new SomeCaseClass((String)fields[0], BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]), (String)fields[3]);
                    }

                    public CaseClassSerializer<SomeCaseClass> createSerializerInstance(Class<SomeCaseClass> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.runtime.batch.table.TableEnvironmentITCase$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}));
        String expected = "Peter,28,4000.0,Sales\nAnna,56,10000.0,Engineering\nLucy,42,6000.0,HR\n";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testToTableFromAndToCaseClass() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        .colon.colon data = new .colon.colon((Object)new SomeCaseClass("Peter", 28, 4000.0, "Sales"), (List)new .colon.colon((Object)new SomeCaseClass("Anna", 56, 10000.0, "Engineering"), (List)new .colon.colon((Object)new SomeCaseClass("Lucy", 42, 6000.0, "HR"), (List)Nil$.MODULE$)));
        Table t = package$.MODULE$.dataSet2DataSetConversions(env.fromCollection((Iterable)data, ClassTag$.MODULE$.apply(SomeCaseClass.class), (TypeInformation)new CaseClassTypeInfo<SomeCaseClass>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<SomeCaseClass> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<SomeCaseClass>(this, fieldSerializers){

                    public SomeCaseClass createInstance(Object[] fields) {
                        return new SomeCaseClass((String)fields[0], BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]), (String)fields[3]);
                    }

                    public CaseClassSerializer<SomeCaseClass> createSerializerInstance(Class<SomeCaseClass> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.runtime.batch.table.TableEnvironmentITCase$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}));
        String expected = "SomeCaseClass(Peter,28,4000.0,Sales)\nSomeCaseClass(Anna,56,10000.0,Engineering)\nSomeCaseClass(Lucy,42,6000.0,HR)\n";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet((TypeInformation)new CaseClassTypeInfo<SomeCaseClass>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<SomeCaseClass> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<SomeCaseClass>(this, fieldSerializers){

                    public SomeCaseClass createInstance(Object[] fields) {
                        return new SomeCaseClass((String)fields[0], BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]), (String)fields[3]);
                    }

                    public CaseClassSerializer<SomeCaseClass> createSerializerInstance(Class<SomeCaseClass> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.runtime.batch.table.TableEnvironmentITCase$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testInsertIntoMemoryTable() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        MemoryTableSourceSinkUtil$.MODULE$.clear();
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("sourceTable", t);
        String[] fieldNames = (String[])((Object[])new String[]{"d", "e", "f"});
        TypeInformation[] fieldTypes = tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sourceTable"})).getSchema().getFieldTypes();
        MemoryTableSourceSinkUtil.UnsafeMemoryAppendTableSink sink = new MemoryTableSourceSinkUtil.UnsafeMemoryAppendTableSink();
        tEnv.registerTableSink("targetTable", fieldNames, fieldTypes, (TableSink)sink);
        tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sourceTable"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).insertInto("targetTable");
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,Hi", (List)new .colon.colon((Object)"2,2,Hello", (List)new .colon.colon((Object)"3,2,Hello world", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)MemoryTableSourceSinkUtil$.MODULE$.tableDataStrings().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public TableEnvironmentITCase(TableProgramsTestBase.TableConfigMode configMode) {
        super(configMode);
    }
}

