/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.java.BatchTableEnvironment;
import org.apache.flink.table.calcite.CalciteConfig;
import org.apache.flink.table.calcite.CalciteConfigBuilder;
import org.apache.flink.table.runtime.utils.TableProgramsCollectionTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.test.operators.util.CollectionDataSets;
import org.apache.flink.types.Either;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JavaTableEnvironmentITCase
extends TableProgramsCollectionTestBase {
    public JavaTableEnvironmentITCase(TableProgramsTestBase.TableConfigMode configMode) {
        super(configMode);
    }

    @Parameterized.Parameters(name="Table config = {0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{TableProgramsTestBase.DEFAULT()}});
    }

    @Test
    public void testSimpleRegister() throws Exception {
        String tableName = "MyTable";
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        DataSet ds = CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env);
        tableEnv.registerDataSet("MyTable", ds);
        Table t = tableEnv.scan(new String[]{"MyTable"});
        Table result = t.select("f0, f1");
        DataSet resultSet = tableEnv.toDataSet(result, Row.class);
        List results = resultSet.collect();
        String expected = "1,1\n2,2\n3,2\n4,3\n5,3\n6,3\n7,4\n8,4\n9,4\n10,4\n11,5\n12,5\n13,5\n14,5\n15,5\n16,6\n17,6\n18,6\n19,6\n20,6\n21,6\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testRegisterWithFields() throws Exception {
        String tableName = "MyTable";
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        DataSet ds = CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env);
        tableEnv.registerDataSet("MyTable", ds, "a, b, c");
        Table t = tableEnv.scan(new String[]{"MyTable"});
        Table result = t.select("a, b, c");
        DataSet resultSet = tableEnv.toDataSet(result, Row.class);
        List results = resultSet.collect();
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test(expected=TableException.class)
    public void testRegisterExistingDatasetTable() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        DataSet ds = CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env);
        tableEnv.registerDataSet("MyTable", ds);
        DataSet ds2 = CollectionDataSets.getSmall5TupleDataSet((ExecutionEnvironment)env);
        tableEnv.registerDataSet("MyTable", ds2);
    }

    @Test(expected=TableException.class)
    public void testScanUnregisteredTable() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        tableEnv.scan(new String[]{"nonRegisteredTable"});
    }

    @Test
    public void testTableRegister() throws Exception {
        String tableName = "MyTable";
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        DataSet ds = CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env);
        Table t = tableEnv.fromDataSet(ds);
        tableEnv.registerTable("MyTable", t);
        Table result = tableEnv.scan(new String[]{"MyTable"}).select("f0, f1").filter("f0 > 7");
        DataSet resultSet = tableEnv.toDataSet(result, Row.class);
        List results = resultSet.collect();
        String expected = "8,4\n9,4\n10,4\n11,5\n12,5\n13,5\n14,5\n15,5\n16,6\n17,6\n18,6\n19,6\n20,6\n21,6\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test(expected=TableException.class)
    public void testIllegalName() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        DataSet ds = CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env);
        Table t = tableEnv.fromDataSet(ds);
        tableEnv.registerTable("_DataSetTable_42", t);
    }

    @Test(expected=TableException.class)
    public void testRegisterTableFromOtherEnv() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv1 = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        BatchTableEnvironment tableEnv2 = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        Table t = tableEnv1.fromDataSet(CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env));
        tableEnv2.registerTable("MyTable", t);
    }

    @Test
    public void testAsFromTupleByPosition() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        Table table = tableEnv.fromDataSet(CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env), "a, b, c").select("a, b, c");
        DataSet ds = tableEnv.toDataSet(table, Row.class);
        List results = ds.collect();
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testAsFromTupleByName() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        Table table = tableEnv.fromDataSet(CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env), "f2");
        DataSet ds = tableEnv.toDataSet(table, Row.class);
        List results = ds.collect();
        String expected = "Hi\nHello\nHello world\nHello world, how are you?\nI am fine.\nLuke Skywalker\nComment#1\nComment#2\nComment#3\nComment#4\nComment#5\nComment#6\nComment#7\nComment#8\nComment#9\nComment#10\nComment#11\nComment#12\nComment#13\nComment#14\nComment#15\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testAsFromAndToTuple() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        Table table = tableEnv.fromDataSet(CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env), "a, b, c").select("a, b, c");
        TupleTypeInfo ti = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        DataSet ds = tableEnv.toDataSet(table, (TypeInformation)ti);
        List results = ds.collect();
        String expected = "(1,1,Hi)\n(2,2,Hello)\n(3,2,Hello world)\n(4,3,Hello world, how are you?)\n(5,3,I am fine.)\n(6,3,Luke Skywalker)\n(7,4,Comment#1)\n(8,4,Comment#2)\n(9,4,Comment#3)\n(10,4,Comment#4)\n(11,5,Comment#5)\n(12,5,Comment#6)\n(13,5,Comment#7)\n(14,5,Comment#8)\n(15,5,Comment#9)\n(16,6,Comment#10)\n(17,6,Comment#11)\n(18,6,Comment#12)\n(19,6,Comment#13)\n(20,6,Comment#14)\n(21,6,Comment#15)\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Ignore
    @Test
    public void testAsFromTupleToPojo() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        ArrayList<Tuple4> data = new ArrayList<Tuple4>();
        data.add(new Tuple4((Object)"Rofl", (Object)1, (Object)1.0, (Object)"Hi"));
        data.add(new Tuple4((Object)"lol", (Object)2, (Object)1.0, (Object)"Hi"));
        data.add(new Tuple4((Object)"Test me", (Object)4, (Object)3.33, (Object)"Hello world"));
        Table table = tableEnv.fromDataSet((DataSet)env.fromCollection(data), "q, w, e, r").select("q as a, w as b, e as c, r as d");
        DataSet ds = tableEnv.toDataSet(table, SmallPojo2.class);
        List results = ds.collect();
        String expected = "Rofl,1,1.0,Hi\nlol,2,1.0,Hi\nTest me,4,3.33,Hello world\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testAsFromPojo() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        ArrayList<SmallPojo> data = new ArrayList<SmallPojo>();
        data.add(new SmallPojo("Peter", 28, 4000.0, "Sales", new Integer[]{42}));
        data.add(new SmallPojo("Anna", 56, 10000.0, "Engineering", new Integer[0]));
        data.add(new SmallPojo("Lucy", 42, 6000.0, "HR", new Integer[]{1, 2, 3}));
        Table table = tableEnv.fromDataSet((DataSet)env.fromCollection(data), "department AS a, age AS b, salary AS c, name AS d,roles as e").select("a, b, c, d, e");
        DataSet ds = tableEnv.toDataSet(table, Row.class);
        List results = ds.collect();
        String expected = "Sales,28,4000.0,Peter,[42]\nEngineering,56,10000.0,Anna,[]\nHR,42,6000.0,Lucy,[1, 2, 3]\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testFromNonAtomicAndNonComposite() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(new Either.Left((Object)"Hello"));
        data.add(new Either.Right((Object)42));
        data.add(new Either.Left((Object)"World"));
        Table table = tableEnv.fromDataSet((DataSet)env.fromCollection(data, TypeInformation.of((TypeHint)new TypeHint<Either<String, Integer>>(){})), "either").select("either");
        DataSet ds = tableEnv.toDataSet(table, Row.class);
        List results = ds.collect();
        String expected = "Left(Hello)\nLeft(World)\nRight(42)\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testAsFromPojoProjected() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        ArrayList<SmallPojo> data = new ArrayList<SmallPojo>();
        data.add(new SmallPojo("Peter", 28, 4000.0, "Sales", new Integer[]{42}));
        data.add(new SmallPojo("Anna", 56, 10000.0, "Engineering", new Integer[0]));
        data.add(new SmallPojo("Lucy", 42, 6000.0, "HR", new Integer[]{1, 2, 3}));
        Table table = tableEnv.fromDataSet((DataSet)env.fromCollection(data), "name AS d").select("d");
        DataSet ds = tableEnv.toDataSet(table, Row.class);
        List results = ds.collect();
        String expected = "Peter\nAnna\nLucy\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testAsFromPrivateFieldsPojo() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        ArrayList<PrivateSmallPojo> data = new ArrayList<PrivateSmallPojo>();
        data.add(new PrivateSmallPojo("Peter", 28, 4000.0, "Sales"));
        data.add(new PrivateSmallPojo("Anna", 56, 10000.0, "Engineering"));
        data.add(new PrivateSmallPojo("Lucy", 42, 6000.0, "HR"));
        Table table = tableEnv.fromDataSet((DataSet)env.fromCollection(data), "department AS a, age AS b, salary AS c, name AS d").select("a, b, c, d");
        DataSet ds = tableEnv.toDataSet(table, Row.class);
        List results = ds.collect();
        String expected = "Sales,28,4000.0,Peter\nEngineering,56,10000.0,Anna\nHR,42,6000.0,Lucy\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testAsFromAndToPojo() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        ArrayList<SmallPojo> data = new ArrayList<SmallPojo>();
        data.add(new SmallPojo("Peter", 28, 4000.0, "Sales", new Integer[]{42}));
        data.add(new SmallPojo("Anna", 56, 10000.0, "Engineering", new Integer[0]));
        data.add(new SmallPojo("Lucy", 42, 6000.0, "HR", new Integer[]{1, 2, 3}));
        Table table = tableEnv.fromDataSet((DataSet)env.fromCollection(data), "department AS a, age AS b, salary AS c, name AS d,roles AS e").select("a, b, c, d, e");
        DataSet ds = tableEnv.toDataSet(table, SmallPojo2.class);
        List results = ds.collect();
        String expected = "Sales,28,4000.0,Peter,[42]\nEngineering,56,10000.0,Anna,[]\nHR,42,6000.0,Lucy,[1, 2, 3]\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testAsFromAndToPrivateFieldPojo() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        ArrayList<PrivateSmallPojo> data = new ArrayList<PrivateSmallPojo>();
        data.add(new PrivateSmallPojo("Peter", 28, 4000.0, "Sales"));
        data.add(new PrivateSmallPojo("Anna", 56, 10000.0, "Engineering"));
        data.add(new PrivateSmallPojo("Lucy", 42, 6000.0, "HR"));
        Table table = tableEnv.fromDataSet((DataSet)env.fromCollection(data), "department AS a, age AS b, salary AS c, name AS d").select("a, b, c, d");
        DataSet ds = tableEnv.toDataSet(table, PrivateSmallPojo2.class);
        List results = ds.collect();
        String expected = "Sales,28,4000.0,Peter\nEngineering,56,10000.0,Anna\nHR,42,6000.0,Lucy\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testAsWithPojoAndGenericTypes() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        ArrayList<PojoWithGeneric> data = new ArrayList<PojoWithGeneric>();
        data.add(new PojoWithGeneric("Peter", 28, new HashMap<String, String>(), new ArrayList<String>()));
        HashMap<String, String> hm1 = new HashMap<String, String>();
        hm1.put("test1", "test1");
        data.add(new PojoWithGeneric("Anna", 56, hm1, new ArrayList<String>()));
        HashMap<String, String> hm2 = new HashMap<String, String>();
        hm2.put("abc", "cde");
        data.add(new PojoWithGeneric("Lucy", 42, hm2, new ArrayList<String>()));
        Table table = tableEnv.fromDataSet((DataSet)env.fromCollection(data), "name AS a, age AS b, generic AS c, generic2 AS d").select("a, b, c, c as c2, d").select("a, b, c, c === c2, d");
        DataSet ds = tableEnv.toDataSet(table, Row.class);
        List results = ds.collect();
        String expected = "Peter,28,{},true,[]\nAnna,56,{test1=test1},true,[]\nLucy,42,{abc=cde},true,[]\n";
        JavaTableEnvironmentITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test(expected=TableException.class)
    public void testGenericRow() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        DataSource dataSet = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2L, "Hello", null})});
        Assert.assertTrue((boolean)(dataSet.getType() instanceof GenericTypeInfo));
        Assert.assertTrue((boolean)dataSet.getType().getTypeClass().equals(Row.class));
        tableEnv.fromDataSet((DataSet)dataSet);
    }

    @Test(expected=TableException.class)
    public void testGenericRowWithAlias() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        DataSource dataSet = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{null})});
        Assert.assertTrue((boolean)(dataSet.getType() instanceof GenericTypeInfo));
        Assert.assertTrue((boolean)dataSet.getType().getTypeClass().equals(Row.class));
        tableEnv.fromDataSet((DataSet)dataSet, "nullField");
    }

    @Test(expected=TableException.class)
    public void testAsWithToManyFields() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        tableEnv.fromDataSet(CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env), "a, b, c, d");
    }

    @Test(expected=TableException.class)
    public void testAsWithAmbiguousFields() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        tableEnv.fromDataSet(CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env), "a, b, b");
    }

    @Test(expected=TableException.class)
    public void testAsWithNonFieldReference1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        tableEnv.fromDataSet(CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env), "a + 1, b, c");
    }

    @Test(expected=TableException.class)
    public void testAsWithNonFieldReference2() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        tableEnv.fromDataSet(CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env), "a as foo, b,  c");
    }

    @Test(expected=TableException.class)
    public void testNonStaticClassInput() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        tableEnv.fromDataSet((DataSet)env.fromElements((Object[])new MyNonStatic[]{new MyNonStatic()}), "name");
    }

    @Test(expected=TableException.class)
    public void testNonStaticClassOutput() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        Table t = tableEnv.fromDataSet((DataSet)env.fromElements((Object[])new Integer[]{1, 2, 3}), "number");
        tableEnv.toDataSet(t, MyNonStatic.class);
    }

    @Test(expected=TableException.class)
    public void testCustomCalciteConfig() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        CalciteConfig cc = new CalciteConfigBuilder().replaceLogicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[0])).replacePhysicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[0])).build();
        tableEnv.getConfig().setCalciteConfig(cc);
        DataSet ds = CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env);
        Table t = tableEnv.fromDataSet(ds);
        tableEnv.toDataSet(t, Row.class);
    }

    public static class PrivateSmallPojo2 {
        private String a;
        private int b;
        private double c;
        private String d;

        public PrivateSmallPojo2() {
        }

        public PrivateSmallPojo2(String a, int b, double c, String d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        public double getC() {
            return this.c;
        }

        public void setC(double c) {
            this.c = c;
        }

        public String getD() {
            return this.d;
        }

        public void setD(String d) {
            this.d = d;
        }

        public String toString() {
            return this.a + "," + this.b + "," + this.c + "," + this.d;
        }
    }

    public static class SmallPojo2 {
        public String a;
        public int b;
        public double c;
        public String d;
        public Integer[] e;

        public SmallPojo2() {
        }

        public SmallPojo2(String a, int b, double c, String d, Integer[] e) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public String toString() {
            return this.a + "," + this.b + "," + this.c + "," + this.d + "," + Arrays.toString((Object[])this.e);
        }
    }

    public static class PrivateSmallPojo {
        private String name;
        private int age;
        private double salary;
        private String department;

        public PrivateSmallPojo() {
        }

        public PrivateSmallPojo(String name, int age, double salary, String department) {
            this.name = name;
            this.age = age;
            this.salary = salary;
            this.department = department;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public double getSalary() {
            return this.salary;
        }

        public void setSalary(double salary) {
            this.salary = salary;
        }

        public String getDepartment() {
            return this.department;
        }

        public void setDepartment(String department) {
            this.department = department;
        }
    }

    public static class PojoWithGeneric {
        public String name;
        public int age;
        public HashMap<String, String> generic;
        public ArrayList<String> generic2;

        public PojoWithGeneric() {
        }

        public PojoWithGeneric(String name, int age, HashMap<String, String> generic, ArrayList<String> generic2) {
            this.name = name;
            this.age = age;
            this.generic = generic;
            this.generic2 = generic2;
        }

        public String toString() {
            return this.name + "," + this.age + "," + this.generic + "," + this.generic2;
        }
    }

    public static class SmallPojo {
        public String name;
        public int age;
        public double salary;
        public String department;
        public Integer[] roles;

        public SmallPojo() {
        }

        public SmallPojo(String name, int age, double salary, String department, Integer[] roles) {
            this.name = name;
            this.age = age;
            this.salary = salary;
            this.department = department;
            this.roles = roles;
        }
    }

    public class MyNonStatic {
        public int number;
    }
}

