/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.table.api.GroupedTable;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.aggfunctions.CountAccumulator;
import org.apache.flink.table.functions.aggfunctions.CountAggFunction;
import org.apache.flink.table.runtime.batch.table.AggregationsITCase$;
import org.apache.flink.table.runtime.batch.table.WC;
import org.apache.flink.table.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.runtime.utils.TableProgramsCollectionTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.table.utils.NonMergableCount;
import org.apache.flink.table.utils.NonMergableCountAcc;
import org.apache.flink.table.utils.Top10;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple7;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0001\u0003\u0001A\u0011!#Q4he\u0016<\u0017\r^5p]NLEkQ1tK*\u00111\u0001B\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u000b\u0019\tQAY1uG\"T!a\u0002\u0005\u0002\u000fI,h\u000e^5nK*\u00111!\u0003\u0006\u0003\u0015-\tQA\u001a7j].T!\u0001D\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0011aA8sO\u000e\u00011C\u0001\u0001\u0012!\t\u0011R#D\u0001\u0014\u0015\t!b!A\u0003vi&d7/\u0003\u0002\u0017'\tyB+\u00192mKB\u0013xn\u001a:b[N\u001cu\u000e\u001c7fGRLwN\u001c+fgR\u0014\u0015m]3\t\u0011a\u0001!\u0011!Q\u0001\ne\t!bY8oM&<Wj\u001c3f!\tQBF\u0004\u0002\u001cU9\u0011A$\u000b\b\u0003;!r!AH\u0014\u000f\u0005}1cB\u0001\u0011&\u001d\t\tC%D\u0001#\u0015\t\u0019s\"\u0001\u0004=e>|GOP\u0005\u0002\u001d%\u0011A\"D\u0005\u0003\u0015-I!aA\u0005\n\u0005\u001dA\u0011B\u0001\u000b\u0007\u0013\tY3#A\u000bUC\ndW\r\u0015:pOJ\fWn\u001d+fgR\u0014\u0015m]3\n\u00055r#a\u0004+bE2,7i\u001c8gS\u001elu\u000eZ3\u000b\u0005-\u001a\u0002\"\u0002\u0019\u0001\t\u0003\t\u0014A\u0002\u001fj]&$h\b\u0006\u00023iA\u00111\u0007A\u0007\u0002\u0005!)\u0001d\fa\u00013!)a\u0007\u0001C\u0001o\u0005aB/Z:u\u0003\u001e<'/Z4bi&|gnV5uQ\u000e\u000b7/Z\"mCN\u001cH#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\tUs\u0017\u000e\u001e\u0015\u0003k}\u0002\"\u0001Q\"\u000e\u0003\u0005S!AQ\u0007\u0002\u000b),h.\u001b;\n\u0005\u0011\u000b%\u0001\u0002+fgRDQA\u0012\u0001\u0005\u0002]\nA\u0003^3ti\u0006;wM]3hCRLwN\u001c+za\u0016\u001c\bFA#@\u0011\u0015I\u0005\u0001\"\u00018\u0003}!Xm\u001d;X_J\\\u0017N\\4BO\u001e\u0014XmZ1uS>tG)\u0019;b)f\u0004Xm\u001d\u0015\u0003\u0011~BQ\u0001\u0014\u0001\u0005\u0002]\na\u0002^3tiB\u0013xN[3di&|g\u000e\u000b\u0002L\u007f!)q\n\u0001C\u0001o\u0005iB/Z:u\u0003\u001e<'/Z4bi&|gnV5uQ\u0006\u0013\u0018\u000e\u001e5nKRL7\r\u000b\u0002O\u007f!)!\u000b\u0001C\u0001o\u0005YB/Z:u\u0003\u001e<'/Z4bi&|gnV5uQR;xnQ8v]RD#!U \t\u000bU\u0003A\u0011A\u001c\u0002=Q,7\u000f^!hOJ,w-\u0019;j_:\fe\r^3s!J|'.Z2uS>t\u0007F\u0001+@\u0011\u0015A\u0006\u0001\"\u00018\u0003a!Xm\u001d;T#2\u001bF/\u001f7f\u0003\u001e<'/Z4bi&|gn\u001d\u0015\u0003/~BQa\u0017\u0001\u0005\u0002]\n1\u0003^3tiB{'n\\!hOJ,w-\u0019;j_:D#AW \t\u000by\u0003A\u0011A\u001c\u0002\u0019Q,7\u000f\u001e#jgRLgn\u0019;)\u0005u{\u0004\"B1\u0001\t\u00039\u0014A\u0007;fgR$\u0015n\u001d;j]\u000e$\u0018I\u001a;fe\u0006;wM]3hCR,\u0007F\u00011@\u0011\u0015!\u0007\u0001\"\u00018\u0003Q!Xm\u001d;He>,\b/\u001a3BO\u001e\u0014XmZ1uK\"\u00121m\u0010\u0005\u0006O\u0002!\taN\u0001 i\u0016\u001cHo\u0012:pkBLgnZ&fs\u001a{'o^1sI&3gj\u001c;Vg\u0016$\u0007F\u00014@\u0011\u0015Q\u0007\u0001\"\u00018\u0003Y!Xm\u001d;He>,\bOT8BO\u001e\u0014XmZ1uS>t\u0007FA5@\u0011\u0015i\u0007\u0001\"\u00018\u0003i!Xm\u001d;BO\u001e\u0014XmZ1uK\u0016k\u0007\u000f^=ECR\f7+\u001a;tQ\taw\bC\u0003q\u0001\u0011\u0005q'\u0001\u0011uKN$xI]8va\u0016$\u0017iZ4sK\u001e\fG/Z,ji\"duN\\4LKf\u001c\bFA8@\u0011\u0015\u0019\b\u0001\"\u00018\u0003\u0005\"Xm\u001d;He>,\b/\u001a3BO\u001e\u0014XmZ1uK^KG\u000f[\"p]N$\u0018M\u001c;2Q\t\u0011x\bC\u0003w\u0001\u0011\u0005q'A\u0011uKN$xI]8va\u0016$\u0017iZ4sK\u001e\fG/Z,ji\"\u001cuN\\:uC:$(\u0007\u000b\u0002v\u007f!)\u0011\u0010\u0001C\u0001o\u0005\u0011C/Z:u\u000fJ|W\u000f]3e\u0003\u001e<'/Z4bi\u0016<\u0016\u000e\u001e5FqB\u0014Xm]:j_:D#\u0001_ \t\u000bq\u0004A\u0011A\u001c\u0002=Q,7\u000f^$s_V\u0004X\rZ!hOJ,w-\u0019;f/&$\bNR5mi\u0016\u0014\bFA>@\u0011\u0015y\b\u0001\"\u00018\u0003]!Xm\u001d;B]\u0006d\u0017\u0010^5d\u0003\u001e<'/Z4bi&|g\u000e\u000b\u0002\u007f\u007f!1\u0011Q\u0001\u0001\u0005\u0002]\nA\u0003^3ti\u000e{W\u000e\u001d7fq\u0006;wM]3hCR,\u0007fAA\u0002\u007f!1\u00111\u0002\u0001\u0005\u0002]\n1\u0002^3ti\u000e{G\u000e\\3di\"\u001a\u0011\u0011B )\u000f\u0001\t\t\"!\b\u0002 A!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018\u0005\u000baA];o]\u0016\u0014\u0018\u0002BA\u000e\u0003+\u0011qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0002\"A!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(\u0005\u000bqA];o]\u0016\u00148/\u0003\u0003\u0002,\u0005\u0015\"!\u0004)be\u0006lW\r^3sSj,G\r")
public class AggregationsITCase
extends TableProgramsCollectionTestBase {
    @Test
    public void testAggregationWithCaseClass() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table inputTable = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmallNestedTupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        tEnv.registerDataSet("MyTable", package$.MODULE$.table2RowDataSet(inputTable));
        Table result = tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MyTable"})).where((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).get("_1")).$greater(package$.MODULE$.int2Literal(0))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).get("_1")).avg(), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).get("_2")).sum(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).count()}));
        String expected = "2,6,3";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAggregationTypes() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).sum(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).sum0(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).min(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).max(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).count(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).avg()}));
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected = "231,231,1,21,21,11";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testWorkingAggregationDataTypes() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple7[]{new Tuple7((Object)BoxesRunTime.boxToByte((byte)1), (Object)BoxesRunTime.boxToShort((short)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)"Hello"), new Tuple7((Object)BoxesRunTime.boxToByte((byte)2), (Object)BoxesRunTime.boxToShort((short)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)"Ciao")}), ClassTag$.MODULE$.apply(Tuple7.class), (TypeInformation)new CaseClassTypeInfo<Tuple7<Object, Object, Object, Object, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>>(this, fieldSerializers){

                    public Tuple7<Object, Object, Object, Object, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple7((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)((String)fields[6]));
                    }

                    public CaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>> createSerializerInstance(Class<Tuple7<Object, Object, Object, Object, Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.runtime.batch.table.AggregationsITCase$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).avg(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).avg(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).avg(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_4")).avg(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_5")).avg(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_6")).avg(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_7")).count()}));
        String expected = "1,1,1,1,1.5,1.5,2";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testProjection() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)BoxesRunTime.boxToByte((byte)1), (Object)BoxesRunTime.boxToShort((short)1)), new scala.Tuple2((Object)BoxesRunTime.boxToByte((byte)2), (Object)BoxesRunTime.boxToShort((short)2))}), ClassTag$.MODULE$.apply(scala.Tuple2.class), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])));
                    }

                    public CaseClassSerializer<scala.Tuple2<Object, Object>> createSerializerInstance(Class<scala.Tuple2<Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.runtime.batch.table.AggregationsITCase$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).avg(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).sum(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).count(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).avg(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).sum()}));
        String expected = "1,3,2,1,3";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAggregationWithArithmetic() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)"Hello"), new scala.Tuple2((Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)"Ciao")}), ClassTag$.MODULE$.apply(scala.Tuple2.class), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple2<Object, String>>(this, fieldSerializers){

                    public scala.Tuple2<Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[0])), (Object)((String)fields[1]));
                    }

                    public CaseClassSerializer<scala.Tuple2<Object, String>> createSerializerInstance(Class<scala.Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.runtime.batch.table.AggregationsITCase$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).$plus(package$.MODULE$.int2Literal(2))).avg()).$plus(package$.MODULE$.int2Literal(2)), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).count()).$plus(package$.MODULE$.int2Literal(5))}));
        String expected = "5.5,7";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAggregationWithTwoCount() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)"Hello"), new scala.Tuple2((Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)"Ciao")}), ClassTag$.MODULE$.apply(scala.Tuple2.class), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple2<Object, String>>(this, fieldSerializers){

                    public scala.Tuple2<Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[0])), (Object)((String)fields[1]));
                    }

                    public CaseClassSerializer<scala.Tuple2<Object, String>> createSerializerInstance(Class<scala.Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.runtime.batch.table.AggregationsITCase$$anon$17 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).count(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).count()}));
        String expected = "2,2";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAggregationAfterProjection() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple7[]{new Tuple7((Object)BoxesRunTime.boxToByte((byte)1), (Object)BoxesRunTime.boxToShort((short)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)"Hello"), new Tuple7((Object)BoxesRunTime.boxToByte((byte)2), (Object)BoxesRunTime.boxToShort((short)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)"Ciao")}), ClassTag$.MODULE$.apply(Tuple7.class), (TypeInformation)new CaseClassTypeInfo<Tuple7<Object, Object, Object, Object, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>>(this, fieldSerializers){

                    public Tuple7<Object, Object, Object, Object, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple7((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)((String)fields[6]));
                    }

                    public CaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>> createSerializerInstance(Class<Tuple7<Object, Object, Object, Object, Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.runtime.batch.table.AggregationsITCase$$anon$18 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).avg(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).sum(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).count()}));
        String expected = "1,3,2";
        Seq result = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    @Test
    public void testSQLStyleAggregations() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select(new StringOps(Predef$.MODULE$.augmentString("Sum( a) as a1, a.sum as a2,\n          |Min (a) as b1, a.min as b2,\n          |Max (a ) as c1, a.max as c2,\n          |Avg ( a ) as d1, a.avg as d2,\n          |Count(a) as e1, a.count as e2\n        ")).stripMargin());
        String expected = "231,231,1,1,21,21,11,11,21,21";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testPojoAggregation() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        DataSet input = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WC[]{new WC("hello", 1L), new WC("hello", 1L), new WC("ciao", 1L), new WC("hola", 1L), new WC("hola", 1L)}), ClassTag$.MODULE$.apply(WC.class), (TypeInformation)new CaseClassTypeInfo<WC>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<WC> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<WC>(this, fieldSerializers){

                    public WC createInstance(Object[] fields) {
                        return new WC((String)fields[0], BoxesRunTime.unboxToLong((Object)fields[1]));
                    }

                    public CaseClassSerializer<WC> createSerializerInstance(Class<WC> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.runtime.batch.table.AggregationsITCase$$anon$19 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table expr = package$.MODULE$.dataSet2DataSetConversions(input).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        DataSet result = package$.MODULE$.table2TableConversions(expr.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "word"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "word")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "frequency")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "frequency"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))})).filter((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "frequency")).$eq$eq$eq(package$.MODULE$.int2Literal(2)))).toDataSet((TypeInformation)new CaseClassTypeInfo<WC>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<WC> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<WC>(this, fieldSerializers){

                    public WC createInstance(Object[] fields) {
                        return new WC((String)fields[0], BoxesRunTime.unboxToLong((Object)fields[1]));
                    }

                    public CaseClassSerializer<WC> createSerializerInstance(Class<WC> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.runtime.batch.table.AggregationsITCase$$anon$20 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Seq mappedResult = result.map((Function1 & Serializable & scala.Serializable)w -> new scala.Tuple2((Object)w.word(), (Object)BoxesRunTime.boxToLong((long)(w.frequency() * 10L))), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$21 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple2<String, Object>>(this, fieldSerializers){

                    public scala.Tuple2<String, Object> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])));
                    }

                    public CaseClassSerializer<scala.Tuple2<String, Object>> createSerializerInstance(Class<scala.Tuple2<String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.runtime.batch.table.AggregationsITCase$$anon$21 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(scala.Tuple2.class)).collect();
        String expected = "(hello,20)\n(hola,20)";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(mappedResult).asJava()), (String)expected);
    }

    @Test
    public void testDistinct() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table distinct = ds.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).distinct();
        String expected = "1\n2\n3\n4\n5\n6\n";
        Seq results = package$.MODULE$.table2TableConversions(distinct).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testDistinctAfterAggregate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}));
        Table distinct = ds.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).distinct();
        String expected = "1\n2\n3\n";
        Seq results = package$.MODULE$.table2TableConversions(distinct).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupedAggregate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        CountAggFunction countFun = new CountAggFunction();
        JavaUserDefinedAggFunctions.WeightedAvgWithMergeAndReset wAvgFun = new JavaUserDefinedAggFunctions.WeightedAvgWithMergeAndReset();
        JavaUserDefinedAggFunctions.CountDistinctWithMergeAndReset countDistinct = new JavaUserDefinedAggFunctions.CountDistinctWithMergeAndReset();
        Expression[] expressionArray = new Expression[6];
        expressionArray[0] = package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"));
        expressionArray[1] = package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum();
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Long.TYPE), (List)Nil$.MODULE$);
        Class<CountAccumulator> clazz = CountAccumulator.class;
        expressionArray[2] = package$.MODULE$.userDefinedAggFunctionConstructor((AggregateFunction)countFun, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), (TypeInformation)new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        expressionArray[3] = package$.MODULE$.userDefinedAggFunctionConstructor((AggregateFunction)wAvgFun, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        expressionArray[4] = package$.MODULE$.userDefinedAggFunctionConstructor((AggregateFunction)wAvgFun, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        expressionArray[5] = package$.MODULE$.userDefinedAggFunctionConstructor((AggregateFunction)countDistinct, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.CountDistinctAccum.class)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])expressionArray));
        String expected = "1,1,1,1,1,1\n2,5,2,2,2,2\n3,15,3,3,5,3\n4,34,4,4,8,4\n5,65,5,5,13,5\n6,111,6,6,18,6\n";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupingKeyForwardIfNotUsed() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()}));
        String expected = "1\n5\n15\n34\n65\n111\n";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupNoAggregation() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        String expected = "1\n2\n3\n4\n5\n6\n";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAggregateEmptyDataSets() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        NonMergableCount myAgg = new NonMergableCount();
        Table t1 = package$.MODULE$.dataSet2DataSetConversions(env.fromCollection((Iterable)new MutableList(), ClassTag$.MODULE$.apply(scala.Tuple2.class), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple2<Object, String>>(this, fieldSerializers){

                    public scala.Tuple2<Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }

                    public CaseClassSerializer<scala.Tuple2<Object, String>> createSerializerInstance(Class<scala.Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.runtime.batch.table.AggregationsITCase$$anon$22 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count()}));
        Table t2 = package$.MODULE$.dataSet2DataSetConversions(env.fromCollection((Iterable)new MutableList(), ClassTag$.MODULE$.apply(scala.Tuple2.class), (TypeInformation)new CaseClassTypeInfo<scala.Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$23 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple2<Object, String>>(this, fieldSerializers){

                    public scala.Tuple2<Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }

                    public CaseClassSerializer<scala.Tuple2<Object, String>> createSerializerInstance(Class<scala.Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.table.runtime.batch.table.AggregationsITCase$$anon$23 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum(), package$.MODULE$.userDefinedAggFunctionConstructor((AggregateFunction)myAgg, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), (TypeInformation)new CaseClassTypeInfo<NonMergableCountAcc>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$24 x$1) {
                return x$1.types;
            }

            public TypeSerializer<NonMergableCountAcc> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$11[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<NonMergableCountAcc>(this, fieldSerializers){

                    public NonMergableCountAcc createInstance(Object[] fields) {
                        return new NonMergableCountAcc(BoxesRunTime.unboxToLong((Object)fields[0]));
                    }

                    public CaseClassSerializer<NonMergableCountAcc> createSerializerInstance(Class<NonMergableCountAcc> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$11(org.apache.flink.table.runtime.batch.table.AggregationsITCase$$anon$24 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count()}));
        String expected1 = "null,0";
        String expected2 = "null,0,0";
        Seq results1 = package$.MODULE$.table2TableConversions(t1).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        Seq results2 = package$.MODULE$.table2TableConversions(t2).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results1).asJava()), (String)expected1);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results2).asJava()), (String)expected2);
    }

    @Test
    public void testGroupedAggregateWithLongKeys() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table ds = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhaa", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhaa", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhaa", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhaa", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhaa", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhab", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhab", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhab", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhab", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2))}), ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$25 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$12[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<String, Object, Object>>(this, fieldSerializers){

                    public Tuple3<String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<String, Object, Object>> createSerializerInstance(Class<Tuple3<String, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$12(org.apache.flink.table.runtime.batch.table.AggregationsITCase$$anon$25 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).rebalance().setParallelism(2)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).sum()}));
        String expected = "10\n8\n";
        Seq results = package$.MODULE$.table2RowDataSet(ds).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupedAggregateWithConstant1() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.LiteralIntExpression(4).as((Symbol)SymbolLiteral.bootstrap("apply", "four"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "four")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "four")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()}));
        String expected = "4,2\n4,3\n4,5\n4,5\n4,5\n4,6\n4,6\n4,6\n4,3\n4,4\n4,6\n4,1\n4,4\n4,4\n4,5\n4,6\n4,2\n4,3\n4,4\n4,5\n4,6\n";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupedAggregateWithConstant2() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.LiteralIntExpression(4).as((Symbol)SymbolLiteral.bootstrap("apply", "four"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "four"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "four")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()}));
        String expected = "4,1\n4,5\n4,15\n4,34\n4,65\n4,111\n";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupedAggregateWithExpression() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$percent(package$.MODULE$.int2Literal(3))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).min(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).avg(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).count()}));
        String expected = "0,1,1,1\n3,2,3,3\n7,1,4,2\n14,2,5,1\n5,3,4,2\n2,1,3,2\n1,2,3,3\n12,3,5,1";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupedAggregateWithFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()})).where((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.int2Literal(2)));
        String expected = "2,5\n";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAnalyticAggregation() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table ds = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple7[]{new Tuple7((Object)BoxesRunTime.boxToByte((byte)1), (Object)BoxesRunTime.boxToShort((short)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BigDecimal.ONE), new Tuple7((Object)BoxesRunTime.boxToByte((byte)2), (Object)BoxesRunTime.boxToShort((short)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)new BigDecimal(2))}), ClassTag$.MODULE$.apply(Tuple7.class), (TypeInformation)new CaseClassTypeInfo<Tuple7<Object, Object, Object, Object, Object, Object, BigDecimal>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$26 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple7<Object, Object, Object, Object, Object, Object, BigDecimal>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$13[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, BigDecimal>>(this, fieldSerializers){

                    public Tuple7<Object, Object, Object, Object, Object, Object, BigDecimal> createInstance(Object[] fields) {
                        return new Tuple7((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)((BigDecimal)fields[6]));
                    }

                    public CaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, BigDecimal>> createSerializerInstance(Class<Tuple7<Object, Object, Object, Object, Object, Object, BigDecimal>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$13(org.apache.flink.table.runtime.batch.table.AggregationsITCase$$anon$26 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        Table res = ds.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).stddevPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).stddevPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).stddevPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_4")).stddevPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_5")).stddevPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_6")).stddevPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_7")).stddevPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).stddevSamp(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).stddevSamp(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).stddevSamp(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_4")).stddevSamp(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_5")).stddevSamp(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_6")).stddevSamp(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_7")).stddevSamp(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).varPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).varPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).varPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_4")).varPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_5")).varPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_6")).varPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_7")).varPop(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).varSamp(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).varSamp(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).varSamp(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_4")).varSamp(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_5")).varSamp(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_6")).varSamp(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_7")).varSamp()}));
        String expected = "0,0,0,0,0.5,0.5,0.5,1,1,1,1,0.70710677,0.7071067811865476,0.7071067811865476,0,0,0,0,0.25,0.25,0.25,1,1,1,1,0.5,0.5,0.5";
        Seq results = package$.MODULE$.table2TableConversions(res).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testComplexAggregate() {
        Object object;
        TupleTypeInfo elementType;
        Object object2;
        TupleTypeInfo elementType2;
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Top10 top10Fun = new Top10();
        GroupedTable groupedTable = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        Expression[] expressionArray = new Expression[2];
        expressionArray[0] = package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"));
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Float.class), (List)Nil$.MODULE$));
        Class<Tuple2> clazz = Tuple2.class;
        TupleTypeInfo tupleTypeInfo = elementType2 = new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.BOOLEAN_TYPE_INFO;
        TupleTypeInfo tupleTypeInfo2 = tupleTypeInfo;
        if (!(basicTypeInfo != null ? !basicTypeInfo.equals(tupleTypeInfo2) : tupleTypeInfo2 != null)) {
            object2 = PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO;
        } else {
            BasicTypeInfo basicTypeInfo2 = BasicTypeInfo.BYTE_TYPE_INFO;
            TupleTypeInfo tupleTypeInfo3 = tupleTypeInfo;
            if (!(basicTypeInfo2 != null ? !basicTypeInfo2.equals(tupleTypeInfo3) : tupleTypeInfo3 != null)) {
                object2 = PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
            } else {
                BasicTypeInfo basicTypeInfo3 = BasicTypeInfo.CHAR_TYPE_INFO;
                TupleTypeInfo tupleTypeInfo4 = tupleTypeInfo;
                if (!(basicTypeInfo3 != null ? !basicTypeInfo3.equals(tupleTypeInfo4) : tupleTypeInfo4 != null)) {
                    object2 = PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO;
                } else {
                    BasicTypeInfo basicTypeInfo4 = BasicTypeInfo.DOUBLE_TYPE_INFO;
                    TupleTypeInfo tupleTypeInfo5 = tupleTypeInfo;
                    if (!(basicTypeInfo4 != null ? !basicTypeInfo4.equals(tupleTypeInfo5) : tupleTypeInfo5 != null)) {
                        object2 = PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO;
                    } else {
                        BasicTypeInfo basicTypeInfo5 = BasicTypeInfo.FLOAT_TYPE_INFO;
                        TupleTypeInfo tupleTypeInfo6 = tupleTypeInfo;
                        if (!(basicTypeInfo5 != null ? !basicTypeInfo5.equals(tupleTypeInfo6) : tupleTypeInfo6 != null)) {
                            object2 = PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO;
                        } else {
                            BasicTypeInfo basicTypeInfo6 = BasicTypeInfo.INT_TYPE_INFO;
                            TupleTypeInfo tupleTypeInfo7 = tupleTypeInfo;
                            if (!(basicTypeInfo6 != null ? !basicTypeInfo6.equals(tupleTypeInfo7) : tupleTypeInfo7 != null)) {
                                object2 = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
                            } else {
                                BasicTypeInfo basicTypeInfo7 = BasicTypeInfo.LONG_TYPE_INFO;
                                TupleTypeInfo tupleTypeInfo8 = tupleTypeInfo;
                                if (!(basicTypeInfo7 != null ? !basicTypeInfo7.equals(tupleTypeInfo8) : tupleTypeInfo8 != null)) {
                                    object2 = PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO;
                                } else {
                                    BasicTypeInfo basicTypeInfo8 = BasicTypeInfo.SHORT_TYPE_INFO;
                                    TupleTypeInfo tupleTypeInfo9 = tupleTypeInfo;
                                    if (!(basicTypeInfo8 != null ? !basicTypeInfo8.equals(tupleTypeInfo9) : tupleTypeInfo9 != null)) {
                                        object2 = PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO;
                                    } else {
                                        BasicTypeInfo basicTypeInfo9 = BasicTypeInfo.STRING_TYPE_INFO;
                                        TupleTypeInfo tupleTypeInfo10 = tupleTypeInfo;
                                        object2 = !(basicTypeInfo9 != null ? !basicTypeInfo9.equals(tupleTypeInfo10) : tupleTypeInfo10 != null) ? BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO : ObjectArrayTypeInfo.getInfoFor((TypeInformation)elementType2);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        PrimitiveArrayTypeInfo result = object2;
        .colon.colon fields2 = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Float.class), (List)Nil$.MODULE$));
        Class<Tuple2> clazz2 = Tuple2.class;
        TupleTypeInfo tupleTypeInfo11 = elementType = new TupleTypeInfo(clazz2, (TypeInformation[])fields2.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
        BasicTypeInfo basicTypeInfo10 = BasicTypeInfo.BOOLEAN_TYPE_INFO;
        TupleTypeInfo tupleTypeInfo12 = tupleTypeInfo11;
        if (!(basicTypeInfo10 != null ? !basicTypeInfo10.equals(tupleTypeInfo12) : tupleTypeInfo12 != null)) {
            object = PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO;
        } else {
            BasicTypeInfo basicTypeInfo11 = BasicTypeInfo.BYTE_TYPE_INFO;
            TupleTypeInfo tupleTypeInfo13 = tupleTypeInfo11;
            if (!(basicTypeInfo11 != null ? !basicTypeInfo11.equals(tupleTypeInfo13) : tupleTypeInfo13 != null)) {
                object = PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
            } else {
                BasicTypeInfo basicTypeInfo12 = BasicTypeInfo.CHAR_TYPE_INFO;
                TupleTypeInfo tupleTypeInfo14 = tupleTypeInfo11;
                if (!(basicTypeInfo12 != null ? !basicTypeInfo12.equals(tupleTypeInfo14) : tupleTypeInfo14 != null)) {
                    object = PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO;
                } else {
                    BasicTypeInfo basicTypeInfo13 = BasicTypeInfo.DOUBLE_TYPE_INFO;
                    TupleTypeInfo tupleTypeInfo15 = tupleTypeInfo11;
                    if (!(basicTypeInfo13 != null ? !basicTypeInfo13.equals(tupleTypeInfo15) : tupleTypeInfo15 != null)) {
                        object = PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO;
                    } else {
                        BasicTypeInfo basicTypeInfo14 = BasicTypeInfo.FLOAT_TYPE_INFO;
                        TupleTypeInfo tupleTypeInfo16 = tupleTypeInfo11;
                        if (!(basicTypeInfo14 != null ? !basicTypeInfo14.equals(tupleTypeInfo16) : tupleTypeInfo16 != null)) {
                            object = PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO;
                        } else {
                            BasicTypeInfo basicTypeInfo15 = BasicTypeInfo.INT_TYPE_INFO;
                            TupleTypeInfo tupleTypeInfo17 = tupleTypeInfo11;
                            if (!(basicTypeInfo15 != null ? !basicTypeInfo15.equals(tupleTypeInfo17) : tupleTypeInfo17 != null)) {
                                object = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
                            } else {
                                BasicTypeInfo basicTypeInfo16 = BasicTypeInfo.LONG_TYPE_INFO;
                                TupleTypeInfo tupleTypeInfo18 = tupleTypeInfo11;
                                if (!(basicTypeInfo16 != null ? !basicTypeInfo16.equals(tupleTypeInfo18) : tupleTypeInfo18 != null)) {
                                    object = PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO;
                                } else {
                                    BasicTypeInfo basicTypeInfo17 = BasicTypeInfo.SHORT_TYPE_INFO;
                                    TupleTypeInfo tupleTypeInfo19 = tupleTypeInfo11;
                                    if (!(basicTypeInfo17 != null ? !basicTypeInfo17.equals(tupleTypeInfo19) : tupleTypeInfo19 != null)) {
                                        object = PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO;
                                    } else {
                                        BasicTypeInfo basicTypeInfo18 = BasicTypeInfo.STRING_TYPE_INFO;
                                        TupleTypeInfo tupleTypeInfo20 = tupleTypeInfo11;
                                        object = !(basicTypeInfo18 != null ? !basicTypeInfo18.equals(tupleTypeInfo20) : tupleTypeInfo20 != null) ? BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO : ObjectArrayTypeInfo.getInfoFor((TypeInformation)elementType);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        PrimitiveArrayTypeInfo result2 = object;
        expressionArray[1] = package$.MODULE$.userDefinedAggFunctionConstructor((AggregateFunction)top10Fun, (TypeInformation)result, (TypeInformation)result2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).cast(Types$.MODULE$.INT()), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast(Types$.MODULE$.FLOAT())}));
        Table t = groupedTable.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])expressionArray));
        String expected = "1,[(1,1.0), null, null, null, null, null, null, null, null, null]\n2,[(2,3.0), (2,2.0), null, null, null, null, null, null, null, null]\n3,[(3,6.0), (3,5.0), (3,4.0), null, null, null, null, null, null, null]\n4,[(4,10.0), (4,9.0), (4,8.0), (4,7.0), null, null, null, null, null, null]\n5,[(5,15.0), (5,14.0), (5,13.0), (5,12.0), (5,11.0), null, null, null, null, null]\n6,[(6,21.0), (6,20.0), (6,19.0), (6,18.0), (6,17.0), (6,16.0), null, null, null, null]";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCollect() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).collect()}));
        String expected = "1,{1=1}\n2,{2=1, 3=1}\n3,{4=1, 5=1, 6=1}\n4,{8=1, 9=1, 10=1, 7=1}\n5,{11=1, 12=1, 13=1, 14=1, 15=1}\n6,{16=1, 17=1, 18=1, 19=1, 20=1, 21=1}";
        Seq results = package$.MODULE$.table2TableConversions(t).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    public AggregationsITCase(TableProgramsTestBase.TableConfigMode configMode) {
        super(configMode);
    }
}

