/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch.sql;

import java.util.List;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.runtime.utils.CommonTestData;
import org.apache.flink.table.runtime.utils.CommonTestData$;
import org.apache.flink.table.runtime.utils.TableProgramsCollectionTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.CsvTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001#\t\tB+\u00192mKN{WO]2f\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u0005)A/\u00192mK*\u00111\u0002D\u0001\u0006M2Lgn\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"BA\u000b\u0007\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0010UC\ndW\r\u0015:pOJ\fWn]\"pY2,7\r^5p]R+7\u000f\u001e\"bg\u0016D\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u000bG>tg-[4N_\u0012,\u0007CA\u000e.\u001d\ta2F\u0004\u0002\u001eU9\u0011a$\u000b\b\u0003?!r!\u0001I\u0014\u000f\u0005\u00052cB\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0011\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002\u000e\u001d%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005U1\u0011B\u0001\u0017\u0015\u0003U!\u0016M\u00197f!J|wM]1ngR+7\u000f\u001e\"bg\u0016L!AL\u0018\u0003\u001fQ\u000b'\r\\3D_:4\u0017nZ'pI\u0016T!\u0001\f\u000b\t\u000bE\u0002A\u0011\u0001\u001a\u0002\rqJg.\u001b;?)\t\u0019T\u0007\u0005\u00025\u00015\t!\u0001C\u0003\u001aa\u0001\u0007!\u0004C\u00038\u0001\u0011\u0005\u0001(\u0001\nuKN$8i\u001d<UC\ndWmU8ve\u000e,G#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\tUs\u0017\u000e\u001e\u0015\u0003m\u0001\u0003\"!\u0011#\u000e\u0003\tS!a\u0011\b\u0002\u000b),h.\u001b;\n\u0005\u0015\u0013%\u0001\u0002+fgRDQa\u0012\u0001\u0005\u0002a\n!\u0002^3ti:+7\u000f^3eQ\t1\u0005\t\u000b\u0003\u0001\u0015B\u000b\u0006CA&O\u001b\u0005a%BA'C\u0003\u0019\u0011XO\u001c8fe&\u0011q\n\u0014\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\u0005\u0011\u0006CA*W\u001b\u0005!&BA+C\u0003\u001d\u0011XO\u001c8feNL!a\u0016+\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0001")
public class TableSourceITCase
extends TableProgramsCollectionTestBase {
    @Test
    public void testCsvTableSource() {
        CsvTableSource csvTable = CommonTestData$.MODULE$.getCsvTableSource();
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        tEnv.registerTableSource("csvTable", (TableSource)csvTable);
        Seq results = package$.MODULE$.table2RowDataSet(tEnv.sqlQuery("SELECT id, `first`, `last`, score FROM csvTable")).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,Mike,Smith,12.3", "2,Bob,Taylor,45.6", "3,Sam,Miller,7.89", "4,Peter,Smith,0.12", "5,Liz,Williams,34.5", "6,Sally,Miller,6.78", "7,Alice,Smith,90.1", "8,Kelly,Williams,2.34"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testNested() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        BatchTableSource<CommonTestData.Person> nestedTable = CommonTestData$.MODULE$.getNestedTableSource();
        tableEnv.registerTableSource("NestedPersons", nestedTable);
        Seq result = package$.MODULE$.table2RowDataSet(tableEnv.sqlQuery("SELECT NestedPersons.firstName, NestedPersons.lastName,NestedPersons.address.street, NestedPersons.address.city AS city FROM NestedPersons WHERE NestedPersons.address.city LIKE 'Dublin'")).collect();
        String expected = "Bob,Taylor,Pearse Street,Dublin";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    public TableSourceITCase(TableProgramsTestBase.TableConfigMode configMode) {
        super(configMode);
    }
}

