/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.runtime.batch.sql.TableEnvironmentITCase$;
import org.apache.flink.table.runtime.utils.TableProgramsCollectionTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.utils.MemoryTableSourceSinkUtil;
import org.apache.flink.table.utils.MemoryTableSourceSinkUtil$;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001#\t1B+\u00192mK\u0016sg/\u001b:p]6,g\u000e^%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011!\u00022bi\u000eD'BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\u0011QCB\u0001\u0006kRLGn]\u0005\u0003/Q\u0011q\u0004V1cY\u0016\u0004&o\\4sC6\u001c8i\u001c7mK\u000e$\u0018n\u001c8UKN$()Y:f\u0011!I\u0002A!A!\u0002\u0013Q\u0012AC2p]\u001aLw-T8eKB\u00111$\f\b\u00039-r!!\b\u0016\u000f\u0005yIcBA\u0010)\u001d\t\u0001sE\u0004\u0002\"M9\u0011!%J\u0007\u0002G)\u0011A\u0005E\u0001\u0007yI|w\u000e\u001e \n\u0003=I!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0016\r%\u0011A\u0006F\u0001\u0016)\u0006\u0014G.\u001a)s_\u001e\u0014\u0018-\\:UKN$()Y:f\u0013\tqsFA\bUC\ndWmQ8oM&<Wj\u001c3f\u0015\taC\u0003C\u00032\u0001\u0011\u0005!'\u0001\u0004=S:LGO\u0010\u000b\u0003gU\u0002\"\u0001\u000e\u0001\u000e\u0003\tAQ!\u0007\u0019A\u0002iAQa\u000e\u0001\u0005\u0002a\nA\u0002^3tiN\u000bF\nV1cY\u0016$\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\u0005+:LG\u000f\u000b\u00027\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\u00111ID\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u000b\n\u0013A\u0001V3ti\")q\t\u0001C\u0001q\u0005\tB/Z:u)\u0006\u0014G.Z*R\u0019R\u000b'\r\\3)\u0005\u0019\u0003\u0005\"\u0002&\u0001\t\u0003A\u0014A\u0006;fgRlU\u000f\u001c;ja2,7+\u0015'Rk\u0016\u0014\u0018.Z:)\u0005%\u0003\u0005\"B'\u0001\t\u0003A\u0014a\u0007;fgR\u001cV\r\\3di^KG\u000f[\"p[B|7/\u001b;f)f\u0004X\r\u000b\u0002M\u0001\")\u0001\u000b\u0001C\u0001q\u0005IB/Z:u\u0013:\u001cXM\u001d;J]R|W*Z7pef$\u0016M\u00197fQ\ty\u0005\t\u000b\u0003\u0001'fS\u0006C\u0001+X\u001b\u0005)&B\u0001,C\u0003\u0019\u0011XO\u001c8fe&\u0011\u0001,\u0016\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u00010C\u0003\u001d\u0011XO\u001c8feNL!\u0001Y/\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0001")
public class TableEnvironmentITCase
extends TableProgramsCollectionTestBase {
    @Test
    public void testSQLTable() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        tEnv.registerDataSet("MyTable", ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        String sqlQuery = "SELECT * FROM MyTable WHERE a > 9";
        Table result = tEnv.sqlQuery(sqlQuery).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).avg(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).count()}));
        String expected = "15,65,12";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableSQLTable() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table t1 = ds.filter((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(9)));
        tEnv.registerTable("MyTable", t1);
        String sqlQuery = "SELECT avg(a) as a1, sum(b) as b1, count(c) as c1 FROM MyTable";
        Table result = tEnv.sqlQuery(sqlQuery).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")).$plus(package$.MODULE$.int2Literal(1)), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b1")).$minus(package$.MODULE$.int2Literal(5)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c1"))}));
        String expected = "16,60,12";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testMultipleSQLQueries() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("MyTable", t);
        String sqlQuery = "SELECT a as aa FROM MyTable WHERE b = 6";
        Table result1 = tEnv.sqlQuery(sqlQuery);
        tEnv.registerTable("ResTable", result1);
        String sqlQuery2 = "SELECT count(aa) FROM ResTable";
        Table result2 = tEnv.sqlQuery(sqlQuery2);
        String expected = "6";
        Seq results = package$.MODULE$.table2TableConversions(result2).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSelectWithCompositeType() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT MyTable.a2, MyTable.a1._2 FROM MyTable";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcIZ.sp(12, true), (Object)"Hello")}), ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<Tuple2<Object, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Tuple2<Object, Object>, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>>(this, fieldSerializers){

                    public Tuple2<Tuple2<Object, Object>, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((Tuple2)fields[0]), (Object)((String)fields[1]));
                    }

                    public CaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>> createSerializerInstance(Class<Tuple2<Tuple2<Object, Object>, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.runtime.batch.sql.TableEnvironmentITCase$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2"))}));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "Hello,true\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testInsertIntoMemoryTable() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        MemoryTableSourceSinkUtil$.MODULE$.clear();
        Table t = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("sourceTable", t);
        String[] fieldNames = (String[])((Object[])new String[]{"d", "e", "f"});
        TypeInformation[] fieldTypes = tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sourceTable"})).getSchema().getFieldTypes();
        MemoryTableSourceSinkUtil.UnsafeMemoryAppendTableSink sink = new MemoryTableSourceSinkUtil.UnsafeMemoryAppendTableSink();
        tEnv.registerTableSink("targetTable", fieldNames, fieldTypes, (TableSink)sink);
        String sql = "INSERT INTO targetTable SELECT a, b, c FROM sourceTable";
        tEnv.sqlUpdate(sql);
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,Hi", (List)new .colon.colon((Object)"2,2,Hello", (List)new .colon.colon((Object)"3,2,Hello world", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)MemoryTableSourceSinkUtil$.MODULE$.tableDataStrings().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public TableEnvironmentITCase(TableProgramsTestBase.TableConfigMode configMode) {
        super(configMode);
    }
}

