/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch.sql;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.TraversableSerializer;
import org.apache.flink.api.scala.typeutils.TraversableTypeInfo;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.runtime.utils.SortTestUtils$;
import org.apache.flink.table.runtime.utils.TableProgramsClusterTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001#\tQ1k\u001c:u\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u0005)A/\u00192mK*\u00111\u0002D\u0001\u0006M2Lgn\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"BA\u000b\u0007\u0003\u0015)H/\u001b7t\u0013\t9BC\u0001\u000fUC\ndW\r\u0015:pOJ\fWn]\"mkN$XM\u001d+fgR\u0014\u0015m]3\t\u0011e\u0001!\u0011!Q\u0001\ni\tA!\\8eKB\u00111d\f\b\u000391r!!H\u0015\u000f\u0005y9cBA\u0010'\u001d\t\u0001SE\u0004\u0002\"I5\t!E\u0003\u0002$!\u00051AH]8pizJ\u0011aD\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005!R\u0011\u0001\u0002;fgRL!AK\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0003Q)I!!\f\u0018\u000215+H\u000e^5qY\u0016\u0004&o\\4sC6\u001cH+Z:u\u0005\u0006\u001cXM\u0003\u0002+W%\u0011\u0001'\r\u0002\u0012)\u0016\u001cH/\u0012=fGV$\u0018n\u001c8N_\u0012,'BA\u0017/\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014AC2p]\u001aLw-T8eKB\u0011QG\u0010\b\u0003mqr!aN\u001e\u000f\u0005aRdB\u0001\u0010:\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QCB\u0005\u0003{Q\tQ\u0003V1cY\u0016\u0004&o\\4sC6\u001cH+Z:u\u0005\u0006\u001cX-\u0003\u0002@\u0001\nyA+\u00192mK\u000e{gNZ5h\u001b>$WM\u0003\u0002>)!)!\t\u0001C\u0001\u0007\u00061A(\u001b8jiz\"2\u0001\u0012$H!\t)\u0005!D\u0001\u0003\u0011\u0015I\u0012\t1\u0001\u001b\u0011\u0015\u0019\u0014\t1\u00015\u0011\u0015I\u0005\u0001\"\u0003K\u0003]9W\r^#yK\u000e,H/[8o\u000b:4\u0018N]8o[\u0016tG/F\u0001L!\ta\u0015+D\u0001N\u0015\tqu*A\u0003tG\u0006d\u0017M\u0003\u0002Q\u0015\u0005\u0019\u0011\r]5\n\u0005Ik%\u0001F#yK\u000e,H/[8o\u000b:4\u0018N]8o[\u0016tG\u000fC\u0003U\u0001\u0011\u0005Q+\u0001\u0011uKN$xJ\u001d3fe\nKX*\u001e7uSBdWMR5fY\u0012\u001cx+\u001b;i'FdG#\u0001,\u0011\u0005]KV\"\u0001-\u000b\u00039K!A\u0017-\u0003\tUs\u0017\u000e\u001e\u0015\u0003'r\u0003\"!\u00181\u000e\u0003yS!a\u0018\b\u0002\u000b),h.\u001b;\n\u0005\u0005t&\u0001\u0002+fgRDQa\u0019\u0001\u0005\u0002U\u000bQ\u0003^3ti>\u0013H-\u001a:Cs^KG\u000f[(gMN,G\u000f\u000b\u0002c9\")a\r\u0001C\u0001+\u0006iB/Z:u\u001fJ$WM\u001d\"z/&$\bn\u00144gg\u0016$\u0018I\u001c3GKR\u001c\u0007\u000e\u000b\u0002f9\")\u0011\u000e\u0001C\u0001+\u0006\u0001B/Z:u\u001fJ$WM\u001d\"z\u0019&l\u0017\u000e\u001e\u0015\u0003QrCC\u0001\u00017sgB\u0011Q\u000e]\u0007\u0002]*\u0011qNX\u0001\u0007eVtg.\u001a:\n\u0005Et'a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0002iB\u0011Q\u000f_\u0007\u0002m*\u0011qOX\u0001\beVtg.\u001a:t\u0013\tIhOA\u0007QCJ\fW.\u001a;fe&TX\r\u001a")
public class SortITCase
extends TableProgramsClusterTestBase {
    /*
     * WARNING - void declaration
     */
    private ExecutionEnvironment getExecutionEnvironment() {
        void var1_1;
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(3);
        return var1_1;
    }

    @Test
    public void testOrderByMultipleFieldsWithSql() {
        ExecutionEnvironment env = this.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT * FROM MyTable ORDER BY _1 DESC, _2 DESC";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        tEnv.registerDataSet("MyTable", ds);
        String expected = SortTestUtils$.MODULE$.sortExpectedly(SortTestUtils$.MODULE$.tupleDataSetStrings(), (Ordering<Product>)SortITCase.tupleOrdering$1());
        TypeInformation elementTpe = TypeExtractor.createTypeInfo(Row.class);
        Seq results = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).mapPartition((Function1 & Serializable & scala.Serializable)rows -> {
            ArrayBuffer copied = new ArrayBuffer();
            rows.foreach((Function1 & Serializable & scala.Serializable)r -> copied.$plus$eq((Object)Row.copy((Row)r)));
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayBuffer[]{copied}));
        }, (TypeInformation)new TraversableTypeInfo<ArrayBuffer<Row>, Row>(null, elementTpe){
            public final TypeInformation elementTpe$1;

            public TraversableSerializer<ArrayBuffer<Row>, Row> createSerializer(ExecutionConfig executionConfig) {
                return new TraversableSerializer<ArrayBuffer<Row>, Row>(this, executionConfig){

                    public CanBuildFrom<ArrayBuffer<Row>, Row, ArrayBuffer<Row>> getCbf() {
                        return (CanBuildFrom)Predef$.MODULE$.implicitly((Object)ArrayBuffer$.MODULE$.canBuildFrom());
                    }
                };
            }
            {
                this.elementTpe$1 = elementTpe$1;
                super(ArrayBuffer.class, elementTpe$1);
            }
        }, ClassTag$.MODULE$.apply(ArrayBuffer.class)).collect();
        ArrayBuffer result = (ArrayBuffer)((TraversableOnce)((SeqLike)results.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty()))).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> (Row)x$2.head(), SortITCase.rowOrdering$1())).reduceLeft((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> (ArrayBuffer)x$3.$plus$plus((GenTraversableOnce)x$4));
        TestBaseUtils.compareOrderedResultAsText((List)((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)result).asJava()), (String)expected);
    }

    @Test
    public void testOrderByWithOffset() {
        ExecutionEnvironment env = this.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT * FROM MyTable ORDER BY _1 DESC OFFSET 2 ROWS";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        tEnv.registerDataSet("MyTable", ds);
        String expected = SortTestUtils$.MODULE$.sortExpectedly(SortTestUtils$.MODULE$.tupleDataSetStrings(), 2, 21, (Ordering<Product>)SortITCase.tupleOrdering$2());
        TypeInformation elementTpe = TypeExtractor.createTypeInfo(Row.class);
        Seq results = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).mapPartition((Function1 & Serializable & scala.Serializable)rows -> {
            ArrayBuffer copied = new ArrayBuffer();
            rows.foreach((Function1 & Serializable & scala.Serializable)r -> copied.$plus$eq((Object)Row.copy((Row)r)));
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayBuffer[]{copied}));
        }, (TypeInformation)new TraversableTypeInfo<ArrayBuffer<Row>, Row>(null, elementTpe){
            public final TypeInformation elementTpe$2;

            public TraversableSerializer<ArrayBuffer<Row>, Row> createSerializer(ExecutionConfig executionConfig) {
                return new TraversableSerializer<ArrayBuffer<Row>, Row>(this, executionConfig){

                    public CanBuildFrom<ArrayBuffer<Row>, Row, ArrayBuffer<Row>> getCbf() {
                        return (CanBuildFrom)Predef$.MODULE$.implicitly((Object)ArrayBuffer$.MODULE$.canBuildFrom());
                    }
                };
            }
            {
                this.elementTpe$2 = elementTpe$2;
                super(ArrayBuffer.class, elementTpe$2);
            }
        }, ClassTag$.MODULE$.apply(ArrayBuffer.class)).collect();
        ArrayBuffer result = (ArrayBuffer)((TraversableOnce)((SeqLike)results.filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty()))).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> (Row)x$6.head(), package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)SortITCase.$anonfun$testOrderByWithOffset$6(r)), (Ordering)Ordering.Int$.MODULE$))).reduceLeft((Function2 & Serializable & scala.Serializable)(x$7, x$8) -> (ArrayBuffer)x$7.$plus$plus((GenTraversableOnce)x$8));
        TestBaseUtils.compareOrderedResultAsText((List)((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)result).asJava()), (String)expected);
    }

    @Test
    public void testOrderByWithOffsetAndFetch() {
        ExecutionEnvironment env = this.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT * FROM MyTable ORDER BY _1 OFFSET 2 ROWS FETCH NEXT 5 ROWS ONLY";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        tEnv.registerDataSet("MyTable", ds);
        String expected = SortTestUtils$.MODULE$.sortExpectedly(SortTestUtils$.MODULE$.tupleDataSetStrings(), 2, 7, (Ordering<Product>)SortITCase.tupleOrdering$3());
        TypeInformation elementTpe = TypeExtractor.createTypeInfo(Row.class);
        Seq results = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).mapPartition((Function1 & Serializable & scala.Serializable)rows -> {
            ArrayBuffer copied = new ArrayBuffer();
            rows.foreach((Function1 & Serializable & scala.Serializable)r -> copied.$plus$eq((Object)Row.copy((Row)r)));
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayBuffer[]{copied}));
        }, (TypeInformation)new TraversableTypeInfo<ArrayBuffer<Row>, Row>(null, elementTpe){
            public final TypeInformation elementTpe$3;

            public TraversableSerializer<ArrayBuffer<Row>, Row> createSerializer(ExecutionConfig executionConfig) {
                return new TraversableSerializer<ArrayBuffer<Row>, Row>(this, executionConfig){

                    public CanBuildFrom<ArrayBuffer<Row>, Row, ArrayBuffer<Row>> getCbf() {
                        return (CanBuildFrom)Predef$.MODULE$.implicitly((Object)ArrayBuffer$.MODULE$.canBuildFrom());
                    }
                };
            }
            {
                this.elementTpe$3 = elementTpe$3;
                super(ArrayBuffer.class, elementTpe$3);
            }
        }, ClassTag$.MODULE$.apply(ArrayBuffer.class)).collect();
        ArrayBuffer result = (ArrayBuffer)((TraversableOnce)((SeqLike)results.filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isEmpty()))).sortBy((Function1 & Serializable & scala.Serializable)x$10 -> (Row)x$10.head(), package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)SortITCase.$anonfun$testOrderByWithOffsetAndFetch$6(r)), (Ordering)Ordering.Int$.MODULE$))).reduceLeft((Function2 & Serializable & scala.Serializable)(x$11, x$12) -> (ArrayBuffer)x$11.$plus$plus((GenTraversableOnce)x$12));
        TestBaseUtils.compareOrderedResultAsText((List)((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)result).asJava()), (String)expected);
    }

    @Test
    public void testOrderByLimit() {
        ExecutionEnvironment env = this.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT * FROM MyTable ORDER BY _2, _1 LIMIT 5";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        tEnv.registerDataSet("MyTable", ds);
        String expected = SortTestUtils$.MODULE$.sortExpectedly(SortTestUtils$.MODULE$.tupleDataSetStrings(), 0, 5, (Ordering<Product>)SortITCase.tupleOrdering$4());
        TypeInformation elementTpe = TypeExtractor.createTypeInfo(Row.class);
        Seq results = org.apache.flink.table.api.scala.package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).mapPartition((Function1 & Serializable & scala.Serializable)rows -> {
            ArrayBuffer copied = new ArrayBuffer();
            rows.foreach((Function1 & Serializable & scala.Serializable)r -> copied.$plus$eq((Object)Row.copy((Row)r)));
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayBuffer[]{copied}));
        }, (TypeInformation)new TraversableTypeInfo<ArrayBuffer<Row>, Row>(null, elementTpe){
            public final TypeInformation elementTpe$4;

            public TraversableSerializer<ArrayBuffer<Row>, Row> createSerializer(ExecutionConfig executionConfig) {
                return new TraversableSerializer<ArrayBuffer<Row>, Row>(this, executionConfig){

                    public CanBuildFrom<ArrayBuffer<Row>, Row, ArrayBuffer<Row>> getCbf() {
                        return (CanBuildFrom)Predef$.MODULE$.implicitly((Object)ArrayBuffer$.MODULE$.canBuildFrom());
                    }
                };
            }
            {
                this.elementTpe$4 = elementTpe$4;
                super(ArrayBuffer.class, elementTpe$4);
            }
        }, ClassTag$.MODULE$.apply(ArrayBuffer.class)).collect();
        ArrayBuffer result = (ArrayBuffer)((TraversableOnce)((SeqLike)results.filterNot((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isEmpty()))).sortBy((Function1 & Serializable & scala.Serializable)x$14 -> (Row)x$14.head(), SortITCase.rowOrdering$2())).reduceLeft((Function2 & Serializable & scala.Serializable)(x$15, x$16) -> (ArrayBuffer)x$15.$plus$plus((GenTraversableOnce)x$16));
        TestBaseUtils.compareOrderedResultAsText((List)((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)result).asJava()), (String)expected);
    }

    private static final Ordering tupleOrdering$1() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x -> new Tuple2.mcIJ.sp(-BoxesRunTime.unboxToInt((Object)x.productElement(0)), -BoxesRunTime.unboxToLong((Object)x.productElement(1))), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Long$.MODULE$));
    }

    private static final Ordering rowOrdering$1() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)r -> new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)r.getField(0)), BoxesRunTime.unboxToLong((Object)r.getField(1))), SortITCase.tupleOrdering$1());
    }

    public static final /* synthetic */ int $anonfun$testOrderByWithOffset$1(Product x) {
        return -BoxesRunTime.unboxToInt((Object)x.productElement(0));
    }

    private static final Ordering tupleOrdering$2() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)SortITCase.$anonfun$testOrderByWithOffset$1(x)), (Ordering)Ordering.Int$.MODULE$);
    }

    public static final /* synthetic */ int $anonfun$testOrderByWithOffset$6(Row r) {
        return -BoxesRunTime.unboxToInt((Object)r.getField(0));
    }

    public static final /* synthetic */ int $anonfun$testOrderByWithOffsetAndFetch$1(Product x) {
        return BoxesRunTime.unboxToInt((Object)x.productElement(0));
    }

    private static final Ordering tupleOrdering$3() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)SortITCase.$anonfun$testOrderByWithOffsetAndFetch$1(x)), (Ordering)Ordering.Int$.MODULE$);
    }

    public static final /* synthetic */ int $anonfun$testOrderByWithOffsetAndFetch$6(Row r) {
        return BoxesRunTime.unboxToInt((Object)r.getField(0));
    }

    private static final Ordering tupleOrdering$4() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x -> new Tuple2.mcJI.sp(BoxesRunTime.unboxToLong((Object)x.productElement(1)), BoxesRunTime.unboxToInt((Object)x.productElement(0))), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
    }

    private static final Ordering rowOrdering$2() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)r -> new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)r.getField(0)), BoxesRunTime.unboxToLong((Object)r.getField(1))), SortITCase.tupleOrdering$4());
    }

    public SortITCase(MultipleProgramsTestBase.TestExecutionMode mode, TableProgramsTestBase.TableConfigMode configMode) {
        super(mode, configMode);
    }
}

