/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.runtime.batch.sql.SetOperatorsITCase$;
import org.apache.flink.table.runtime.utils.TableProgramsCollectionTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001#\t\u00112+\u001a;Pa\u0016\u0014\u0018\r^8sg&#6)Y:f\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\u000b\t\fGo\u00195\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002 )\u0006\u0014G.\u001a)s_\u001e\u0014\u0018-\\:D_2dWm\u0019;j_:$Vm\u001d;CCN,\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0015\r|gNZ5h\u001b>$W\r\u0005\u0002\u001c[9\u0011Ad\u000b\b\u0003;)r!AH\u0015\u000f\u0005}AcB\u0001\u0011(\u001d\t\tcE\u0004\u0002#K5\t1E\u0003\u0002%!\u00051AH]8pizJ\u0011aD\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)b!\u0003\u0002-)\u0005)B+\u00192mKB\u0013xn\u001a:b[N$Vm\u001d;CCN,\u0017B\u0001\u00180\u0005=!\u0016M\u00197f\u0007>tg-[4N_\u0012,'B\u0001\u0017\u0015\u0011\u0015\t\u0004\u0001\"\u00013\u0003\u0019a\u0014N\\5u}Q\u00111'\u000e\t\u0003i\u0001i\u0011A\u0001\u0005\u00063A\u0002\rA\u0007\u0005\u0006o\u0001!\t\u0001O\u0001\ri\u0016\u001cH/\u00168j_:\fE\u000e\u001c\u000b\u0002sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t!QK\\5uQ\t1\u0004\t\u0005\u0002B\t6\t!I\u0003\u0002D\u001d\u0005)!.\u001e8ji&\u0011QI\u0011\u0002\u0005)\u0016\u001cH\u000fC\u0003H\u0001\u0011\u0005\u0001(A\u0005uKN$XK\\5p]\"\u0012a\t\u0011\u0005\u0006\u0015\u0002!\t\u0001O\u0001\u0014i\u0016\u001cH/\u00168j_:<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0003\u0013\u0002CQ!\u0014\u0001\u0005\u0002a\n\u0001\u0004^3tiVs\u0017n\u001c8XSRD\u0017iZ4sK\u001e\fG/[8oQ\ta\u0005\tC\u0003Q\u0001\u0011\u0005\u0001(\u0001\nuKN$h+\u00197vKN<\u0016\u000e\u001e5DCN$\bFA(A\u0011\u0015\u0019\u0006\u0001\"\u00019\u0003)!Xm\u001d;Fq\u000e,\u0007\u000f\u001e\u0015\u0003%\u0002CQA\u0016\u0001\u0005\u0002a\nQ\u0002^3ti\u0016C8-\u001a9u\u00032d\u0007FA+Y!\t\t\u0015,\u0003\u0002[\u0005\n1\u0011j\u001a8pe\u0016D#!\u0016!\t\u000bu\u0003A\u0011\u0001\u001d\u0002)Q,7\u000f^#yG\u0016\u0004HoV5uQ\u001aKG\u000e^3sQ\ta\u0006\tC\u0003a\u0001\u0011\u0005\u0001(A\u0007uKN$\u0018J\u001c;feN,7\r\u001e\u0015\u0003?\u0002CQa\u0019\u0001\u0005\u0002a\n\u0001\u0003^3ti&sG/\u001a:tK\u000e$\u0018\t\u001c7)\u0005\tD\u0006F\u00012A\u0011\u00159\u0007\u0001\"\u00019\u0003]!Xm\u001d;J]R,'o]3di^KG\u000f\u001b$jYR,'\u000f\u000b\u0002g\u0001\")!\u000e\u0001C\u0001q\u0005\u0001B/Z:u\u0013:<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0003S\u0002CQ!\u001c\u0001\u0005\u0002a\nA\u0003^3ti&sw+\u001b;i!J|'.Z2uS>t\u0007F\u00017AQ\u0011\u0001\u0001O^<\u0011\u0005E$X\"\u0001:\u000b\u0005M\u0014\u0015A\u0002:v]:,'/\u0003\u0002ve\n9!+\u001e8XSRD\u0017!\u0002<bYV,7%\u0001=\u0011\u0005edX\"\u0001>\u000b\u0005m\u0014\u0015a\u0002:v]:,'o]\u0005\u0003{j\u0014Q\u0002U1sC6,G/\u001a:ju\u0016$\u0007")
public class SetOperatorsITCase
extends TableProgramsCollectionTestBase {
    @Test
    public void testUnionAll() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT c FROM t1 UNION ALL (SELECT f FROM t2)";
        DataSet ds1 = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet ds2 = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        tEnv.registerDataSet("t1", ds1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerDataSet("t2", ds2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "Hi\nHello\nHello world\nHi\nHello\nHello world\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUnion() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT c FROM t1 UNION (SELECT f FROM t2)";
        DataSet ds1 = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet ds2 = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        tEnv.registerDataSet("t1", ds1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerDataSet("t2", ds2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "Hi\nHello\nHello world\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUnionWithFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT c FROM (SELECT * FROM t1 UNION ALL (SELECT a, b, c FROM t2))WHERE b < 2";
        DataSet ds1 = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet ds2 = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        tEnv.registerDataSet("t1", ds1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerDataSet("t2", ds2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "Hi\nHallo\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUnionWithAggregation() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT count(c) FROM (SELECT * FROM t1 UNION ALL (SELECT a, b, c FROM t2))";
        DataSet ds1 = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet ds2 = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        tEnv.registerDataSet("t1", ds1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerDataSet("t2", ds2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "18";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testValuesWithCast() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "VALUES (1, cast(1 as BIGINT) ),(2, cast(2 as BIGINT)),(3, cast(3 as BIGINT))";
        Table result = tEnv.sqlQuery(sqlQuery);
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected = "1,1\n2,2\n3,3";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testExcept() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT c FROM t1 EXCEPT (SELECT c FROM t2)";
        DataSet ds1 = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet ds2 = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi")}), ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.runtime.batch.sql.SetOperatorsITCase$$anon$3 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        tEnv.registerDataSet("t1", ds1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerDataSet("t2", ds2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "Hello\nHello world\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Ignore
    @Test
    public void testExceptAll() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT c FROM t1 EXCEPT ALL SELECT c FROM t2";
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 2}));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        DataSet ds1 = env.fromCollection((Iterable)data1, ClassTag$.MODULE$.Int(), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        DataSet ds2 = env.fromCollection((Iterable)data2, ClassTag$.MODULE$.Int(), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        tEnv.registerDataSet("t1", ds1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerDataSet("t2", ds2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "1\n1";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testExceptWithFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT c FROM (SELECT * FROM t1 EXCEPT (SELECT a, b, c FROM t2))WHERE b < 2";
        DataSet ds1 = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet ds2 = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        tEnv.registerDataSet("t1", ds1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerDataSet("t2", ds2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "Hi\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersect() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT c FROM t1 INTERSECT SELECT c FROM t2";
        DataSet ds1 = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hello"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hello"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hello world!"));
        DataSet ds2 = env.fromCollection((Iterable)Random$.MODULE$.shuffle((TraversableOnce)data, MutableList$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.runtime.batch.sql.SetOperatorsITCase$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        tEnv.registerDataSet("t1", ds1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerDataSet("t2", ds2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "Hi\nHello\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Ignore
    @Test
    public void testIntersectAll() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT c FROM t1 INTERSECT ALL SELECT c FROM t2";
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 2}));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        DataSet ds1 = env.fromCollection((Iterable)data1, ClassTag$.MODULE$.Int(), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        DataSet ds2 = env.fromCollection((Iterable)data2, ClassTag$.MODULE$.Int(), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        tEnv.registerDataSet("t1", ds1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerDataSet("t2", ds2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "1\n2\n2";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersectWithFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT c FROM ((SELECT * FROM t1) INTERSECT (SELECT * FROM t2)) WHERE a > 1";
        DataSet ds1 = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet ds2 = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        tEnv.registerDataSet("t1", ds1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerDataSet("t2", ds2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "Hello\nHello world\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testInWithFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        tEnv.registerTable("Table3", ds1);
        tEnv.registerTable("Table5", ds2);
        Table result = tEnv.sqlQuery("SELECT d FROM Table5 WHERE d IN (SELECT a FROM Table3)");
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "2", "3", "3", "3"}))).mkString("\n");
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testInWithProjection() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        tEnv.registerTable("Table3", ds1);
        tEnv.registerTable("Table5", ds2);
        Table result = tEnv.sqlQuery("SELECT d IN (SELECT a FROM Table3) FROM Table5");
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"false", "false", "false", "false", "false", "false", "false", "false", "false", "true", "true", "true", "true", "true", "true"}))).mkString("\n");
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    public SetOperatorsITCase(TableProgramsTestBase.TableConfigMode configMode) {
        super(configMode);
    }
}

