/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.runtime.batch.sql.JoinITCase$;
import org.apache.flink.table.runtime.batch.sql.JoinITCase$$anon$6$;
import org.apache.flink.table.runtime.utils.TableProgramsCollectionTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u0001E\u0011!BS8j]&#6)Y:f\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\u000b\t\fGo\u00195\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002 )\u0006\u0014G.\u001a)s_\u001e\u0014\u0018-\\:D_2dWm\u0019;j_:$Vm\u001d;CCN,\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0015\r|gNZ5h\u001b>$W\r\u0005\u0002\u001c[9\u0011Ad\u000b\b\u0003;)r!AH\u0015\u000f\u0005}AcB\u0001\u0011(\u001d\t\tcE\u0004\u0002#K5\t1E\u0003\u0002%!\u00051AH]8pizJ\u0011aD\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)b!\u0003\u0002-)\u0005)B+\u00192mKB\u0013xn\u001a:b[N$Vm\u001d;CCN,\u0017B\u0001\u00180\u0005=!\u0016M\u00197f\u0007>tg-[4N_\u0012,'B\u0001\u0017\u0015\u0011\u0015\t\u0004\u0001\"\u00013\u0003\u0019a\u0014N\\5u}Q\u00111'\u000e\t\u0003i\u0001i\u0011A\u0001\u0005\u00063A\u0002\rA\u0007\u0005\u0006o\u0001!\t\u0001O\u0001\u000ei\u0016\u001cH/\u00138oKJTu.\u001b8\u0015\u0003e\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012A!\u00168ji\"\u0012a\u0007\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007:\tQA[;oSRL!!\u0012\"\u0003\tQ+7\u000f\u001e\u0005\u0006\u000f\u0002!\t\u0001O\u0001\u0018i\u0016\u001cH/\u00138oKJTu.\u001b8XSRDg)\u001b7uKJD#A\u0012!\t\u000b)\u0003A\u0011\u0001\u001d\u0002KQ,7\u000f^%o]\u0016\u0014(j\\5o/&$\bNT8o\u000bF,\u0018NS8j]B\u0013X\rZ5dCR,\u0007FA%A\u0011\u0015i\u0005\u0001\"\u00019\u0003u!Xm\u001d;J]:,'OS8j]^KG\u000f['vYRL\u0007\u000f\\3LKf\u001c\bF\u0001'A\u0011\u0015\u0001\u0006\u0001\"\u00019\u0003Y!Xm\u001d;J]:,'OS8j]^KG\u000f[!mS\u0006\u001c\bFA(A\u0011\u0015\u0019\u0006\u0001\"\u00019\u0003q!Xm\u001d;J]:,'OS8j]^KG\u000f[!hOJ,w-\u0019;j_:D#A\u0015!\t\u000bY\u0003A\u0011\u0001\u001d\u0002;Q,7\u000f^%o]\u0016\u0014(j\\5o/&$\b.Q4he\u0016<\u0017\r^5p]JB#!\u0016!\t\u000be\u0003A\u0011\u0001\u001d\u0002#Q,7\u000f\u001e$vY2|U\u000f^3s\u0015>Lg\u000e\u000b\u0002Y\u0001\")A\f\u0001C\u0001q\u0005\tB/Z:u\u0019\u00164GoT;uKJTu.\u001b8)\u0005m\u0003\u0005\"B0\u0001\t\u0003A\u0014A\u0005;fgR\u0014\u0016n\u001a5u\u001fV$XM\u001d&pS:D#A\u0018!\t\u000b\t\u0004A\u0011\u0001\u001d\u0002GQ,7\u000f^\"s_N\u001c(j\\5o/&$\b\u000eT3giNKgn\u001a7f%><\u0018J\u001c9vi\"\u0012\u0011\r\u0011\u0005\u0006K\u0002!\t\u0001O\u0001%i\u0016\u001cHo\u0011:pgNTu.\u001b8XSRD'+[4iiNKgn\u001a7f%><\u0018J\u001c9vi\"\u0012A\r\u0011\u0005\u0006Q\u0002!\t\u0001O\u0001%i\u0016\u001cHo\u0011:pgNTu.\u001b8XSRDW)\u001c9usNKgn\u001a7f%><\u0018J\u001c9vi\"\u0012q\r\u0011\u0005\u0006W\u0002!\t\u0001O\u0001\u0016i\u0016\u001cH\u000fT3gi:+H\u000e\u001c*jO\"$(j\\5oQ\tQ\u0007\tC\u0003o\u0001\u0011\u0005\u0001(A\u0013uKN$H*\u001a4u'&tw\r\\3SS\u001eDGOS8j]\u0016\u000bX/\u00197Qe\u0016$\u0017nY1uK\"\u0012Q\u000e\u0011\u0005\u0006c\u0002!\t\u0001O\u0001)i\u0016\u001cH\u000fT3giNKgn\u001a7f%&<\u0007\u000e\u001e&pS:tu\u000e^#rk\u0006d\u0007K]3eS\u000e\fG/\u001a\u0015\u0003a\u0002CQ\u0001\u001e\u0001\u0005\u0002a\nQ\u0003^3tiJKw\r\u001b;Ok2dG*\u001a4u\u0015>Lg\u000e\u000b\u0002t\u0001\")q\u000f\u0001C\u0001q\u0005)C/Z:u%&<\u0007\u000e^*j]\u001edW\rT3gi*{\u0017N\\#rk\u0006d\u0007K]3eS\u000e\fG/\u001a\u0015\u0003m\u0002CQA\u001f\u0001\u0005\u0002a\n\u0001\u0006^3tiJKw\r\u001b;TS:<G.\u001a'fMRTu.\u001b8O_R,\u0015/^1m!J,G-[2bi\u0016D#!\u001f!\t\u000bu\u0004A\u0011\u0001\u001d\u0002AQ,7\u000f\u001e*jO\"$8+\u001b8hY\u0016dUM\u001a;K_&tGk^8GS\u0016dGm\u001d\u0015\u0003y\u0002Ca!!\u0001\u0001\t\u0003A\u0014a\u0005;fgR\u001c%o\\:t/&$\b.\u00168oKN$\bFA@A\u0011\u0019\t9\u0001\u0001C\u0001q\u0005IB/Z:u\u0015>LgnV5uQVsg.Z:u\u001f\u001a$V\u000f\u001d7fQ\r\t)\u0001\u0011\u0015\b\u0001\u00055\u0011\u0011DA\u000e!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\n\u0005\u00061!/\u001e8oKJLA!a\u0006\u0002\u0012\t9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA\u000f!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012\u0005\u00069!/\u001e8oKJ\u001c\u0018\u0002BA\u0014\u0003C\u0011Q\u0002U1sC6,G/\u001a:ju\u0016$\u0007")
public class JoinITCase
extends TableProgramsCollectionTestBase {
    @Test
    public void testInnerJoin() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT c, g FROM Table3, Table5 WHERE b = e";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        tEnv.registerTable("Table3", ds1);
        tEnv.registerTable("Table5", ds2);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testInnerJoinWithFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT c, g FROM Table3, Table5 WHERE b = e AND b < 2";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        tEnv.registerTable("Table3", ds1);
        tEnv.registerTable("Table5", ds2);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "Hi,Hallo\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testInnerJoinWithNonEquiJoinPredicate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT c, g FROM Table3, Table5 WHERE b = e AND a < 6 AND h < b";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        tEnv.registerTable("Table3", ds1);
        tEnv.registerTable("Table5", ds2);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "Hello world, how are you?,Hallo Welt wie\nI am fine.,Hallo Welt wie\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testInnerJoinWithMultipleKeys() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT c, g FROM Table3, Table5 WHERE a = d AND b = h";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        tEnv.registerTable("Table3", ds1);
        tEnv.registerTable("Table5", ds2);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nI am fine.,HIJ\nI am fine.,IJK\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testInnerJoinWithAlias() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT Table5.c, T.`1-_./\u00dc` FROM (SELECT a, b, c AS `1-_./\u00dc` FROM Table3) AS T, Table5 WHERE a = d AND a < 4";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("Table3", ds1);
        tEnv.registerTable("Table5", ds2);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "1,Hi\n2,Hello\n1,Hello\n2,Hello world\n2,Hello world\n3,Hello world\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testInnerJoinWithAggregation() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT COUNT(g), COUNT(b) FROM Table3, Table5 WHERE a = d";
        DataSet ds1 = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet ds2 = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        tEnv.registerDataSet("Table3", ds1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerDataSet("Table5", ds2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "6,6";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testInnerJoinWithAggregation2() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT COUNT(b), COUNT(g) FROM Table3, Table5 WHERE a = d";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        tEnv.registerTable("Table3", ds1);
        tEnv.registerTable("Table5", ds2);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "6,6";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFullOuterJoin() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        tEnv.getConfig().setNullCheck(true);
        String sqlQuery = "SELECT c, g FROM Table3 FULL OUTER JOIN Table5 ON b = e";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        tEnv.registerTable("Table3", ds1);
        tEnv.registerTable("Table5", ds2);
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\nnull,Hallo Welt wie\nnull,Hallo Welt wie gehts?\nnull,ABC\nnull,BCD\nnull,CDE\nnull,DEF\nnull,EFG\nnull,FGH\nnull,GHI\nnull,HIJ\nnull,IJK\nnull,JKL\nnull,KLM";
        Seq results = package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLeftOuterJoin() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        tEnv.getConfig().setNullCheck(true);
        String sqlQuery = "SELECT c, g FROM Table5 LEFT OUTER JOIN Table3 ON b = e";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        tEnv.registerTable("Table3", ds1);
        tEnv.registerTable("Table5", ds2);
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\nnull,Hallo Welt wie\nnull,Hallo Welt wie gehts?\nnull,ABC\nnull,BCD\nnull,CDE\nnull,DEF\nnull,EFG\nnull,FGH\nnull,GHI\nnull,HIJ\nnull,IJK\nnull,JKL\nnull,KLM";
        Seq results = package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRightOuterJoin() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        tEnv.getConfig().setNullCheck(true);
        String sqlQuery = "SELECT c, g FROM Table3 RIGHT OUTER JOIN Table5 ON b = e";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        tEnv.registerTable("Table3", ds1);
        tEnv.registerTable("Table5", ds2);
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\nnull,Hallo Welt wie\nnull,Hallo Welt wie gehts?\nnull,ABC\nnull,BCD\nnull,CDE\nnull,DEF\nnull,EFG\nnull,FGH\nnull,GHI\nnull,HIJ\nnull,IJK\nnull,JKL\nnull,KLM";
        Seq results = package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCrossJoinWithLeftSingleRowInput() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table table = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a3"))}));
        tEnv.registerTable("A", table);
        String sqlQuery2 = "SELECT * FROM (SELECT count(*) FROM A) CROSS JOIN A";
        String expected = "3,1,1,Hi\n3,2,2,Hello\n3,3,2,Hello world";
        Seq result = package$.MODULE$.table2RowDataSet(tEnv.sqlQuery(sqlQuery2)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    @Test
    public void testCrossJoinWithRightSingleRowInput() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table table = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a3"))}));
        tEnv.registerTable("A", table);
        String sqlQuery1 = "SELECT * FROM A CROSS JOIN (SELECT count(*) FROM A)";
        String expected = "1,1,Hi,3\n2,2,Hello,3\n3,2,Hello world,3";
        Seq result = package$.MODULE$.table2RowDataSet(tEnv.sqlQuery(sqlQuery1)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    @Test
    public void testCrossJoinWithEmptySingleRowInput() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        Table table = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a3"))}));
        tEnv.registerTable("A", table);
        String sqlQuery1 = "SELECT * FROM A CROSS JOIN (SELECT count(*) FROM A HAVING count(*) < 0)";
        long result = package$.MODULE$.table2RowDataSet(tEnv.sqlQuery(sqlQuery1)).count();
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testLeftNullRightJoin() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT a, cnt FROM (SELECT cnt FROM (SELECT COUNT(*) AS cnt FROM B) WHERE cnt < 0) RIGHT JOIN A ON a < cnt";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("A", ds1);
        tEnv.registerTable("B", ds2);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,null", "2,null", "2,null", "3,null", "3,null", "3,null", "4,null", "4,null", "4,null", "4,null", "5,null", "5,null", "5,null", "5,null", "5,null"}))).mkString("\n");
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLeftSingleRightJoinEqualPredicate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT a, cnt FROM (SELECT COUNT(*) AS cnt FROM B) RIGHT JOIN A ON cnt = a";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("A", ds1);
        tEnv.registerTable("B", ds2);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,null", "2,null", "2,null", "3,3", "3,3", "3,3", "4,null", "4,null", "4,null", "4,null", "5,null", "5,null", "5,null", "5,null", "5,null"}))).mkString("\n");
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLeftSingleRightJoinNotEqualPredicate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT a, cnt FROM (SELECT COUNT(*) AS cnt FROM B) RIGHT JOIN A ON cnt > a";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("A", ds1);
        tEnv.registerTable("B", ds2);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,3", "2,3", "2,3", "3,null", "3,null", "3,null", "4,null", "4,null", "4,null", "4,null", "5,null", "5,null", "5,null", "5,null", "5,null"}))).mkString("\n");
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRightNullLeftJoin() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT a, cnt FROM A LEFT JOIN (SELECT cnt FROM (SELECT COUNT(*) AS cnt FROM B) WHERE cnt < 0) ON cnt > a";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("A", ds2);
        tEnv.registerTable("B", ds1);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,null", "3,null", "1,null"}))).mkString("\n");
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRightSingleLeftJoinEqualPredicate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT a, cnt FROM A LEFT JOIN (SELECT COUNT(*) AS cnt FROM B) ON cnt = a";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("A", ds1);
        tEnv.registerTable("B", ds2);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,null", "2,null", "2,null", "3,3", "3,3", "3,3", "4,null", "4,null", "4,null", "4,null", "5,null", "5,null", "5,null", "5,null", "5,null"}))).mkString("\n");
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRightSingleLeftJoinNotEqualPredicate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT a, cnt FROM A LEFT JOIN (SELECT COUNT(*) AS cnt FROM B) ON cnt < a";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("A", ds1);
        tEnv.registerTable("B", ds2);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,null", "2,null", "2,null", "3,null", "3,null", "3,null", "4,3", "4,3", "4,3", "4,3", "5,3", "5,3", "5,3", "5,3", "5,3"}))).mkString("\n");
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRightSingleLeftJoinTwoFields() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT a, cnt, cnt2 FROM t1 LEFT JOIN (SELECT COUNT(*) AS cnt,COUNT(*) AS cnt2 FROM t2 ) AS x ON a = cnt";
        Table ds1 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get5TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}));
        Table ds2 = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("t1", ds1);
        tEnv.registerTable("t2", ds2);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,null,null", "2,null,null", "2,null,null", "3,3,3", "3,3,3", "3,3,3", "4,null,null", "4,null,null", "4,null,null", "4,null,null", "5,null,null", "5,null,null", "5,null,null", "5,null,null", "5,null,null"}))).mkString("\n");
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCrossWithUnnest() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        .colon.colon data = new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)new String[]{"Hi", "w"}), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)new String[]{"Hello", "k"}), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)new String[]{"Hello world", "x"}), (List)Nil$.MODULE$)));
        DataSet stream = env.fromCollection((Iterable)data, ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String[]>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String[]>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String[]>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String[]> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String[])fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String[]>> createSerializerInstance(Class<Tuple3<Object, Object, String[]>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.runtime.batch.sql.JoinITCase$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        tEnv.registerDataSet("T", stream, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        String sqlQuery = "SELECT a, s FROM T, UNNEST(T.c) as A (s)";
        Table result = tEnv.sqlQuery(sqlQuery);
        .colon.colon expected = new .colon.colon((Object)"1,Hi", (List)new .colon.colon((Object)"1,w", (List)new .colon.colon((Object)"2,Hello", (List)new .colon.colon((Object)"2,k", (List)new .colon.colon((Object)"3,Hello world", (List)new .colon.colon((Object)"3,x", (List)Nil$.MODULE$))))));
        List results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect().toList();
        Assert.assertEquals((Object)expected.toString(), (Object)((SeqLike)results.sortWith((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)JoinITCase.$anonfun$testCrossWithUnnest$1(x$1, x$2)))).toString());
    }

    @Test
    public void testJoinWithUnnestOfTuple() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        .colon.colon data = new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)12), (Object)"45.6"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"45.612")}), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)13), (Object)"41.6"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"45.2136")}), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)18), (Object)"42.6")}), (List)Nil$.MODULE$)));
        DataSet stream = env.fromCollection((Iterable)data, ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Tuple2<Object, String>[]>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Tuple2<Object, String>[]>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Object, Tuple2<Object, String>[]>>(this, fieldSerializers){

                    public Tuple2<Object, Tuple2<Object, String>[]> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((Tuple2[])fields[1]));
                    }

                    public CaseClassSerializer<Tuple2<Object, Tuple2<Object, String>[]>> createSerializerInstance(Class<Tuple2<Object, Tuple2<Object, String>[]>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }
            {
                Object object;
                CaseClassTypeInfo<Tuple2<Object, String>> elementType;
                Object object2;
                CaseClassTypeInfo<Tuple2<Object, String>> elementType2;
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.getInfoFor(Integer.TYPE);
                CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo = elementType2 = new CaseClassTypeInfo<Tuple2<Object, String>>(null){

                    public /* synthetic */ TypeInformation[] protected$types($anon$6$$anon$7 x$1) {
                        return x$1.types;
                    }

                    public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                        TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                            fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                        });
                        return new CaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                            public Tuple2<Object, String> createInstance(Object[] fields) {
                                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                            }

                            public CaseClassSerializer<Tuple2<Object, String>> createSerializerInstance(Class<Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                                return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                            }
                        };
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.runtime.batch.sql.JoinITCase$$anon$6$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                    }
                };
                BasicTypeInfo basicTypeInfo2 = BasicTypeInfo.BOOLEAN_TYPE_INFO;
                CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo2 = caseClassTypeInfo;
                if (!(basicTypeInfo2 != null ? !basicTypeInfo2.equals(caseClassTypeInfo2) : caseClassTypeInfo2 != null)) {
                    object2 = PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO;
                } else {
                    BasicTypeInfo basicTypeInfo3 = BasicTypeInfo.BYTE_TYPE_INFO;
                    CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo3 = caseClassTypeInfo;
                    if (!(basicTypeInfo3 != null ? !basicTypeInfo3.equals(caseClassTypeInfo3) : caseClassTypeInfo3 != null)) {
                        object2 = PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
                    } else {
                        BasicTypeInfo basicTypeInfo4 = BasicTypeInfo.CHAR_TYPE_INFO;
                        CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo4 = caseClassTypeInfo;
                        if (!(basicTypeInfo4 != null ? !basicTypeInfo4.equals(caseClassTypeInfo4) : caseClassTypeInfo4 != null)) {
                            object2 = PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO;
                        } else {
                            BasicTypeInfo basicTypeInfo5 = BasicTypeInfo.DOUBLE_TYPE_INFO;
                            CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo5 = caseClassTypeInfo;
                            if (!(basicTypeInfo5 != null ? !basicTypeInfo5.equals(caseClassTypeInfo5) : caseClassTypeInfo5 != null)) {
                                object2 = PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO;
                            } else {
                                BasicTypeInfo basicTypeInfo6 = BasicTypeInfo.FLOAT_TYPE_INFO;
                                CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo6 = caseClassTypeInfo;
                                if (!(basicTypeInfo6 != null ? !basicTypeInfo6.equals(caseClassTypeInfo6) : caseClassTypeInfo6 != null)) {
                                    object2 = PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO;
                                } else {
                                    BasicTypeInfo basicTypeInfo7 = BasicTypeInfo.INT_TYPE_INFO;
                                    CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo7 = caseClassTypeInfo;
                                    if (!(basicTypeInfo7 != null ? !basicTypeInfo7.equals(caseClassTypeInfo7) : caseClassTypeInfo7 != null)) {
                                        object2 = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
                                    } else {
                                        BasicTypeInfo basicTypeInfo8 = BasicTypeInfo.LONG_TYPE_INFO;
                                        CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo8 = caseClassTypeInfo;
                                        if (!(basicTypeInfo8 != null ? !basicTypeInfo8.equals(caseClassTypeInfo8) : caseClassTypeInfo8 != null)) {
                                            object2 = PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO;
                                        } else {
                                            BasicTypeInfo basicTypeInfo9 = BasicTypeInfo.SHORT_TYPE_INFO;
                                            CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo9 = caseClassTypeInfo;
                                            if (!(basicTypeInfo9 != null ? !basicTypeInfo9.equals(caseClassTypeInfo9) : caseClassTypeInfo9 != null)) {
                                                object2 = PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO;
                                            } else {
                                                BasicTypeInfo basicTypeInfo10 = BasicTypeInfo.STRING_TYPE_INFO;
                                                CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo10 = caseClassTypeInfo;
                                                object2 = !(basicTypeInfo10 != null ? !basicTypeInfo10.equals(caseClassTypeInfo10) : caseClassTypeInfo10 != null) ? BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO : ObjectArrayTypeInfo.getInfoFor((TypeInformation)elementType2);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                PrimitiveArrayTypeInfo result = object2;
                TypeInformation[] typeInformationArray = (TypeInformation[])new .colon.colon((Object)basicTypeInfo, (List)new .colon.colon((Object)result, (List)Nil$.MODULE$)).toArray((ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(TypeInformation.class)));
                BasicTypeInfo basicTypeInfo11 = BasicTypeInfo.getInfoFor(Integer.TYPE);
                CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo11 = elementType = new CaseClassTypeInfo<Tuple2<Object, String>>(null){

                    public /* synthetic */ TypeInformation[] protected$types($anon$6$$anon$8 x$1) {
                        return x$1.types;
                    }

                    public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                        TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                            fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                        });
                        return new CaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                            public Tuple2<Object, String> createInstance(Object[] fields) {
                                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                            }

                            public CaseClassSerializer<Tuple2<Object, String>> createSerializerInstance(Class<Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                                return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                            }
                        };
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.runtime.batch.sql.JoinITCase$$anon$6$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                    }
                };
                BasicTypeInfo basicTypeInfo12 = BasicTypeInfo.BOOLEAN_TYPE_INFO;
                CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo12 = caseClassTypeInfo11;
                if (!(basicTypeInfo12 != null ? !basicTypeInfo12.equals(caseClassTypeInfo12) : caseClassTypeInfo12 != null)) {
                    object = PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO;
                } else {
                    BasicTypeInfo basicTypeInfo13 = BasicTypeInfo.BYTE_TYPE_INFO;
                    CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo13 = caseClassTypeInfo11;
                    if (!(basicTypeInfo13 != null ? !basicTypeInfo13.equals(caseClassTypeInfo13) : caseClassTypeInfo13 != null)) {
                        object = PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
                    } else {
                        BasicTypeInfo basicTypeInfo14 = BasicTypeInfo.CHAR_TYPE_INFO;
                        CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo14 = caseClassTypeInfo11;
                        if (!(basicTypeInfo14 != null ? !basicTypeInfo14.equals(caseClassTypeInfo14) : caseClassTypeInfo14 != null)) {
                            object = PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO;
                        } else {
                            BasicTypeInfo basicTypeInfo15 = BasicTypeInfo.DOUBLE_TYPE_INFO;
                            CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo15 = caseClassTypeInfo11;
                            if (!(basicTypeInfo15 != null ? !basicTypeInfo15.equals(caseClassTypeInfo15) : caseClassTypeInfo15 != null)) {
                                object = PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO;
                            } else {
                                BasicTypeInfo basicTypeInfo16 = BasicTypeInfo.FLOAT_TYPE_INFO;
                                CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo16 = caseClassTypeInfo11;
                                if (!(basicTypeInfo16 != null ? !basicTypeInfo16.equals(caseClassTypeInfo16) : caseClassTypeInfo16 != null)) {
                                    object = PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO;
                                } else {
                                    BasicTypeInfo basicTypeInfo17 = BasicTypeInfo.INT_TYPE_INFO;
                                    CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo17 = caseClassTypeInfo11;
                                    if (!(basicTypeInfo17 != null ? !basicTypeInfo17.equals(caseClassTypeInfo17) : caseClassTypeInfo17 != null)) {
                                        object = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
                                    } else {
                                        BasicTypeInfo basicTypeInfo18 = BasicTypeInfo.LONG_TYPE_INFO;
                                        CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo18 = caseClassTypeInfo11;
                                        if (!(basicTypeInfo18 != null ? !basicTypeInfo18.equals(caseClassTypeInfo18) : caseClassTypeInfo18 != null)) {
                                            object = PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO;
                                        } else {
                                            BasicTypeInfo basicTypeInfo19 = BasicTypeInfo.SHORT_TYPE_INFO;
                                            CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo19 = caseClassTypeInfo11;
                                            if (!(basicTypeInfo19 != null ? !basicTypeInfo19.equals(caseClassTypeInfo19) : caseClassTypeInfo19 != null)) {
                                                object = PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO;
                                            } else {
                                                BasicTypeInfo basicTypeInfo20 = BasicTypeInfo.STRING_TYPE_INFO;
                                                CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo20 = caseClassTypeInfo11;
                                                object = !(basicTypeInfo20 != null ? !basicTypeInfo20.equals(caseClassTypeInfo20) : caseClassTypeInfo20 != null) ? BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO : ObjectArrayTypeInfo.getInfoFor((TypeInformation)elementType);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                PrimitiveArrayTypeInfo result2 = object;
                super(Tuple2.class, typeInformationArray, (Seq)new .colon.colon((Object)basicTypeInfo11, (List)new .colon.colon((Object)result2, (List)Nil$.MODULE$)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_1", "_2"})));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.runtime.batch.sql.JoinITCase$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        tEnv.registerDataSet("T", stream, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        String sqlQuery = "SELECT a, b, x, y FROM   (SELECT a, b FROM T WHERE a < 3) as tf,   UNNEST(tf.b) as A (x, y) WHERE x > a";
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = new .colon.colon((Object)"1,[(12,45.6), (2,45.612)],12,45.6", (List)new .colon.colon((Object)"1,[(12,45.6), (2,45.612)],2,45.612", (List)new .colon.colon((Object)"2,[(13,41.6), (1,45.2136)],13,41.6", (List)Nil$.MODULE$))).mkString(", ");
        Seq results = (Seq)package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)expected, (Object)((TraversableOnce)results.sorted((Ordering)Ordering.String$.MODULE$)).mkString(", "));
    }

    public static final /* synthetic */ boolean $anonfun$testCrossWithUnnest$1(Row x$1, Row x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.toString())).$less((Object)x$2.toString());
    }

    public JoinITCase(TableProgramsTestBase.TableConfigMode configMode) {
        super(configMode);
    }
}

