/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.java.BatchTableEnvironment;
import org.apache.flink.table.runtime.utils.TableProgramsCollectionTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.test.operators.util.CollectionDataSets;
import org.apache.flink.types.Row;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JavaSqlITCase
extends TableProgramsCollectionTestBase {
    public JavaSqlITCase(TableProgramsTestBase.TableConfigMode configMode) {
        super(configMode);
    }

    @Test
    public void testValues() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        String sqlQuery = "VALUES (1, 'Test', TRUE, DATE '1944-02-24', 12.4444444444444445),(2, 'Hello', TRUE, DATE '1944-02-24', 12.666666665),(3, 'World', FALSE, DATE '1944-12-24', 12.54444445)";
        Table result = tableEnv.sqlQuery(sqlQuery);
        DataSet resultSet = tableEnv.toDataSet(result, Row.class);
        List results = resultSet.collect();
        String expected = "3,World,false,1944-12-24,12.5444444500000000\n2,Hello,true,1944-02-24,12.6666666650000000\n1,Test ,true,1944-02-24,12.4444444444444445\n";
        JavaSqlITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testSelectFromTable() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        DataSet ds = CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env);
        Table in = tableEnv.fromDataSet(ds, "a,b,c");
        tableEnv.registerTable("T", in);
        String sqlQuery = "SELECT a, c FROM T";
        Table result = tableEnv.sqlQuery(sqlQuery);
        DataSet resultSet = tableEnv.toDataSet(result, Row.class);
        List results = resultSet.collect();
        String expected = "1,Hi\n2,Hello\n3,Hello world\n4,Hello world, how are you?\n5,I am fine.\n6,Luke Skywalker\n7,Comment#1\n8,Comment#2\n9,Comment#3\n10,Comment#4\n11,Comment#5\n12,Comment#6\n13,Comment#7\n14,Comment#8\n15,Comment#9\n16,Comment#10\n17,Comment#11\n18,Comment#12\n19,Comment#13\n20,Comment#14\n21,Comment#15\n";
        JavaSqlITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testFilterFromDataSet() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        DataSet ds = CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env);
        tableEnv.registerDataSet("DataSetTable", ds, "x, y, z");
        String sqlQuery = "SELECT x FROM DataSetTable WHERE z LIKE '%Hello%'";
        Table result = tableEnv.sqlQuery(sqlQuery);
        DataSet resultSet = tableEnv.toDataSet(result, Row.class);
        List results = resultSet.collect();
        String expected = "2\n3\n4";
        JavaSqlITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testAggregation() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        DataSet ds = CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env);
        tableEnv.registerDataSet("AggTable", ds, "x, y, z");
        String sqlQuery = "SELECT sum(x), min(x), max(x), count(y), avg(x) FROM AggTable";
        Table result = tableEnv.sqlQuery(sqlQuery);
        DataSet resultSet = tableEnv.toDataSet(result, Row.class);
        List results = resultSet.collect();
        String expected = "231,1,21,21,11";
        JavaSqlITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testJoin() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        DataSet ds1 = CollectionDataSets.getSmall3TupleDataSet((ExecutionEnvironment)env);
        DataSet ds2 = CollectionDataSets.get5TupleDataSet((ExecutionEnvironment)env);
        tableEnv.registerDataSet("t1", ds1, "a, b, c");
        tableEnv.registerDataSet("t2", ds2, "d, e, f, g, h");
        String sqlQuery = "SELECT c, g FROM t1, t2 WHERE b = e";
        Table result = tableEnv.sqlQuery(sqlQuery);
        DataSet resultSet = tableEnv.toDataSet(result, Row.class);
        List results = resultSet.collect();
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\n";
        JavaSqlITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testMap() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        ArrayList<Tuple2> rows = new ArrayList<Tuple2>();
        rows.add(new Tuple2((Object)1, Collections.singletonMap("foo", "bar")));
        rows.add(new Tuple2((Object)2, Collections.singletonMap("foo", "spam")));
        TupleTypeInfo ty = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, new MapTypeInfo((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO)});
        DataSource ds1 = env.fromCollection(rows, (TypeInformation)ty);
        tableEnv.registerDataSet("t1", (DataSet)ds1, "a, b");
        String sqlQuery = "SELECT b['foo'] FROM t1";
        Table result = tableEnv.sqlQuery(sqlQuery);
        DataSet resultSet = tableEnv.toDataSet(result, Row.class);
        List results = resultSet.collect();
        String expected = "bar\nspam\n";
        JavaSqlITCase.compareResultAsText((List)results, (String)expected);
    }
}

