/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch.sql;

import java.util.Comparator;
import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.java.BatchTableEnvironment;
import org.apache.flink.table.runtime.utils.TableProgramsClusterTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.test.operators.util.CollectionDataSets;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupingSetsITCase
extends TableProgramsClusterTestBase {
    private static final String TABLE_NAME = "MyTable";
    private static final String TABLE_WITH_NULLS_NAME = "MyTableWithNulls";
    private BatchTableEnvironment tableEnv;

    public GroupingSetsITCase(MultipleProgramsTestBase.TestExecutionMode mode, TableProgramsTestBase.TableConfigMode tableConfigMode) {
        super(mode, tableConfigMode);
    }

    @Before
    public void setupTables() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)new TableConfig());
        DataSet dataSet = CollectionDataSets.get3TupleDataSet((ExecutionEnvironment)env);
        this.tableEnv.registerDataSet(TABLE_NAME, dataSet);
        MapOperator dataSetWithNulls = dataSet.map((MapFunction)new MapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>>(){

            public Tuple3<Integer, Long, String> map(Tuple3<Integer, Long, String> value) throws Exception {
                if (((String)value.f2).toLowerCase().contains("world")) {
                    value.f2 = null;
                }
                return value;
            }
        });
        this.tableEnv.registerDataSet(TABLE_WITH_NULLS_NAME, (DataSet)dataSetWithNulls);
    }

    @Test
    public void testGroupingSets() throws Exception {
        String query = "SELECT f1, f2, avg(f0) as a, GROUP_ID() as g,  GROUPING(f1) as gf1, GROUPING(f2) as gf2,  GROUPING_ID(f1) as gif1, GROUPING_ID(f2) as gif2,  GROUPING_ID(f1, f2) as gid,  COUNT(*) as cnt FROM MyTable GROUP BY GROUPING SETS (f1, f2, ())";
        String expected = "1,null,1,1,1,0,1,0,2,1\n6,null,18,1,1,0,1,0,2,6\n2,null,2,1,1,0,1,0,2,2\n4,null,8,1,1,0,1,0,2,4\n5,null,13,1,1,0,1,0,2,5\n3,null,5,1,1,0,1,0,2,3\nnull,Comment#11,17,2,0,1,0,1,1,1\nnull,Comment#8,14,2,0,1,0,1,1,1\nnull,Comment#2,8,2,0,1,0,1,1,1\nnull,Comment#1,7,2,0,1,0,1,1,1\nnull,Comment#14,20,2,0,1,0,1,1,1\nnull,Comment#7,13,2,0,1,0,1,1,1\nnull,Comment#6,12,2,0,1,0,1,1,1\nnull,Comment#3,9,2,0,1,0,1,1,1\nnull,Comment#12,18,2,0,1,0,1,1,1\nnull,Comment#5,11,2,0,1,0,1,1,1\nnull,Comment#15,21,2,0,1,0,1,1,1\nnull,Comment#4,10,2,0,1,0,1,1,1\nnull,Hi,1,2,0,1,0,1,1,1\nnull,Comment#10,16,2,0,1,0,1,1,1\nnull,Hello world,3,2,0,1,0,1,1,1\nnull,I am fine.,5,2,0,1,0,1,1,1\nnull,Hello world, how are you?,4,2,0,1,0,1,1,1\nnull,Comment#9,15,2,0,1,0,1,1,1\nnull,Comment#13,19,2,0,1,0,1,1,1\nnull,Luke Skywalker,6,2,0,1,0,1,1,1\nnull,Hello,2,2,0,1,0,1,1,1\nnull,null,11,0,0,0,0,0,0,21";
        this.checkSql(query, expected);
    }

    @Test
    public void testGroupingSetsWithNulls() throws Exception {
        String query = "SELECT f1, f2, avg(f0) as a, GROUP_ID() as g FROM MyTableWithNulls GROUP BY GROUPING SETS (f1, f2)";
        String expected = "6,null,18,1\n5,null,13,1\n4,null,8,1\n3,null,5,1\n2,null,2,1\n1,null,1,1\nnull,Luke Skywalker,6,2\nnull,I am fine.,5,2\nnull,Hi,1,2\nnull,null,3,2\nnull,Hello,2,2\nnull,Comment#9,15,2\nnull,Comment#8,14,2\nnull,Comment#7,13,2\nnull,Comment#6,12,2\nnull,Comment#5,11,2\nnull,Comment#4,10,2\nnull,Comment#3,9,2\nnull,Comment#2,8,2\nnull,Comment#15,21,2\nnull,Comment#14,20,2\nnull,Comment#13,19,2\nnull,Comment#12,18,2\nnull,Comment#11,17,2\nnull,Comment#10,16,2\nnull,Comment#1,7,2";
        this.checkSql(query, expected);
    }

    @Test
    public void testCubeAsGroupingSets() throws Exception {
        String cubeQuery = "SELECT f1, f2, avg(f0) as a, GROUP_ID() as g,  GROUPING(f1) as gf1, GROUPING(f2) as gf2,  GROUPING_ID(f1) as gif1, GROUPING_ID(f2) as gif2,  GROUPING_ID(f1, f2) as gid  FROM MyTable GROUP BY CUBE (f1, f2)";
        String groupingSetsQuery = "SELECT f1, f2, avg(f0) as a, GROUP_ID() as g,  GROUPING(f1) as gf1, GROUPING(f2) as gf2,  GROUPING_ID(f1) as gif1, GROUPING_ID(f2) as gif2,  GROUPING_ID(f1, f2) as gid  FROM MyTable GROUP BY GROUPING SETS ((f1, f2), (f1), (f2), ())";
        this.compareSql(cubeQuery, groupingSetsQuery);
    }

    @Test
    public void testRollupAsGroupingSets() throws Exception {
        String rollupQuery = "SELECT f1, f2, avg(f0) as a, GROUP_ID() as g,  GROUPING(f1) as gf1, GROUPING(f2) as gf2,  GROUPING_ID(f1) as gif1, GROUPING_ID(f2) as gif2,  GROUPING_ID(f1, f2) as gid  FROM MyTable GROUP BY ROLLUP (f1, f2)";
        String groupingSetsQuery = "SELECT f1, f2, avg(f0) as a, GROUP_ID() as g,  GROUPING(f1) as gf1, GROUPING(f2) as gf2,  GROUPING_ID(f1) as gif1, GROUPING_ID(f2) as gif2,  GROUPING_ID(f1, f2) as gid  FROM MyTable GROUP BY GROUPING SETS ((f1, f2), (f1), ())";
        this.compareSql(rollupQuery, groupingSetsQuery);
    }

    private void checkSql(String query, String expected) throws Exception {
        Table resultTable = this.tableEnv.sqlQuery(query);
        DataSet resultDataSet = this.tableEnv.toDataSet(resultTable, Row.class);
        List results = resultDataSet.collect();
        TestBaseUtils.compareResultAsText((List)results, (String)expected);
    }

    private void compareSql(String query1, String query2) throws Exception {
        MapFunction<Row, String> mapFunction = new MapFunction<Row, String>(){

            public String map(Row value) throws Exception {
                return value == null ? "null" : value.toString();
            }
        };
        Table resultTable1 = this.tableEnv.sqlQuery(query1);
        DataSet resultDataSet1 = this.tableEnv.toDataSet(resultTable1, Row.class);
        List results1 = resultDataSet1.map((MapFunction)mapFunction).collect();
        Table resultTable2 = this.tableEnv.sqlQuery(query2);
        DataSet resultDataSet2 = this.tableEnv.toDataSet(resultTable2, Row.class);
        List results2 = resultDataSet2.map((MapFunction)mapFunction).collect();
        TestBaseUtils.compareResultCollections((List)results1, (List)results2, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2 == null ? (o1 == null ? 0 : 1) : o1.compareTo(o2);
            }
        });
    }
}

