/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.utils.SplitUDF;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.runtime.batch.sql.CalcITCase$;
import org.apache.flink.table.runtime.batch.sql.MyHashCode$;
import org.apache.flink.table.runtime.batch.table.OldHashCode$;
import org.apache.flink.table.runtime.utils.TableProgramsCollectionTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001E\u0011!bQ1mG&#6)Y:f\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\u000b\t\fGo\u00195\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002 )\u0006\u0014G.\u001a)s_\u001e\u0014\u0018-\\:D_2dWm\u0019;j_:$Vm\u001d;CCN,\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0015\r|gNZ5h\u001b>$W\r\u0005\u0002\u001c[9\u0011Ad\u000b\b\u0003;)r!AH\u0015\u000f\u0005}AcB\u0001\u0011(\u001d\t\tcE\u0004\u0002#K5\t1E\u0003\u0002%!\u00051AH]8pizJ\u0011aD\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)b!\u0003\u0002-)\u0005)B+\u00192mKB\u0013xn\u001a:b[N$Vm\u001d;CCN,\u0017B\u0001\u00180\u0005=!\u0016M\u00197f\u0007>tg-[4N_\u0012,'B\u0001\u0017\u0015\u0011\u0015\t\u0004\u0001\"\u00013\u0003\u0019a\u0014N\\5u}Q\u00111'\u000e\t\u0003i\u0001i\u0011A\u0001\u0005\u00063A\u0002\rA\u0007\u0005\u0006o\u0001!\t\u0001O\u0001\u0018i\u0016\u001cHoU3mK\u000e$8\u000b^1s\rJ|W\u000eV1cY\u0016$\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\u0005+:LG\u000f\u000b\u00027\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\u00111ID\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u000b\n\u0013A\u0001V3ti\")q\t\u0001C\u0001q\u0005iB/Z:u'\u0016dWm\u0019;Ti\u0006\u0014hI]8n\u001d\u0016\u001cH/\u001a3UC\ndW\r\u000b\u0002G\u0001\")!\n\u0001C\u0001q\u0005IB/Z:u'\u0016dWm\u0019;Ti\u0006\u0014hI]8n\t\u0006$\u0018mU3uQ\tI\u0005\tC\u0003N\u0001\u0011\u0005\u0001(A\nuKN$8+[7qY\u0016\u001cV\r\\3di\u0006cG\u000e\u000b\u0002M\u0001\")\u0001\u000b\u0001C\u0001q\u0005!B/Z:u'\u0016dWm\u0019;XSRDg*Y7j]\u001eD#a\u0014!\t\u000bM\u0003A\u0011\u0001\u001d\u0002#Q,7\u000f^%om\u0006d\u0017\u000e\u001a$jK2$7\u000f\u000b\u0003S\u0001V3\u0016\u0001C3ya\u0016\u001cG/\u001a3$\u0003]\u0003\"\u0001W.\u000e\u0003eS!A\u0017\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002]3\n\u0019b+\u00197jI\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\")a\f\u0001C\u0001q\u00051B/Z:u\u00032d'+\u001a6fGRLgn\u001a$jYR,'\u000f\u000b\u0002^\u0001\")\u0011\r\u0001C\u0001q\u0005!B/Z:u\u00032d\u0007+Y:tS:<g)\u001b7uKJD#\u0001\u0019!\t\u000b\u0011\u0004A\u0011\u0001\u001d\u0002%Q,7\u000f\u001e$jYR,'o\u00148TiJLgn\u001a\u0015\u0003G\u0002CQa\u001a\u0001\u0005\u0002a\n1\u0003^3ti\u001aKG\u000e^3s\u001f:Le\u000e^3hKJD#A\u001a!\t\u000b)\u0004A\u0011\u0001\u001d\u00021Q,7\u000f\u001e#jg*,hn\u0019;jm\u0016\u0004&/\u001a3jG\u0006$X\r\u000b\u0002j\u0001\")Q\u000e\u0001C\u0001q\u0005\tB/Z:u\r&dG/\u001a:XSRD\u0017I\u001c3)\u00051\u0004\u0005\"\u00029\u0001\t\u0003A\u0014!\u0006;fgR\fEM^1oG\u0016$G)\u0019;b)f\u0004Xm\u001d\u0015\u0003_\u0002CQa\u001d\u0001\u0005\u0002a\nA\u0003^3tiZ\u000bG.^3D_:\u001cHO];di>\u0014\bF\u0001:A\u0011\u00151\b\u0001\"\u00019\u0003u!Xm\u001d;Vg\u0016\u0014H)\u001a4j]\u0016$7kY1mCJ4UO\\2uS>t\u0007FA;A\u0011\u0015I\b\u0001\"\u00019\u0003\u0005\"Xm\u001d;Gk:\u001cG/[8o/&$\b.\u00168jG>$W\rU1sC6,G/\u001a:tQ\tA\b\t\u000b\u0004\u0001y\u0006\u0015\u0011q\u0001\t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}\u0014\u0015A\u0002:v]:,'/C\u0002\u0002\u0004y\u0014qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0002\nA!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010\t\u000bqA];o]\u0016\u00148/\u0003\u0003\u0002\u0014\u00055!!\u0004)be\u0006lW\r^3sSj,GmB\u0004\u0002\u0018\tA\t!!\u0007\u0002\u0015\r\u000bGnY%U\u0007\u0006\u001cX\rE\u00025\u000371a!\u0001\u0002\t\u0002\u0005u1\u0003BA\u000e\u0003?\u00012AOA\u0011\u0013\r\t\u0019c\u000f\u0002\u0007\u0003:L(+\u001a4\t\u000fE\nY\u0002\"\u0001\u0002(Q\u0011\u0011\u0011\u0004\u0005\t\u0003W\tY\u0002\"\u0001\u0002.\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\u0005=\u0002CBA\u0019\u0003w\ty$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0012\u0001\u00026bm\u0006LA!!\u0010\u00024\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u000bi\n\t%!\u0012\n\u0007\u0005\r3HA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002H\u00055SBAA%\u0015\u0011\tY%a\u000e\u0002\t1\fgnZ\u0005\u0005\u0003\u001f\nIE\u0001\u0004PE*,7\r\u001e\u0015\t\u0003S\t\u0019&!\u0019\u0002dA!\u0011QKA.\u001d\u0011\tY!a\u0016\n\t\u0005e\u0013QB\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\n\t\u0005u\u0013q\f\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c(\u0002BA-\u0003\u001b\tAA\\1nK\u0006\u0012\u0011QM\u0001\u0013)\u0006\u0014G.\u001a\u0011d_:4\u0017n\u001a\u0011>Am\u0004T\u0010")
public class CalcITCase
extends TableProgramsCollectionTestBase {
    @Parameterized.Parameters(name="Table config = {0}")
    public static Collection<Object[]> parameters() {
        return CalcITCase$.MODULE$.parameters();
    }

    @Test
    public void testSelectStarFromTable() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT * FROM MyTable";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSelectStarFromNestedTable() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT * FROM MyTable";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.getSmallNestedTupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "(1,1),one\n(2,2),two\n(3,3),three\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSelectStarFromDataSet() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT * FROM MyTable";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        tEnv.registerDataSet("MyTable", ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSimpleSelectAll() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT a, b, c FROM MyTable";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testSelectWithNaming() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT `1-_./\u00dc`, b FROM (SELECT _1 as `1-_./\u00dc`, _2 as b FROM MyTable)";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "1,1\n2,2\n3,2\n4,3\n5,3\n6,3\n7,4\n8,4\n9,4\n10,4\n11,5\n12,5\n13,5\n14,5\n15,5\n16,6\n17,6\n18,6\n19,6\n20,6\n21,6\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test(expected=ValidationException.class)
    public void testInvalidFields() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT a, foo FROM MyTable";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("MyTable", ds);
        tEnv.sqlQuery(sqlQuery);
    }

    @Test
    public void testAllRejectingFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT * FROM MyTable WHERE false";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAllPassingFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT * FROM MyTable WHERE true";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFilterOnString() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT * FROM MyTable WHERE c LIKE '%world%'";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "3,2,Hello world\n4,3,Hello world, how are you?\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFilterOnInteger() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT * FROM MyTable WHERE MOD(a,2)=0";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "2,2,Hello\n4,3,Hello world, how are you?\n6,3,Luke Skywalker\n8,4,Comment#2\n10,4,Comment#4\n12,5,Comment#6\n14,5,Comment#8\n16,6,Comment#10\n18,6,Comment#12\n20,6,Comment#14\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testDisjunctivePredicate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT * FROM MyTable WHERE a < 2 OR a > 20 OR a IN(3,4,5)";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "1,1,Hi\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n21,6,Comment#15\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFilterWithAnd() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT * FROM MyTable WHERE MOD(a,2)<>0 AND MOD(b,2)=0 AND b NOT IN(1,2,3)";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "7,4,Comment#1\n9,4,Comment#3\n17,6,Comment#11\n19,6,Comment#13\n21,6,Comment#15\n";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAdvancedDataTypes() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT a, b, c, DATE '1984-07-12', TIME '14:34:24', TIMESTAMP '1984-07-12 14:34:24' FROM MyTable";
        DataSet ds = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)Date.valueOf("1984-07-12"), (Object)Time.valueOf("14:34:24"), (Object)Timestamp.valueOf("1984-07-12 14:34:24"))}), ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<Date, Time, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Date, Time, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Date, Time, Timestamp>>(this, fieldSerializers){

                    public Tuple3<Date, Time, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((Date)fields[0]), (Object)((Time)fields[1]), (Object)((Timestamp)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Date, Time, Timestamp>> createSerializerInstance(Class<Tuple3<Date, Time, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.runtime.batch.sql.CalcITCase$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        tEnv.registerDataSet("MyTable", ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "1984-07-12,14:34:24,1984-07-12 14:34:24.0,1984-07-12,14:34:24,1984-07-12 14:34:24.0";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testValueConstructor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT (a, b, c), ARRAY[12, b], MAP[a, c] FROM MyTable WHERE (a, b, c) = ('foo', 12, TIMESTAMP '1984-07-12 14:34:24')";
        Tuple3 rowValue = new Tuple3((Object)"foo", (Object)BoxesRunTime.boxToInteger((int)12), (Object)Timestamp.valueOf("1984-07-12 14:34:24"));
        DataSet ds = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{rowValue}), ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<String, Object, Timestamp>> createSerializerInstance(Class<Tuple3<String, Object, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.runtime.batch.sql.CalcITCase$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        tEnv.registerDataSet("MyTable", ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "foo,12,1984-07-12 14:34:24.0,[12, 12],{foo=1984-07-12 14:34:24.0}";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
        Row resultRow = (Row)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()).get(0);
        Assert.assertEquals((Object)rowValue._1(), (Object)((Row)resultRow.getField(0)).getField(0));
        Assert.assertEquals((Object)rowValue._2(), (Object)((Integer[])resultRow.getField(1))[1]);
        Assert.assertEquals((Object)rowValue._3(), ((Map)resultRow.getField(2)).get(rowValue._1()));
    }

    @Test
    public void testUserDefinedScalarFunction() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        tEnv.registerFunction("hashCode", (ScalarFunction)OldHashCode$.MODULE$);
        tEnv.registerFunction("hashCode", (ScalarFunction)MyHashCode$.MODULE$);
        DataSet ds = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}), ClassTag$.MODULE$.apply(String.class), (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        tEnv.registerDataSet("MyTable", ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text"))}));
        Table result = tEnv.sqlQuery("SELECT hashCode(text) FROM MyTable");
        String expected = "97\n98\n99";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFunctionWithUnicodeParameters() {
        .colon.colon data = new .colon.colon((Object)new Tuple3((Object)"a\u0001b", (Object)"c\"d", (Object)"e\\\"\u0004f"), (List)new .colon.colon((Object)new Tuple3((Object)"x\u0001y", (Object)"y\"z", (Object)"z\\\"\u0004z"), (List)Nil$.MODULE$));
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        SplitUDF splitUDF0 = new SplitUDF(true);
        SplitUDF splitUDF1 = new SplitUDF(false);
        tEnv.registerFunction("splitUDF0", (ScalarFunction)splitUDF0);
        tEnv.registerFunction("splitUDF1", (ScalarFunction)splitUDF1);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(297).append("\n      |SELECT\n      |  splitUDF0(a, U&'").append('\\').append("0001', 0) AS a0,\n      |  splitUDF1(a, U&'").append('\\').append("0001', 0) AS a1,\n      |  splitUDF0(b, U&'\"', 1) AS b0,\n      |  splitUDF1(b, U&'\"', 1) AS b1,\n      |  splitUDF0(c, U&'").append('\\').append('\\').append("\"").append('\\').append("0004', 0) AS c0,\n      |  splitUDF1(c, U&'").append('\\').append("\"#0004' UESCAPE '#', 0) AS c1\n      |FROM T1\n      |").toString())).stripMargin();
        Table t1 = package$.MODULE$.dataSet2DataSetConversions(env.fromCollection((Iterable)data, ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<String, String, String>>(this, fieldSerializers){

                    public Tuple3<String, String, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<String, String, String>> createSerializerInstance(Class<Tuple3<String, String, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.runtime.batch.sql.CalcITCase$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("T1", t1);
        Seq results = package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected = new .colon.colon((Object)"a,a,d,d,e,e", (List)new .colon.colon((Object)"x,x,z,z,z,z", (List)Nil$.MODULE$)).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    public CalcITCase(TableProgramsTestBase.TableConfigMode configMode) {
        super(configMode);
    }
}

